/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Iterator;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.ProxyDesignObjectSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class StructuredTypeProxySet
extends ProxyDesignObjectSet {
    public StructuredTypeProxySet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected DesignObjectSet getPhysicalDesignObjectSet() {
        return this.getDesign().getDataTypesDesign().getStructuredTypeSet();
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject designObject) {
        return new StructuredTypeProxy((StructuredType)designObject, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String string, String string2) {
        return new StructuredTypeProxy(design, string, string2, this.getStorageDesign());
    }

    @Override
    public StructuredTypeProxy getByName(String string) {
        Iterator iterator = this.getElements().iterator();
        StructuredTypeProxy structuredTypeProxy = null;
        while (iterator.hasNext()) {
            structuredTypeProxy = (StructuredTypeProxy)iterator.next();
            if (!string.equalsIgnoreCase(structuredTypeProxy.getName())) continue;
            return structuredTypeProxy;
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("STRUCTURED_TYPE_ICON", 16);
    }

    public StructuredTypeProxy getBySchemaAndName(String string, String string2) {
        Iterator iterator = this.getElements().iterator();
        StructuredTypeProxy structuredTypeProxy = null;
        while (iterator.hasNext()) {
            structuredTypeProxy = (StructuredTypeProxy)iterator.next();
            StorageObject storageObject = structuredTypeProxy.getSchemaOrUser();
            if (storageObject == null || !storageObject.getName().equalsIgnoreCase(string) || !string2.equalsIgnoreCase(structuredTypeProxy.getName())) continue;
            return structuredTypeProxy;
        }
        return null;
    }
}

