/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;

public class StorageObjectPropertyTranslator
implements PropertyTranslator {
    public static final String NO_OBJECT = "NO_OBJECT";
    Class storageObjectClass = StorageObject.class;
    private StorageDesign storageDesign;

    public StorageObjectPropertyTranslator(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public Object translateFromString(String string) {
        if (string == null || NO_OBJECT.equals(string)) {
            return null;
        }
        StorageObject storageObject = this.storageDesign.getStorageObject(string);
        if (storageObject == null) {
            ModelIDObject modelIDObject;
            String string2 = null;
            Map map = this.storageDesign.getCorrespondenceMap();
            if (map != null && (modelIDObject = (ModelIDObject)map.get(string)) != null) {
                string2 = modelIDObject.getObjectID();
                storageObject = this.storageDesign.getStorageObject(string2);
            }
        }
        return storageObject;
    }

    @Override
    public String translateToString(Object object) {
        if (object != null) {
            return ((StorageObject)object).getObjectID();
        }
        return NO_OBJECT;
    }

    @Override
    public boolean canHandleClass(Class clazz) {
        return this.storageObjectClass.isAssignableFrom(clazz);
    }

    @Override
    public boolean isStatefull() {
        return true;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }
}

