/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesignSet;

public class StorageDesignFactory
extends ModelObject {
    private Map instances = new HashMap();
    StorageDesignSet elements = new StorageDesignSet();
    private RelationalDesign physicalDesign;

    public StorageDesignFactory(RelationalDesign relationalDesign) {
        this.physicalDesign = relationalDesign;
        this.elements.setName(Messages.getString("StorageDesignFactory.PhysicalModels"));
        this.elements.setParent(relationalDesign);
        this.elements.setDesign(relationalDesign.getDesign());
        this.setDesign(relationalDesign.getDesign());
    }

    public static final String getStorageDesignSetName() {
        return Messages.getString("StorageDesignFactory.PhysicalModels");
    }

    public RDBMSSiteSet getRDBMSSiteSet() {
        return this.getDesign().getRDBMSSiteSet();
    }

    public RDBMSSite[] getRDBMSSites() {
        return this.getRDBMSSiteSet().toSiteArray();
    }

    public StorageDesign getStorageDesign(RDBMSSite rDBMSSite) {
        StorageDesign storageDesign;
        if (!this.instances.containsKey(rDBMSSite)) {
            storageDesign = StorageDesign.createStorageDesign(this.getPhysicalDesign(), rDBMSSite, this.physicalDesign.getDesign());
            storageDesign.setParent(this.elements);
            this.instances.put(rDBMSSite, storageDesign);
            storageDesign.setLoading(false);
        }
        storageDesign = (StorageDesign)this.instances.get(rDBMSSite);
        return storageDesign;
    }

    public StorageDesign[] getOpenStorageDesigns() {
        return this.instances.values().toArray(StorageDesign.PROTOTYPE_ARRAY);
    }

    public RDBMSSite[] getOpenRDBMSSites() {
        return (RDBMSSite[])this.instances.keySet().toArray(RDBMSSiteSet.PROTO_ARRAY);
    }

    public void removeStorageDesign(StorageDesign storageDesign) {
        if (this.instances.containsKey(storageDesign.getRDBMSSite())) {
            this.instances.remove(storageDesign.getRDBMSSite());
            this.elements.remove(storageDesign);
        }
    }

    public StorageDesignSet getSorageDesigns() {
        return this.elements;
    }

    public void sdTempStatusChanged(StorageDesign storageDesign) {
        if (!storageDesign.isTempModel() && !this.elements.contains(storageDesign)) {
            storageDesign.setParent(this.elements);
            this.elements.add(storageDesign);
        } else if (storageDesign.isTempModel()) {
            this.elements.remove(storageDesign);
        }
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public boolean existStorageDesign(RDBMSSite rDBMSSite) {
        return this.instances.get(rDBMSSite) != null;
    }
}

