/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.exports.ddl.SSBDropFK;
import oracle.dbtools.crest.exports.ddl.SSBDropIndex;
import oracle.dbtools.crest.exports.ddl.SSBDropTable;
import oracle.dbtools.crest.exports.ddl.SSBDropView;
import oracle.dbtools.crest.exports.ddl.SSBEndScript;
import oracle.dbtools.crest.exports.ddl.SSBErrorHandler;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBDataBaseDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBFKeyDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBStorageGroupDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBTableDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBTableSpaceDB2v70;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBViewDB2v70;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.imports.ddl.DDLHandler;
import oracle.dbtools.crest.model.AbstractDesign;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SegmentNameManager;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignPartListener;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxySet;
import oracle.dbtools.crest.model.design.storage.ColumnProxySet;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.MethodParamProxySet;
import oracle.dbtools.crest.model.design.storage.MethodProxySet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.ReadRequest;
import oracle.dbtools.crest.model.design.storage.ReadRequestQueue;
import oracle.dbtools.crest.model.design.storage.ReadRequestStorageDesign;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPropertyTranslator;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageObjectSetEvent;
import oracle.dbtools.crest.model.design.storage.StorageObjectSetListener;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxySet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.TableViewProxySet;
import oracle.dbtools.crest.model.design.storage.TypeElementProxySet;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.model.metadata.XMLToObjectTransformer;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.db.RepDeleteDescr;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.storage.AbstractRXMLStorageDesign;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.w3c.dom.Document;

public abstract class StorageDesign
extends AbstractDesign
implements DesignPartListener,
StorageObjectSetListener,
DesignListener {
    public static final String RDBMS_DB2_V7_0 = "db2v7.0";
    public static String TYPE_NAME = "StorageDesign";
    public static final StorageDesign[] PROTOTYPE_ARRAY = new StorageDesign[0];
    protected List<ElementSet> ddlSelectionSetsList;
    private RDBMSSite rdbmsSite = null;
    private Map physicalProxyMap = new TreeMap();
    private Map storageObjectMap = new TreeMap();
    private RuleHandler ruleHandler;
    private DDLGenerator generator;
    private DDLGenerator dropGenerator;
    private DDLGenerator incompleteTypeGenerator;
    private DDLGenerator compileTypeGenerator;
    private DDLGenerator typeGenerator;
    private DDLGenerator scopeGenerator;
    private DDLGenerator physicalTriggerGenerator;
    private DDLGenerator triggerGenerator;
    private DDLGenerator autoIncrementColumnGenerator;
    private DDLGenerator collectionTypeGenerator;
    private DDLGenerator userGenerator;
    private List endGenerators;
    private boolean initialReadBackDone = false;
    private ReadRequestQueue readRequestQueue;
    private MDDataTypeFactory dataTypeFactory = null;
    private boolean isLoading = true;
    protected List elements = new ArrayList();
    private boolean open = false;
    private RelationalDesign physicalDesign;
    private boolean closing = false;
    private boolean storageObjectsOnly = false;
    private TreeMap repositoryMap = new TreeMap();
    private float loadedVersion = 2.2f;
    private float version = 2.2f;
    private boolean cloneOperation = false;
    private RDBMSSite clonedSite = null;
    private boolean objectListChanged = false;
    protected Map f2tMap = null;
    private boolean tempModel = true;
    private static File lastFolder = null;
    private static final Logger LOGGER = new Logger(StorageDesign.class);
    private TreeMap filesMap = new TreeMap();
    private PropertyTranslator[] translators;
    private List substitutionList;
    protected Map correspondenceMap;
    protected Map reverseMap;
    private static GetHelper getHelper = new GetHelper();

    public StorageDesign(RelationalDesign relationalDesign, RDBMSSite rDBMSSite, Design design) {
        this.id = new GUID().toString();
        this.physicalDesign = relationalDesign;
        this.setRDBMSSite(rDBMSSite);
        this.setDesign(design);
    }

    public ReadRequestQueue getReadRequestQueue() {
        if (this.readRequestQueue == null) {
            this.readRequestQueue = new ReadRequestQueue();
            this.readRequestQueue.setDesign(this.getDesign());
            this.readRequestQueue.setStorageDesign(this);
        }
        return this.readRequestQueue;
    }

    public ReadRequest getReadRequestFor(String string) {
        return this.getReadRequestQueue().getReadRequest(string);
    }

    public void removeReadRequestFor(String string) {
        this.removeReadRequestFor(this.getReadRequestFor(string));
    }

    public void removeReadRequestFor(ReadRequest readRequest) {
        this.getReadRequestQueue().removeReadRequest(readRequest);
    }

    public ReadRequest[] getReadRequests() {
        return this.getReadRequestQueue().getReadRequests();
    }

    public MDDataTypeFactory getDataTypeFactory() {
        if (this.dataTypeFactory == null) {
            this.dataTypeFactory = this.createDataTypeFactory();
        }
        return this.dataTypeFactory;
    }

    public MDDataTypeFactory createDataTypeFactory() {
        return MDDataTypeFactory.getInstance(this.getRDBMSType(), this.getDesign().getAppView().getSettings());
    }

    protected void initialize() {
        this.getDataTypeFactory();
        this.initializeImportedDesigns();
    }

    public boolean hasSpaceCalculation() {
        return false;
    }

    public void showSpaceCalculation() {
    }

    public boolean hasDistinctTypes() {
        return false;
    }

    public void showDistinctTypes() {
    }

    public boolean hasUserDefinedTypes() {
        return false;
    }

    public void showUserDefinedTypes() {
    }

    public List getDropableSets() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public void initializeProxiesForExistingDesignObjects() {
        if (this.getDesign() != null) {
            LOGGER.debug("StorageDesign.initializeProxiesForExistingDesignObjects should not be used. PhysicalObjectProxySets do that now");
            Collection collection = this.getDesign().getRelationalDesign().getAllTopLevelObjects();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addPhysicalObject((DesignObject)iterator.next());
            }
            this.getDesign().getRelationalDesign().addDesignPartListener(this);
        }
    }

    @Override
    public String getFileName() {
        return this.getDesign().getFileName();
    }

    @Override
    public Collection getAllTopLevelObjects() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (ElementSet elementSet : this.getAllSetsList()) {
            linkedList.addAll(Arrays.asList(elementSet.toArray()));
        }
        return linkedList;
    }

    public static StorageDesign createStorageDesign(RelationalDesign relationalDesign, RDBMSSite rDBMSSite, Design design) {
        if (relationalDesign == null || rDBMSSite == null || rDBMSSite.getType() == null || rDBMSSite.getType().getStorageDesignClassName() == null) {
            return StorageDesign.createNullInstanceWith(rDBMSSite, design);
        }
        RDBMSType rDBMSType = rDBMSSite.getType();
        String string = rDBMSType.getStorageDesignClassName();
        StorageDesign storageDesign = null;
        ArrayList<String> arrayList = null;
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getDeclaredConstructor(RelationalDesign.class, RDBMSSite.class, Design.class);
            storageDesign = (StorageDesign)constructor.newInstance(relationalDesign, rDBMSSite, design);
            design.addDesignListener(storageDesign);
            storageDesign.initialize();
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error("Can not find class " + string, classNotFoundException);
            arrayList = new ArrayList();
            arrayList.add("Can not find class (cnfe)");
            arrayList.add(string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            LOGGER.error("Can not find class (ncdfe)" + string);
            arrayList = new ArrayList();
            arrayList.add("Can not find class (ncdfe)");
            arrayList.add(string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.error("There is no appropriate constructor Xxx(PhysicalDesign, RDBMSSite, design).", noSuchMethodException);
            arrayList = new ArrayList<String>();
            arrayList.add("There is no appropriate constructor Xxx(PhysicalDesign, RDBMSSite, design)");
            arrayList.add(string);
        }
        catch (Exception exception) {
            LOGGER.error("Can not instantiate StorageDesign:", exception);
            arrayList = new ArrayList();
            arrayList.add("Can not instantiate StorageDesign");
            arrayList.add(string);
        }
        if (storageDesign == null) {
            storageDesign = new NullStorageDesign(null, "No Storage Design loaded", arrayList.toArray(), rDBMSSite, design);
        }
        return storageDesign;
    }

    private static StorageDesign createNullInstanceWith(RDBMSSite rDBMSSite, Design design) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Storage Design can not be instantiated due to: ");
        if (rDBMSSite == null) {
            arrayList.add("No RDBMSSite information (null)");
        } else if (rDBMSSite.getType() == null) {
            arrayList.add("No RDBMSType information (null)");
        } else if (rDBMSSite.getType().getStorageDesignClassName() == null) {
            arrayList.add("No StorageDesignClassName information (null)");
        }
        if (design == null) {
            arrayList.add("Design (null).");
        }
        return new NullStorageDesign(null, Messages.getString("StorageDesign.NoStorageDesignLoaded"), arrayList.toArray(), rDBMSSite, design);
    }

    public void setRDBMSSite(RDBMSSite rDBMSSite) {
        this.rdbmsSite = rDBMSSite;
    }

    public RDBMSSite getRDBMSSite() {
        return this.rdbmsSite;
    }

    public RDBMSTypeSet getRDBMSTypeSet() {
        return this.getDesign().getRDBMSTypeSet();
    }

    public boolean isRDBMSSite(RDBMSSite rDBMSSite) {
        return this.getRDBMSSite().equals(rDBMSSite);
    }

    public abstract RDBMSType getRDBMSType();

    public abstract PropertyHolder getPropertyHolder();

    @Override
    public String getIDPrefix() {
        return "STODES";
    }

    public void addStorageObject(StorageObject storageObject) {
        this.storageObjectMap.put(storageObject.getObjectID(), storageObject);
    }

    public void removeStorageObject(StorageObject storageObject) {
        this.storageObjectMap.remove(storageObject.getObjectID());
    }

    public void addPhysicalObject(DesignObject designObject) {
        throw new RuntimeException("addPhysicalObject(DesignObject) is deprecated");
    }

    public void addPhysicalObject(String string) {
        throw new RuntimeException("addPhysicalObject(String) is deprecated");
    }

    public void addPhysicalObject(String string, String string2) {
        throw new RuntimeException("addPhysicalObject(String, String) is deprecated");
    }

    public void removePhysicalObject(DesignObject designObject) {
        throw new RuntimeException("removePhysicalObject(DesignObject) is deprecated");
    }

    public void removePhysicalObject(String string) {
        throw new RuntimeException("removePhysicalObject(String) is deprecated");
    }

    public RelationalObjectProxy getObject(String string) {
        return this.getPhysicalObject(string);
    }

    public RelationalObjectProxy getPhysicalObject(String string) {
        throw new RuntimeException("getPhysicalObject(String) is deprecated");
    }

    public ModelIDObject getModelIDObject(String string) {
        if (this.storageObjectMap.containsKey(string)) {
            return (ModelIDObject)this.storageObjectMap.get(string);
        }
        if (this.physicalProxyMap.containsKey(string)) {
            LOGGER.error("StorageDesign.getModelIDObject(String): should not return PhysicalObjectProxy");
            return this.getPhysicalObject(string);
        }
        return null;
    }

    public StorageObject getStorageObject(String string) {
        return (StorageObject)this.getModelIDObject(string);
    }

    protected void registerModelIDObject(ModelIDObject modelIDObject) {
        String string = modelIDObject.getObjectID();
        if (modelIDObject != null && string != null) {
            this.storageObjectMap.put(modelIDObject.getObjectID(), modelIDObject);
            this.setObjectListChanged(true);
        }
    }

    protected void unregisterModelIDObject(ModelIDObject modelIDObject) {
        if (modelIDObject != null && modelIDObject.getObjectID() != null) {
            this.storageObjectMap.remove(modelIDObject.getObjectID());
            this.setObjectListChanged(true);
        }
    }

    public void unregisterAll() {
        this.storageObjectMap.clear();
    }

    public boolean hasModelIDObject(ModelIDObject modelIDObject) {
        return this.hasModelIDObject(modelIDObject.getObjectID());
    }

    public boolean hasModelIDObject(String string) {
        return this.storageObjectMap.containsKey(string);
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject designObject) {
        if (designObject instanceof Table || designObject instanceof Index) {
            this.addPhysicalObject(designObject);
        }
    }

    @Override
    public void objectRemoved(DesignPart designPart, DesignObject designObject) {
        this.removePhysicalObject(designObject);
    }

    public boolean isNullInstance() {
        return false;
    }

    public Map getFunctionalities() {
        return Collections.EMPTY_MAP;
    }

    public abstract TableProxySet getTableProxySet();

    public abstract TableProxySet getSubViewTableProxySet();

    public abstract IndexProxySet getIndexProxySet();

    public abstract ColumnProxySet getColumnProxySet();

    public abstract TableViewProxySet getTableViewProxySet();

    public abstract TableViewProxySet getSubViewTableViewProxySet();

    public abstract StructuredTypeProxySet getStructuredTypeProxySet();

    public abstract TypeElementProxySet getTypeElementProxySet();

    public abstract MethodProxySet getMethodProxySet();

    public abstract MethodParamProxySet getMethodParamProxySet();

    public abstract StorageObjectSet getStorageObjectSetForType(String var1);

    public abstract CollectionTypeProxySet getCollectionTypeProxySet();

    public abstract void sortCollections();

    public List getAllSetsList() {
        ArrayList<RelationalObjectProxySet> arrayList = new ArrayList<RelationalObjectProxySet>();
        arrayList.add(this.getTableProxySet());
        arrayList.add(this.getColumnProxySet());
        arrayList.add(this.getIndexProxySet());
        arrayList.add(this.getTableViewProxySet());
        arrayList.add(this.getStructuredTypeProxySet());
        arrayList.add(this.getTypeElementProxySet());
        arrayList.add(this.getMethodProxySet());
        return arrayList;
    }

    public RelationalObjectProxy getProxy(Object object) {
        String string = null;
        if (object instanceof ModelIDObject) {
            string = ((ModelIDObject)object).getObjectID();
        } else if (object instanceof String) {
            string = (String)object;
        }
        if (this.getTableProxySet().containsId(string)) {
            return this.getTableProxySet().getProxy(string);
        }
        if (this.getIndexProxySet().containsId(string)) {
            return this.getIndexProxySet().getProxy(string);
        }
        if (this.getColumnProxySet().containsId(string)) {
            return this.getColumnProxySet().getProxy(string);
        }
        if (this.getTableViewProxySet().containsId(string)) {
            return this.getTableViewProxySet().getProxy(string);
        }
        if (this.getStructuredTypeProxySet() != null && this.getStructuredTypeProxySet().containsId(string)) {
            return this.getStructuredTypeProxySet().getProxy(string);
        }
        if (this.getTypeElementProxySet() != null && this.getTypeElementProxySet().containsId(string)) {
            return this.getTypeElementProxySet().getProxy(string);
        }
        if (this.getMethodProxySet() != null && this.getMethodProxySet().containsId(string)) {
            return this.getMethodProxySet().getProxy(string);
        }
        if (this.getMethodParamProxySet() != null && this.getMethodParamProxySet().containsId(string)) {
            return this.getMethodParamProxySet().getProxy(string);
        }
        if (this.getCollectionTypeProxySet() != null && this.getCollectionTypeProxySet().containsId(string)) {
            return this.getCollectionTypeProxySet().getProxy(string);
        }
        return null;
    }

    public RuleHandler getRuleHandler() {
        if (this.ruleHandler == null) {
            this.ruleHandler = this.createRuleHandler();
            this.ruleHandler.setLabel(this.getLongName());
        }
        return this.ruleHandler;
    }

    protected RuleHandler createRuleHandler() {
        return RuleHandler.getNullInstance();
    }

    public List getDDLEndScriptGenerators() {
        if (this.endGenerators == null) {
            this.endGenerators = this.createDDLEndScriptGenerators();
            for (DDLGenerator dDLGenerator : this.endGenerators) {
                dDLGenerator.setLabel(this.getRDBMSType().getLongName());
            }
        }
        return this.endGenerators;
    }

    protected List createDDLEndScriptGenerators() {
        ArrayList<DDLGeneratorSpecific> arrayList = new ArrayList<DDLGeneratorSpecific>();
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        dDLGeneratorSpecific.append(new SSBEndScript());
        arrayList.add(dDLGeneratorSpecific);
        return arrayList;
    }

    public DDLGenerator getDDLGenerator() {
        if (this.generator == null) {
            this.generator = this.createDDLGenerator();
            this.generator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
            this.generator.setLabel(this.getRDBMSType().getLongName());
        }
        return this.generator;
    }

    protected DDLGenerator createDDLGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        dDLGeneratorSpecific.append(new SSBTableDB2v70());
        dDLGeneratorSpecific.append(new SSBFKeyDB2v70());
        dDLGeneratorSpecific.append(new SSBDataBaseDB2v70());
        dDLGeneratorSpecific.append(new SSBStorageGroupDB2v70());
        dDLGeneratorSpecific.append(new SSBTableSpaceDB2v70());
        dDLGeneratorSpecific.append(new SSBViewDB2v70());
        return dDLGeneratorSpecific;
    }

    public DDLGenerator getDDLDropGenerator() {
        if (this.dropGenerator == null) {
            this.dropGenerator = this.createDDLDropGenerator();
            this.dropGenerator.setLabel("DropGen");
            this.dropGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.dropGenerator;
    }

    protected DDLGenerator createDDLDropGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        dDLGeneratorSpecific.append(new SSBDropFK());
        dDLGeneratorSpecific.append(new SSBDropIndex());
        dDLGeneratorSpecific.append(new SSBDropView());
        dDLGeneratorSpecific.append(new SSBDropTable());
        return dDLGeneratorSpecific;
    }

    public DDLGenerator getDDLIncompleteTypeGenerator() {
        if (this.incompleteTypeGenerator == null) {
            this.incompleteTypeGenerator = this.createDDLIncompleteTypeGenerator();
            this.incompleteTypeGenerator.setLabel("TypesGen");
            this.incompleteTypeGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.incompleteTypeGenerator;
    }

    public DDLGenerator getDDLCollectionTypeGenerator() {
        if (this.collectionTypeGenerator == null) {
            this.collectionTypeGenerator = this.createDDLCollectionTypeGenerator();
            this.collectionTypeGenerator.setLabel("TypesGen");
            this.collectionTypeGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.collectionTypeGenerator;
    }

    public DDLGenerator getDDLUserGenerator() {
        if (this.userGenerator == null) {
            this.userGenerator = this.createDDLUserGenerator();
            this.userGenerator.setLabel("UserGen");
            this.userGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.userGenerator;
    }

    protected DDLGenerator createDDLIncompleteTypeGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        return dDLGeneratorSpecific;
    }

    protected DDLGenerator createDDLCollectionTypeGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        return dDLGeneratorSpecific;
    }

    public DDLGenerator getDDLCompileTypeGenerator() {
        if (this.compileTypeGenerator == null) {
            this.compileTypeGenerator = this.createDDLCompileTypeGenerator();
            this.compileTypeGenerator.setLabel("CompileTypesGen");
            this.compileTypeGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.compileTypeGenerator;
    }

    protected DDLGenerator createDDLCompileTypeGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        return dDLGeneratorSpecific;
    }

    public DDLGenerator getDDLTypeGenerator() {
        if (this.typeGenerator == null) {
            this.typeGenerator = this.createDDLTypeGenerator();
            this.typeGenerator.setLabel("CompileTypesGen");
            this.typeGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.typeGenerator;
    }

    protected DDLGenerator createDDLTypeGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        return dDLGeneratorSpecific;
    }

    public DDLGenerator getDDLScopeGenerator() {
        if (this.scopeGenerator == null) {
            this.scopeGenerator = this.createDDLScopeGenerator();
            this.scopeGenerator.setLabel("ScopeGenerator");
            this.scopeGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.scopeGenerator;
    }

    protected DDLGenerator createDDLScopeGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        return dDLGeneratorSpecific;
    }

    protected DDLGenerator createDDLUserGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        return dDLGeneratorSpecific;
    }

    public DDLGenerator getDDLPhysicalTriggerGenerator() {
        if (this.physicalTriggerGenerator == null) {
            this.physicalTriggerGenerator = this.createDDLPhysicalTriggerGenerator();
            this.physicalTriggerGenerator.setLabel("PhysicalTriggerGenerator");
            this.physicalTriggerGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.physicalTriggerGenerator;
    }

    protected DDLGenerator createDDLPhysicalTriggerGenerator() {
        return new DDLGeneratorSpecific();
    }

    public DDLGenerator getDDLTriggerGenerator() {
        if (this.triggerGenerator == null) {
            this.triggerGenerator = this.createDDLTriggerGenerator();
            this.triggerGenerator.setLabel("TriggerGenerator");
            this.triggerGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.triggerGenerator;
    }

    public DDLGenerator getDDLAutoIncrementColumnGenerator() {
        if (this.autoIncrementColumnGenerator == null) {
            this.autoIncrementColumnGenerator = this.createDDLAutoIncrementColumnGenerator();
            this.autoIncrementColumnGenerator.setLabel("AutoIncrementColumnGenerator");
            this.autoIncrementColumnGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.autoIncrementColumnGenerator;
    }

    protected DDLGenerator createDDLTriggerGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        return dDLGeneratorSpecific;
    }

    protected DDLGenerator createDDLAutoIncrementColumnGenerator() {
        return new DDLGeneratorSpecific();
    }

    public Iterator ddlObjects() {
        ArrayList arrayList = new ArrayList();
        this.addDDLStorageObjects(arrayList, this.getTableProxySet());
        this.addDDLStorageObjects(arrayList, this.getIndexProxySet());
        this.addDDLStorageObjects(arrayList, this.getTableViewProxySet());
        return arrayList.iterator();
    }

    public Iterator ddlDropObjects() {
        ArrayList arrayList = new ArrayList();
        this.addDDLStorageObjects(arrayList, this.getIndexProxySet());
        this.addDDLStorageObjects(arrayList, this.getTableViewProxySet());
        this.addDDLStorageObjects(arrayList, this.getTableProxySet());
        return arrayList.iterator();
    }

    public Iterator ddlIncompleteTypeObjects() {
        ArrayList arrayList = new ArrayList();
        return arrayList.iterator();
    }

    public Iterator ddlCompileTypeObjects() {
        ArrayList arrayList = new ArrayList();
        return arrayList.iterator();
    }

    public Iterator ddlCollectionTypeObjects() {
        ArrayList arrayList = new ArrayList();
        return arrayList.iterator();
    }

    public Iterator ddlTypeObjects() {
        ArrayList arrayList = new ArrayList();
        return arrayList.iterator();
    }

    public Iterator ddlScopeObjects() {
        ArrayList arrayList = new ArrayList();
        return arrayList.iterator();
    }

    public Iterator ddlUserObjects() {
        ArrayList arrayList = new ArrayList();
        return arrayList.iterator();
    }

    public Iterator ddlAutoIncrementColumnObjects() {
        ArrayList arrayList = new ArrayList();
        this.addDDLStorageObjects(arrayList, this.getTableProxySet());
        return arrayList.iterator();
    }

    public Iterator ddlEndScriptObjects() {
        ArrayList arrayList = new ArrayList();
        this.addDDLStorageObjects(arrayList, this.getTableProxySet());
        this.addDDLStorageObjects(arrayList, this.getTableViewProxySet());
        return arrayList.iterator();
    }

    public Iterator ddlTriggersCausingObjects() {
        ArrayList<TableProxy> arrayList = new ArrayList<TableProxy>();
        Iterator iterator = this.getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxy tableProxy = (TableProxy)iterator.next();
            if (!((Table)tableProxy.getObject()).hasNoneTransferableFK()) continue;
            arrayList.add(tableProxy);
        }
        this.getPhysicalDesign().getArcSet().addAllElementsTo(arrayList);
        return arrayList.iterator();
    }

    protected void addDDLStorageObjects(Collection collection, RelationalObjectProxySet relationalObjectProxySet) {
        this.addDDLStorageObjects(collection, (StorageObject[])relationalObjectProxySet.toArray());
    }

    protected void addDDLStorageObjectsNosort(Collection collection, RelationalObjectProxySet relationalObjectProxySet) {
        this.addDDLStorageObjectsNoSort(collection, (StorageObject[])relationalObjectProxySet.toArray());
    }

    protected void addDDLStorageObjects(Collection collection, StorageObjectSet storageObjectSet) {
        this.addDDLStorageObjects(collection, (StorageObject[])storageObjectSet.toArray());
    }

    protected void addDDLStorageObjects(Collection collection, StorageObject[] storageObjectArray) {
        ArrayList<StorageObject> arrayList = new ArrayList<StorageObject>();
        for (int i = 0; i < storageObjectArray.length; ++i) {
            if (storageObjectArray[i].isNullInstance() || !storageObjectArray[i].belongsToDesign()) continue;
            StorageObject storageObject = storageObjectArray[i];
            arrayList.add(storageObject);
        }
        Collections.sort(arrayList, ModelObjectSet.NAME_COMPARATOR);
        collection.addAll(arrayList);
    }

    protected void addDDLStorageObjectsNoSort(Collection collection, StorageObject[] storageObjectArray) {
        DesignPartView designPartView = this.getDesign().getSelectedSubView();
        for (int i = 0; i < storageObjectArray.length; ++i) {
            StorageObject storageObject;
            if (storageObjectArray[i].isNullInstance() || !storageObjectArray[i].belongsToDesign() || !this.canProcesProxy(designPartView, storageObject = storageObjectArray[i])) continue;
            collection.add(storageObject);
        }
    }

    protected void addDDLStorageObjectsNoSort(Collection collection, List list) {
        for (StorageObject storageObject : list) {
            if (storageObject.isNullInstance() || !storageObject.belongsToDesign()) continue;
            collection.add(storageObject);
        }
    }

    public boolean canProcesProxy(DesignPartView designPartView, Object object) {
        if (designPartView == null) {
            return true;
        }
        DesignObject designObject = null;
        DesignObject designObject2 = null;
        if (object instanceof RelationalObjectProxy) {
            designObject2 = ((RelationalObjectProxy)object).getObject();
        }
        if (designObject2 != null) {
            if (designObject2 instanceof Table) {
                designObject = designObject2;
            } else if (designObject2 instanceof TableView) {
                designObject = designObject2;
            } else if (designObject2 instanceof Index) {
                designObject = ((Index)designObject2).getTable();
            } else if (designObject2 instanceof FKIndexAssociation) {
                designObject = ((FKIndexAssociation)designObject2).getTable();
            }
            if (designObject != null) {
                return designObject.getFirstViewForDPV(designPartView) != null;
            }
        }
        return true;
    }

    public Iterator siteObjects() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator designSpecificObjects() {
        ArrayList arrayList = new ArrayList();
        this.addStorageObjects(arrayList, this.getStructuredTypeProxySet());
        this.addStorageObjects(arrayList, this.getTableProxySet());
        this.addStorageObjects(arrayList, this.getIndexProxySet());
        this.addStorageObjects(arrayList, this.getTableViewProxySet());
        return arrayList.iterator();
    }

    protected void addStorageObjects(Collection collection, RelationalObjectProxySet relationalObjectProxySet) {
        this.addStorageObjects(collection, (StorageObject[])relationalObjectProxySet.toArray());
    }

    protected void addStorageObjects(Collection collection, StorageObjectSet storageObjectSet) {
        this.addDDLStorageObjects(collection, (StorageObject[])storageObjectSet.toArray());
    }

    protected void addStorageObjects(Collection collection, StorageObject[] storageObjectArray) {
        collection.add(Arrays.asList(storageObjectArray));
    }

    public PropertyTranslator[] getPropertyTranslators() {
        if (this.translators == null) {
            this.translators = new PropertyTranslator[]{new StorageObjectPropertyTranslator(this)};
        }
        return this.translators;
    }

    public void doTableSpaceCalculations() {
    }

    public void doIndexSpaceCalculations() {
    }

    public void copyCommentInRDBMS() {
        this.copyCommentInRDBMS(this.getTableProxySet());
        this.copyCommentInRDBMS(this.getTableViewProxySet());
        this.copyCommentInRDBMS(this.getColumnProxySet());
        this.copyCommentInRDBMS(this.getIndexProxySet());
    }

    public void copyCommentInRDBMS(RelationalObjectProxySet relationalObjectProxySet) {
        Iterator iterator = relationalObjectProxySet.iterator();
        while (iterator.hasNext()) {
            RelationalObjectProxy relationalObjectProxy = (RelationalObjectProxy)iterator.next();
            System.out.println("copying: " + relationalObjectProxy);
            relationalObjectProxy.copyCommentInRDBMS();
        }
    }

    @Override
    public void changed(StorageObjectSet storageObjectSet, StorageObjectSetEvent storageObjectSetEvent) {
        if (storageObjectSetEvent.isAdded()) {
            this.addStorageObject(storageObjectSetEvent.getAffectedStorageObject());
        } else if (storageObjectSetEvent.isRemoved()) {
            this.removeStorageObject(storageObjectSetEvent.getAffectedStorageObject());
        }
    }

    public boolean isInitialReadBackDone() {
        return this.initialReadBackDone;
    }

    public void setInitialReadBackDone(boolean bl) {
        this.initialReadBackDone = bl;
    }

    @Override
    public void designChanged(DesignEvent designEvent) {
    }

    public void importDesign(Object object) {
        ReadRequestStorageDesign readRequestStorageDesign = new ReadRequestStorageDesign();
        readRequestStorageDesign.setStorageDesign(this);
        readRequestStorageDesign.setDesignName((String)object);
        readRequestStorageDesign.setRequestLock(false);
        this.getDesign().getAppView().getPersistenceManager().read(readRequestStorageDesign, this.getDesign());
    }

    protected void initializeImportedDesigns() {
        String[] stringArray = this.getDesign().getImportedDesignNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.importDesign(stringArray[i]);
        }
    }

    @Override
    public String[] getImportedDesignNames() {
        return this.getDesign().getImportedDesignNames();
    }

    public void setLoading(boolean bl) {
        this.isLoading = bl;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void clearAll() {
        for (Object e : this.getAllSetsList()) {
            if (e instanceof StorageObjectSet) {
                ((StorageObjectSet)e).removeAll();
                continue;
            }
            if (!(e instanceof RelationalObjectProxySet)) continue;
            ((RelationalObjectProxySet)e).clearAll();
        }
        this.unregisterAll();
        this.getReadRequestQueue().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.closing = true;
            DataModelerAddin.closeAllEditors(this, false);
            this.getDesign().getAppView().getPersistenceManager().getPMWPoolMap().clearPMWPoolMap();
            this.setVisible(false);
            this.setOpen(false);
            this.clearAll();
            this.reloadAllProxies();
            this.reloadDefaults();
        }
        finally {
            this.closing = false;
        }
        System.gc();
    }

    public void reloadDefaults() {
    }

    public void delete() {
        this.delete(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(boolean bl) {
        int n;
        if (bl && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), "Are you sure you want to delete this physical model?", "Warning", 0, 3)) == 1) {
            return;
        }
        try {
            String string;
            this.closing = true;
            DataModelerAddin.closeAllEditors(this, false);
            if (this.getDesign().isOldRepositoryType()) {
                this.getDesign().getAppView().getPersistenceManager().getPMWPoolMap().clearPMWPoolMap();
            }
            this.setVisible(false);
            this.setOpen(false);
            this.getDesign().removeDesignListener(this);
            this.getPhysicalDesign().removeDesignPartListener(this);
            this.clearAll();
            if (this.getPhysicalDesign().getStorageDesignFactory() != null) {
                this.getPhysicalDesign().getStorageDesignFactory().removeStorageDesign(this);
            }
            if ((string = this.getStoragePath()) != null) {
                File file = new File(string);
                if (Extension.isSVNExtensionLoaded()) {
                    SVNClientHelper sVNClientHelper = SVNClientHelper.getInstance();
                    if (sVNClientHelper.isVersioned(file)) {
                        sVNClientHelper.doRemove(new File[]{file});
                    } else {
                        this.getAppView().getXMLTransformationManager().deleteDirectory(file);
                    }
                } else {
                    this.getAppView().getXMLTransformationManager().deleteDirectory(file);
                }
            }
            this.physicalDesign = null;
            this.setDesign(null);
        }
        finally {
            this.closing = false;
        }
        System.gc();
    }

    @Override
    public int getNumberOfChildren() {
        if (!this.isOpen()) {
            return 0;
        }
        return this.elements.size();
    }

    @Override
    public ModelObject getChild(int n) {
        return (ModelObject)this.elements.get(n);
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return this.elements.indexOf(modelObject);
    }

    @Override
    public int getIndexForChild(Object object) {
        return this.elements.indexOf(object);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean bl) {
        this.open = bl;
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public void doAfterLoad() {
        this.checkAndSetIDGenerator();
        this.createFilesMap();
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.setAllStorableObjectsDirty(false);
        this.sortCollections();
        this.getAppView().getXMLTransformationManager().restoreDDLSelection(this);
    }

    public void load() {
        XMLPersistenceManager xMLPersistenceManager = this.getDesign().getAppView().getPersistenceManager();
        xMLPersistenceManager.removePMWPoolMap();
        xMLPersistenceManager.read((Object)this, this.getDesign(), true);
        this.checkAndSetIDGenerator();
        this.createFilesMap();
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.setAllStorableObjectsDirty(false);
    }

    public void checkAndSetIDGenerator() {
        Collection collection = this.getAllTopLevelObjects();
        Iterator iterator = collection.iterator();
        long l = 0L;
        long l2 = 0L;
        while (iterator.hasNext()) {
            ModelIDObject modelIDObject = (ModelIDObject)iterator.next();
            String string = modelIDObject.getObjectID();
            l2 = this.getCounter(string);
            if (l2 <= l) continue;
            l = l2;
        }
        long l3 = this.getDesign().getAppView().getIDGenerator().getStartCounter();
        long l4 = this.getDesign().getAppView().getIDGenerator().getLastIDIndex();
        if (l > l4) {
            this.getDesign().getAppView().getIDGenerator().setCounter(l - l3 + 1L);
        }
    }

    private long getCounter(String string) {
        int n = 9;
        int n2 = string.length();
        long l = 0L;
        if (n > n2) {
            n = n2 - 1;
        }
        while (true) {
            try {
                l = Integer.parseInt(string.substring(n2 - n));
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                if (--n >= 1) continue;
                return 0L;
            }
            break;
        }
    }

    public void createRepositoryMap() {
        this.repositoryMap.clear();
        List list = this.getStorableObjects();
        for (ModelIDObject modelIDObject : list) {
            if (modelIDObject.getRepositoryOID() == null) continue;
            RepDeleteDescr repDeleteDescr = new RepDeleteDescr();
            repDeleteDescr.objectType = modelIDObject.getObjectTypeName();
            repDeleteDescr.repOID = modelIDObject.getRepositoryOID();
            repDeleteDescr.repOVID = modelIDObject.getRepositoryOVID();
            this.repositoryMap.put(modelIDObject.getObjectID(), repDeleteDescr);
        }
    }

    public List getObjectsToDeleteFromRepository() {
        Object object22;
        List list = this.getStorableObjects();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Object object22 : list) {
            if (((ModelIDObject)object22).getRepositoryOID() == null) continue;
            treeMap.put(((ModelIDObject)object22).getObjectID(), ((ModelIDObject)object22).getObjectID());
        }
        object22 = new ArrayList();
        for (Map.Entry entry : this.repositoryMap.entrySet()) {
            Object v = treeMap.get(entry.getKey());
            if (v != null) continue;
            object22.add(entry.getValue());
        }
        return object22;
    }

    public void doAfterSave() {
        if (this.getPhysicalDesign().getDesign().getCurrentOperation() != 5) {
            this.synchronizeFilesMap(true);
        }
        this.setDirty(false);
        this.setAllStorableObjectsDirty(false);
    }

    public void synchronizeFilesMap(boolean bl) {
        this.removeDeletedObjects(bl);
        this.createFilesMap();
    }

    public void save() {
        if (!this.isTempModel()) {
            if (this.getDesign().isOldRepositoryType()) {
                MessageDialogs.showWarningMessage("This design is saved in an old format and can't be overwritten!\nPlease use \"Save As..\" option to save it as new design.");
            } else {
                DataModelerAddin.saveAllEditors(this);
                this.getAppView().setCurrentDesign(this.getDesign());
                this.getAppView().getXMLTransformationManager().savePhysicalModel(this);
            }
            this.setDirty(false);
            this.setAllStorableObjectsDirty(false);
        }
    }

    protected void createFilesMap() {
        this.filesMap.clear();
        List list = this.getStorableObjects();
        for (Object e : list) {
            ModelIDObject modelIDObject;
            if (!(e instanceof ModelIDObject) || (modelIDObject = (ModelIDObject)e).getSegmentedStorageName() == null) continue;
            this.filesMap.put(modelIDObject.getObjectID(), modelIDObject.getSegmentedStorageName());
        }
    }

    private void removeDeletedObjects(boolean bl) {
        Object object22;
        List list = this.getStorableObjects();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Object object22 : list) {
            treeMap.put(((ModelIDObject)object22).getObjectID(), ((ModelIDObject)object22).getObjectID());
        }
        object22 = new ArrayList();
        for (Map.Entry entry : this.filesMap.entrySet()) {
            Object v = treeMap.get(entry.getKey());
            if (v != null || entry.getValue() == null) continue;
            object22.add(entry.getValue());
        }
        if (object22.size() > 0) {
            if (Extension.isSVNExtensionLoaded() && bl && this.getDesign().isVersioned()) {
                SVNClientHelper.getInstance().doRemove((List<String>)object22);
            } else {
                this.getAppView().getXMLTransformationManager().deleteFiles((List)object22);
            }
        }
    }

    public abstract String getFormatedName(String var1);

    public static boolean hasForbiddenCharsOracle(String string) {
        return string.indexOf(32) > -1 || string.indexOf(46) > -1 || string.indexOf(38) > -1 || string.indexOf(33) > -1 || string.indexOf(39) > -1 || string.indexOf(126) > -1 || string.indexOf(37) > -1 || string.indexOf(94) > -1 || string.indexOf(40) > -1 || string.indexOf(41) > -1 || string.indexOf(45) > -1 || string.indexOf(123) > -1 || string.indexOf(125) > -1 || string.indexOf(92) > -1 || string.indexOf(47) > -1 || string.indexOf(124) > -1 || string.indexOf(58) > -1 || string.indexOf(59) > -1 || string.indexOf(42) > -1 || string.indexOf(63) > -1 || string.indexOf(62) > -1 || string.indexOf(60) > -1 || string.indexOf(44) > -1 || string.indexOf(39) > -1 || string.indexOf(34) > -1 || string.indexOf(63) > -1 || string.indexOf(43) > -1 || string.indexOf(96) > -1;
    }

    public boolean startsWithNumber(String string) {
        String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[0])) continue;
            return true;
        }
        return false;
    }

    public DDLAdvancedGenerator createDDLAdvancedGenerator() {
        return null;
    }

    public Map getNameSubstituionTypes() {
        return new TreeMap();
    }

    public List getNameSubstitutionTypesList() {
        if (this.substitutionList == null) {
            this.substitutionList = Arrays.asList(this.getNameSubstituionTypes().values().toArray());
        }
        return this.substitutionList;
    }

    public boolean isNameSubstitutionTypeSelected(String string) {
        ObjectType objectType = (ObjectType)this.getNameSubstituionTypes().get(string);
        if (objectType != null) {
            return objectType.isSelected();
        }
        return false;
    }

    public void copyStorageObjects(StorageDesign storageDesign) {
        this.getAllSetsList().clear();
        for (Object e : this.getAllSetsList()) {
            StorageObject storageObject;
            Iterator iterator;
            ModelObject modelObject;
            if (e instanceof StorageObjectSet) {
                modelObject = (StorageObjectSet)e;
                iterator = ((ModelObjectSet)modelObject).iterator();
                while (iterator.hasNext()) {
                    storageObject = (StorageObject)iterator.next();
                    storageObject.copy(storageDesign);
                }
                continue;
            }
            if (e instanceof RelationalObjectProxySet) {
                modelObject = (RelationalObjectProxySet)e;
                iterator = ((RelationalObjectProxySet)modelObject).iterator();
                while (iterator.hasNext()) {
                    storageObject = (StorageObject)iterator.next();
                    storageObject.copy(storageDesign);
                }
                continue;
            }
            System.out.println(e);
        }
    }

    public boolean isClosing() {
        return this.closing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStorageObjectsFromDDL() {
        block11: {
            try {
                Serializable serializable;
                URLFilter uRLFilter = new URLFilter(){

                    public boolean accept(URL uRL) {
                        File file = new File(uRL.getPath());
                        return file.getName().toLowerCase().endsWith(".sql") || file.getName().toLowerCase().endsWith(".ddl") || file.isDirectory();
                    }

                    public String toString() {
                        return "DDL Files (*.sql; *.ddl)";
                    }
                };
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(0);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setURLFilter(uRLFilter);
                ApplicationView.waitLoadFilesThreadToComplete();
                if (lastFolder != null) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
                } else {
                    String string = this.getAppView().getSettings().getDefaultImportPath();
                    if (string != null && string.length() > 0) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        serializable = this.getAppView().getUserHomeDirectory();
                        if (serializable != null) {
                            uRLChooser.setSelectedURL((URL)serializable);
                        }
                    }
                }
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), "Select File");
                if (n != 0 || (serializable = new File(uRLChooser.getSelectedURL().getPath())) == null) break block11;
                lastFolder = ((File)serializable).getParentFile();
                try {
                    String string = ((File)serializable).getName();
                    int n2 = string.lastIndexOf(46);
                    if (n2 > -1) {
                        string = string.substring(0, n2);
                    }
                    String string2 = this.physicalDesign.getDesign().getDesignPath();
                    ApplicationView.log(Messages.getString("StorageDesign.ImportingStorageObjectsFromDDL"));
                    DDLHandler dDLHandler = new DDLHandler(this.physicalDesign.getAppView(), this.physicalDesign, false, true, this);
                    dDLHandler.parse(new Object[]{serializable}, string, string2);
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error Importing Storage Objects from DDL", exception);
            }
        }
    }

    public boolean importStorageObjectsOnly() {
        return this.storageObjectsOnly;
    }

    public void setImportStorageObjectsOnly(boolean bl) {
        this.storageObjectsOnly = bl;
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public List getTypeOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("TSpace");
        arrayList.add("TmpTSpace");
        arrayList.add("UTSpace");
        arrayList.add("DB");
        arrayList.add("DataFile");
        arrayList.add("RLGrp");
        arrayList.add("Segment");
        arrayList.add("User");
        arrayList.add("QuotaItem");
        arrayList.add("Cluster");
        arrayList.add("Snapshot");
        arrayList.add("PartList");
        arrayList.add("Partition");
        arrayList.add("Level");
        arrayList.add("Hierarchy");
        arrayList.add("DimenAttr");
        arrayList.add("Dimension");
        arrayList.add("SType");
        arrayList.add("TypeElement");
        arrayList.add("Method");
        arrayList.add(MethodParam.TYPE_NAME);
        arrayList.add("CollectionType");
        arrayList.add("Table");
        arrayList.add("Column");
        arrayList.add("Index");
        return arrayList;
    }

    public List getOrderedTypes(List list) {
        ArrayList arrayList = new ArrayList(list);
        List list2 = this.getTypeOrder();
        if (list2.size() == 0) {
            return list;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : list2) {
            String string2 = null;
            for (int i = 0; i < list.size(); ++i) {
                String string3 = (String)list.get(i);
                if (!string3.equalsIgnoreCase(string)) continue;
                string2 = string3;
                arrayList.remove(string3);
                break;
            }
            if (string2 == null) continue;
            arrayList2.add(string2);
        }
        arrayList2.addAll(arrayList);
        return arrayList2;
    }

    public float getLoadedVersion() {
        return this.loadedVersion;
    }

    public void setLoadedVersion(float f) {
        this.loadedVersion = f;
    }

    public float getVersion() {
        return this.version;
    }

    public List getStorableObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ElementSet elementSet : this.getStorableSetsList()) {
            arrayList.addAll(Arrays.asList(elementSet.toArray()));
        }
        return arrayList;
    }

    public abstract List getStorableSetsList();

    public abstract List getUniqueList();

    public abstract List getFKProxyList();

    public abstract List getPKProxyList();

    public boolean hasDirtyStorableObjects() {
        for (ModelIDObject modelIDObject : this.getStorableObjects()) {
            if (!modelIDObject.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void setAllStorableObjectsDirty(boolean bl) {
        for (ModelIDObject modelIDObject : this.getStorableObjects()) {
            modelIDObject.setDirty(bl);
        }
    }

    public List getDirtyObjects() {
        ArrayList<ModelIDObject> arrayList = new ArrayList<ModelIDObject>();
        for (ModelIDObject modelIDObject : this.getStorableObjects()) {
            if (!modelIDObject.isDirty()) continue;
            arrayList.add(modelIDObject);
        }
        return arrayList;
    }

    public boolean isCloneOperation() {
        return this.cloneOperation;
    }

    public void setCloneOperation(boolean bl) {
        this.cloneOperation = bl;
    }

    public RDBMSSite getClonedSite() {
        return this.clonedSite;
    }

    public void setClonedSite(RDBMSSite rDBMSSite) {
        this.clonedSite = rDBMSSite;
    }

    public abstract List getRDBMSTypesForClone();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneFromMemoryToAnother(StorageDesign storageDesign, Map map, boolean bl) {
        List list = this.getRDBMSTypesForClone();
        StorageDesign storageDesign2 = storageDesign;
        StorageDesign storageDesign3 = this;
        if (list.contains(storageDesign2.getRDBMSType())) {
            try {
                Object object;
                Object object2;
                Object object3;
                TreeMap<Object, Object> treeMap;
                boolean bl2 = false;
                this.correspondenceMap = map;
                storageDesign2.correspondenceMap = map;
                storageDesign2.reverseMap = treeMap = new TreeMap<Object, Object>();
                storageDesign2.setLoading(true);
                this.getDesign().getAppView().getPersistenceManager().setCheckDirty(false);
                AbstractRXMLStorageDesign abstractRXMLStorageDesign = (AbstractRXMLStorageDesign)this.getDesign().getAppView().getPersistenceManager().getReaderFor(storageDesign2);
                AbstractXMLWriter abstractXMLWriter = this.getDesign().getAppView().getPersistenceManager().getWriterFor(storageDesign3);
                ArrayList<StorageObject> arrayList = new ArrayList<StorageObject>();
                ArrayList<StorageObject> arrayList2 = new ArrayList<StorageObject>();
                for (StorageObject storageObject : storageDesign3.getStorableObjects()) {
                    if (!this.shouldMerge(storageObject, bl)) continue;
                    if (storageObject instanceof RelationalObjectProxy) {
                        arrayList.add(storageObject);
                        if (map == null || (object3 = (ModelIDObject)map.get(object2 = storageObject.getObjectID())) == null) continue;
                        object = ((ModelIDObject)object3).getObjectID();
                        if (treeMap == null) continue;
                        treeMap.put(object, object2);
                        continue;
                    }
                    if (storageObject instanceof SnapshotOracle || storageObject instanceof SequenceOracle) continue;
                    arrayList2.add(storageObject);
                    this.createReadRequestForTargetObject(storageObject, storageDesign2);
                }
                arrayList2.addAll(arrayList);
                for (StorageObject storageObject : arrayList2) {
                    if (map == null || !storageObject.isTopLevelObject()) continue;
                    object2 = map.get(storageObject.getObjectID());
                    object3 = null;
                    if (object2 == null) continue;
                    if (object2 instanceof DesignObject) {
                        object = (DesignObject)object2;
                        if (object2 instanceof Table) {
                            object3 = storageDesign2.getTableProxySet().getProxy(((ModelIDObject)object).getObjectID());
                        } else if (object2 instanceof TableView) {
                            object3 = storageDesign2.getTableViewProxySet().getProxy(((ModelIDObject)object).getObjectID());
                        }
                    } else {
                        object3 = (StorageObject)object2;
                    }
                    if (object3 == null) continue;
                    ((StorageObject)object3).clearNoneMergableStructure();
                    ((StorageObject)object3).clearMergableStructure(treeMap);
                }
                for (StorageObject storageObject : arrayList2) {
                    String string = storageObject.getObjectTypeName();
                    object2 = abstractXMLWriter.getWriterFor(storageObject);
                    if (object2 == null || (object = abstractRXMLStorageDesign.recreateStorageObject((Document)(object3 = ((AbstractXMLWriter)object2).getDocument(storageObject)), string, storageDesign2, true)) == null) continue;
                    ((StorageObject)object).setDirty(true);
                    bl2 = true;
                }
                if (bl2) {
                    storageDesign2.setDirty(bl2);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error during clone of physical model " + this.getName() + "/n", exception);
            }
            finally {
                this.getDesign().getAppView().getPersistenceManager().setCheckDirty(true);
                this.correspondenceMap = null;
                storageDesign2.setLoading(false);
                storageDesign2.correspondenceMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneFromMemoryToAnotherSD_MD(StorageDesign storageDesign, Map map, boolean bl) {
        List list = this.getRDBMSTypesForClone();
        StorageDesign storageDesign2 = storageDesign;
        StorageDesign storageDesign3 = this;
        if (list.contains(storageDesign2.getRDBMSType())) {
            XMLTransformationManager xMLTransformationManager = this.getAppView().getXMLTransformationManager();
            boolean bl2 = xMLTransformationManager.isCheckDirty();
            try {
                Object object;
                Object object22;
                Object object3;
                Object object42;
                TreeMap<Object, Object> treeMap;
                boolean bl3 = false;
                this.correspondenceMap = map;
                storageDesign2.correspondenceMap = map;
                storageDesign2.reverseMap = treeMap = new TreeMap<Object, Object>();
                storageDesign2.setLoading(true);
                xMLTransformationManager.setCheckDirty(false);
                ArrayList<StorageObject> arrayList = new ArrayList<StorageObject>();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                this.processMatchByNameSets(storageDesign3, storageDesign2);
                for (Object object42 : storageDesign3.getStorableObjects()) {
                    if (!this.shouldMerge((ModelIDObject)object42, bl)) continue;
                    if (object42 instanceof RelationalObjectProxy) {
                        arrayList.add((StorageObject)object42);
                        if (map == null || (object3 = (ModelIDObject)map.get(object22 = ((ModelIDObject)object42).getObjectID())) == null) continue;
                        object = ((ModelIDObject)object3).getObjectID();
                        if (treeMap == null) continue;
                        treeMap.put(object, object22);
                        continue;
                    }
                    if (object42 instanceof SnapshotOracle || object42 instanceof SequenceOracle) continue;
                    arrayList2.add(object42);
                }
                arrayList2.addAll(arrayList);
                for (Object object42 : arrayList2) {
                    if (map == null || !((StorageObject)object42).isTopLevelObject()) continue;
                    object22 = map.get(((ModelIDObject)object42).getObjectID());
                    object3 = null;
                    if (object22 == null) continue;
                    if (object22 instanceof DesignObject) {
                        object = (DesignObject)object22;
                        if (object22 instanceof Table) {
                            object3 = storageDesign2.getTableProxySet().getProxy(((ModelIDObject)object).getObjectID());
                        } else if (object22 instanceof TableView) {
                            object3 = storageDesign2.getTableViewProxySet().getProxy(((ModelIDObject)object).getObjectID());
                        }
                    } else {
                        object3 = (StorageObject)object22;
                    }
                    if (object3 == null) continue;
                    ((StorageObject)object3).clearMergableStructure(treeMap);
                }
                XMLToObjectTransformer.processCreatedTime = false;
                object42 = storageDesign2.getDesign().getName();
                for (Object object22 : arrayList2) {
                    object3 = this.getOrCreateTargetObject((StorageObject)object22, storageDesign2);
                    object = ((GetHelper)object3).object;
                    if (object == null) continue;
                    String string = ((ModelIDObject)object).getObjectID();
                    String string2 = ((StorageObject)object).getDirectorySegmentName();
                    String string3 = ((ModelIDObject)object22).getCreatedTime();
                    String string4 = ((ModelIDObject)object22).getCreatedBy();
                    String string5 = ((ModelIDObject)object).getCreatedBy();
                    Document document = xMLTransformationManager.getXMLContent(object22);
                    if (document != null) {
                        xMLTransformationManager.transformFromXMLToObject(object, document);
                        ((ModelIDObject)object).setOwnerDesignName((String)object42);
                        if (!string.equals(((ModelIDObject)object).getObjectID())) {
                            ((StorageObject)object).setObjectID(string);
                        }
                        ((StorageObject)object).setDirectorySegmentName(string2, true);
                        if (!((GetHelper)object3).exists) {
                            ((ModelIDObject)object).setCreatedTime(string3);
                            ((ModelIDObject)object).setCreatedBy(string4);
                        } else {
                            ((ModelIDObject)object).setCreatedBy(string5);
                        }
                        ((StorageObject)object).setDirty(true);
                    }
                    if (!((ModelIDObject)object).isDirty()) continue;
                    bl3 = true;
                }
                if (bl3) {
                    storageDesign2.setDirty(bl3);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error during in memory clone of physical model " + this.getName() + "/n", exception);
            }
            finally {
                XMLToObjectTransformer.processCreatedTime = true;
                storageDesign2.setOwnerDesignName(storageDesign2.getDesign().getName());
                this.getDesign().getAppView().getPersistenceManager().setCheckDirty(true);
                this.correspondenceMap = null;
                storageDesign2.setLoading(false);
                storageDesign2.correspondenceMap = null;
                xMLTransformationManager.setCheckDirty(bl2);
            }
        }
    }

    public Map getCorrespondenceMap() {
        return this.correspondenceMap;
    }

    private GetHelper getOrCreateTargetObject(StorageObject storageObject, StorageDesign storageDesign) {
        String string;
        StorageObjectSet storageObjectSet;
        if (storageObject instanceof RelationalObjectProxy) {
            StorageDesign.getHelper.object = this.getTargetProxy(storageObject, storageDesign);
            return getHelper;
        }
        StorageObject storageObject2 = this.getMatchedTargetObject(storageObject, storageDesign);
        if (storageObject2 == null && (storageObjectSet = storageDesign.getStorageObjectSetForType(string = storageObject.getObjectTypeName())) != null) {
            storageObject2 = (StorageObject)storageObjectSet.createElement(this.id);
            StorageDesign.getHelper.exists = false;
        }
        StorageDesign.getHelper.object = storageObject2;
        return getHelper;
    }

    private StorageObject getTargetProxy(StorageObject storageObject, StorageDesign storageDesign) {
        ModelIDObject modelIDObject;
        String string = storageObject.getObjectID();
        String string2 = null;
        StorageObject storageObject2 = null;
        Map map = storageDesign.getCorrespondenceMap();
        Map map2 = storageDesign.getReverseMap();
        if (map != null && (modelIDObject = (ModelIDObject)map.get(string)) != null) {
            string2 = modelIDObject.getObjectID();
            if (map2 != null) {
                map2.put(string2, string);
            }
        }
        storageObject2 = string2 != null ? storageDesign.getStorageObject(string2) : storageDesign.getStorageObject(string);
        return storageObject2;
    }

    private void createReadRequestForTargetObject(StorageObject storageObject, StorageDesign storageDesign) {
        String string;
        ModelObject modelObject;
        Object object;
        String string2 = storageObject.getObjectID();
        String string3 = storageObject.getObjectTypeName();
        String string4 = null;
        storageDesign.setInitialReadBackDone(true);
        Map map = storageDesign.getCorrespondenceMap();
        Map map2 = storageDesign.getReverseMap();
        if (map != null && (object = (ModelIDObject)map.get(string2)) != null) {
            string4 = ((ModelIDObject)object).getObjectID();
            if (map2 != null) {
                map2.put(string4, string2);
            }
        }
        if (!((ReadRequest)(object = string4 != null ? storageDesign.getReadRequestFor(string4) : storageDesign.getReadRequestFor(string2))).hasObjectSet() && (modelObject = storageDesign.getStorageObjectSetForType(string3)) != null) {
            ((ReadRequest)object).setObjectSet(modelObject);
        }
        ((ReadRequest)object).setRequestLock(true);
        ((ReadRequest)object).setName(storageObject.getName());
        if (storageObject instanceof AbstractStorageObjectSqlServer && ((AbstractStorageObjectSqlServer)(modelObject = (AbstractStorageObjectSqlServer)storageObject)).getDatabase() != null && !"".equals(string = ((AbstractStorageObjectSqlServer)modelObject).getDatabase().getName().trim())) {
            ((ReadRequest)object).setDataBaseName(string);
        }
        ((ReadRequest)object).setTopLevelObject(storageObject.isTopLevelObject());
        ((ReadRequest)object).getStorageObject();
    }

    public Map getReverseMap() {
        return this.reverseMap;
    }

    boolean shouldMerge(ModelIDObject modelIDObject, boolean bl) {
        if (bl && modelIDObject instanceof RelationalObjectProxy) {
            DesignObject designObject = ((RelationalObjectProxy)modelIDObject).getObject();
            if (designObject instanceof TypeElement) {
                StructuredType structuredType = ((TypeElement)designObject).getStructuredType();
                return structuredType.shouldBeMerge() && designObject.shouldBeMerge();
            }
            if (designObject instanceof Method) {
                StructuredType structuredType = ((Method)designObject).getStructuredType();
                return structuredType.shouldBeMerge() && designObject.shouldBeMerge();
            }
            if (designObject instanceof MethodParam && ((MethodParam)designObject).getMethod() != null) {
                StructuredType structuredType = ((MethodParam)designObject).getMethod().getStructuredType();
                return structuredType.shouldBeMerge() && ((MethodParam)designObject).getMethod().shouldBeMerge();
            }
            return designObject.shouldBeMerge();
        }
        return true;
    }

    @Override
    public String getShortObjectID() {
        String string = this.getRDBMSSite().getShortObjectID();
        if (this.isCloneOperation() && this.getClonedSite() != null) {
            string = this.getClonedSite().getShortObjectID();
        }
        return string;
    }

    @Override
    public String getStoragePath() {
        String string = this.getPhysicalDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                String string2 = this.getRDBMSSite().getShortObjectID();
                if (this.isCloneOperation() && this.getClonedSite() != null) {
                    string2 = this.getClonedSite().getShortObjectID();
                }
                return new File(string, "phys/" + string2).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String string = this.getPhysicalDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                String string2 = this.getRDBMSSite().getShortObjectID();
                if (this.isCloneOperation() && this.getClonedSite() != null) {
                    string2 = this.getClonedSite().getShortObjectID();
                }
                return new File(string, "phys/" + string2 + "/" + string2 + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setObjectListChanged(boolean bl) {
        this.objectListChanged = bl;
    }

    public boolean isObjectListChanged() {
        return this.objectListChanged;
    }

    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
        }
        return this.f2tMap;
    }

    public void dumpObjectTypes() {
        for (Object e : this.getStorableSetsList()) {
            try {
                ModelObject modelObject;
                if (e instanceof StorageObjectSet) {
                    modelObject = (StorageObjectSet)e;
                    ModelIDObject modelIDObject = ((ModelIDObjectSet)modelObject).createElement(null);
                    System.out.println("f2tMap.put(" + modelIDObject.getClass().getSimpleName() + ".TYPE_NAME, " + modelIDObject.getClass().getSimpleName() + ".TYPE_NAME);");
                    continue;
                }
                if (e instanceof RelationalObjectProxySet) {
                    modelObject = (RelationalObjectProxySet)e;
                    System.out.println("f2tMap.put(" + modelObject.getClass().getSimpleName() + ".TYPE_NAME, " + modelObject.getClass().getSimpleName() + ".TYPE_NAME);");
                    continue;
                }
                System.out.println("---" + e);
            }
            catch (Exception exception) {}
        }
    }

    public void reloadAllProxies() {
        if (this.getTableProxySet() != null) {
            this.getTableProxySet().setDesign(this.getDesign());
        }
        if (this.getTableViewProxySet() != null) {
            this.getTableViewProxySet().setDesign(this.getDesign());
        }
        if (this.getColumnProxySet() != null) {
            this.getColumnProxySet().setDesign(this.getDesign());
        }
        if (this.getIndexProxySet() != null) {
            this.getIndexProxySet().setDesign(this.getDesign());
        }
        if (this.getStructuredTypeProxySet() != null) {
            this.getStructuredTypeProxySet().setDesign(this.getDesign());
        }
        if (this.getTypeElementProxySet() != null) {
            this.getTypeElementProxySet().setDesign(this.getDesign());
        }
        if (this.getMethodProxySet() != null) {
            this.getMethodProxySet().setDesign(this.getDesign());
        }
        if (this.getMethodParamProxySet() != null) {
            this.getMethodParamProxySet().setDesign(this.getDesign());
        }
        if (this.getCollectionTypeProxySet() != null) {
            this.getCollectionTypeProxySet().setDesign(this.getDesign());
        }
    }

    public boolean isTempModel() {
        return this.tempModel;
    }

    public void setTempModel(boolean bl) {
        this.tempModel = bl;
        this.getPhysicalDesign().getStorageDesignFactory().sdTempStatusChanged(this);
    }

    public static void initObjectDetails(Design design, File file, SVNUrl sVNUrl, boolean bl, String string, StorableObjectStatusHelper storableObjectStatusHelper, String string2, StorageDesign storageDesign) {
        SVNObjectHelper sVNObjectHelper;
        File file2;
        SVNClientHelper sVNClientHelper = SVNClientHelper.getInstance();
        SVNObjectHelper sVNObjectHelper2 = SVNClientHelper.svnOHMap.get(storageDesign.getShortObjectID() + "_" + string2);
        if (sVNObjectHelper2 == null) {
            sVNObjectHelper2 = sVNClientHelper.createSVNObjectHelper(file, sVNUrl, bl, storageDesign.getShortObjectID());
        }
        if ((file2 = file.getParentFile()).getName().startsWith(SegmentNameManager.NAME_PREFIX)) {
            file2 = file2.getParentFile();
        }
        if ((sVNObjectHelper = SVNClientHelper.svnOHMap.get(sVNObjectHelper2.parentID)) != null) {
            storableObjectStatusHelper.treePath.add(new TreePathHelper(sVNObjectHelper.propName, new File(sVNObjectHelper.fileName), StorageDesign.class));
        } else {
            storableObjectStatusHelper.treePath.add(new TreePathHelper(storageDesign.getName(), new File(storageDesign.getStoragePath()), StorageDesign.class));
        }
        storableObjectStatusHelper.objectType = string;
        storableObjectStatusHelper.storableObject = storageDesign.getStorageObject(sVNObjectHelper2.propID);
        if (sVNObjectHelper2.className != null) {
            try {
                Class<?> clazz;
                storableObjectStatusHelper.objectClass = clazz = Class.forName(sVNObjectHelper2.className);
                storableObjectStatusHelper.treePath.add(new TreePathHelper(string, file2, clazz));
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.error(classNotFoundException);
            }
        }
    }

    public List<ModelIDObject> getNotMarkedGenerateObjects() {
        ArrayList<ModelIDObject> arrayList = new ArrayList<ModelIDObject>();
        for (ElementSet elementSet : this.createDDLSelectionSetsList()) {
            this.addNotMarkedGenerateObjects(elementSet, arrayList);
        }
        return arrayList;
    }

    public List<ElementSet> getDDLSelectionSetsList() {
        if (this.ddlSelectionSetsList == null) {
            this.ddlSelectionSetsList = this.createDDLSelectionSetsList();
        }
        return this.ddlSelectionSetsList;
    }

    protected List<ElementSet> createDDLSelectionSetsList() {
        return new ArrayList<ElementSet>();
    }

    private void addNotMarkedGenerateObjects(ElementSet elementSet, List<ModelIDObject> list) {
        Iterator iterator = elementSet.iterator();
        while (iterator.hasNext()) {
            ModelIDObject modelIDObject = (ModelIDObject)iterator.next();
            if (modelIDObject.isMarkedGenerate()) continue;
            list.add(modelIDObject);
        }
    }

    public List getStructuredTypesOrderedByParent() {
        ArrayList<StructuredTypeProxy> arrayList = new ArrayList<StructuredTypeProxy>();
        for (StructuredType structuredType : this.getDesign().getDataTypesDesign().getStructuredTypesOrderedByParent()) {
            StructuredTypeProxy structuredTypeProxy = (StructuredTypeProxy)this.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
            if (structuredTypeProxy == null) continue;
            arrayList.add(structuredTypeProxy);
        }
        return arrayList;
    }

    public TableProxy getTableProxyBySchemaAndName(String string, String string2) {
        Table table = this.getPhysicalDesign().getTableSet().getBySchemaAndName(string, string2);
        if (table != null) {
            return (TableProxy)this.getTableProxySet().getObjectGeneratedBy(table);
        }
        return null;
    }

    public StorageObjectSet getUserSchemaSet() {
        return null;
    }

    public String getSchemaImplementationNane(SchemaObject schemaObject) {
        StorageObject storageObject;
        if (schemaObject != null && (storageObject = this.getUserSchemaSet().getBySchemaObject(schemaObject)) != null) {
            return storageObject.getName();
        }
        return "";
    }

    public String getSiteName() {
        if (this.rdbmsSite != null) {
            return this.rdbmsSite.getName();
        }
        return "";
    }

    public void setSiteName(String string) {
    }

    public String getSiteID() {
        if (this.rdbmsSite != null) {
            return this.rdbmsSite.getObjectID();
        }
        return "";
    }

    public void setSiteID(String string) {
    }

    public int getSiteType() {
        if (this.rdbmsSite != null) {
            return this.rdbmsSite.getType().getType();
        }
        return -1;
    }

    public void setSiteType(int n) {
    }

    public void openStorageDesign() {
        if (!this.isOpen()) {
            this.getAppView().getXMLTransformationManager().openPhysicalModel(this);
            this.setOpen(true);
        }
    }

    public List getMatchByNameSets() {
        return Collections.EMPTY_LIST;
    }

    private void processMatchByNameSets(StorageDesign storageDesign, StorageDesign storageDesign2) {
        for (Object e : storageDesign.getMatchByNameSets()) {
            if (!(e instanceof StorageObjectSet)) continue;
            StorageObjectSet storageObjectSet = (StorageObjectSet)e;
            Iterator iterator = storageObjectSet.iterator();
            while (iterator.hasNext()) {
                StorageObject storageObject = (StorageObject)iterator.next();
                this.getMatchedTargetObject(storageObject, storageDesign2);
            }
        }
    }

    private StorageObject getMatchedTargetObject(StorageObject storageObject, StorageDesign storageDesign) {
        ModelObject modelObject;
        StorageObject storageObject2 = null;
        String string = storageObject.getObjectID();
        String string2 = storageObject.getObjectTypeName();
        String string3 = null;
        Map map = storageDesign.getCorrespondenceMap();
        Map map2 = storageDesign.getReverseMap();
        if (map != null && (modelObject = (ModelIDObject)map.get(string)) != null) {
            string3 = ((ModelIDObject)modelObject).getObjectID();
            if (map2 != null) {
                map2.put(string3, string);
            }
        }
        if (string3 != null) {
            string = string3;
        }
        if ((modelObject = storageDesign.getStorageObjectSetForType(string2)) != null) {
            storageObject2 = (StorageObject)((ModelObjectSet)modelObject).getObjectByID(string);
            if (storageObject2 == null && storageObject.isTopLevelObject()) {
                String string4;
                AbstractStorageObjectSqlServer abstractStorageObjectSqlServer;
                String string5 = null;
                String string6 = storageObject.getName();
                if (storageObject instanceof AbstractStorageObjectSqlServer && (abstractStorageObjectSqlServer = (AbstractStorageObjectSqlServer)storageObject).getDatabase() != null && !"".equals(string4 = abstractStorageObjectSqlServer.getDatabase().getName().trim())) {
                    string5 = string4;
                }
                if (string6 != null && string6.length() > 0 && (storageObject2 = string5 != null ? ((StorageObjectSet)modelObject).getByNameAndDatabase(string6, string5) : (StorageObject)((ModelObjectSet)modelObject).getByName(string6)) != null) {
                    storageDesign.getCorrespondenceMap().put(string, storageObject2);
                }
            }
            if (storageObject2 != null && map2 != null) {
                map2.put(storageObject2.getObjectID(), string);
            }
            if (storageObject2 == null) {
                storageObject2 = (StorageObject)((ModelIDObjectSet)modelObject).createElement(string);
            }
        }
        return storageObject2;
    }

    @Override
    public void setOwnerDesignName(String string) {
        super.setOwnerDesignName(string);
        for (Object e : this.getAllSetsList()) {
            if (!(e instanceof ElementSet)) continue;
            ElementSet elementSet = (ElementSet)e;
            Iterator iterator = elementSet.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!(e2 instanceof ModelIDObject)) continue;
                ((ModelIDObject)e2).setOwnerDesignName(string);
            }
        }
    }

    public String[] getFKDeleteRules() {
        return FKIndexAssociation.DELETE_RULES;
    }

    public String[] getFKDeleteRulesMandatory() {
        return FKIndexAssociation.DELETE_RULES_WITHOUT_NULL;
    }

    public String[] getFKDeleteRulesNonTransferable() {
        return FKIndexAssociation.DELETE_RULES_RESTRICT_CASCADE;
    }

    public String getValidFKRule(String string) {
        if ("SET DEFAULT".equals(string)) {
            return "NO ACTION";
        }
        return string;
    }

    static class GetHelper {
        StorageObject object;
        boolean exists = true;

        GetHelper() {
        }
    }

    public class ObjectType {
        private boolean isSelected = false;
        private String typeName = "";

        public ObjectType(String string) {
            this.typeName = string;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String string) {
            this.typeName = string;
        }

        public String toString() {
            return this.typeName;
        }
    }

    public static class NullStorageDesign
    extends StorageDesign {
        private String label;
        private Object msg;

        NullStorageDesign(RelationalDesign relationalDesign, String string, Object object, RDBMSSite rDBMSSite, Design design) {
            super(relationalDesign, rDBMSSite, design);
            this.label = string;
            this.msg = object;
        }

        @Override
        public RDBMSType getRDBMSType() {
            return this.getRDBMSSite().getType();
        }

        public RDBMSSite getDefaultRDBMSSite() {
            return this.getRDBMSSite();
        }

        @Override
        public PropertyHolder getPropertyHolder() {
            return null;
        }

        @Override
        public void objectAdded(DesignPart designPart, DesignObject designObject) {
        }

        @Override
        public void objectRemoved(DesignPart designPart, DesignObject designObject) {
        }

        @Override
        public void addPhysicalObject(DesignObject designObject) {
        }

        @Override
        public void removePhysicalObject(DesignObject designObject) {
        }

        @Override
        public void removePhysicalObject(String string) {
        }

        @Override
        public TableProxySet getTableProxySet() {
            return null;
        }

        @Override
        public IndexProxySet getIndexProxySet() {
            return null;
        }

        @Override
        public ColumnProxySet getColumnProxySet() {
            return null;
        }

        @Override
        public TableViewProxySet getTableViewProxySet() {
            return null;
        }

        @Override
        public StructuredTypeProxySet getStructuredTypeProxySet() {
            return null;
        }

        @Override
        public CollectionTypeProxySet getCollectionTypeProxySet() {
            return null;
        }

        @Override
        public MethodProxySet getMethodProxySet() {
            return null;
        }

        @Override
        public TypeElementProxySet getTypeElementProxySet() {
            return null;
        }

        @Override
        public MethodParamProxySet getMethodParamProxySet() {
            return null;
        }

        @Override
        public StorageObjectSet getStorageObjectSetForType(String string) {
            return null;
        }

        @Override
        public Collection getAllTopLevelObjects() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public String getIDPrefix() {
            return "NULLSTODES";
        }

        @Override
        public String getObjectID() {
            return this.getIDPrefix();
        }

        @Override
        public boolean isNullInstance() {
            return true;
        }

        public Object getMessage() {
            return this.msg;
        }

        @Override
        public String getName() {
            return this.label;
        }

        @Override
        public MDDataTypeFactory createDataTypeFactory() {
            return null;
        }

        @Override
        public String getFormatedName(String string) {
            return string;
        }

        @Override
        public List getStorableSetsList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getUniqueList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getFKProxyList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getPKProxyList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getRDBMSTypesForClone() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public void sortCollections() {
        }

        @Override
        public TableProxySet getSubViewTableProxySet() {
            return null;
        }

        @Override
        public TableViewProxySet getSubViewTableViewProxySet() {
            return null;
        }
    }
}

