/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.io.File;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.ReadRequest;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubjectImpl;
import oracle.dbtools.crest.util.logging.Logger;

public class RelationalObjectProxy
extends StorageObject
implements UpdateSubject,
ObjectListener {
    private DesignObject object = null;
    private String id = null;
    private String longName = null;
    private boolean nameChanged = false;
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    private UpdateSubjectImpl updateDelegate = new UpdateSubjectImpl();
    private RelationalObjectProxySet proxySet;
    private static final Logger LOGGER = new Logger(RelationalObjectProxy.class);

    public RelationalObjectProxy(DesignObject designObject, StorageDesign storageDesign) {
        this.object = designObject;
        this.setStorageDesign(storageDesign);
        this.setObjectID(designObject.getObjectID());
        this.id = designObject.getObjectID();
        this.longName = designObject.getLongName();
        this.setDesign(designObject.getDesign());
        this.setName(designObject.getName());
        this.setNameChanged(false);
        designObject.addObjectListener(this);
    }

    public RelationalObjectProxy(Design design, String string, String string2, StorageDesign storageDesign) {
        this.id = string;
        this.longName = string2;
        this.setDesign(design);
        this.setStorageDesign(storageDesign);
    }

    public DesignObject getObject() {
        if (this.object == null) {
            this.loadDesignObject();
        }
        return this.object;
    }

    public void setObject(DesignObject designObject) {
        this.object = designObject;
    }

    public boolean loadDesignObject() {
        if (this.getStorageDesign().isClosing()) {
            return false;
        }
        if (this.object == null && this.getDesign() != null) {
            this.object = this.getDesign().getDesignObject(this.id);
            if (this.object == null) {
                try {
                    this.object = (DesignObject)this.getDesign().getAppView().getPersistenceManager().read((Object)this.getObjectID(), this.getDesign(), true);
                    this.object.addObjectListener(this);
                    this.longName = this.object.getLongName();
                    this.fireUpdate();
                }
                catch (Exception exception) {
                    LOGGER.error("PhysicalObjectProxy can not load object: " + this.getObjectID(), exception);
                }
            }
            if (this.isLoaded()) {
                this.setName(this.object.getName());
            }
        }
        return this.isLoaded();
    }

    public boolean isLoaded() {
        return this.object != null;
    }

    @Override
    public String getObjectID() {
        return this.id;
    }

    @Override
    public void setObjectID(String string) {
        this.id = string;
    }

    @Override
    public String getLongName() {
        if (this.isLoaded()) {
            this.longName = this.getObject().isContainedObject() ? this.getObject().getLongName() : super.getLongName();
        } else if (this.longName == null) {
            this.longName = this.getObjectID();
        }
        return this.longName;
    }

    @Override
    public String toString() {
        return this.getLongName();
    }

    public boolean isTable() {
        return false;
    }

    @Override
    public void addUpdateListener(UpdateListener updateListener) {
        this.updateDelegate.addUpdateListener(updateListener);
    }

    @Override
    public void removeUpdateListener(UpdateListener updateListener) {
        this.updateDelegate.removeUpdateListener(updateListener);
    }

    @Override
    protected void fireUpdate() {
        this.updateDelegate.fireChange();
    }

    @Override
    public String getIDPrefix() {
        return "PROXY";
    }

    @Override
    public String getObjectTypeName() {
        return "PROXY";
    }

    @Override
    public final boolean isPhysicalObjectProxy() {
        return true;
    }

    @Override
    public String getName() {
        if (this.isNameChanged() && !"".equals(super.getName())) {
            return super.getName();
        }
        String string = this.getObject().getName();
        string = this.applyNameSubstitution(string);
        return string;
    }

    @Override
    public boolean setName(String string) {
        boolean bl = true;
        if (!this.getName().equals(string) && (bl = super.setName(this.applyNameRules(string)))) {
            this.setNameChanged(true);
            this.setDirty(true);
        }
        if (this.getObject() != null && this.isNameChanged() && this.getName().equals(this.getObject().getName())) {
            this.setNameChanged(false);
            this.setDirty(true);
        }
        return bl;
    }

    protected String applyNameRules(String string) {
        return string;
    }

    public void copyCommentInRDBMS() {
        if (this.isLoaded()) {
            this.setCommentInRDBMS(this.getObject().getCommentInRDBMS());
        }
    }

    protected ColumnProxy[] getColumnProxies() {
        ContainedObject[] containedObjectArray = ((ContainerObject)this.getObject()).getElements();
        ColumnProxy[] columnProxyArray = new ColumnProxy[containedObjectArray.length];
        for (int i = 0; i < containedObjectArray.length; ++i) {
            columnProxyArray[i] = this.getColumnProxy(containedObjectArray[i].getObjectID());
        }
        return columnProxyArray;
    }

    protected ColumnProxy getColumnProxy(String string) {
        return (ColumnProxy)this.getStorageDesign().getColumnProxySet().getProxy(string);
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.NAME_CHANGED)) {
            ElementSet elementSet;
            if (!this.isNameChanged()) {
                this.setName(designObject.getName());
            }
            if (this.isTopLevelObject() && (elementSet = this.getSet()) != null && elementSet.canSort()) {
                elementSet.sort();
            }
            this.fireChangeNoDirty(objectChangeEvent);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.OBJECT_ID_CHANED)) {
            String string = this.getObjectID();
            String string2 = designObject.getObjectID();
            if (string != null && !string.equals(string2)) {
                this.getStorageDesign().unregisterModelIDObject(this);
                if (this.proxySet != null) {
                    this.proxySet.updateProxyID(string, string2);
                }
                this.setObjectID(string2);
                this.getStorageDesign().registerModelIDObject(this);
            }
        }
    }

    @Override
    public void showPropertyDialog() {
    }

    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    public void setCommentChanged(boolean bl) {
        this.commentChanged = bl;
    }

    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    public void setCommentInRDBMSChanged(boolean bl) {
        this.commentInRDBMSChanged = bl;
    }

    @Override
    public boolean isNameChanged() {
        return this.nameChanged;
    }

    @Override
    public void setNameChanged(boolean bl) {
        this.nameChanged = bl;
    }

    @Override
    public boolean isMarkedGenerate() {
        if (this.getStorageDesign().isOpen()) {
            return super.isMarkedGenerate();
        }
        return this.getObject().isMarkedGenerate();
    }

    @Override
    public void setMarkedGenerate(boolean bl) {
        super.setMarkedGenerate(bl);
        if (!this.getStorageDesign().isOpen() && !this.getStorageDesign().isLoading()) {
            this.getObject().setMarkedGenerate(bl);
        }
    }

    @Override
    public void setDropEnabled(boolean bl) {
        super.setDropEnabled(bl);
        this.getObject().setDropEnabled(bl);
    }

    @Override
    public boolean isDropEnabled() {
        if (this.getStorageDesign().isOpen()) {
            if (!Design.DROP_GENERATED_OBJECTS_ONLY) {
                return super.isDropEnabled();
            }
            return this.isMarkedGenerate() && super.isDropEnabled();
        }
        if (!Design.DROP_GENERATED_OBJECTS_ONLY) {
            return this.getObject().isDropEnabled();
        }
        return this.isMarkedGenerate() && this.getObject().isDropEnabled();
    }

    @Override
    public void remove() {
        if (this.object != null) {
            this.object.removeObjectListener(this);
        }
        super.remove();
    }

    public RelationalObjectProxySet getProxySet() {
        return this.proxySet;
    }

    public void setProxySet(RelationalObjectProxySet relationalObjectProxySet) {
        this.proxySet = relationalObjectProxySet;
    }

    public void reloadExistingData() {
        ReadRequest readRequest = this.getStorageDesign().getReadRequestFor(this.getObjectID());
        AbstractXMLReader abstractXMLReader = this.getDesign().getAppView().getPersistenceManager().getReaderFor(this.getStorageDesign());
        if (abstractXMLReader != null) {
            readRequest.setObjectSet(this.getProxySet());
            readRequest.setStorageObject(this);
            abstractXMLReader.recreateObject((Object)readRequest, this.getDesign(), true);
        }
    }

    @Override
    public String getDirectorySegmentName() {
        RelationalObjectProxySet relationalObjectProxySet;
        if ("".equals(this.directorySegmentName) && (relationalObjectProxySet = this.getProxySet()) != null) {
            this.directorySegmentName = relationalObjectProxySet.getSegmentName(this);
        }
        return this.directorySegmentName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getSegmentedStorageName() {
        RelationalObjectProxySet relationalObjectProxySet = this.getProxySet();
        if (this.segmentedStorageName != null) return this.segmentedStorageName;
        if (relationalObjectProxySet == null) return super.getSegmentedStorageName();
        String string = relationalObjectProxySet.getSegmentName(this);
        if ("".equals(string)) return super.getSegmentedStorageName();
        File file = new File(this.getStorageName());
        String string2 = file.getName();
        this.segmentedStorageName = file.getParent() + "/" + string + "/" + string2;
        return this.segmentedStorageName;
    }

    @Override
    public void setDirectorySegmentName(String string, boolean bl) {
        RelationalObjectProxySet relationalObjectProxySet;
        if (string != null && !"".equals(string) && (relationalObjectProxySet = this.getProxySet()) != null) {
            relationalObjectProxySet.addSegmentEntry(string, this.getObjectID(), bl);
        }
        this.directorySegmentName = string;
    }

    @Override
    public void setDirectorySegmentName(String string) {
        this.setDirectorySegmentName(string, false);
    }

    @Override
    protected void sortObjectSet() {
        RelationalObjectProxySet relationalObjectProxySet = this.getProxySet();
        if (relationalObjectProxySet != null) {
            relationalObjectProxySet.sort();
        }
    }

    @Override
    public ElementSet getSet() {
        return this.getProxySet();
    }
}

