/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Map;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;

public class ReadRequest {
    private StorageDesign storageDesign;
    private String id;
    private StorageObjectSet storageObjectSet;
    private RelationalObjectProxySet proxySet;
    private StorageObject storageObject = null;
    private boolean requestLock = true;
    private String name;
    private String dataBaseName;
    private boolean isTopLevelObject = true;

    public ReadRequest(StorageDesign storageDesign, String string) {
        this.storageDesign = storageDesign;
        this.id = string;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public String getObjectName() {
        return this.id;
    }

    public String getObjectId() {
        return this.id;
    }

    public boolean isRequestFor(StorageDesign storageDesign) {
        return this.isRequestFor(storageDesign.getRDBMSSite());
    }

    public boolean isRequestFor(RDBMSSite rDBMSSite) {
        return this.getStorageDesign().getRDBMSSite().equals(rDBMSSite);
    }

    public boolean isRequestFor(RDBMSType rDBMSType) {
        return this.getStorageDesign().getRDBMSType().equals(rDBMSType);
    }

    public void setRequestLock(boolean bl) {
        this.requestLock = bl;
    }

    public boolean getRequestLock() {
        return this.requestLock;
    }

    public void setObjectSet(Object object) {
        if (object instanceof StorageObjectSet) {
            this.storageObjectSet = (StorageObjectSet)object;
        } else if (object instanceof RelationalObjectProxySet) {
            this.proxySet = (RelationalObjectProxySet)object;
        } else {
            throw new IllegalArgumentException("GenericRXMLStorageObject accepts a StorageObjectSet or a PhysicalObjectProxySet only");
        }
    }

    protected StorageObject createObject(String string) {
        if (this.proxySet != null) {
            return this.createProxy(string);
        }
        if (this.storageObjectSet != null) {
            return this.createStorageObject(string);
        }
        throw new IllegalStateException("Either a PhysicalObjectProxySet or a StorageObjectSet instance should be set");
    }

    protected RelationalObjectProxy createProxy(String string) {
        if (this.proxySet != null) {
            return this.proxySet.getProxy(string);
        }
        return null;
    }

    protected StorageObject createStorageObject(String string) {
        if (this.storageObjectSet != null) {
            StorageObject storageObject = (StorageObject)this.storageObjectSet.getById(string);
            if (storageObject != null) {
                return storageObject;
            }
            if (this.storageDesign.getDesign().isMerging() && this.isTopLevelObject && this.name != null && this.name.length() > 0 && (storageObject = this.dataBaseName != null ? this.storageObjectSet.getByNameAndDatabase(this.name, this.dataBaseName) : (StorageObject)this.storageObjectSet.getByName(this.name)) != null) {
                this.storageDesign.getCorrespondenceMap().put(string, storageObject);
                Map map = this.storageDesign.getReverseMap();
                if (map != null) {
                    map.put(storageObject.getObjectID(), string);
                }
                return storageObject;
            }
            return (StorageObject)this.storageObjectSet.createElement(string);
        }
        return null;
    }

    public StorageObject getStorageObject() {
        if (this.storageObject == null) {
            this.storageObject = this.createStorageObject(this.id);
        }
        return this.storageObject;
    }

    public void setStorageObject(StorageObject storageObject) {
        if (this.storageObject != null && this.storageObject != storageObject) {
            throw new IllegalStateException("Changing StorageObject instance on read request is not allowed");
        }
        this.storageObject = storageObject;
    }

    public String toString() {
        return new StringBuffer("Read request for <").append(this.id).append("> in Storage Design <").append(this.storageDesign.getLongName()).append(">").toString();
    }

    public boolean hasObjectSet() {
        return this.proxySet != null || this.storageObjectSet != null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setTopLevelObject(boolean bl) {
        this.isTopLevelObject = bl;
    }

    public String getDataBaseName() {
        return this.dataBaseName;
    }

    public void setDataBaseName(String string) {
        this.dataBaseName = string;
    }
}

