/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.AbstractRDBMSSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;

public class RDBMSSiteSet
extends AbstractRDBMSSet
implements RepositoryObject {
    public static final Object[] PROTO_ARRAY = new RDBMSSite[0];
    private RDBMSSite[] array = null;
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private boolean checkedOut = false;
    private boolean checkedOutByMe = false;
    private String checkedOutBy = "";
    private boolean dirty = false;
    private boolean saveDefaults = false;
    private boolean loadFromRepository = false;
    private RepositoryObject pac_Element;
    private int maxIndex = 0;
    private Design design;

    public RDBMSSiteSet(Design design) {
        this.design = design;
    }

    public void add(RDBMSSite rDBMSSite) {
        this.basicAdd(rDBMSSite);
        this.array = null;
        rDBMSSite.setRDBMSSiteSet(this);
    }

    public void remove(RDBMSSite rDBMSSite) {
        this.getValueSet().remove(rDBMSSite);
        this.array = (RDBMSSite[])this.getValueSet().toArray(PROTO_ARRAY);
    }

    public void removeAll(Collection<RDBMSSite> collection) {
        this.getValueSet().removeAll(collection);
        this.array = (RDBMSSite[])this.getValueSet().toArray(PROTO_ARRAY);
    }

    public void removeAll() {
        this.getValueSet().clear();
        this.array = (RDBMSSite[])this.getValueSet().toArray(PROTO_ARRAY);
    }

    public RDBMSSite[] toSiteArray() {
        if (this.array == null) {
            this.array = (RDBMSSite[])this.getValueSet().toArray(PROTO_ARRAY);
        }
        return this.array;
    }

    public Object[] toArray() {
        return this.toSiteArray();
    }

    public RDBMSType getDefaultType() {
        return this.design.getDefaultRDBMSTypeSet().get(this.design.getAppView().getSettings().getDefaultRDBMSType());
    }

    public RDBMSSite createSite(String string, RDBMSType rDBMSType, Design design) {
        RDBMSSite rDBMSSite = new RDBMSSite(string, design);
        rDBMSSite.setType(rDBMSType);
        this.add(rDBMSSite);
        return rDBMSSite;
    }

    public RDBMSSite createSite(String string, Design design) {
        return this.createSite(string, this.getDefaultType(), design);
    }

    public RDBMSSite get(RDBMSType rDBMSType) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RDBMSSite rDBMSSite = (RDBMSSite)iterator.next();
            if (rDBMSSite.getType() != rDBMSType) continue;
            return rDBMSSite;
        }
        return null;
    }

    public RDBMSSite getByObjectID(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RDBMSSite rDBMSSite = (RDBMSSite)iterator.next();
            if (!rDBMSSite.getObjectID().equalsIgnoreCase(string)) continue;
            return rDBMSSite;
        }
        return null;
    }

    public RDBMSSite getByPathIDString(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RDBMSSite rDBMSSite = (RDBMSSite)iterator.next();
            if (!rDBMSSite.getPathIDString().equalsIgnoreCase(string)) continue;
            return rDBMSSite;
        }
        return null;
    }

    public RDBMSSite getByShortObjectIDString(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RDBMSSite rDBMSSite = (RDBMSSite)iterator.next();
            if (!rDBMSSite.getShortObjectID().equalsIgnoreCase(string)) continue;
            return rDBMSSite;
        }
        return null;
    }

    public RDBMSSite getByName(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RDBMSSite rDBMSSite = (RDBMSSite)iterator.next();
            if (!rDBMSSite.getName().equalsIgnoreCase(string)) continue;
            return rDBMSSite;
        }
        return null;
    }

    public boolean canSaveDefaults() {
        return this.saveDefaults;
    }

    public void setSaveDefaults(boolean bl) {
        this.saveDefaults = bl;
    }

    @Override
    public boolean canBedeleted() {
        return false;
    }

    @Override
    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    @Override
    public boolean isCheckedOutByMe() {
        return this.checkedOutByMe;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setCheckedOut(boolean bl) {
        this.checkedOut = bl;
    }

    @Override
    public void setCheckedOutBy(String string) {
        this.checkedOutBy = string;
    }

    @Override
    public void setCheckedOutByMe(boolean bl) {
        this.checkedOutByMe = bl;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public void setRepositoryOID(String string) {
        this.repositoryOID = string;
    }

    @Override
    public void setRepositoryOVID(String string) {
        this.repositoryOVID = string;
    }

    @Override
    public String getName() {
        return "RDBMSSiteSet";
    }

    public boolean isLoadFromRepository() {
        return this.loadFromRepository;
    }

    public void setLoadFromRepository(boolean bl) {
        this.loadFromRepository = bl;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return true;
    }

    @Override
    public void setPAC_Element(RepositoryObject repositoryObject) {
        if (!this.isPAC_Element()) {
            this.pac_Element = repositoryObject;
        }
    }

    public void updateMaxIndex(int n) {
        this.maxIndex = Math.max(this.maxIndex, n);
    }

    public int nextIndex() {
        return ++this.maxIndex;
    }

    public List getRDBMSSitesForTypes(List list) {
        ArrayList<RDBMSSite> arrayList = new ArrayList<RDBMSSite>();
        for (RDBMSType rDBMSType : list) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                RDBMSSite rDBMSSite = (RDBMSSite)iterator.next();
                if (rDBMSSite.getType() != rDBMSType) continue;
                arrayList.add(rDBMSSite);
            }
        }
        return arrayList;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    public RDBMSSite getDefaultRDBMSSite(Settings settings) {
        RDBMSSite rDBMSSite;
        String string = settings.getDefaultRDBMSSite();
        if (StringUtilities.isNotEmpty(string) && (rDBMSSite = this.getByObjectID(string)) != null) {
            return rDBMSSite;
        }
        return this.get(StorageDesignOraclev11g.RDBMS_TYPE);
    }
}

