/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.AbstractRDBMSObject;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.util.GUID;

public class RDBMSSite
extends AbstractRDBMSObject
implements Comparable {
    private RDBMSType type;
    private String name;
    private boolean isDefault = false;
    private String objectID = new GUID().toString();
    private int pathID = 0;
    private RDBMSSiteSet set;
    private boolean designLevel = false;
    private Design design;

    public RDBMSSite(String string, Design design) {
        this.name = string;
        this.design = design;
    }

    public RDBMSSite(String string, RDBMSType rDBMSType, Design design) {
        this.name = string;
        this.type = rDBMSType;
        this.design = design;
    }

    public void setType(RDBMSType rDBMSType) {
        this.type = rDBMSType;
    }

    public RDBMSType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String string) {
        if (string != null && !"".equalsIgnoreCase(string)) {
            this.objectID = string;
        }
    }

    public String getShortObjectID() {
        int n;
        if (this.objectID != null && !"".equalsIgnoreCase(this.objectID) && (n = this.objectID.indexOf(45)) > -1) {
            String string = this.objectID.substring(0, n);
            n = this.objectID.lastIndexOf(45);
            String string2 = this.objectID.substring(n + 1);
            return string + '-' + string2;
        }
        return this.objectID;
    }

    public String toString() {
        return this.getLongName();
    }

    public boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(boolean bl) {
        this.isDefault = bl;
    }

    public int getPathID() {
        if (this.pathID == 0) {
            this.pathID = this.set.nextIndex();
        }
        return this.pathID;
    }

    public void setPathID(int n) {
        this.pathID = n;
    }

    public String getPathIDString() {
        return String.valueOf(this.getPathID());
    }

    public void setRDBMSSiteSet(RDBMSSiteSet rDBMSSiteSet) {
        this.set = rDBMSSiteSet;
    }

    public boolean isDesignLevel() {
        return this.designLevel;
    }

    public void setDesignLevel(boolean bl) {
        this.designLevel = bl;
    }

    public void setTypeID(int n) {
        RDBMSType rDBMSType = this.design.getRDBMSTypeSet().get(n);
        if (rDBMSType == null) {
            rDBMSType = this.design.getRDBMSTypeSet().get(9);
        }
        this.setType(rDBMSType);
    }

    public int getTypeID() {
        return this.getType().getType();
    }
}

