/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;

public abstract class IndexProxySet
extends RelationalObjectProxySet
implements ModelObjectSetListener {
    public IndexProxySet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void setDesign(Design design) {
        if (this.getDesign() != null) {
            this.getPhysicalModelObjectSet().removeSetListener(this);
        }
        super.setDesign(design);
        if (design != null) {
            this.getPhysicalModelObjectSet().addSetListener(this);
            this.add((Index[])this.getPhysicalModelObjectSet().toArray());
        }
    }

    protected ModelObjectSet getPhysicalModelObjectSet() {
        return this.getStorageDesign().getPhysicalDesign().getGlobalIndexSet();
    }

    protected void add(Index[] indexArray) {
        for (int i = 0; i < indexArray.length; ++i) {
            Index index = indexArray[i];
            if (index.isPK() || index.isUnique()) continue;
            this.add(index);
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        Index index;
        if (modelObjectSetEvent.isAdded()) {
            Index index2 = (Index)modelObjectSetEvent.getAffected();
            if (!index2.isPK() && !index2.isUnique()) {
                this.add(index2);
                this.fireUpdate();
            }
        } else if (modelObjectSetEvent.isRemoved() && this.containsId((index = (Index)modelObjectSetEvent.getAffected()).getObjectID())) {
            this.remove((Index)modelObjectSetEvent.getAffected());
            this.fireUpdate();
        }
    }

    public List getIndexList() {
        return this.getObjectList();
    }

    @Override
    public IndexProxy getByName(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            IndexProxy indexProxy = (IndexProxy)iterator.next();
            if (!string.equals(indexProxy.getName())) continue;
            return indexProxy;
        }
        return null;
    }

    @Override
    protected void unregisterFromDesignObjectSet() {
        this.getPhysicalModelObjectSet().removeSetListener(this);
    }
}

