/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedData;

public class DistinctTypeProxy
extends RelationalObjectProxy {
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    private String usedDistinctType = "";
    private UsedDistinctTypeSet usedDTSet = null;
    protected String nullType;
    public static final String[] NULL_STATES = new String[]{"NULL", "NOT NULL"};
    private static Set nullSet = null;
    public static final String TYPE_NAME = "DType";

    public DistinctTypeProxy(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    public DistinctTypeProxy(DesignObject designObject, StorageDesign storageDesign) {
        super(designObject, storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return "UDDT-Distinct Type";
    }

    public DistinctType getDistinctType() {
        return (DistinctType)this.getObject();
    }

    @Override
    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    @Override
    public void setCommentChanged(boolean bl) {
        this.commentChanged = bl;
    }

    @Override
    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    @Override
    public void setCommentInRDBMSChanged(boolean bl) {
        this.commentInRDBMSChanged = bl;
    }

    public void setUsedDistinctType(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUsedDistinctTypeSet(string);
        } else {
            this.addUsedDistinctType(string);
        }
        this.usedDistinctType = this.getUsedDTSet().toString();
        this.fireDataFieldChange();
    }

    private void addUsedDistinctType(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (!this.getUsedDTSet().contains(string2)) {
            this.getUsedDTSet().add(string2);
        }
    }

    private void recreateUsedDistinctTypeSet(String string) {
        this.getUsedDTSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (this.getUsedDTSet().contains(string2)) continue;
            this.getUsedDTSet().add(string2);
        }
    }

    public String getUsedDistinctType() {
        return this.usedDistinctType;
    }

    public UsedDistinctTypeSet getUsedDTSet() {
        if (this.usedDTSet == null) {
            this.usedDTSet = new UsedDistinctTypeSet();
        }
        return this.usedDTSet;
    }

    public void clearFromDataBase(DataBaseSqlServer dataBaseSqlServer) {
        UsedUserDefinedData[] usedUserDefinedDataArray = (UsedUserDefinedData[])((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().toArray();
        for (int i = 0; i < usedUserDefinedDataArray.length; ++i) {
            UsedUserDefinedData usedUserDefinedData = usedUserDefinedDataArray[i];
            if (usedUserDefinedData.getDistinctTypeProxy() != this || usedUserDefinedData.getDatabase() != dataBaseSqlServer) continue;
            this.getUsedDTSet().remove(usedUserDefinedData.getName());
            ((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().remove(usedUserDefinedData);
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.OBJECT_REMOVED) && objectChangeEvent.getAffected() instanceof DistinctType) {
            DistinctType distinctType = (DistinctType)objectChangeEvent.getAffected();
            if (this.getObject() == distinctType) {
                this.removeUsedDistinctType();
            }
        }
        super.changed(designObject, objectChangeEvent);
    }

    public void removeUsedDistinctType() {
        UsedUserDefinedData[] usedUserDefinedDataArray = (UsedUserDefinedData[])((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().toArray();
        for (int i = 0; i < usedUserDefinedDataArray.length; ++i) {
            UsedUserDefinedData usedUserDefinedData = usedUserDefinedDataArray[i];
            if (usedUserDefinedData.getDistinctTypeProxy() != this) continue;
            ((StorageDesignSqlServer)this.getStorageDesign()).getUsedUserDefinedDataSet().remove(usedUserDefinedData);
        }
    }

    protected boolean checkNullType(String string) {
        if (nullSet == null) {
            nullSet = new HashSet();
            nullSet.addAll(Arrays.asList(NULL_STATES));
        }
        return nullSet.contains(string);
    }

    public String getNullType() {
        return this.nullType;
    }

    public void setNullType(String string) {
        if (this.checkNullType(string)) {
            this.nullType = string;
            this.fireDataFieldChange();
        }
    }

    public String getDatatypeString() {
        LogicalDatatype logicalDatatype = this.getDistinctType().getLogicalDataType();
        if (logicalDatatype != null) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("size", "" + this.getDistinctType().getSize());
            treeMap.put("precision", "" + this.getDistinctType().getPrecision());
            treeMap.put("scale", "" + this.getDistinctType().getScale());
            MDDataType mDDataType = logicalDatatype.createDataType(this.getRDBMSType().toString(), treeMap);
            return mDDataType.toString();
        }
        return "";
    }

    public class UsedDistinctTypeSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

