/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.ProxyDesignObjectSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;

public class ColumnProxySet
extends ProxyDesignObjectSet {
    public ColumnProxySet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected DesignObjectSet getPhysicalDesignObjectSet() {
        return this.getStorageDesign().getPhysicalDesign().getColumnSet();
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject designObject) {
        return new ColumnProxy((Column)designObject, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String string, String string2) {
        return new ColumnProxy(design, string, string2, this.getStorageDesign());
    }

    @Override
    public void add(DesignObject designObject) {
        if (!this.isBackupObject(designObject)) {
            if (designObject instanceof Column && ((Column)designObject).getContainerWithKeyObject() == null) {
                return;
            }
            String string = designObject.getObjectID();
            RelationalObjectProxy relationalObjectProxy = this.getProxy(string);
            if (relationalObjectProxy != null) {
                if (!relationalObjectProxy.isLoaded()) {
                    relationalObjectProxy.loadDesignObject();
                }
            } else {
                relationalObjectProxy = this.createProxy(designObject);
                this.add(relationalObjectProxy);
                this.fireUpdate();
            }
        }
    }
}

