/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public class ColumnProxy
extends RelationalObjectProxy {
    protected transient TableProxy tableProxy;
    private boolean generateAlwaysChanged;
    private boolean startWithChanged;
    private boolean incrementByChanged;
    private boolean minValueChanged;
    private boolean maxValueChanged;
    private boolean cycleChanged;
    private boolean cacheChanged;
    public static final String TYPE_NAME = "Column";

    public ColumnProxy(Column column, StorageDesign storageDesign) {
        super(column, storageDesign);
        this.tableProxy = (TableProxy)storageDesign.getTableProxySet().getProxy(column.getContainerWithKeyObject().getObjectID());
        if (this.tableProxy != null) {
            this.tableProxy.addObject(this);
        }
    }

    public ColumnProxy(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public Column getColumn() {
        return (Column)this.getObject();
    }

    public Datatype getDataType() {
        return this.getColumn().getDataType(this.getRDBMSType().toString());
    }

    public String getDatatypeString() {
        Datatype datatype = this.getColumn().getDataType(this.getRDBMSType().toString());
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getColumn().isReference()) {
            stringBuffer.append("REF ");
        }
        stringBuffer.append(datatype.toString());
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void remove() {
        if (this.tableProxy != null) {
            this.tableProxy.removeObject(this);
        }
        super.remove();
    }

    public TableProxy getTableProxyR() {
        return this.tableProxy;
    }

    public void setTableProxyW(TableProxy tableProxy) {
        this.tableProxy = tableProxy;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        if (this.tableProxy != null) {
            if (this.pac_Element == null) {
                this.setPAC_Element(this.tableProxy);
            }
            return this.tableProxy;
        }
        if (this.pac_Element == null) {
            Table table = null;
            table = (Table)this.getColumn().getContainer();
            if (table != null) {
                StorageObject storageObject = this.getStorageDesign().getStorageObject(table.getObjectID());
                if (storageObject == null) {
                    this.getStorageDesign().getTableProxySet().getObjectGeneratedBy(table);
                }
                if (storageObject != null && storageObject instanceof TableProxy) {
                    this.setPAC_Element(storageObject);
                }
            }
        }
        return super.getPAC_Element();
    }

    public boolean isGenerateAlwaysChanged() {
        return this.generateAlwaysChanged;
    }

    public void setGenerateAlwaysChanged(boolean bl) {
        this.generateAlwaysChanged = bl;
    }

    public boolean isStartWithChanged() {
        return this.startWithChanged;
    }

    public void setStartWithChanged(boolean bl) {
        this.startWithChanged = bl;
    }

    public boolean isIncrementByChanged() {
        return this.incrementByChanged;
    }

    public void setIncrementByChanged(boolean bl) {
        this.incrementByChanged = bl;
    }

    public boolean isMinValueChanged() {
        return this.minValueChanged;
    }

    public void setMinValueChanged(boolean bl) {
        this.minValueChanged = bl;
    }

    public boolean isMaxValueChanged() {
        return this.maxValueChanged;
    }

    public void setMaxValueChanged(boolean bl) {
        this.maxValueChanged = bl;
    }

    public boolean isCycleChanged() {
        return this.cycleChanged;
    }

    public void setCycleChanged(boolean bl) {
        this.cycleChanged = bl;
    }

    public boolean isCacheChanged() {
        return this.cacheChanged;
    }

    public void setCacheChanged(boolean bl) {
        this.cacheChanged = bl;
    }
}

