/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.ColumnViewSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.ViewColumnPlaceHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.relational.TableViewPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class TableView
extends AbstractView
implements EditableFonts {
    private List editableFonts;
    private String oidText = "";

    public TableView(DesignPart designPart) {
        super(designPart);
        this.initEditableFonts();
    }

    @Override
    public String getIDPrefix() {
        return MDPreferences.getDefaultInstance().get("tableview id prefix");
    }

    @Override
    public Class getContainedClass() {
        return ColumnView.class;
    }

    @Override
    public DesignObjectSet getTableSet() {
        return ((RelationalDesign)this.getDesignPart()).getTableSet();
    }

    public ColumnViewSet getColumnViewSet() {
        return ((RelationalDesign)this.getDesignPart()).getColumnViewSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getColumnViewSet();
    }

    @Override
    public ContainedObject createContainedObject(String string) {
        ColumnView columnView = new ColumnView(this.getDesignPart());
        columnView.setDesign(this.getDesign());
        columnView.setContainer(this);
        if (string != null) {
            columnView.setObjectID(string);
        }
        columnView.setDesignObjectSet(this.getColumnViewSet());
        this.add(columnView);
        this.getColumnViewSet().add(columnView);
        if (string != null) {
            columnView.setObjectID(string);
        }
        return columnView;
    }

    @Override
    public void add(ContainedObject containedObject) {
        if (!this.exists(containedObject)) {
            if (containedObject instanceof ColumnView) {
                if (containedObject.getObjectID() == null) {
                    this.assignLocalID(containedObject);
                }
                containedObject.setDesign(this.getDesign());
                this.getColumnViewSet().add(containedObject);
                this.phelements.add(new ViewColumnPlaceHolder(this.getDesignPart(), containedObject));
                super.add(containedObject);
                if (((ColumnView)containedObject).getReferencedColumn() != null) {
                    ((ColumnView)containedObject).getReferencedColumn().addObjectListener(this);
                }
                if (((ColumnView)containedObject).getReferencedColumnView() != null) {
                    ((ColumnView)containedObject).getReferencedColumnView().addObjectListener(this);
                }
                if (((ColumnView)containedObject).getView() != null && ((ColumnView)containedObject).getView() != this) {
                    ContainedObject[] containedObjectArray = ((ColumnView)containedObject).getView().getElements();
                    for (int i = 0; i < containedObjectArray.length; ++i) {
                        if (((ColumnView)containedObjectArray[i]).getReferencedColumn() != ((ColumnView)containedObject).getReferencedColumn()) continue;
                        ((ColumnView)containedObjectArray[i]).addObjectListener(this);
                    }
                }
            } else {
                ColumnView columnView = new ColumnView(this.getDesignPart());
                columnView.setObjectID(this.getDesign().getAppView().getIDGenerator().createNewID());
                columnView.setName(containedObject.getName());
                columnView.setDesign(this.getDesign());
                columnView.setReferencedColumn((Column)containedObject);
                columnView.setDataType(((Column)containedObject).getDataType().toString());
                columnView.setContainer(this);
                columnView.setTable((Table)containedObject.getContainer());
                this.getColumnViewSet().add(columnView);
                this.phelements.add(new ViewColumnPlaceHolder(this.getDesignPart(), columnView));
                super.add(columnView);
                if (columnView.getView() != this) {
                    columnView.addObjectListener(this);
                }
            }
            containedObject.addObjectListener(this);
        }
    }

    public ColumnView columnViewAdd(ContainedObject containedObject) {
        if (!this.exists(containedObject)) {
            if (containedObject instanceof ColumnView) {
                if (containedObject.getObjectID() == null) {
                    this.assignLocalID(containedObject);
                }
                containedObject.setDesign(this.getDesign());
                this.getColumnViewSet().add(containedObject);
                this.phelements.add(new ViewColumnPlaceHolder(this.getDesignPart(), containedObject));
                super.add(containedObject);
                if (((ColumnView)containedObject).getReferencedColumn() != null) {
                    ((ColumnView)containedObject).getReferencedColumn().addObjectListener(this);
                }
                if (((ColumnView)containedObject).getView() != null && ((ColumnView)containedObject).getView() != this) {
                    ContainedObject[] containedObjectArray = ((ColumnView)containedObject).getView().getElements();
                    for (int i = 0; i < containedObjectArray.length; ++i) {
                        if (((ColumnView)containedObjectArray[i]).getReferencedColumn() != ((ColumnView)containedObject).getReferencedColumn()) continue;
                        ((ColumnView)containedObjectArray[i]).addObjectListener(this);
                    }
                }
                return (ColumnView)containedObject;
            }
            ColumnView columnView = new ColumnView(this.getDesignPart());
            columnView.setObjectID(this.getDesign().getAppView().getIDGenerator().createNewID());
            columnView.setName(containedObject.getName());
            columnView.setDesign(this.getDesign());
            columnView.setReferencedColumn((Column)containedObject);
            columnView.setDataType(((Column)containedObject).getDataType().toString());
            this.getColumnViewSet().add(columnView);
            columnView.setContainer(this);
            columnView.setTable((Table)containedObject.getContainer());
            this.phelements.add(new ViewColumnPlaceHolder(this.getDesignPart(), columnView));
            super.add(columnView);
            if (columnView.getView() != this) {
                columnView.addObjectListener(this);
            }
            containedObject.addObjectListener(this);
            return columnView;
        }
        return null;
    }

    private boolean exists(ContainedObject containedObject) {
        if (containedObject instanceof ColumnView) {
            return this.getElementsCollection().contains(containedObject);
        }
        for (ColumnView columnView : this.getElementsCollection()) {
            if (containedObject != columnView.getReferencedColumn()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove(ContainedObject containedObject) {
        this.phelements.removePlaceHolderFor(containedObject);
        this.removeFromOrderBy(containedObject);
        super.remove(containedObject);
        this.getColumnViewSet().remove(containedObject);
    }

    @Override
    public void addToOrderBy(ContainedObject containedObject, String string) {
        if (containedObject.getObjectID() == null) {
            this.assignLocalID(containedObject);
        }
        containedObject.setContainer(this);
        this.getColumnViewSet().add(containedObject);
        this.orderByMap.put(containedObject.getObjectID(), string);
        this.orderByList.add(containedObject);
        if (((AbstractViewElement)containedObject).getReferencedColumn() != null) {
            ((AbstractViewElement)containedObject).getReferencedColumn().addObjectListener(this);
        }
    }

    public ContainedObject[] getColumns() {
        return this.getElements();
    }

    public ColumnView getColumnByObjectID(String string) {
        for (ColumnView columnView : this.getElementsCollection()) {
            if (!columnView.getObjectID().equals(string)) continue;
            return columnView;
        }
        return null;
    }

    @Override
    public void addToContainers(ContainerObject containerObject, String string) {
        this.containerMap.put(string, containerObject.getObjectID());
        if (containerObject instanceof Table) {
            if (!this.tables.contains(containerObject)) {
                this.tables.add(containerObject);
            }
        } else if (containerObject instanceof TableView && !this.views.contains(containerObject)) {
            this.views.add(containerObject);
        }
        this.usedContainers.add(new AbstractView.ContainerHolder(containerObject, string));
        containerObject.addObjectListener(this);
    }

    @Override
    public void clearContainers() {
        this.containerMap.clear();
        this.tables.clear();
        this.views.clear();
        this.usedContainers.clear();
    }

    @Override
    public void addToContainers(String string, String string2) {
        this.containerMap.put(string2, string);
        ContainerObject containerObject = (ContainerObject)this.getTableSet().getObjectByID(string);
        if (containerObject != null) {
            if (!this.tables.contains(containerObject)) {
                this.tables.add(containerObject);
            }
            this.usedContainers.add(new AbstractView.ContainerHolder(containerObject, string2));
            containerObject.addObjectListener(this);
            this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(string, string2));
        } else {
            TableView tableView = (TableView)((RelationalDesign)this.getDesignPart()).getTableViewSet().getObjectByID(string);
            if (tableView != null) {
                if (!this.views.contains(tableView)) {
                    this.views.add(tableView);
                }
                this.usedContainers.add(new AbstractView.ContainerHolder(tableView, string2));
                tableView.addObjectListener(this);
                this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(string, string2));
            } else {
                this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(string, string2));
            }
        }
    }

    public ColumnView getColumnViewByName(String string) {
        for (ColumnView columnView : this.getElementsCollection()) {
            if (!columnView.getName().equalsIgnoreCase(string)) continue;
            return columnView;
        }
        return null;
    }

    public ColumnView getColumnViewByLongName(String string) {
        for (ColumnView columnView : this.getElementsCollection()) {
            if (!columnView.getLongName().equalsIgnoreCase(string)) continue;
            return columnView;
        }
        return null;
    }

    public String getUserDefinedSQLAsDDL() {
        String string = this.userDefinedSQL;
        if (!string.toUpperCase().startsWith("CREATE ")) {
            string = ((RelationalDesign)this.getDesignPart()).getStorageDesign() instanceof StorageDesignOracle ? "CREATE OR REPLACE VIEW " + this.getName() + "\nAS \n" + string : "CREATE VIEW " + this.getName() + "\nAS \n" + string;
        }
        return string;
    }

    @Override
    public void clear(ContainerObject containerObject) {
        this.tables.remove(containerObject);
        this.views.remove(containerObject);
        Object[] objectArray = this.containerMap.keySet().toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            String string = (String)objectArray[i];
            String string2 = (String)this.containerMap.get(string);
            if (!containerObject.getObjectID().equalsIgnoreCase(string2)) continue;
            this.containerMap.remove(string);
        }
        if (containerObject != this) {
            this.clearElements(containerObject);
        }
        this.clearOrderByElements(containerObject);
        AbstractView.ContainerHolder containerHolder = this.getContainerHolderFor(containerObject);
        if (containerHolder != null) {
            this.usedContainers.remove(containerHolder);
        }
    }

    public void clear(ColumnView columnView) {
        if (columnView.getContainer() == this) {
            this.removeFromOrderBy(columnView);
            columnView.remove();
        }
    }

    @Override
    public void clearElements(ContainerObject containerObject) {
        block5: {
            block4: {
                if (!(containerObject instanceof TableView)) break block4;
                ContainedObject[] containedObjectArray = containerObject.getElements();
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    if (!this.getElementsCollection().contains(containedObjectArray[i])) continue;
                    this.remove(containedObjectArray[i]);
                }
                break block5;
            }
            if (!(containerObject instanceof Table)) break block5;
            ArrayList<ColumnView> arrayList = new ArrayList<ColumnView>();
            Iterator iterator = this.getElementsCollection().iterator();
            ContainedObject[] containedObjectArray = containerObject.getElements();
            block1: while (iterator.hasNext()) {
                ColumnView columnView = (ColumnView)iterator.next();
                if (columnView.getReferencedColumn() == null) continue;
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    if (columnView.getReferencedColumn() != containedObjectArray[i]) continue;
                    arrayList.add(columnView);
                    continue block1;
                }
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.remove((ColumnView)iterator.next());
            }
        }
    }

    @Override
    public void clearOrderByElements(ContainerObject containerObject) {
        block7: {
            block6: {
                Object object2;
                if (!(containerObject instanceof TableView)) break block6;
                ArrayList<ColumnView> arrayList = new ArrayList<ColumnView>();
                for (Object object2 : containerObject.getElementsCollection()) {
                    for (ColumnView columnView : this.orderByList) {
                        if (((AbstractViewElement)object2).getReferencedColumn() != columnView.getReferencedColumn()) continue;
                        arrayList.add(columnView);
                    }
                }
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    this.removeFromOrderBy((ColumnView)object2.next());
                }
                break block7;
            }
            if (!(containerObject instanceof Table)) break block7;
            ArrayList<ColumnView> arrayList = new ArrayList<ColumnView>();
            block3: for (ColumnView columnView : this.orderByList) {
                if (columnView.getReferencedColumn() == null) continue;
                for (Column column : containerObject.getElementsCollection()) {
                    if (columnView.getReferencedColumn() != column) continue;
                    arrayList.add(columnView);
                    continue block3;
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.removeFromOrderBy((ColumnView)iterator.next());
            }
        }
    }

    @Override
    public void remove() {
        ColumnView columnView;
        Object object2;
        Iterator iterator = ((RelationalDesign)this.getDesignPart()).getTableViewSet().iterator();
        while (iterator.hasNext()) {
            object2 = (TableView)iterator.next();
            ((TableView)object2).clear(this);
        }
        for (Object object2 : this.getElementsCollection()) {
            this.getColumnViewSet().remove((DesignObject)object2);
        }
        object2 = new ArrayList();
        iterator = this.getColumnViewSet().iterator();
        while (iterator.hasNext()) {
            columnView = (ColumnView)iterator.next();
            if (columnView.getView() != this) continue;
            ((ArrayList)object2).add(columnView);
        }
        iterator = ((ArrayList)object2).iterator();
        while (iterator.hasNext()) {
            columnView = (ColumnView)iterator.next();
            this.getColumnViewSet().remove(columnView);
            columnView.getContainer().remove(columnView);
        }
        super.remove();
        SetEvent.OBJECT_REMOVED.setAffected(this);
        ((RelationalDesign)this.getDesignPart()).getTableViewSet().fireChange(SetEvent.OBJECT_REMOVED);
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (designObjectSet instanceof StructuredTypeSet || designObjectSet instanceof SchemaObjectSet) {
            super.changed(designObjectSet, setEvent);
            return;
        }
        if (SetEvent.OBJECT_REMOVED.equals(setEvent) && setEvent.getAffected() instanceof ContainerObject) {
            ((ContainerObject)setEvent.getAffected()).removeContainerListener(this);
        }
    }

    protected void invalidateLinkedViews() {
        Iterator iterator = ((RelationalDesign)this.getDesignPart()).getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            if (tableView == null || !tableView.isValidSQL() || !tableView.sqlNameExists(this.getObjectID())) continue;
            tableView.setValidSQL(false);
            tableView.invalidateLinkedViews();
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        boolean bl = false;
        if (!ApplicationView.loading && (objectChangeEvent.isType(ObjectChangeEvent.OBJECT_REMOVED) || objectChangeEvent.isType(ObjectChangeEvent.NAME_CHANGED) || objectChangeEvent.isType(ObjectChangeEvent.SCHEMA_CHANGED))) {
            if (this.sqlNameExists(designObject.getObjectID())) {
                bl = true;
            }
            if (!bl) {
                if (designObject instanceof ContainerObject) {
                    if (this.sqlNameExists(designObject.getObjectID())) {
                        bl = true;
                    }
                } else if (designObject instanceof Column) {
                    for (ColumnView columnView : this.getElementsCollection()) {
                        if (columnView.getReferencedColumn() == null || columnView.getReferencedColumn() != designObject) continue;
                        bl = true;
                        break;
                    }
                } else if (designObject instanceof ColumnView) {
                    for (ColumnView columnView : this.getElementsCollection()) {
                        if (columnView != designObject && columnView.getReferencedColumnView() != designObject) continue;
                        bl = true;
                        break;
                    }
                }
            }
            if (bl) {
                this.setValidSQL(!this.isSQLNamesChanged());
                if (!this.isValidSQL()) {
                    this.invalidateLinkedViews();
                }
            }
        }
    }

    @Override
    public void copy(DesignObject designObject) {
        Object object3;
        TableView tableView = (TableView)designObject;
        super.copy(tableView);
        tableView.setSyntaxProvider(this.getSyntaxProvider());
        tableView.setWhere(this.getWhere());
        tableView.setGroupBy(this.getGroupBy());
        tableView.setHaving(this.getHaving());
        tableView.setUserDefined(this.getUserDefined());
        tableView.setUserDefinedSQL(this.getUserDefinedSQL(tableView.getName()));
        tableView.setBasedOnStructuredType(this.getBasedOnStructuredType());
        for (Object object2 : this.getContainerMap().keySet()) {
            object3 = this.getContainerID((String)object2);
            tableView.addToContainers((String)object3, (String)object2);
        }
        for (Object object3 : this.getOrderByMap().keySet()) {
            Object object2;
            object2 = (ColumnView)this.getObjectByID(this.orderByList, (String)object3);
            if (object2 != null) {
                ColumnView columnView = new ColumnView(this.getDesignPart());
                ((ColumnView)object2).copy(columnView);
                columnView.setView(tableView);
                tableView.addToOrderBy(columnView, (String)this.getOrderByMap().get(object3));
                continue;
            }
            System.out.println("TableView.copy: Unable to find ColumnView: " + (String)object3);
        }
        for (int i = 0; i < this.getGroupByList().size(); ++i) {
            object3 = (ColumnView)this.getGroupByList().get(i);
            tableView.addGroupByList((ContainedObject)object3);
        }
        if (!this.isBST()) {
            ContainedObject[] containedObjectArray = this.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                object3 = new ColumnView(this.getDesignPart());
                ((ColumnView)containedObjectArray[i]).copy((DesignObject)object3);
                ((AbstractViewElement)object3).setView(tableView);
                ((ContainedObject)object3).setContainer(tableView);
                tableView.add((ContainedObject)object3);
            }
        }
    }

    @Override
    public void importView(DesignObject designObject) {
        Column column;
        ContainedObject containedObject;
        DesignObject designObject2;
        Object object3;
        TableView tableView = (TableView)designObject;
        super.copy(tableView);
        tableView.setWhere(this.getWhere());
        tableView.setGroupBy(this.getGroupBy());
        tableView.setHaving(this.getHaving());
        tableView.setUserDefined(this.getUserDefined());
        tableView.setUserDefinedSQL(this.getUserDefinedSQL());
        tableView.setBasedOnStructuredType(this.getBasedOnStructuredType());
        for (Object object2 : this.getContainerMap().keySet()) {
            object3 = this.getContainerID((String)object2);
            designObject2 = tableView.getDesign().getCorrObject((String)object3);
            if (designObject2 == null) continue;
            tableView.addToContainers(designObject2.getObjectID(), (String)object2);
        }
        for (Object object3 : this.getOrderByMap().keySet()) {
            Object object2;
            object2 = (ColumnView)this.getObjectByID(this.orderByList, (String)object3);
            if (object2 != null) {
                designObject2 = new ColumnView(this.getDesignPart());
                containedObject = (Column)((AbstractViewElement)object2).getReferencedColumn();
                if (containedObject != null && (column = (Column)tableView.getDesign().getCorrObject(containedObject.getObjectID())) != null) {
                    ((AbstractViewElement)designObject2).setReferencedColumn(column);
                    designObject2.setName(((ContainedObject)object2).getName());
                    ((AbstractViewElement)designObject2).setDataType(column.getDataType().toString());
                    ((AbstractViewElement)designObject2).setTable((Table)column.getContainer());
                    ((AbstractViewElement)designObject2).setView(tableView);
                    designObject2.setDesign(tableView.getDesign());
                    tableView.addToOrderBy((ContainedObject)designObject2, (String)this.getOrderByMap().get(object3));
                }
                designObject2.setImportedDesign(this.getDesign());
                designObject2.setImportedId(((ModelIDObject)object2).getObjectID());
                continue;
            }
            System.out.println("TableView.copy: Unable to find ColumnView: " + (String)object3);
        }
        if (!this.isBST()) {
            for (int i = 0; i < this.getElements().length; ++i) {
                Table table;
                Column column2;
                object3 = new ColumnView(tableView.getDesignPart());
                containedObject = (ColumnView)this.getElements()[i];
                column = (Column)((AbstractViewElement)containedObject).getReferencedColumn();
                if (column != null && (column2 = (Column)tableView.getDesign().getCorrObject(column.getObjectID())) != null) {
                    ((AbstractViewElement)object3).setReferencedColumn(column2);
                }
                ((DesignObject)object3).setName(containedObject.getName());
                ((AbstractViewElement)object3).setDataType(((AbstractViewElement)containedObject).getDataType().toString());
                if (((AbstractViewElement)containedObject).getTable() != null && (table = (Table)tableView.getDesign().getCorrObject(((AbstractViewElement)containedObject).getTable().getObjectID())) != null) {
                    ((AbstractViewElement)object3).setTable(table);
                }
                ((AbstractViewElement)object3).setView(tableView);
                ((ModelObject)object3).setDesign(tableView.getDesign());
                ((ContainedObject)object3).setContainer(tableView);
                tableView.add((ContainedObject)object3);
                ((DesignObject)object3).setImportedDesign(this.getDesign());
                ((DesignObject)object3).setImportedId(containedObject.getObjectID());
            }
        }
        for (int i = 0; i < this.getGroupByList().size(); ++i) {
            object3 = (ColumnView)this.getGroupByList().get(i);
            if (object3 == null || (containedObject = (ColumnView)tableView.getDesign().getCorrObject(((ModelIDObject)object3).getObjectID())) == null) continue;
            tableView.addGroupByList(containedObject);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableViewPropertiesDialogEx tableViewPropertiesDialogEx = new TableViewPropertiesDialogEx(this.getDesign().getAppView(), this);
            tableViewPropertiesDialogEx.initProperties(this);
            tableViewPropertiesDialogEx.show();
        }
    }

    @Override
    public void updateElements(List list) {
        for (int i = 0; i < list.size(); ++i) {
            TypeElement typeElement = (TypeElement)list.get(i);
            ColumnView columnView = (ColumnView)this.getElementByStructAttributeID(typeElement.getObjectID());
            if (columnView == null) {
                columnView = new ColumnView(this.getDesignPart());
                columnView.setName(typeElement.getName());
                columnView.setStructAttributeID(typeElement.getObjectID());
                columnView.setAlias(typeElement.getName());
                this.addColumn(columnView);
            }
            this.copyTEtoColumn(typeElement, columnView);
        }
    }

    private void copyTEtoColumn(TypeElement typeElement, ColumnView columnView) {
        columnView.setName(typeElement.getName());
        columnView.setDataType(typeElement.getDataType(this.getDesignPart().getSelectedRDBMSSite().getName()));
        columnView.setReference(typeElement.isReference());
        columnView.setTypeElement(typeElement);
        if (typeElement.getType() instanceof StructuredType) {
            columnView.setStructuredType((StructuredType)typeElement.getType());
        } else {
            columnView.setStructuredType(null);
        }
    }

    public void addColumn(ColumnView columnView) {
        columnView.setDesign(this.getDesign());
        columnView.setContainer(this);
        this.add(columnView);
    }

    public List getRefColumns() {
        ArrayList<ColumnView> arrayList = new ArrayList<ColumnView>();
        if (this.isBST()) {
            ContainedObject[] containedObjectArray = this.getColumns();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                ColumnView columnView = (ColumnView)containedObjectArray[i];
                if (!columnView.isReference()) continue;
                arrayList.add(columnView);
            }
        }
        return arrayList;
    }

    public void getColumns(String string) {
        this.getElements(string);
    }

    @Override
    public AbstractViewElement createViewElement(DesignPart designPart) {
        return new ColumnView(designPart);
    }

    public XtdMapping getDeletedMapping() {
        List list = this.getRMExtendedMap().getDeletedMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            XtdMapping xtdMapping = (XtdMapping)list.get(0);
            return xtdMapping;
        }
        return null;
    }

    public EntityView getEngEntityView() {
        XtdMapping xtdMapping;
        DesignObject designObject;
        MappingCollector mappingCollector = this.getRMExtendedMap().getOrCreateCollector(this);
        List list = mappingCollector.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (designObject = (xtdMapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null && designObject instanceof EntityView) {
            return (EntityView)designObject;
        }
        EntityView entityView = (EntityView)this.getGenerator();
        if (entityView == null) {
            if (!ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID())) {
                entityView = (EntityView)this.getDesign().getLogicalDesign().getEntityViewSet().getObjectByID(this.getGeneratorID());
            }
            if (entityView == null) {
                entityView = (EntityView)this.getDesign().getLogicalDesign().getEntityViewSet().getObjectGeneratedBy(this.getObjectID());
            }
        }
        return entityView;
    }

    public void updateDeletedMappings(String string, String string2, String string3) {
        for (ContainedObject containedObject : this.getElementsCollection()) {
            XtdMapping xtdMapping = containedObject.getDeletedMapping(string, string3);
            if (xtdMapping == null) continue;
            xtdMapping.setRecreatedContainerID(string2);
        }
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && this.getDesignPart().getAppView() != null && (defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject("Relational View")) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject("Relational View")) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.resetAllTopViewsCustomFormat();
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
            this.setUseDefaultColor(true);
        } else if (DefaultFontAndColor.isModified("Relational View")) {
            DefaultFontAndColor defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject("Relational View");
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
            this.setUseDefaultColor(bl);
        }
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    public String getOidText() {
        return this.oidText;
    }

    public void setOidText(String string) {
        this.oidText = string;
    }

    @Override
    protected String appendQuotes(String string) {
        StorageDesign storageDesign = ((RelationalDesign)this.getDesignPart()).getStorageDesign();
        if (storageDesign != null) {
            return storageDesign.getFormatedName(string);
        }
        return super.appendQuotes(string);
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "view/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getLongName() {
        if (this.getSchemaObject() != null) {
            return new StringBuffer(this.getSchemaObject().getName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean hasProxyToDelete() {
        return true;
    }

    public boolean canSetSchemaToTablesOnRE() {
        if (this.includeSchemaNameInQuery()) {
            return true;
        }
        if (this.getSchemaObject() == null) {
            for (SQLNameHelper sQLNameHelper : this.getSQLNames()) {
                DesignObject designObject = this.getDesign().getDesignObject(sQLNameHelper.getID());
                if (designObject == null || !(designObject instanceof ContainerObject) || ((ContainerObject)designObject).getSchema() == null) continue;
                return true;
            }
        }
        return false;
    }

    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }
}

