/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.SubsetCO;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectPH_ShortName;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.TableCheckConstraintListener;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraintEvent;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.logical.RelationSet;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.TablePropertiesDialogEx;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class Table
extends ContainerWithKeyObject
implements SetListener,
EditableFonts {
    public static final String PK_INDEX = "PK_INDEX.class";
    private static final KeyObject[] KEY_PROTOTYPE = new Index[0];
    private static final Object[] INDEX_ASSOCIATION_PROTO = FKIndexAssociationSet.PROTOTYPE_ARRAY;
    private List<ColumnGroup> columnGroupsSet;
    private static final int ARC_SIZE_INDEX = 20;
    private List<FKIndexAssociation> fkList = new ArrayList<FKIndexAssociation>();
    private List pendingFKassociation = null;
    private boolean beingRecreated = false;
    private KeyObjectSet allkeys;
    private DesignObjectCollection indSet;
    private DesignObjectCollection pkSet;
    private DesignObjectCollection unSet;
    private DesignObjectCollection fkSet;
    private DesignObjectCollection indexOnlySet;
    private List checkConstraints = new ArrayList();
    private boolean userDefinedOid = true;
    private List oidPKColumns = new ArrayList();
    private boolean oidIsPK = false;
    private String splittedTableID = "";
    private String scope = "";
    private String minVolumes = "0";
    private String expectedVolumes = "0";
    private String maxVolumes = "9999999";
    private int growthPercent = 0;
    private String growthType = GROWTH_TYPES[2];
    private String normalForm = NORMAL_FORMS[3];
    private String adequatelyNormalized = YES_NO_STATES[1];
    public static final String[] GROWTH_TYPES = new String[]{"Day", "Month", "Year"};
    private static Set growthSet = null;
    public static final String[] NORMAL_FORMS = new String[]{"None", "First", "Second", "Third", "Fourth"};
    private static Set normalFormSet = null;
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    public static final String OID_PK = "Oid_PK_";
    private static Set yesNoSet = null;
    private boolean isSpatialTable = false;
    private List spatialDefinitions;
    private List editableFonts;
    private List arcs;
    private String abbreviation = "";
    private Map generatedLists = new TreeMap();
    public static final String TYPE_NAME = "Table";

    public Table(DesignPart designPart) {
        super(designPart);
        this.initEditableFonts();
        this.arcs = new ArrayList();
        this.initIndexFilters();
    }

    public void initIndexFilters() {
        this.allkeys = this.getKeySet();
        this.indSet = new DesignObjectCollection();
        this.pkSet = new DesignObjectCollection();
        this.unSet = new DesignObjectCollection();
        this.fkSet = new DesignObjectCollection();
        this.unSet.setParent(this);
        this.pkSet.setParent(this);
        this.indSet.setParent(this);
        this.fkSet.setParent(this);
        this.indSet.setDesign(this.getDesign());
        this.indSet.setName(Messages.getString("Table.Indexes"));
        this.indSet.setParent(this);
        this.fkSet.setDesign(this.getDesign());
        this.fkSet.setName(Messages.getString("Table.ForeignKeys"));
        this.pkSet.setDesign(this.getDesign());
        this.pkSet.setName(Messages.getString("Table.PrimaryKeys"));
        this.unSet.setDesign(this.getDesign());
        this.unSet.setName(Messages.getString("Table.UniqueConstraints"));
        this.fkSet.setParent(this);
        this.allkeys.addSetListener(this);
        if (this.getDesignPart() != null) {
            this.indexOnlySet = ((RelationalDesign)this.getDesignPart()).getIndexOnlyPlaceHolderSet();
        }
        this.indSet.setElementDescriptor(Index.class);
        this.pkSet.setElementDescriptor(PK_INDEX);
        this.unSet.setElementDescriptor(Index.class);
        this.fkSet.setElementDescriptor(FKIndexAssociation.class);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public KeyObject[] getKeyArrayPrototype() {
        return KEY_PROTOTYPE;
    }

    @Override
    public Class getContainedClass() {
        return Column.class;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("table id prefix");
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        if (designObject instanceof Index) {
            if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
                if (!this.pkSet.containsPlaceHolderFor(designObject)) {
                    this.pkSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), designObject));
                }
                this.indSet.removePlaceHolderFor(designObject);
                this.indexOnlySet.removePlaceHolderFor(designObject);
                this.unSet.removePlaceHolderFor(designObject);
            } else if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_NO_PK)) {
                this.pkSet.removePlaceHolderFor(designObject);
                if (!((Index)designObject).isUnique()) {
                    this.indSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), designObject));
                    if (!this.isBackup()) {
                        this.indexOnlySet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), designObject));
                    }
                }
            }
            if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE)) {
                this.indSet.removePlaceHolderFor(designObject);
                this.indexOnlySet.removePlaceHolderFor(designObject);
                this.unSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), designObject));
            } else if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE)) {
                if (this.unSet.getNumberOfChildren() > 0) {
                    this.unSet.removePlaceHolderFor(designObject);
                }
                if (!((Index)designObject).isPK()) {
                    this.indSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), designObject));
                    if (!this.isBackup()) {
                        this.indexOnlySet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), designObject));
                    }
                }
            }
        } else if (designObject instanceof FKArc && objectChangeEvent == ObjectChangeEvent.OBJECT_REMOVED) {
            this.removeArc((FKArc)designObject);
        }
    }

    public List getPKandUKConstraints() {
        ArrayList<KeyObject> arrayList = new ArrayList<KeyObject>();
        Iterator iterator = this.getKeySet().iterator();
        while (iterator.hasNext()) {
            KeyObject keyObject = (KeyObject)iterator.next();
            if (!keyObject.isPK() && !keyObject.isUnique()) continue;
            arrayList.add(keyObject);
        }
        return arrayList;
    }

    public List getAllInds_PK_UK_NoFKeys() {
        ArrayList<KeyObject> arrayList = new ArrayList<KeyObject>();
        Iterator iterator = this.getKeySet().iterator();
        while (iterator.hasNext()) {
            KeyObject keyObject = (KeyObject)iterator.next();
            if (keyObject.isFK()) continue;
            arrayList.add(keyObject);
        }
        return arrayList;
    }

    public List getAllInds_FKeyInds() {
        ArrayList<Index> arrayList = new ArrayList<Index>();
        ArrayList<Index> arrayList2 = new ArrayList<Index>();
        ArrayList<Index> arrayList3 = new ArrayList<Index>();
        Iterator iterator = this.getKeySet().iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            if (index.isPK()) {
                arrayList.add(0, index);
                continue;
            }
            if (index.isUnique()) {
                arrayList.add(index);
                continue;
            }
            if (index.isFK()) {
                arrayList3.add(index);
                continue;
            }
            arrayList2.add(index);
        }
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        return arrayList;
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (designObjectSet instanceof StructuredTypeSet || designObjectSet instanceof SchemaObjectSet) {
            super.changed(designObjectSet, setEvent);
            return;
        }
        if (setEvent == SetEvent.OBJECT_ADDED) {
            Index index = (Index)setEvent.getAffected();
            index.addObjectListener(this);
            if (index.isFK()) {
                if (!this.fkSet.containsPlaceHolderFor(index.getFKAssociation())) {
                    this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)index.getFKAssociation()));
                }
            } else if (!index.isUnique() && !index.isPK()) {
                this.indSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), index));
                if (!this.isBackup()) {
                    this.indexOnlySet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), index));
                }
            } else if (index.isUnique()) {
                this.unSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), index));
            } else {
                this.pkSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), index));
            }
        } else if (setEvent == SetEvent.OBJECT_REMOVED) {
            Index index = (Index)setEvent.getAffected();
            if (index.isFK()) {
                this.fkSet.removePlaceHolderFor(index.getFKAssociation());
            } else {
                this.indSet.removePlaceHolderFor(index);
                this.indexOnlySet.removePlaceHolderFor(index);
                this.pkSet.removePlaceHolderFor(index);
                this.unSet.removePlaceHolderFor(index);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 3;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n < super.getNumberOfChildren() - 1) {
            return super.getChild(n);
        }
        if (n == this.getNumberOfChildren() - 2) {
            return this.indSet;
        }
        if (n == this.getNumberOfChildren() - 3) {
            return this.unSet;
        }
        if (n == this.getNumberOfChildren() - 4) {
            return this.pkSet;
        }
        return this.fkSet;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.fkSet) {
            return this.getNumberOfChildren();
        }
        if (modelObject == this.indSet) {
            return this.getNumberOfChildren() - 1;
        }
        if (modelObject == this.pkSet) {
            return this.getNumberOfChildren() - 3;
        }
        if (modelObject == this.unSet) {
            return this.getNumberOfChildren() - 2;
        }
        return super.getIndexForChild(modelObject);
    }

    @Override
    protected KeyObjectSet createKeySet() {
        return new IndexSet(this.getDesignPart(), this);
    }

    public Column createColumn() {
        return this.createColumn(null);
    }

    public Column createColumn(String string) {
        return this.createColumn(string, null);
    }

    @Override
    public void add(ContainedObject containedObject) {
        super.add(containedObject);
        if (!this.isBackup()) {
            this.getColumnSet().add(containedObject);
        }
    }

    public Column createColumn(String string, String string2) {
        Column column = new Column(this.getDesignPart());
        column.setBackup(this.isBackup());
        column.setDesign(this.getDesign());
        column.setContainer(this);
        if (string2 != null) {
            column.setObjectID(string2);
        }
        column.setDesignObjectSet(this.getColumnSet());
        this.add(column);
        if (string != null) {
            column.setName(string);
        }
        return column;
    }

    public void addColumn(Column column) {
        column.setDesign(this.getDesign());
        column.setContainer(this);
        this.add(column);
    }

    @Override
    public ContainedObject createContainedObject(String string) {
        return this.createColumn(null, string);
    }

    public Column createColumnFK(Column column, FKIndexAssociation fKIndexAssociation) {
        Column column2 = new Column(this.getDesignPart(), column, fKIndexAssociation);
        column2.setDesign(this.getDesign());
        column2.setPreviousColumn(false);
        column2.setUse(column.getUse());
        column2.setLogicalDatatype(column.getLogicalDatatype());
        column2.setDomain(column.getDomain());
        column2.setStructuredType(column.getStructuredType());
        column2.setCollectionType(column.getCollectionType());
        column2.setReference(column.isReference());
        column2.copyParametersFrom(column);
        column2.setContainer(this);
        this.add(column2);
        column2.addFKAssociation(column, fKIndexAssociation);
        fKIndexAssociation.getLocalFKIndex().add(column2);
        return column2;
    }

    public Column createRefToStructuredType(StructuredType structuredType, FKIndexAssociation fKIndexAssociation) {
        Column column = new Column(this.getDesignPart());
        column.setDesign(this.getDesign());
        column.setContainer(this);
        column.setPreviousColumn(false);
        column.setUse((short)3);
        column.setStructuredType(structuredType);
        column.setReference(true);
        column.setScopeId(fKIndexAssociation.getOriginalContainer().getObjectID());
        this.add(column);
        Column column2 = (Column)fKIndexAssociation.getOriginalContainer().getOidElement();
        if (column2 != null) {
            column.addFKAssociation(column2, fKIndexAssociation);
        }
        fKIndexAssociation.getLocalFKIndex().add(column);
        return column;
    }

    public Column createColumnFK(Column column, FKIndexAssociationReference fKIndexAssociationReference) {
        Column column2 = new Column(this.getDesignPart(), column, fKIndexAssociationReference);
        column2.setDesign(this.getDesign());
        column2.setPreviousColumn(false);
        column2.setContainer(this);
        this.add(column2);
        return column2;
    }

    public Column createTemporaryFKColumn(String string) {
        Column column = new Column(this.getDesignPart());
        column.setDesign(this.getDesign());
        column.setPreviousColumn(false);
        column.setContainer(this);
        column.setObjectID(string);
        column.setRealFKPlaceHolder(true);
        this.add(column);
        return column;
    }

    public Column recreateColumn(String string) {
        Column column = new Column(this.getDesignPart());
        column.setObjectID(string);
        column.setDesign(this.getDesign());
        column.setContainer(this);
        this.add(column);
        return column;
    }

    public FKIndexAssociation addFK(KeyObject keyObject) {
        return this.addFK(keyObject, keyObject.getGeneratorID());
    }

    public FKIndexAssociation addFK(KeyObject keyObject, DesignObject designObject) {
        return this.addFK(keyObject, designObject.getObjectID());
    }

    public FKIndexAssociation addFK(KeyObject keyObject, String string) {
        return this.addFK(keyObject, string, null);
    }

    public FKIndexAssociation addFK(KeyObject keyObject, String string, FKIndexAssociationReference fKIndexAssociationReference) {
        return this.addFK(keyObject, string, fKIndexAssociationReference, null);
    }

    public FKIndexAssociation addBackupFK(FKIndexAssociation fKIndexAssociation) {
        return this.addFK(fKIndexAssociation.getRemoteIndex(), null, null, fKIndexAssociation);
    }

    public FKIndexAssociation addFK(KeyObject keyObject, String string, FKIndexAssociationReference fKIndexAssociationReference, FKIndexAssociation fKIndexAssociation) {
        FKIndexAssociation fKIndexAssociation2 = new FKIndexAssociation(this.getDesignPart(), fKIndexAssociation);
        if (fKIndexAssociationReference != null) {
            fKIndexAssociationReference.setObject(fKIndexAssociation2);
        }
        if (!fKIndexAssociation2.isBackupFK()) {
            fKIndexAssociation2.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        fKIndexAssociation2.setDesign(this.getDesign());
        this.assignLocalID(fKIndexAssociation2);
        if (!this.isBackup()) {
            this.getDesign().addDesignObject(fKIndexAssociation2);
        }
        fKIndexAssociation2.setKeyObject(keyObject);
        fKIndexAssociation2.setGeneratorID(string);
        fKIndexAssociation2.setDeleteRule(this.getDesign().getAppView().getSettings().getDefaultFKDeleteRule());
        this.addFKAssociation(fKIndexAssociation2);
        this.addToMap(string, fKIndexAssociation2);
        Index index = fKIndexAssociation2.getLocalFKIndex();
        if (index != null) {
            if (string == null) {
                string = ModelIDObject.USER_GENERATED;
            }
            index.setGeneratorID(string);
        }
        return fKIndexAssociation2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FKIndexAssociation addForeignKey(Index index, List list) {
        DesignObject designObject2;
        Column[] columnArray = index.getColumns();
        if (columnArray.length != list.size()) {
            return null;
        }
        for (DesignObject designObject2 : list) {
            if (((ContainedObject)designObject2).getContainer() == this) continue;
            return null;
        }
        designObject2 = new FKIndexAssociation(this.getDesignPart());
        NamingStandardRule namingStandardRule = this.getDesign().getNamingStandardRule();
        String string = ApplyNamingStandards.createFK_Name(this.getName(), index.getTable(), index, 1, namingStandardRule, this.getDesignPart().getName(), this.getAbbreviation());
        designObject2.setObjectID(new GUID().toString());
        ((FKIndexAssociation)designObject2).setContainerWithKeyObject(this);
        ((FKIndexAssociation)designObject2).setName(string);
        boolean bl = true;
        if (list.size() == 0) {
            bl = false;
        }
        if (bl) {
            this.getDesign().setPropagatePKChahges(false);
        }
        try {
            ((FKIndexAssociation)designObject2).getLocalFKIndex().getElementsCollection().addAll(list);
            ((FKIndexAssociation)designObject2).setKeyObject(index);
            designObject2 = this.recreateFK((FKIndexAssociation)designObject2, index);
            for (int i = 0; i < columnArray.length; ++i) {
                Column column = (Column)list.get(i);
                column.addFKAssociation(columnArray[i], (FKIndexAssociation)designObject2);
            }
        }
        finally {
            if (bl) {
                this.getDesign().setPropagatePKChahges(true);
            }
        }
        return designObject2;
    }

    public FKIndexAssociation recreateFK(FKIndexAssociation fKIndexAssociation, KeyObject keyObject) {
        fKIndexAssociation.setDesign(this.getDesign());
        fKIndexAssociation.setContainerWithKeyObject(this);
        if (!fKIndexAssociation.isBackupFK() && !this.isBackup()) {
            fKIndexAssociation.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(fKIndexAssociation);
        fKIndexAssociation.setKeyObject(keyObject);
        if (!this.fkList.contains(fKIndexAssociation)) {
            this.fkList.add(fKIndexAssociation);
        }
        this.assignLocalID(fKIndexAssociation);
        this.getDesign().addDesignObject(fKIndexAssociation);
        this.addToMap(keyObject.getGeneratorID(), fKIndexAssociation);
        Index index = fKIndexAssociation.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(fKIndexAssociation)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)fKIndexAssociation));
        }
        this.indSet.removePlaceHolderFor(index);
        this.indexOnlySet.removePlaceHolderFor(index);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(fKIndexAssociation);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
        return fKIndexAssociation;
    }

    public FKIndexAssociation recreateFK(FKIndexAssociation fKIndexAssociation, KeyObject keyObject, String string, String string2) {
        Index index;
        fKIndexAssociation.setDesign(this.getDesign());
        fKIndexAssociation.setContainerWithKeyObject(this);
        if (!fKIndexAssociation.isBackupFK() && !this.isBackup()) {
            fKIndexAssociation.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        fKIndexAssociation.setKeyObject(keyObject);
        fKIndexAssociation.setDeleteRule(string2);
        if (string != null) {
            index = (Index)this.getKeyObject(string);
            fKIndexAssociation.setLocalFKIndex(index);
            index.setFKAssociation(fKIndexAssociation);
        }
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(fKIndexAssociation);
        if (!this.fkList.contains(fKIndexAssociation)) {
            this.fkList.add(fKIndexAssociation);
        }
        this.assignLocalID(fKIndexAssociation);
        this.getDesign().addDesignObject(fKIndexAssociation);
        this.addToMap(keyObject.getGeneratorID(), fKIndexAssociation);
        index = fKIndexAssociation.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(fKIndexAssociation)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)fKIndexAssociation));
        }
        this.indSet.removePlaceHolderFor(index);
        this.indexOnlySet.removePlaceHolderFor(index);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(fKIndexAssociation);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
        return fKIndexAssociation;
    }

    public FKIndexAssociation recreateFK(KeyObject keyObject, String string, String string2, String string3, String string4, String string5, String string6) {
        Index index;
        FKIndexAssociation fKIndexAssociation = new FKIndexAssociation(this.getDesignPart());
        fKIndexAssociation.setDesign(this.getDesign());
        fKIndexAssociation.setContainerWithKeyObject(this);
        if (!fKIndexAssociation.isBackupFK()) {
            fKIndexAssociation.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        fKIndexAssociation.setObjectID(string);
        fKIndexAssociation.setKeyObject(keyObject);
        fKIndexAssociation.setComment(string5);
        fKIndexAssociation.setNotes(string6);
        fKIndexAssociation.setDeleteRule(string3);
        if (string2 != null) {
            index = (Index)this.getKeyObject(string2);
            fKIndexAssociation.setLocalFKIndex(index);
            index.setFKAssociation(fKIndexAssociation);
        }
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(fKIndexAssociation);
        fKIndexAssociation.setName(string4);
        this.fkList.add(fKIndexAssociation);
        this.assignLocalID(fKIndexAssociation);
        this.getDesign().addDesignObject(fKIndexAssociation);
        this.addToMap(keyObject.getGeneratorID(), fKIndexAssociation);
        index = fKIndexAssociation.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(fKIndexAssociation)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)fKIndexAssociation));
        }
        this.indSet.removePlaceHolderFor(index);
        this.indexOnlySet.removePlaceHolderFor(index);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(fKIndexAssociation);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
        return fKIndexAssociation;
    }

    public void recreateFK(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        this.addPending(new PendingFKAssociationRecreation(string, string2, string3, string4, string5, string6, string7, string8, string9, string10));
    }

    public void attemptRecreateFK() {
        if (this.pendingFKassociation != null) {
            Object[] objectArray = this.pendingFKassociation.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((PendingFKAssociationRecreation)objectArray[i]).resolve();
            }
        }
    }

    private void addPending(PendingFKAssociationRecreation pendingFKAssociationRecreation) {
        if (this.pendingFKassociation == null) {
            this.pendingFKassociation = new ArrayList();
        }
        this.pendingFKassociation.add(pendingFKAssociationRecreation);
    }

    private void removePending(PendingFKAssociationRecreation pendingFKAssociationRecreation) {
        if (this.pendingFKassociation != null) {
            this.pendingFKassociation.remove(pendingFKAssociationRecreation);
            if (this.pendingFKassociation.size() <= 0) {
                this.pendingFKassociation = null;
            }
        }
    }

    @Override
    public boolean setName(String string) {
        return super.setName(string);
    }

    public boolean hasPendingFKAssociationRecreations() {
        return this.pendingFKassociation != null && this.pendingFKassociation.size() > 0;
    }

    public boolean hasFKAssociationFor(KeyObject keyObject) {
        FKIndexAssociation[] fKIndexAssociationArray = this.getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            if (fKIndexAssociationArray[i].getKeyObject() != keyObject) continue;
            return true;
        }
        return false;
    }

    public Column getColumnForDelegate(FKIndexAssociation fKIndexAssociation, Column column) {
        Column[] columnArray = (Column[])this.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].isReferingTo(fKIndexAssociation, column)) continue;
            return columnArray[i];
        }
        return null;
    }

    public int getNumberOfFKAssociationFor(KeyObject keyObject) {
        int n = 0;
        FKIndexAssociation[] fKIndexAssociationArray = this.getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            if (fKIndexAssociationArray[i].getKeyObject() != keyObject) continue;
            ++n;
        }
        return n;
    }

    public Column[] getAllFKColumns(FKIndexAssociation fKIndexAssociation) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Column[] columnArray = (Column[])this.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column;
            if (!columnArray[i].isFKColumn() || !(column = columnArray[i]).isPartOfFKIndexAssociation(fKIndexAssociation)) continue;
            arrayList.add(columnArray[i]);
        }
        return arrayList.toArray(new Column[0]);
    }

    public Column getFKColumn(FKIndexAssociation fKIndexAssociation, Column column) {
        Column[] columnArray = (Column[])this.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].isReferingTo(fKIndexAssociation, column)) continue;
            return columnArray[i];
        }
        return null;
    }

    public Column[] getAllFKPlaceHolderColumns() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Column[] columnArray = (Column[])this.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].isFKPlaceHolderColumn()) continue;
            arrayList.add(columnArray[i]);
        }
        return arrayList.toArray(new Column[0]);
    }

    protected void addToMap(String string, FKIndexAssociation fKIndexAssociation) {
        if (string != null) {
            HashSet<FKIndexAssociation> hashSet = (HashSet<FKIndexAssociation>)this.generatedLists.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<FKIndexAssociation>();
                this.generatedLists.put(string, hashSet);
            }
            hashSet.add(fKIndexAssociation);
        }
    }

    public void removeAllGeneratedFKs(DesignObject designObject) {
        this.removeAllGeneratedFKs(designObject.getObjectID());
    }

    public void removeAllGeneratedFKs(String string) {
        Set set = (Set)this.generatedLists.get(string);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.removeFKAssociation((FKIndexAssociation)iterator.next());
            }
            this.generatedLists.remove(string);
        }
    }

    public FKIndexAssociation[] getFKAssociations() {
        return (FKIndexAssociation[])this.fkList.toArray(INDEX_ASSOCIATION_PROTO);
    }

    public FKIndexAssociation getFKIndexAssociationByName(String string) {
        for (FKIndexAssociation fKIndexAssociation : this.fkList) {
            if (!fKIndexAssociation.getName().equalsIgnoreCase(string)) continue;
            return fKIndexAssociation;
        }
        return null;
    }

    public List<FKIndexAssociation> getFKAssociationsList() {
        return this.fkList;
    }

    public FKIndexAssociation[] getFKIndexAssociationsWith(Table table) {
        HashSet<FKIndexAssociation> hashSet = new HashSet<FKIndexAssociation>();
        Collection collection = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(table);
        hashSet.addAll(this.fkList);
        hashSet.retainAll(collection);
        return (FKIndexAssociation[])hashSet.toArray(INDEX_ASSOCIATION_PROTO);
    }

    public FKIndexAssociation getFKIndexAssociationFor(KeyObject keyObject) {
        Table table = (Table)keyObject.getContainerObject();
        FKIndexAssociation[] fKIndexAssociationArray = this.getFKIndexAssociationsWith(table);
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            if (fKIndexAssociationArray[i].getKeyObject() != keyObject) continue;
            return fKIndexAssociationArray[i];
        }
        return null;
    }

    public void addFKAssociation(FKIndexAssociation fKIndexAssociation) {
        fKIndexAssociation.setContainerWithKeyObject(this);
        if (!fKIndexAssociation.isBackupFK()) {
            ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(fKIndexAssociation);
        }
        if (this.getDesign().isPropagatePKChahges() && !fKIndexAssociation.isBackupFK()) {
            fKIndexAssociation.addAllFKElements();
        }
        this.fkList.add(fKIndexAssociation);
        Index index = fKIndexAssociation.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(fKIndexAssociation)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)fKIndexAssociation));
        }
        this.indSet.removePlaceHolderFor(index);
        this.indexOnlySet.removePlaceHolderFor(index);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(fKIndexAssociation);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
    }

    public void addRecreateFKAssociation(FKIndexAssociation fKIndexAssociation) {
        this.recreateFK(fKIndexAssociation, fKIndexAssociation.getRemoteIndex(), fKIndexAssociation.getLocalFKIndex().getObjectID(), fKIndexAssociation.getDeleteRule());
    }

    public void restoreFKAssociation(FKIndexAssociation fKIndexAssociation, String string) {
        fKIndexAssociation.setContainerWithKeyObject(this);
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(fKIndexAssociation);
        Index index = this.createIndexFK(fKIndexAssociation, string);
        this.fkList.add(fKIndexAssociation);
        if (!this.fkSet.containsPlaceHolderFor(fKIndexAssociation)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)fKIndexAssociation));
        }
        this.indSet.removePlaceHolderFor(index);
        this.indexOnlySet.removePlaceHolderFor(index);
    }

    public void removeDependentFKAssociations(Index index) {
        Collection collection = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(index);
        for (FKIndexAssociation fKIndexAssociation : collection) {
            fKIndexAssociation.removeAllFKElements();
            Index index2 = fKIndexAssociation.getLocalFKIndex();
            ((Table)index2.getContainerWithKeyObject()).removeFKAssociation(fKIndexAssociation);
            ((ContainerWithKeyObject)index2.getTopLevelContainer()).remove(index2);
        }
    }

    public void removeDependentFKAssociations() {
        Collection collection = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(this);
        for (FKIndexAssociation fKIndexAssociation : collection) {
            fKIndexAssociation.removeAllFKElements();
            Index index = fKIndexAssociation.getLocalFKIndex();
            ((Table)index.getContainerWithKeyObject()).removeFKAssociation(fKIndexAssociation);
            ((ContainerWithKeyObject)index.getTopLevelContainer()).remove(index);
        }
    }

    @Override
    public void remove(KeyObject keyObject) {
        if (keyObject.isPK() || keyObject.isUnique()) {
            this.removeDependentFKAssociations((Index)keyObject);
        }
        if (keyObject.isPK()) {
            this.pkSet.remove(keyObject);
        }
        if (keyObject.isFK() && ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().contains(keyObject.getFKAssociation())) {
            this.removeFKAssociation(keyObject.getFKAssociation());
        }
        ((RelationalDesign)this.getDesignPart()).getGlobalIndexSet().remove(keyObject);
        super.remove(keyObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        int n;
        FKIndexAssociation[] fKIndexAssociationArray = this.getFKAssociations();
        for (n = 0; n < fKIndexAssociationArray.length; ++n) {
            fKIndexAssociationArray[n].setSilentRemove(true);
        }
        try {
            this.removeAllKeys();
            this.clearViews();
            this.deleteAllArcs();
            super.remove();
        }
        finally {
            for (n = 0; n < fKIndexAssociationArray.length; ++n) {
                fKIndexAssociationArray[n].setSilentRemove(false);
            }
        }
    }

    public void removeAllFKAssociations() {
        FKIndexAssociation[] fKIndexAssociationArray = this.getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            this.removeFKAssociation(fKIndexAssociationArray[i]);
        }
    }

    @Override
    public void removeAllKeys() {
        KeyObject[] keyObjectArray = this.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            keyObjectArray[i].remove();
        }
    }

    public void clearViews() {
        Iterator iterator = ((RelationalDesign)this.getDesignPart()).getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            tableView.clear(this);
        }
    }

    public void removeFKAssociation(FKIndexAssociation fKIndexAssociation) {
        fKIndexAssociation.removeAllFKElements();
        this.removeFKAssociationFromList(fKIndexAssociation);
        this.getDesign().removeDesignObject(fKIndexAssociation);
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().remove(fKIndexAssociation);
        this.removeContainerListener(fKIndexAssociation);
        if (fKIndexAssociation.getOriginalContainer() != null) {
            fKIndexAssociation.getOriginalContainer().removeContainerListener(fKIndexAssociation);
            fKIndexAssociation.removeObjectListener(fKIndexAssociation.getOriginalContainer());
        }
        if (fKIndexAssociation.getKeyObject() != null) {
            fKIndexAssociation.getKeyObject().removeObjectListener(this);
            fKIndexAssociation.getKeyObject().removeContainerListener(fKIndexAssociation);
            fKIndexAssociation.setKeyObject(null);
        }
        fKIndexAssociation.removeObjectListener(this);
        fKIndexAssociation.callRemoveListeners();
        ObjectChangeEvent.FKINDEX_REMOVED.setAffected(fKIndexAssociation);
        this.fireChange(ObjectChangeEvent.FKINDEX_REMOVED);
        this.clearDeleteFKcolumnChoose();
    }

    private void clearDeleteFKcolumnChoose() {
    }

    public void removeFKAssociationFromList(FKIndexAssociation fKIndexAssociation) {
        this.fkList.remove(fKIndexAssociation);
    }

    public boolean isAssociated(KeyObject keyObject) {
        if (keyObject == null) {
            return false;
        }
        Iterator<FKIndexAssociation> iterator = this.fkList.iterator();
        while (iterator.hasNext()) {
            if (!keyObject.equals(iterator.next().getKeyObject())) continue;
            return true;
        }
        return false;
    }

    @Override
    public KeyObject createKeyObject(String string) {
        return this.createIndex(string);
    }

    public Index createIndex() {
        Index index = this.createIndex(null);
        return index;
    }

    public Index createIndex(String string) {
        Index index = new Index(this.getDesignPart());
        index.setBackup(this.isBackup());
        index.setObjectID(string);
        String string2 = ApplyNamingStandards.createIndexName(this.getName(), this.getKeySet().size(), this.getDesignPart().getDesign().getDLSettings().getNamingStandardRule(), this.getDesignPart().getName(), this.getAbbreviation());
        index.setName(string2);
        this.add(index);
        return index;
    }

    public Index createIndexFK(FKIndexAssociation fKIndexAssociation) {
        Index index = new Index(this.getDesignPart(), fKIndexAssociation);
        index.setBackup(this.isBackup());
        index.setObjectID(null);
        index.setFKAssociation(fKIndexAssociation);
        this.add(index);
        return index;
    }

    public Index createIndexFK(FKIndexAssociation fKIndexAssociation, String string) {
        Index index = fKIndexAssociation.getLocalFKIndex();
        index.setBackup(this.isBackup());
        fKIndexAssociation.setBackup(this.isBackup());
        index.setObjectID(string);
        index.setFKAssociation(fKIndexAssociation);
        this.add(index);
        return index;
    }

    public ColumnSet getColumnSet() {
        return ((RelationalDesign)this.getDesignPart()).getColumnSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getColumnSet();
    }

    public boolean reconnectFKColumns() {
        boolean bl = true;
        Column[] columnArray = this.getAllFKPlaceHolderColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            bl = bl && this.replace(columnArray[i]);
        }
        return bl;
    }

    public boolean reconnectFK() {
        return false;
    }

    private boolean replace(Column column) {
        if (!column.isAdapterLoaded()) {
            column.loadDelegate();
        }
        return true;
    }

    public boolean isBeingRecreated() {
        return this.beingRecreated;
    }

    public boolean isMtoNjoinCandidate() {
        return false;
    }

    public void setBeingRecreated(boolean bl) {
        this.beingRecreated = bl;
    }

    @Override
    public int getByteSize(String string) {
        return super.getByteSize(string);
    }

    @Override
    public int countRelationsWith(ContainerWithKeyObject containerWithKeyObject) {
        if (containerWithKeyObject != null && containerWithKeyObject instanceof Table) {
            int n = 0;
            FKIndexAssociation[] fKIndexAssociationArray = this.getFKAssociations();
            for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
                if (!containerWithKeyObject.equals(fKIndexAssociationArray[i].getContainerWithKeyObject())) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    @Override
    public int countRelations() {
        return this.fkList.size();
    }

    public List getCheckConstraints() {
        return this.checkConstraints;
    }

    public TableLevelConstraint createCheckConstraint() {
        TableLevelConstraint tableLevelConstraint = new TableLevelConstraint(this.getDesignPart());
        return tableLevelConstraint;
    }

    public TableLevelConstraint createCheckConstraint(String string, String string2) {
        TableLevelConstraint tableLevelConstraint = new TableLevelConstraint(this.getDesignPart());
        tableLevelConstraint.setName(string);
        tableLevelConstraint.setRule(string2);
        return tableLevelConstraint;
    }

    public void addCheckConstraint(TableLevelConstraint tableLevelConstraint) {
        if (!this.checkConstraints.contains(tableLevelConstraint)) {
            this.checkConstraints.add(tableLevelConstraint);
            tableLevelConstraint.setTable(this);
            TableLevelConstraintEvent tableLevelConstraintEvent = TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_ADDED;
            tableLevelConstraintEvent.setAffected(tableLevelConstraint);
            this.fireChange(tableLevelConstraintEvent);
        }
    }

    public void removeCheckConstraint(TableLevelConstraint tableLevelConstraint) {
        if (this.checkConstraints.contains(tableLevelConstraint)) {
            this.checkConstraints.remove(tableLevelConstraint);
            TableLevelConstraintEvent tableLevelConstraintEvent = TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_REMOVED;
            tableLevelConstraintEvent.setAffected(tableLevelConstraint);
            this.fireChange(tableLevelConstraintEvent);
        }
    }

    public void clearCheckConstraints() {
        for (TableLevelConstraint tableLevelConstraint : this.checkConstraints) {
            TableLevelConstraintEvent tableLevelConstraintEvent = TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_REMOVED;
            tableLevelConstraintEvent.setAffected(tableLevelConstraint);
            this.fireChange(tableLevelConstraintEvent);
        }
        this.checkConstraints.clear();
    }

    public TableLevelConstraint getCheckConstraintByID(String string) {
        for (TableLevelConstraint tableLevelConstraint : this.checkConstraints) {
            if (!tableLevelConstraint.getID().equals(string)) continue;
            return tableLevelConstraint;
        }
        return null;
    }

    protected void fireChange(TableLevelConstraintEvent tableLevelConstraintEvent) {
        this.setDirty(true);
        this.getChange().setTimeNow();
        for (Object e : this.getListeners()) {
            if (!(e instanceof TableCheckConstraintListener)) continue;
            ((TableCheckConstraintListener)e).changed((TableLevelConstraint)tableLevelConstraintEvent.getAffected(), tableLevelConstraintEvent);
        }
    }

    @Override
    public boolean hasAliveGenerator() {
        RelationSet relationSet;
        DesignObject designObject;
        EntitySet entitySet = this.getDesign().getLogicalDesign().getEntitySet();
        return ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID()) || (designObject = entitySet.getObjectByID(this.getGeneratorID())) != null || (designObject = (relationSet = this.getDesign().getLogicalDesign().getRelationSet()).getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertiesDialogEx tablePropertiesDialogEx = new TablePropertiesDialogEx(this.getDesign().getAppView(), this);
            tablePropertiesDialogEx.initProperties(this);
            tablePropertiesDialogEx.show();
        }
    }

    public boolean hasPrimaryKey() {
        return this.pkSet.size() > 0;
    }

    public boolean hasUniqueKeys() {
        return this.unSet.size() > 0;
    }

    public DesignObjectCollection getPKeys() {
        return this.pkSet;
    }

    public DesignObjectCollection getUKeys() {
        return this.unSet;
    }

    public DesignObjectCollection getIndexes() {
        return this.indSet;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        if (string != null && string.equals(this.scope)) {
            return;
        }
        this.scope = string;
    }

    @Override
    public String getLongName() {
        StringBuffer stringBuffer = new StringBuffer();
        if ("".equals(this.getSchema())) {
            return this.getName();
        }
        stringBuffer.append(this.getSchema()).append('.').append(this.getName());
        return stringBuffer.toString();
    }

    private boolean checkGrowth(String string) {
        if (growthSet == null) {
            growthSet = new HashSet();
            growthSet.addAll(Arrays.asList(GROWTH_TYPES));
        }
        return growthSet.contains(string);
    }

    private boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(string);
    }

    private boolean checkNormalForm(String string) {
        if (normalFormSet == null) {
            normalFormSet = new HashSet();
            normalFormSet.addAll(Arrays.asList(NORMAL_FORMS));
        }
        return normalFormSet.contains(string);
    }

    public String getAdequatelyNormalized() {
        return this.adequatelyNormalized;
    }

    public void setAdequatelyNormalized(String string) {
        if (this.checkYesNo(string)) {
            this.adequatelyNormalized = string;
        }
    }

    public String getExpectedVolumes() {
        return this.expectedVolumes;
    }

    public void setExpectedVolumes(String string) {
        try {
            if (string != null) {
                this.expectedVolumes = string;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getGrowthPercent() {
        return Integer.toString(this.growthPercent);
    }

    public int getGrowthPercentInt() {
        return this.growthPercent;
    }

    public void setGrowthPercent(String string) {
        try {
            this.growthPercent = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getGrowthType() {
        return this.growthType;
    }

    public void setGrowthType(String string) {
        if (this.checkGrowth(string)) {
            this.growthType = string;
        }
    }

    public String getMaxVolumes() {
        return this.maxVolumes;
    }

    public void setMaxVolumes(String string) {
        if (string != null) {
            this.maxVolumes = string;
        }
    }

    public String getMinVolumes() {
        return this.minVolumes;
    }

    public void setMinVolumes(String string) {
        if (string != null) {
            this.minVolumes = string;
        }
    }

    public String getNormalForm() {
        return this.normalForm;
    }

    public void setNormalForm(String string) {
        if (this.checkNormalForm(string)) {
            this.normalForm = string;
        }
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public boolean canPaste() {
        for (Object e : this.getAppView().getCopiedObjects()) {
            if (e == null || !(e instanceof Column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void copy(DesignObject designObject) {
        this.copy(designObject, null);
    }

    public void copy(DesignObject designObject, Map map) {
        Object object;
        Object object2;
        DesignObject designObject2;
        Table table = (Table)designObject;
        super.copy(table);
        table.setTypeID(this.getTypeID());
        table.setScope(this.getScope());
        table.setBasedOnStructuredType(this.getBasedOnStructuredType());
        table.setAbbreviation(this.getAbbreviation());
        table.setOidIsPK(this.isOidIsPK());
        table.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
        table.setMinVolumes(this.getMinVolumes());
        table.setExpectedVolumes(this.getExpectedVolumes());
        table.setMaxVolumes(this.getMaxVolumes());
        table.setGrowthPercent(this.getGrowthPercent());
        table.setGrowthType(this.getGrowthType());
        table.setNormalForm(this.getNormalForm());
        table.setAdequatelyNormalized(this.getAdequatelyNormalized());
        if (!this.isBST()) {
            ContainedObject[] containedObjectArray = this.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                designObject2 = (Column)containedObjectArray[i];
                object2 = table.createColumn();
                ((Column)designObject2).copy((DesignObject)object2);
                if (map == null) continue;
                map.put(designObject2.getObjectID(), object2);
            }
        } else {
            object2 = this.getElements();
            for (int i = 0; i < ((ContainedObject[])object2).length; ++i) {
                Object object3;
                designObject2 = (Column)object2[i];
                if (!((ContainedObject)designObject2).isOid()) {
                    Object object4;
                    object3 = ((ContainedObject)designObject2).getStructAttributeID();
                    if (object3 == null || "".equals(object3)) continue;
                    Column column = (Column)table.getElementByStructAttributeID((String)object3);
                    if (column == null && map != null && (object4 = (DesignObject)map.get(object3)) != null) {
                        column = (Column)table.getElementByStructAttributeID(((ModelIDObject)object4).getObjectID());
                    }
                    if (column == null) continue;
                    column.setObjectID(designObject2.getObjectID());
                    ((Column)designObject2).copy(column);
                    continue;
                }
                object3 = (Column)table.getOidElement();
                if (object3 == null) continue;
                ((ContainedObject)object3).setObjectID(designObject2.getObjectID());
                ((Column)designObject2).copy((DesignObject)object3);
            }
        }
        for (int i = 0; i < this.getKeys().length; ++i) {
            object2 = null;
            designObject2 = this.getKeys()[i];
            if (((KeyObject)designObject2).isFK()) continue;
            if (((KeyObject)designObject2).isOidKey()) {
                object2 = table.getOidKey();
            }
            if (object2 == null) {
                object2 = table.createKeyObject();
            }
            ((KeyObject)designObject2).copy((DesignObject)object2);
            ((SubsetCO)object2).setContainerObject(table);
            if (designObject2 instanceof Index) {
                ((Index)object2).setIndexState(((Index)designObject2).getIndexState());
            }
            if (map == null) continue;
            map.put(designObject2.getObjectID(), object2);
        }
        table.setPKName(this.getPKName());
        for (int i = 0; i < this.getCheckConstraints().size(); ++i) {
            TableLevelConstraint tableLevelConstraint = (TableLevelConstraint)this.getCheckConstraints().get(i);
            TableLevelConstraint tableLevelConstraint2 = table.createCheckConstraint(tableLevelConstraint.getName(), tableLevelConstraint.getRule());
            table.addCheckConstraint(tableLevelConstraint2);
            if (map == null) continue;
            map.put(tableLevelConstraint.getObjectID(), tableLevelConstraint2);
        }
        table.setSpatialTable(this.isSpatialTable());
        table.getSpatialDefinitions().clear();
        for (Object object4 : this.getSpatialDefinitions()) {
            object = new SpatialColumnDefObject(table);
            ((SpatialColumnDefObject)object4).copyTo((SpatialColumnDefObject)object, map);
            table.addSpatialDefinition((SpatialColumnDefObject)object);
        }
        table.setBeforeDrop(this.getBeforeDrop());
        table.setBeforeCreate(this.getBeforeCreate());
        table.setAfterCreate(this.getAfterCreate());
        table.setEndOfScript(this.getEndOfScript());
        table.setShouldGenerateScript(this.getShouldGenerateScript());
        table.getColumnGroupsSet().clear();
        for (Object object4 : this.getColumnGroupsSet()) {
            object = table.createColumnGroup(((ColumnGroup)object4).getName(), null);
            table.getColumnGroupsSet().add(object);
            ((ColumnGroup)object4).copy((ColumnGroup)object, map);
        }
    }

    public void copyForeignKeys(Table table, Map map) {
        if (map == null) {
            return;
        }
        FKIndexAssociation[] fKIndexAssociationArray = this.getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            FKIndexAssociation fKIndexAssociation = fKIndexAssociationArray[i];
            Index index = fKIndexAssociation.getRemoteIndex();
            if (index == null) continue;
            boolean bl = this.getDesignPart() == table.getDesignPart();
            Object v = map.get(index.getObjectID());
            if (!bl && v == null) continue;
            FKIndexAssociation fKIndexAssociation2 = new FKIndexAssociation(table.getDesignPart());
            fKIndexAssociation2.setBackup(this.isBackup());
            this.assignLocalID(fKIndexAssociation2);
            KeyObject keyObject = v != null ? (KeyObject)v : index;
            fKIndexAssociation2.setKeyObject(keyObject);
            Index index2 = fKIndexAssociation.getLocalFKIndex();
            Index index3 = table.createIndexFK(fKIndexAssociation2);
            for (Object object : index2.getElementsCollection()) {
                Object v2 = map.get(((ModelIDObject)object).getObjectID());
                Column column = ((Column)object).getReferencedColumn(fKIndexAssociation);
                Column column2 = v != null ? map.get(column.getObjectID()) : column;
                if (!(v2 instanceof Column) || !(column2 instanceof Column)) continue;
                Column column3 = (Column)v2;
                column3.addFKAssociation(column2, fKIndexAssociation2);
                index3.add(column3);
            }
            index2.copy(index3);
            table.recreateFK(fKIndexAssociation2, keyObject, index3.getObjectID(), null);
            fKIndexAssociation.copy(fKIndexAssociation2);
            if (bl) {
                Object object;
                object = FKUtilities.generateFKName(table, fKIndexAssociation2.getRemoteTable(), fKIndexAssociation2.getRemoteIndex());
                fKIndexAssociation2.setName((String)object);
            }
            fKIndexAssociation2.resetEdgeParams();
            if (map == null) continue;
            map.put(fKIndexAssociation.getObjectID(), fKIndexAssociation2);
        }
    }

    public void backupTo(Table table) {
        Object object;
        Object object2;
        DesignObject designObject;
        int n;
        table.setBackup(true);
        super.copy(table);
        table.setObjectID(this.getObjectID());
        table.setTypeID(this.getTypeID());
        table.setScope(this.getScope());
        table.setBasedOnStructuredType(this.getBasedOnStructuredType());
        table.setAbbreviation(this.getAbbreviation());
        table.setOidIsPK(this.isOidIsPK());
        table.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
        table.setMinVolumes(this.getMinVolumes());
        table.setExpectedVolumes(this.getExpectedVolumes());
        table.setMaxVolumes(this.getMaxVolumes());
        table.setGrowthPercent(this.getGrowthPercent());
        table.setGrowthType(this.getGrowthType());
        table.setNormalForm(this.getNormalForm());
        table.setAdequatelyNormalized(this.getAdequatelyNormalized());
        if (!this.isBST()) {
            for (n = 0; n < this.getElements().length; ++n) {
                designObject = (Column)this.getElements()[n];
                object2 = new Column(table.getDesignPart());
                ((ModelObject)object2).setDesign(table.getDesign());
                ((ContainedObject)object2).setContainer(table);
                ((ContainedObject)object2).setObjectID(designObject.getObjectID());
                table.add((ContainedObject)object2);
                ((Column)designObject).copy((DesignObject)object2);
            }
        } else {
            for (n = 0; n < this.getElements().length; ++n) {
                designObject = (Column)this.getElements()[n];
                if (!((ContainedObject)designObject).isOid()) {
                    object2 = ((ContainedObject)designObject).getStructAttributeID();
                    if (object2 == null || "".equals(object2)) continue;
                    Column column = (Column)table.getElementByStructAttributeID((String)object2);
                    column.setObjectID(designObject.getObjectID());
                    ((Column)designObject).copy(column);
                    continue;
                }
                object2 = (Column)table.getOidElement();
                if (object2 == null) continue;
                ((ContainedObject)object2).setObjectID(designObject.getObjectID());
                ((Column)designObject).copy((DesignObject)object2);
            }
        }
        object2 = this.getKeys();
        for (int i = 0; i < ((KeyObject[])object2).length; ++i) {
            Index index = null;
            designObject = (Index)object2[i];
            if (((KeyObject)designObject).isFK()) continue;
            if (((KeyObject)designObject).isOidKey()) {
                index = (Index)table.getOidKey();
            }
            if (index == null) {
                index = (Index)table.createKeyObject();
            }
            ((Index)designObject).copy(index);
            index.setContainerObject(table);
            index.setObjectID(designObject.getObjectID());
            index.setIndexState(((Index)designObject).getIndexState());
            if (!((KeyObject)designObject).isPK()) continue;
            index.getContainerWithKeyObject().setPK(index);
        }
        table.setPKName(this.getPKName());
        table.clearCheckConstraints();
        for (int i = 0; i < this.getCheckConstraints().size(); ++i) {
            TableLevelConstraint tableLevelConstraint = (TableLevelConstraint)this.getCheckConstraints().get(i);
            TableLevelConstraint tableLevelConstraint2 = table.createCheckConstraint(tableLevelConstraint.getName(), tableLevelConstraint.getRule());
            tableLevelConstraint2.setID(tableLevelConstraint.getID());
            table.addCheckConstraint(tableLevelConstraint2);
        }
        table.setSpatialTable(this.isSpatialTable());
        table.getSpatialDefinitions().clear();
        for (Object object3 : this.getSpatialDefinitions()) {
            object = new SpatialColumnDefObject(table);
            ((SpatialColumnDefObject)object3).copyTo((SpatialColumnDefObject)object);
            ((SpatialColumnDefObject)object).setObjectID(((SpatialColumnDefObject)object3).getObjectID());
            table.addSpatialDefinition((SpatialColumnDefObject)object);
        }
        table.setBeforeDrop(this.getBeforeDrop());
        table.setBeforeCreate(this.getBeforeCreate());
        table.setAfterCreate(this.getAfterCreate());
        table.setEndOfScript(this.getEndOfScript());
        table.setShouldGenerateScript(this.getShouldGenerateScript());
        table.getColumnGroupsSet().clear();
        for (Object object3 : this.getColumnGroupsSet()) {
            object = table.createColumnGroup(((ColumnGroup)object3).getName(), null);
            table.getColumnGroupsSet().add(object);
            ((ColumnGroup)object3).copy((ColumnGroup)object);
        }
    }

    public void backupFKeysTO(Table table, DesignPartView designPartView) {
        FKIndexAssociation[] fKIndexAssociationArray = this.getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            FKIndexAssociation fKIndexAssociation = fKIndexAssociationArray[i];
            if (fKIndexAssociation.getRemoteIndex() == null) continue;
            FKIndexAssociation fKIndexAssociation2 = table.addBackupFK(fKIndexAssociation);
            fKIndexAssociation.backupTo(fKIndexAssociation2, designPartView);
        }
    }

    public void restoreTo(Table table) {
        Object object;
        DesignObject designObject;
        DesignObject designObject2;
        super.copy(table);
        table.setObjectID(this.getObjectID());
        table.setTypeID(this.getTypeID());
        table.setScope(this.getScope());
        table.setBasedOnStructuredType(this.getBasedOnStructuredType());
        table.setAbbreviation(this.getAbbreviation());
        table.setOidIsPK(this.isOidIsPK());
        table.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
        table.setMinVolumes(this.getMinVolumes());
        table.setExpectedVolumes(this.getExpectedVolumes());
        table.setMaxVolumes(this.getMaxVolumes());
        table.setGrowthPercent(this.getGrowthPercent());
        table.setGrowthType(this.getGrowthType());
        table.setNormalForm(this.getNormalForm());
        table.setAdequatelyNormalized(this.getAdequatelyNormalized());
        if (!this.isBST()) {
            for (int i = 0; i < this.getElements().length; ++i) {
                designObject2 = (Column)this.getElements()[i];
                designObject = table.createColumn(((ContainedObject)designObject2).getName(), designObject2.getObjectID());
                ((Column)designObject2).copy(designObject);
                ((ContainedObject)designObject).setObjectID(designObject2.getObjectID());
            }
        }
        KeyObject[] keyObjectArray = this.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            designObject2 = keyObjectArray[i];
            if (((KeyObject)designObject2).isFK() || ((KeyObject)designObject2).isOidKey()) continue;
            designObject = table.createKeyObject(designObject2.getObjectID());
            ((KeyObject)designObject2).copy(designObject);
            ((SubsetCO)designObject).setContainerObject(table);
            ((KeyObject)designObject).setObjectID(designObject2.getObjectID());
            if (!(designObject2 instanceof Index)) continue;
            ((Index)designObject).setIndexState(((Index)designObject2).getIndexState());
        }
        table.setPKName(this.getPKName());
        table.clearCheckConstraints();
        for (int i = 0; i < this.getCheckConstraints().size(); ++i) {
            TableLevelConstraint tableLevelConstraint = (TableLevelConstraint)this.getCheckConstraints().get(i);
            TableLevelConstraint tableLevelConstraint2 = table.createCheckConstraint(tableLevelConstraint.getName(), tableLevelConstraint.getRule());
            tableLevelConstraint2.setID(tableLevelConstraint.getID());
            table.addCheckConstraint(tableLevelConstraint2);
        }
        table.setSpatialTable(this.isSpatialTable());
        table.getSpatialDefinitions().clear();
        for (Object object2 : this.getSpatialDefinitions()) {
            object = new SpatialColumnDefObject(table);
            ((SpatialColumnDefObject)object2).copyTo((SpatialColumnDefObject)object);
            ((SpatialColumnDefObject)object).setObjectID(((SpatialColumnDefObject)object2).getObjectID());
            table.addSpatialDefinition((SpatialColumnDefObject)object);
        }
        table.setBeforeDrop(this.getBeforeDrop());
        table.setBeforeCreate(this.getBeforeCreate());
        table.setAfterCreate(this.getAfterCreate());
        table.setEndOfScript(this.getEndOfScript());
        table.setShouldGenerateScript(this.getShouldGenerateScript());
        table.getColumnGroupsSet().clear();
        for (Object object2 : this.getColumnGroupsSet()) {
            object = table.createColumnGroup(((ColumnGroup)object2).getName(), null);
            table.getColumnGroupsSet().add(object);
            ((ColumnGroup)object2).copy((ColumnGroup)object);
        }
    }

    @Override
    public void applyChangesTo(DesignObject designObject) {
        super.applyChangesTo(designObject);
        if (designObject instanceof Table) {
            TableLevelConstraint tableLevelConstraint;
            Table table = (Table)designObject;
            table.setObjectID(this.getObjectID());
            table.setTypeID(this.getTypeID());
            table.setScope(this.getScope());
            table.setBasedOnStructuredType(this.getBasedOnStructuredType());
            table.setAbbreviation(this.getAbbreviation());
            table.setSchemaObject(this.getSchemaObject());
            table.setOidIsPK(this.isOidIsPK());
            table.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
            table.setMinVolumes(this.getMinVolumes());
            table.setExpectedVolumes(this.getExpectedVolumes());
            table.setMaxVolumes(this.getMaxVolumes());
            table.setGrowthPercent(this.getGrowthPercent());
            table.setGrowthType(this.getGrowthType());
            table.setNormalForm(this.getNormalForm());
            table.setAdequatelyNormalized(this.getAdequatelyNormalized());
            table.setSpatialTable(this.isSpatialTable());
            table.getSpatialDefinitions().clear();
            table.setBeforeDrop(this.getBeforeDrop());
            table.setBeforeCreate(this.getBeforeCreate());
            table.setAfterCreate(this.getAfterCreate());
            table.setEndOfScript(this.getEndOfScript());
            table.setShouldGenerateScript(this.getShouldGenerateScript());
            List list = table.getCheckConstraints();
            for (int i = list.size() - 1; i >= 0; --i) {
                tableLevelConstraint = (TableLevelConstraint)list.get(i);
                TableLevelConstraint tableLevelConstraint2 = this.getCheckConstraintByID(tableLevelConstraint.getObjectID());
                if (tableLevelConstraint2 != null) {
                    tableLevelConstraint.setName(tableLevelConstraint2.getName());
                    tableLevelConstraint.setRule(tableLevelConstraint2.getRule());
                    continue;
                }
                tableLevelConstraint.remove();
            }
            for (TableLevelConstraint tableLevelConstraint2 : this.getCheckConstraints()) {
                tableLevelConstraint = table.getCheckConstraintByID(tableLevelConstraint2.getObjectID());
                if (tableLevelConstraint != null) continue;
                tableLevelConstraint = table.createCheckConstraint(tableLevelConstraint2.getName(), tableLevelConstraint2.getRule());
                tableLevelConstraint.setID(tableLevelConstraint2.getID());
                table.addCheckConstraint(tableLevelConstraint);
            }
            table.getColumnGroupsSet().clear();
            for (ColumnGroup columnGroup : this.getColumnGroupsSet()) {
                ColumnGroup columnGroup2 = table.createColumnGroup(columnGroup.getName(), null);
                table.getColumnGroupsSet().add(columnGroup2);
                columnGroup.copy(columnGroup2);
            }
        }
    }

    public void applySpatialColumndefinitions(Table table) {
        table.getSpatialDefinitions().clear();
        for (SpatialColumnDefObject spatialColumnDefObject : this.getSpatialDefinitions()) {
            SpatialColumnDefObject spatialColumnDefObject2 = new SpatialColumnDefObject(table);
            spatialColumnDefObject.copyTo(spatialColumnDefObject2);
            spatialColumnDefObject2.setObjectID(spatialColumnDefObject.getObjectID());
            table.addSpatialDefinition(spatialColumnDefObject2);
        }
    }

    @Override
    public void paste() {
        for (Object e : this.getAppView().getCopiedObjects()) {
            if (e == null || !(e instanceof Column)) continue;
            Column column = this.createColumn();
            Column column2 = (Column)e;
            column2.copy(column);
        }
    }

    public Entity getEngEntity() {
        RepositoryObject repositoryObject;
        DesignObject designObject;
        MappingCollector mappingCollector = this.getRMExtendedMap().getOrCreateCollector(this);
        Entity entity = null;
        List list = mappingCollector.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (designObject = ((XtdMapping)(repositoryObject = (XtdMapping)list.get(0))).getObjectMappedTo(this)) != null) {
            if (designObject instanceof Entity) {
                return (Entity)designObject;
            }
            return null;
        }
        repositoryObject = this.getGenerator();
        if (repositoryObject instanceof Entity && (entity = (Entity)repositoryObject) == null) {
            if (!ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID())) {
                entity = (Entity)this.getDesign().getLogicalDesign().getEntitySet().getObjectByID(this.getGeneratorID());
            }
            if (entity == null) {
                entity = (Entity)this.getDesign().getLogicalDesign().getEntitySet().getObjectGeneratedBy(this.getObjectID());
            }
        }
        return entity;
    }

    public List getMappingsToEntities() {
        MappingCollector mappingCollector = this.getRMExtendedMap().getOrCreateCollector(this);
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        List list = mappingCollector.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        for (XtdMapping xtdMapping : list) {
            DesignObject designObject = xtdMapping.getObjectMappedTo(this);
            if (designObject == null || !(designObject instanceof Entity)) continue;
            arrayList.add(xtdMapping);
        }
        return arrayList;
    }

    public boolean hasMappingWithEntity(Entity entity) {
        MappingCollector mappingCollector = this.getRMExtendedMap().getOrCreateCollector(this);
        List list = mappingCollector.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        for (XtdMapping xtdMapping : list) {
            DesignObject designObject = xtdMapping.getObjectMappedTo(this);
            if (designObject == null || !(designObject instanceof Entity) || designObject != entity) continue;
            return true;
        }
        return false;
    }

    public Relation getEngRelation() {
        RepositoryObject repositoryObject;
        DesignObject designObject;
        MappingCollector mappingCollector = this.getRMExtendedMap().getOrCreateCollector(this);
        Relation relation = null;
        List list = mappingCollector.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (designObject = ((XtdMapping)(repositoryObject = (XtdMapping)list.get(0))).getObjectMappedTo(this)) != null && designObject instanceof Relation) {
            return (Relation)designObject;
        }
        repositoryObject = this.getGenerator();
        if (repositoryObject != null && repositoryObject instanceof Relation) {
            return (Relation)repositoryObject;
        }
        if (relation == null) {
            if (!ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID())) {
                relation = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectByID(this.getGeneratorID());
            }
            if (relation == null) {
                relation = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectGeneratedBy(this.getObjectID());
            }
        }
        return relation;
    }

    @Override
    protected void clearStructure() {
        this.removeAllFKAssociations();
        this.removeAllKeys();
        this.removeAll();
    }

    @Override
    protected void updateStructure() {
        block5: {
            block4: {
                TypeElement typeElement;
                int n;
                if (!this.isBST()) break block4;
                StructuredType structuredType = this.getBasedOnStructuredType();
                if ("XMLTYPE".equalsIgnoreCase(structuredType.getName())) break block5;
                List list = structuredType.getAllElements();
                ContainedObject[] containedObjectArray = this.getElements();
                for (n = 0; n < containedObjectArray.length; ++n) {
                    if (containedObjectArray[n].isOid() || (typeElement = this.findTypeElement(list, containedObjectArray[n].getStructAttributeID())) != null) continue;
                    containedObjectArray[n].remove();
                }
                this.addOidColumn();
                this.updateElements(list);
                for (n = 0; n < list.size(); ++n) {
                    typeElement = (TypeElement)list.get(n);
                    ContainedObject containedObject = this.getElementByStructAttributeID(typeElement.getObjectID());
                    if (containedObject == null) continue;
                    this.moveToIndex(containedObject, n + 1);
                }
                break block5;
            }
            ContainedObject[] containedObjectArray = this.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                if (column.getDataType() instanceof StructuredType && !column.isReference()) {
                    column.setUse((short)3);
                    continue;
                }
                if (!(column.getDataType() instanceof CollectionType)) continue;
                column.setUse((short)4);
            }
        }
    }

    private TypeElement findTypeElement(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            TypeElement typeElement = (TypeElement)list.get(i);
            if (!typeElement.getObjectID().equalsIgnoreCase(string)) continue;
            return typeElement;
        }
        return null;
    }

    private void addOidColumn() {
        if (this.getElementsCollection().size() == 0) {
            Column column;
            if (this.isBackup()) {
                column = new Column(this.getDesignPart());
                column.setName("Oid");
            } else {
                column = this.createColumn("Oid");
            }
            column.setOid(true);
            column.setUse((short)3);
            column.setStructuredType(this.getBasedOnStructuredType());
            column.setReference(true);
            this.addColumn(column);
            column.setNullsAllowed(false);
            Index index = this.createIndex();
            index.setPK(true);
            index.add(column);
            index.setName(OID_PK + this.getName());
            index.setOidKey(true);
            this.setUserDefinedOid(true);
        }
    }

    private void updateElements(List list) {
        for (int i = 0; i < list.size(); ++i) {
            TypeElement typeElement = (TypeElement)list.get(i);
            Column column = (Column)this.getElementByStructAttributeID(typeElement.getObjectID());
            if (column == null) {
                if (this.isBackup()) {
                    column = new Column(this.getDesignPart());
                    column.setName(typeElement.getName());
                    column.setStructAttributeID(typeElement.getObjectID());
                } else {
                    column = this.createColumn(typeElement.getName());
                    column.setStructAttributeID(typeElement.getObjectID());
                }
                this.addColumn(column);
            }
            this.copyTEtoColumn(typeElement, column);
        }
    }

    public void createColumnAndNestedColumns(TypeElement typeElement, Column column) {
        if (typeElement.getType() instanceof StructuredType && !typeElement.isReference()) {
            Column column2 = (Column)this.getElementByStructAttributeID(typeElement.getObjectID(), column);
            if (column2 == null) {
                column2 = new Column(this.getDesignPart());
                column2.setName(typeElement.getName());
                column2.setStructAttributeID(typeElement.getObjectID());
                column2.setParentObject(column);
                this.addColumn(column2);
            }
            this.copyTEtoColumn(typeElement, column2);
            StructuredType structuredType = (StructuredType)typeElement.getType();
            TypeElement[] typeElementArray = structuredType.getElements();
            for (int i = 0; i < typeElementArray.length; ++i) {
                TypeElement typeElement2 = typeElementArray[i];
                Column column3 = (Column)this.getElementByStructAttributeID(typeElement2.getObjectID(), column2);
                if (column3 == null) {
                    column3 = new Column(this.getDesignPart());
                    column3.setName(typeElement.getName());
                    column3.setStructAttributeID(typeElement2.getObjectID());
                    column3.setParentObject(column2);
                    this.addColumn(column3);
                }
                this.copyTEtoColumn(typeElement2, column3);
                if (!(typeElement2.getType() instanceof StructuredType) || typeElement2.isReference()) continue;
                this.createNestedColumnsOnly(typeElement2, column3);
            }
        } else {
            Column column4 = (Column)this.getElementByStructAttributeID(typeElement.getObjectID(), column);
            if (column4 == null) {
                column4 = new Column(this.getDesignPart());
                column4.setName(typeElement.getName());
                column4.setStructAttributeID(typeElement.getObjectID());
                column4.setParentObject(column);
                this.addColumn(column4);
            }
            this.copyTEtoColumn(typeElement, column4);
        }
    }

    public void createNestedColumnsOnly(TypeElement typeElement, Column column) {
        if (typeElement.getType() instanceof StructuredType && !typeElement.isReference()) {
            StructuredType structuredType = (StructuredType)typeElement.getType();
            TypeElement[] typeElementArray = structuredType.getElements();
            for (int i = 0; i < typeElementArray.length; ++i) {
                TypeElement typeElement2 = typeElementArray[i];
                Column column2 = (Column)this.getElementByStructAttributeID(typeElement2.getObjectID(), column);
                if (column2 == null) {
                    column2 = new Column(this.getDesignPart());
                    column2.setName(typeElement.getName());
                    column2.setStructAttributeID(typeElement2.getObjectID());
                    column2.setParentObject(column);
                    this.addColumn(column2);
                }
                this.copyTEtoColumn(typeElement2, column2);
                if (!(typeElement2.getType() instanceof StructuredType) || typeElement2.isReference()) continue;
                this.createNestedColumnsOnly(typeElement2, column2);
            }
        } else {
            Column column3 = (Column)this.getElementByStructAttributeID(typeElement.getObjectID(), column);
            if (column3 == null) {
                column3 = new Column(this.getDesignPart());
                column3.setName(typeElement.getName());
                column3.setStructAttributeID(typeElement.getObjectID());
                column3.setParentObject(column);
                this.addColumn(column3);
            }
            this.copyTEtoColumn(typeElement, column3);
        }
    }

    public void createNestedColumnsOnly(StructuredType structuredType, Column column) {
        if (!column.isReference()) {
            TypeElement typeElement;
            List list = structuredType.getAllElements();
            Object[] objectArray = column.getNestedObjects().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ContainedObject containedObject = (ContainedObject)objectArray[i];
                typeElement = this.findTypeElement(list, containedObject.getStructAttributeID());
                if (typeElement != null) continue;
                this.removeNestedCOFor(containedObject);
                containedObject.remove();
                this.nestedElements.remove(containedObject);
            }
            TypeElement[] typeElementArray = structuredType.getElements();
            for (int i = 0; i < typeElementArray.length; ++i) {
                typeElement = typeElementArray[i];
                Column column2 = (Column)this.getElementByStructAttributeID(typeElement.getObjectID(), column);
                if (column2 == null) {
                    column2 = new Column(this.getDesignPart());
                    column2.setName(typeElement.getName());
                    column2.setStructAttributeID(typeElement.getObjectID());
                    column2.setParentObject(column);
                    this.addColumn(column2);
                }
                this.copyTEtoColumn(typeElement, column2);
            }
        }
    }

    public void createNestedCol(TypeElement typeElement, Column column) {
        if (typeElement.getStructuredType() != null) {
            Column column2 = (Column)this.getElementByStructAttributeID(typeElement.getObjectID(), column);
            if (column2 == null) {
                column2 = new Column(this.getDesignPart());
                column2.setName(typeElement.getName());
                column2.setStructAttributeID(typeElement.getObjectID());
                column2.setParentObject(column);
                this.addColumn(column2);
            }
            this.copyTEtoColumn(typeElement, column2);
        }
    }

    private void copyTEtoColumn(TypeElement typeElement, Column column) {
        column.setName(typeElement.getName());
        if (typeElement.getType() instanceof LogicalDatatype) {
            column.setUse((short)1);
            column.setLogicalDatatype((LogicalDatatype)typeElement.getType());
            column.setReference(false);
            String string = typeElement.getUnits();
            if (string != null && !"".equals(string) && !typeElement.getSize().equals("")) {
                column.setDataTypeParameter("size", typeElement.getSize() + " " + string);
            } else {
                column.setDataTypeParameter("size", typeElement.getSize());
            }
            column.setDataTypeParameter("precision", Integer.toString(typeElement.getPrecision()));
            column.setDataTypeParameter("scale", Integer.toString(typeElement.getScale()));
        } else if (typeElement.getType() instanceof DistinctType) {
            column.setUse((short)2);
            column.setDistinctType((DistinctType)typeElement.getType());
            column.setReference(false);
        } else if (typeElement.getType() instanceof StructuredType) {
            column.setUse((short)3);
            column.setReference(typeElement.isReference());
            column.setStructuredType((StructuredType)typeElement.getType());
        } else if (typeElement.getType() instanceof CollectionType) {
            column.setUse((short)4);
            column.setCollectionType((CollectionType)typeElement.getType());
        } else if (typeElement.getType() instanceof Domain) {
            Domain domain = (Domain)typeElement.getType();
            column.setUse((short)0);
            column.setDomain(domain);
            column.setReference(false);
            column.setDataTypeParameter("size", domain.getSize());
            column.setDataTypeParameter("precision", domain.getPrecision());
            column.setDataTypeParameter("scale", domain.getScale());
        }
        column.setNullsAllowed(!typeElement.isMandatory());
    }

    public List getNonStructuredElements() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Column column : this.getElementsCollection()) {
            if (column.isOid() || column.isReference() || column.getDataType() instanceof StructuredType) continue;
            arrayList.add(column);
        }
        return arrayList;
    }

    public boolean isUserDefinedOid() {
        return this.userDefinedOid;
    }

    public void setUserDefinedOid(boolean bl) {
        this.userDefinedOid = bl;
    }

    public List getOidPKColumns() {
        Index index = (Index)this.getPK();
        if (index != null) {
            this.oidPKColumns.clear();
            Column column = (Column)this.getOidElement();
            if (column != null && index.contains(column)) {
                return this.oidPKColumns;
            }
            this.oidPKColumns.addAll(index.getElementsCollection());
        }
        return this.oidPKColumns;
    }

    public void setOidPKColumns(List list) {
        this.oidPKColumns = list;
    }

    public List getAllPossibleElements() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getElementsCollection());
        if (this.hasTypeSubstitutionChildren() && this.getTypeSubstitution() == null) {
            arrayList.addAll(this.getElementsFromSubTables());
        }
        return arrayList;
    }

    private List getElementsFromSubTables() {
        ArrayList arrayList = new ArrayList();
        if (this.hasTypeSubstitutionChildren()) {
            for (TypeSubstitution typeSubstitution : this.getSubTypeSubstitutions()) {
                Table table = (Table)typeSubstitution.getChildContainerObject();
                arrayList.addAll(table.getElementsFromStructuredType(table.basedOnStructuredType));
                arrayList.addAll(table.getElementsFromSubTables());
            }
        }
        return arrayList;
    }

    private List getElementsFromStructuredType(StructuredType structuredType) {
        ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
        if (structuredType != null) {
            TypeElement[] typeElementArray = structuredType.getElements();
            for (int i = 0; i < typeElementArray.length; ++i) {
                ContainedObject containedObject = this.getElementByStructAttributeID(typeElementArray[i].getObjectID());
                if (containedObject == null) continue;
                arrayList.add(containedObject);
            }
        }
        return arrayList;
    }

    public boolean isReferencedByFKs() {
        Iterator iterator = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            if (fKIndexAssociation.getRemoteTable() != this) continue;
            return true;
        }
        return false;
    }

    public List getAllNestedElements() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        if (this.hasTypeSubstitutionChildren()) {
            for (TypeSubstitution typeSubstitution : this.getSubTypeSubstitutions()) {
                Table table = (Table)typeSubstitution.getChildContainerObject();
                ContainedObject[] containedObjectArray = table.getElements();
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    Column column = (Column)containedObjectArray[i];
                    if (!column.isAtomic() || arrayList.contains(column)) continue;
                    arrayList.add(column);
                }
                for (Column column : table.getNestedElements()) {
                    if (!column.isAtomic() || arrayList.contains(column)) continue;
                    arrayList.add(column);
                }
            }
        } else {
            ContainedObject[] containedObjectArray = this.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                if (!column.isAtomic() || arrayList.contains(column)) continue;
                arrayList.add(column);
            }
            for (Column column : this.getNestedElements()) {
                if (!column.isAtomic() || arrayList.contains(column)) continue;
                arrayList.add(column);
            }
        }
        return arrayList;
    }

    public String getSplittedTableID() {
        return this.splittedTableID;
    }

    public void setSplittedTableID(String string) {
        this.splittedTableID = string;
    }

    public List getPossibleSplits() {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        Iterator iterator = ((TableSet)this.getParent()).iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (!table.getSplittedTableID().equalsIgnoreCase(this.getObjectID())) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    public XtdMapping getDeletedMapping() {
        List list = this.getRMExtendedMap().getDeletedMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            XtdMapping xtdMapping = (XtdMapping)list.get(0);
            return xtdMapping;
        }
        return null;
    }

    public Index getIndexByID(String string) {
        Iterator iterator = this.getKeySet().iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            if (!index.getObjectID().equals(string)) continue;
            return index;
        }
        return null;
    }

    public Index getIndexByName(String string) {
        KeyObject[] keyObjectArray = this.getKeys();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            Index index = (Index)keyObjectArray[i];
            if (!index.getName().equals(string)) continue;
            return index;
        }
        return null;
    }

    public Index getIndexByNameAndSchema(String string, String string2) {
        if (string != null && string2 != null && !"".equals(string)) {
            KeyObject[] keyObjectArray = this.getKeys();
            for (int i = 0; i < keyObjectArray.length; ++i) {
                Index index = (Index)keyObjectArray[i];
                if (!index.getName().equals(string2) || !string.equals(index.getSchema())) continue;
                return index;
            }
        }
        return null;
    }

    public boolean isSpatialTable() {
        return this.isSpatialTable;
    }

    public void setSpatialTable(boolean bl) {
        this.isSpatialTable = bl;
    }

    public List getSpatialDefinitions() {
        if (this.spatialDefinitions == null) {
            this.spatialDefinitions = new ArrayList();
        }
        return this.spatialDefinitions;
    }

    public void setSpatialDefinitions(List list) {
        this.spatialDefinitions = list;
    }

    public void addSpatialDefinition(SpatialColumnDefObject spatialColumnDefObject) {
        if (!this.getSpatialDefinitions().contains(spatialColumnDefObject)) {
            this.getSpatialDefinitions().add(spatialColumnDefObject);
        }
    }

    public boolean isOidIsPK() {
        return this.oidIsPK;
    }

    public void setOidIsPK(boolean bl) {
        this.oidIsPK = bl;
    }

    public List getAllowedStrTypeInstances() {
        ArrayList arrayList = new ArrayList();
        this.addStructuredSubTypeInstances(this, arrayList);
        return arrayList;
    }

    private void addStructuredSubTypeInstances(Table table, List list) {
        if (table.isBST()) {
            list.add(table.getBasedOnStructuredType());
            for (TypeSubstitution typeSubstitution : table.getSubTypeSubstitutions()) {
                Table table2 = (Table)typeSubstitution.getChildContainerObject();
                this.addStructuredSubTypeInstances(table2, list);
            }
        }
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && this.getDesignPart().getAppView() != null && (defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.resetAllTopViewsCustomFormat();
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
            this.setUseDefaultColor(true);
        } else if (DefaultFontAndColor.isModified(TYPE_NAME)) {
            DefaultFontAndColor defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME);
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
            this.setUseDefaultColor(bl);
        }
    }

    public List getAllSubstitutionTables() {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        if (this.hasTypeSubstitutionChildren()) {
            for (TypeSubstitution typeSubstitution : this.getSubTypeSubstitutions()) {
                Table table = (Table)typeSubstitution.getChildContainerObject();
                arrayList.add(table);
                arrayList.addAll(table.getAllSubstitutionTables());
            }
        }
        return arrayList;
    }

    public int getFKAssociationsCount() {
        return this.fkList.size();
    }

    public List getFKeysOnColumn(Column column) {
        ArrayList<FKIndexAssociation> arrayList = new ArrayList<FKIndexAssociation>();
        for (FKIndexAssociation fKIndexAssociation : this.fkList) {
            if (!fKIndexAssociation.getLocalFKIndex().contains(column)) continue;
            arrayList.add(fKIndexAssociation);
        }
        return arrayList;
    }

    public void addArc(FKArc fKArc) {
        if (!this.arcExists(fKArc)) {
            this.arcs.add(fKArc);
            fKArc.setTable(this);
            fKArc.addObjectListener(this);
            this.updateArcSizeIndexes();
        }
    }

    public boolean arcExists(FKArc fKArc) {
        if (this.arcs.contains(fKArc)) {
            return true;
        }
        for (FKArc fKArc2 : this.arcs) {
            if (fKArc2.getFkeys().size() <= 0 || fKArc2.getFkeys().size() != fKArc.getFkeys().size() || !fKArc2.getFkeys().containsAll(fKArc.getFkeys())) continue;
            return true;
        }
        return false;
    }

    public boolean arcExists(List list) {
        for (FKArc fKArc : this.arcs) {
            if (!fKArc.getFkeys().containsAll(list)) continue;
            return true;
        }
        return false;
    }

    public void removeArc(FKArc fKArc) {
        this.arcs.remove(fKArc);
        fKArc.removeObjectListener(this);
        this.updateArcSizeIndexes();
    }

    public void deleteAllArcs() {
        Object[] objectArray = this.arcs.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            FKArc fKArc = (FKArc)objectArray[i];
            fKArc.remove();
        }
    }

    public List getArcs() {
        return this.arcs;
    }

    public void clearArcs() {
        this.arcs.clear();
    }

    private void updateArcSizeIndexes() {
        Object[] objectArray = this.arcs.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            FKArc fKArc = (FKArc)objectArray[i];
            fKArc.setSizeIndex((i + 1) * 20);
        }
    }

    public boolean inArc(FKIndexAssociation fKIndexAssociation) {
        for (FKArc fKArc : this.arcs) {
            if (!fKArc.containsFKey(fKIndexAssociation)) continue;
            return true;
        }
        return false;
    }

    public void showArcs(boolean bl) {
        for (FKArc fKArc : this.arcs) {
            fKArc.setVisible(bl);
            if (bl) {
                this.getDesignPart().getMainView().getWorkSpace().addFKArc(fKArc, new Rectangle());
                continue;
            }
            this.getDesignPart().getMainView().getWorkSpace().removeFKArc(fKArc);
        }
    }

    public boolean hasNoneTransferableFK() {
        FKIndexAssociation[] fKIndexAssociationArray = this.getFKAssociations();
        for (int i = 0; i < fKIndexAssociationArray.length; ++i) {
            if (fKIndexAssociationArray[i].isTransferable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBedeleted() {
        if (this.getDesign().isRepositoryRelated()) {
            if (this.getDesignPart().isCheckedOutByMe()) {
                return this.getRepositoryOID() == null || !this.isReferencedByFKs();
            }
            return false;
        }
        return true;
    }

    public void setAbbreviation(String string) {
        this.abbreviation = string;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void addColumnGroup(ColumnGroup columnGroup) {
        if (!this.getColumnGroupsSet().contains(columnGroup)) {
            this.getColumnGroupsSet().add(columnGroup);
        }
    }

    public void removeColumnGroup(ColumnGroup columnGroup) {
        this.getColumnGroupsSet().remove(columnGroup);
    }

    public List getColumnGroupsSet() {
        if (this.columnGroupsSet == null) {
            this.columnGroupsSet = new ArrayList<ColumnGroup>();
        }
        return this.columnGroupsSet;
    }

    public ColumnGroup createColumnGroup() {
        ColumnGroup columnGroup = new ColumnGroup(null);
        this.addColumnGroup(columnGroup);
        return columnGroup;
    }

    public ColumnGroup createColumnGroup(String string, String string2) {
        ColumnGroup columnGroup = new ColumnGroup(null);
        if (string2 != null) {
            columnGroup.setObjectID(string2);
        }
        if (string != null) {
            columnGroup.setName(string);
        }
        return columnGroup;
    }

    public ColumnGroup getColumnGroupByID(String string) {
        for (ColumnGroup columnGroup : this.getColumnGroupsSet()) {
            if (!columnGroup.getObjectID().equals(string)) continue;
            return columnGroup;
        }
        return null;
    }

    public void applyIndexOrderFromList(List list) {
        this.getKeySet().applyOrderFromList(list);
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "table/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public SpatialColumnDefObject createSpatialDefinition() {
        SpatialColumnDefObject spatialColumnDefObject = new SpatialColumnDefObject(this);
        this.getSpatialDefinitions().add(spatialColumnDefObject);
        return spatialColumnDefObject;
    }

    public void removeSpatialDefinition(SpatialColumnDefObject spatialColumnDefObject) {
        this.getSpatialDefinitions().remove(spatialColumnDefObject);
    }

    public SpatialColumnDefObject getSpatialDefinitionByID(String string) {
        for (SpatialColumnDefObject spatialColumnDefObject : this.getSpatialDefinitions()) {
            if (!spatialColumnDefObject.getObjectID().equals(string)) continue;
            return spatialColumnDefObject;
        }
        return null;
    }

    public Column getColumnByProperty(String string, String string2) {
        for (Column column : this.getElementsCollection()) {
            String string3 = column.getProperty(string);
            if (string3 == null || !string3.equals(string2)) continue;
            return column;
        }
        return null;
    }

    public Object[] getColumnsByProperty(String string, String string2) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Column column : this.getElementsCollection()) {
            String string3 = column.getProperty(string);
            if (string3 == null || !string3.equals(string2)) continue;
            arrayList.add(column);
        }
        return arrayList.toArray();
    }

    @Override
    public boolean hasProxyToDelete() {
        return true;
    }

    public List getAllFKeysEndingToTable() {
        return ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().getFKeysEndingTo(this);
    }

    public Index getUniqueIndex_PK_UK(Column[] columnArray) {
        Iterator iterator = this.getKeySet().iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            if (!index.isPK() && !index.isUnique() && !index.isUniquePlainIndex() || !index.isIndexForColumns(columnArray)) continue;
            return index;
        }
        return null;
    }

    public Index getIndex(Column[] columnArray) {
        Iterator iterator = this.getKeySet().iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            if (index.isPK() || index.isUnique() || index.isUniquePlainIndex() || index.isFK() || !index.isIndexForColumns(columnArray)) continue;
            return index;
        }
        return null;
    }

    public Column getEquivelentColumn(Column column, String string, boolean bl) {
        for (Column column2 : this.getElementsCollection()) {
            if (column2 == column || column2.isFKColumn() && bl || (string == null || "".equals(string) ? !column.getName().equalsIgnoreCase(column2.getName()) : !string.equalsIgnoreCase(column2.getName()))) continue;
            if (!column2.hasEqulaDataType(column) || column2.isReferingTo(column)) continue;
            return column2;
        }
        return null;
    }

    public Column getEquivelentColumn(Column column, String string) {
        return this.getEquivelentColumn(column, string, true);
    }

    public String createFKColumnName(Column column) {
        NamingStandardRule namingStandardRule = this.getDesign().getNamingStandardRule();
        String string = ApplyNamingStandards.createFKColumnName(column, namingStandardRule);
        return string;
    }

    public void resetIdentityColumn() {
        DesignObject designObject;
        Iterator iterator = this.getElementsCollection().iterator();
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        while (iterator.hasNext()) {
            designObject = (Column)iterator.next();
            if (((Column)designObject).isIdentityColumn()) {
                return;
            }
            if (!((Column)designObject).isAutoIncrementColumn()) continue;
            arrayList.add(designObject);
        }
        if (arrayList.size() == 1) {
            designObject = (Column)arrayList.get(0);
            if (((ContainedObject)designObject).isMandatory()) {
                ((Column)designObject).setIdentityColumn(true);
                return;
            }
        } else if (arrayList.size() > 1 && (designObject = this.getPK()) != null && ((ContainerObject)designObject).getElementsCollection().size() == 1) {
            for (Column column : arrayList) {
                if (!column.isPKElement()) continue;
                column.setIdentityColumn(true);
                return;
            }
        }
    }

    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }

    public List getPK_UKList() {
        ArrayList<Index> arrayList = new ArrayList<Index>();
        Index index = (Index)this.getPK();
        if (index != null) {
            arrayList.add(index);
        }
        Iterator iterator = this.getKeySet().iterator();
        while (iterator.hasNext()) {
            Index index2 = (Index)iterator.next();
            if (!index2.isUnique()) continue;
            arrayList.add(index2);
        }
        return arrayList;
    }

    public List getIndexes_Plain_List() {
        ArrayList<Index> arrayList = new ArrayList<Index>();
        Iterator iterator = this.getKeySet().iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            if (index.isUnique() || index.isPK() || index.isFK()) continue;
            arrayList.add(index);
        }
        return arrayList;
    }

    public class ColumnGroup {
        public static final String TYPE_NAME = "ColumnGroup";
        String name = "";
        String objectId = "";
        String note = "";
        List<String> columns = null;

        public ColumnGroup(String string) {
            this.name = string;
            this.columns = new ArrayList<String>();
            this.objectId = new GUID().toString();
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setObjectID(String string) {
            this.objectId = string;
        }

        public String getObjectID() {
            return this.objectId;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public void setNote(String string) {
            this.note = string;
        }

        public String getNote() {
            return this.note;
        }

        public String getColumnRefs() {
            if (this.columns.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = true;
                for (String string : this.columns) {
                    if (bl) {
                        stringBuffer.append(string);
                        bl = false;
                        continue;
                    }
                    stringBuffer.append(' ').append(string);
                }
                return stringBuffer.toString();
            }
            return "";
        }

        public void setColumnRefs(String string) {
            if (string != null) {
                this.columns.clear();
                String[] stringArray = string.split(" ");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.columns.add(stringArray[i]);
                }
            }
        }

        public void copy(ColumnGroup columnGroup, Map map) {
            columnGroup.setObjectID(this.getObjectID());
            columnGroup.setName(this.getName());
            columnGroup.setNote(this.getNote());
            columnGroup.getColumns().clear();
            if (map == null) {
                columnGroup.getColumns().addAll(this.getColumns());
            } else {
                List<String> list = columnGroup.getColumns();
                for (String string : this.getColumns()) {
                    Column column = (Column)map.get(string);
                    if (column == null) continue;
                    list.add(column.getObjectID());
                }
            }
        }

        public void copy(ColumnGroup columnGroup) {
            this.copy(columnGroup, null);
        }
    }

    public class DesignObjectPH_ShortName
    extends DesignObjectPlaceHolder {
        public DesignObjectPH_ShortName(DesignObject designObject) {
            super(designObject);
        }

        @Override
        public String toString() {
            return this.getDesignObject().getName();
        }
    }

    private class PendingFKAssociationRecreation {
        private String referencedTableId;
        private String referencedKeyId;
        private String referencedFKAssocId;
        private String deleteRule;
        private String name$;
        private String comments;
        private String notes;
        private String localIndexId = null;
        private String mandatory;
        private String transferable;

        PendingFKAssociationRecreation(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            this.referencedTableId = string;
            this.referencedKeyId = string2;
            this.referencedFKAssocId = string3;
            this.deleteRule = string4;
            this.name$ = string5;
            this.comments = string6;
            this.notes = string7;
        }

        PendingFKAssociationRecreation(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
            this(string, string2, string3, string5, string6, string7, string8);
            this.localIndexId = string4;
            this.mandatory = string9;
            this.transferable = string10;
        }

        public void resolve() {
            Table table = (Table)Table.this.getDesign().getDesignObject(this.referencedTableId);
            if (table != null) {
                Index index = (Index)table.getKeyObject(this.referencedKeyId);
                FKIndexAssociation fKIndexAssociation = Table.this.recreateFK(index, this.referencedFKAssocId, this.localIndexId, this.deleteRule, this.name$, this.comments, this.notes);
                if (this.mandatory != null && "true".equalsIgnoreCase(this.mandatory)) {
                    fKIndexAssociation.setMandatory(true);
                } else if ("".equals(this.mandatory)) {
                    fKIndexAssociation.resetMandatoryUsingColumns();
                } else {
                    fKIndexAssociation.setMandatory(false);
                }
                if (this.transferable != null && ("true".equalsIgnoreCase(this.transferable) || "".equals(this.transferable))) {
                    fKIndexAssociation.setTransferable(true);
                } else {
                    fKIndexAssociation.setTransferable(false);
                }
                fKIndexAssociation.resetEdgeParams();
                if (Table.this.pendingFKassociation != null) {
                    Table.this.removePending(this);
                }
            }
        }
    }
}

