/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.editor.relational.SchemaObjectPropertiesDialogEx;

public class SchemaObject
extends DesignObject
implements SetListener {
    public static final String TYPE_NAME = "SchemaObject";
    private String abbreviation = "";
    private ArrayList tables = new ArrayList();
    private ArrayList views = new ArrayList();
    private ArrayList indexes = new ArrayList();

    public SchemaObject(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("schema id prefix");
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SchemaObjectPropertiesDialogEx schemaObjectPropertiesDialogEx = new SchemaObjectPropertiesDialogEx(this.getDesign().getAppView(), this);
            schemaObjectPropertiesDialogEx.initProperties(this);
            schemaObjectPropertiesDialogEx.show();
        }
    }

    public ArrayList getTables() {
        if (this.tables == null) {
            this.tables = new ArrayList();
        }
        return this.tables;
    }

    public void setTables(ArrayList arrayList) {
        this.tables = arrayList;
    }

    public ArrayList getViews() {
        if (this.views == null) {
            this.views = new ArrayList();
        }
        return this.views;
    }

    public void setViews(ArrayList arrayList) {
        this.views = arrayList;
    }

    public ArrayList getIndexes() {
        if (this.indexes == null) {
            this.indexes = new ArrayList();
        }
        return this.indexes;
    }

    public void setIndexes(ArrayList arrayList) {
        this.indexes = arrayList;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (setEvent == SetEvent.OBJECT_ADDED || setEvent == SetEvent.OBJECT_REMOVED) {
            // empty if block
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "schema/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

