/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.DDLFileStamp;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SegmentNameManager;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.TypeSubstitutionSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.MeasurementSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.ColumnViewSet;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKArcSet;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.GlobalIndexSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelTypeSubstitutionSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesignFactory;
import oracle.dbtools.crest.model.design.storage.StorageDesignSet;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.undo.relational.ColumnRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKArcCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKArcRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.IndexRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.TableCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.TableRemoveEdit;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.relational.RelationalModelDialogEx;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RelationalDesign
extends DesignPart
implements SetListener,
ModelObjectSetListener {
    public static final String OBJECT_TYPE_NAME = "RelationalModel";
    public static final String TABLE_SET_NAME = Messages.getString("RelationalDesign.Tables");
    public static final String SCHEMA_SET_NAME = Messages.getString("RelationalDesign.Schemas");
    public static final String FK_SET_NAME = Messages.getString("RelationalDesign.ForeignKeys");
    public static final String TYPE_SUBSTITUTION_NAME = Messages.getString("RelationalDesign.TypeSubstitutions");
    public static final String INDEX_SET_NAME = Messages.getString("RelationalDesign.Indexes");
    public static final String COLUMN_SET_NAME = Messages.getString("RelationalDesign.Columns");
    public static final String COLUMN_VIEW_SET_NAME = Messages.getString("RelationalDesign.ColumnViews");
    public static final String VIEW_SET_NAME = Messages.getString("RelationalDesign.Views");
    public static final String NOTE_SET_NAME = Messages.getString("RelationalDesign.Notes");
    public static final String MEASUREMENT_SET_NAME = Messages.getString("RelationalDesign.Measurement");
    public static final String ARC_SET_NAME = Messages.getString("RelationalDesign.Arcs");
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    private TableSet tableSet;
    private ColumnSet columnSet;
    private ColumnViewSet columnViewSet;
    private TableViewSet viewSet;
    private FKIndexAssociationSet fkAssociationSet;
    private TypeSubstitutionSet typeSubstitutionSet;
    private DesignObjectCollection indexOnlySet;
    private StorageDesignFactory storageDesignFactory = null;
    private String rdbms = "db2v7.0";
    private RDBMSSite selectedRDBMSSite = null;
    private NoteSet noteSet;
    private MeasurementSet measurementSet;
    private FKArcSet arcSet;
    private SchemaObjectSet schemaObjectSet;
    private RelationalDesign importTo = null;
    private List<DBConnectionStamp> importConnectionStamps = new ArrayList<DBConnectionStamp>();
    private int importConnectionStampIndex = -1;
    private List<DDLFileStamp> importDDLFileStamps = new ArrayList<DDLFileStamp>();
    private int importDDLFileStampIndex = -1;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    private List namingOptionsHolderList;
    private boolean subviewToNewDesign = false;
    private RMExtendedMap extendedMap;
    private RelationalDesign relatedSyncModel;

    public boolean isSubviewToNewDesign() {
        return this.subviewToNewDesign;
    }

    public void setSubviewToNewDesign(boolean bl) {
        this.subviewToNewDesign = bl;
    }

    public RelationalDesign(Design design) {
        this.setDesign(design);
        this.getStorageDesignFactory().getSorageDesigns().setParent(this);
    }

    @Override
    public String getName() {
        if (super.getName() != null) {
            return super.getName();
        }
        return this.getConfiguration("namePhysDesign");
    }

    public TableSet getTableSet() {
        if (this.tableSet == null) {
            this.tableSet = new TableSet(this);
            this.tableSet.setDesign(this.getDesign());
            this.tableSet.setName(TABLE_SET_NAME);
            this.tableSet.addSetListener(this);
            this.tableSet.setParent(this);
        }
        return this.tableSet;
    }

    public SchemaObjectSet getSchemaObjectSet() {
        if (this.schemaObjectSet == null) {
            this.schemaObjectSet = new SchemaObjectSet(this);
            this.schemaObjectSet.setDesign(this.getDesign());
            this.schemaObjectSet.setName(SCHEMA_SET_NAME);
            this.schemaObjectSet.addSetListener(this);
            this.schemaObjectSet.setParent(this);
        }
        return this.schemaObjectSet;
    }

    public FKIndexAssociationSet getFKIndexAssociationSet() {
        if (this.fkAssociationSet == null) {
            this.fkAssociationSet = new FKIndexAssociationSet(this);
            this.fkAssociationSet.setDesign(this.getDesign());
            this.fkAssociationSet.setName(FK_SET_NAME);
            this.fkAssociationSet.setParent(this);
            this.fkAssociationSet.addSetListener(this);
        }
        return this.fkAssociationSet;
    }

    public TypeSubstitutionSet getTypeSubstitutionSet() {
        if (this.typeSubstitutionSet == null) {
            this.typeSubstitutionSet = new RelTypeSubstitutionSet(this);
            this.typeSubstitutionSet.setDesign(this.getDesign());
            this.typeSubstitutionSet.setName(TYPE_SUBSTITUTION_NAME);
            this.typeSubstitutionSet.setParent(this);
            this.typeSubstitutionSet.addSetListener(this);
        }
        return this.typeSubstitutionSet;
    }

    public TypeSubstitution createTypeSubstitution() {
        return this.getTypeSubstitutionSet().createTypeSubstitution(null);
    }

    public TypeSubstitution createTypeSubstitution(String string) {
        return this.getTypeSubstitutionSet().createTypeSubstitution(string);
    }

    public GlobalIndexSet getGlobalIndexSet() {
        return this.getTableSet().getGlobalIndexSet();
    }

    public DesignObjectCollection getIndexOnlyPlaceHolderSet() {
        if (this.indexOnlySet == null) {
            this.indexOnlySet = new DesignObjectCollection();
            this.indexOnlySet.setDesign(this.getDesign());
            this.indexOnlySet.setName(INDEX_SET_NAME);
            this.indexOnlySet.setElementDescriptor(IndexSet.class);
            this.indexOnlySet.setParent(this);
        }
        return this.indexOnlySet;
    }

    public ColumnSet getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new ColumnSet(this);
            this.columnSet.setDesign(this.getDesign());
            this.columnSet.setName(COLUMN_SET_NAME);
            this.columnSet.setParent(this);
            this.columnSet.addSetListener(this);
        }
        return this.columnSet;
    }

    public ColumnViewSet getColumnViewSet() {
        if (this.columnViewSet == null) {
            this.columnViewSet = new ColumnViewSet(this);
            this.columnViewSet.setDesign(this.getDesign());
            this.columnViewSet.setName(COLUMN_VIEW_SET_NAME);
            this.columnViewSet.setParent(this);
            this.columnViewSet.addSetListener(this);
        }
        return this.columnViewSet;
    }

    public TableViewSet getTableViewSet() {
        if (this.viewSet == null) {
            this.viewSet = new TableViewSet(this);
            this.viewSet.setDesign(this.getDesign());
            this.viewSet.setParent(this);
            this.viewSet.addSetListener(this);
            this.viewSet.setName(VIEW_SET_NAME);
        }
        return this.viewSet;
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (setEvent == SetEvent.OBJECT_ADDED) {
            this.fireAdded(setEvent.getAffected());
        } else if (setEvent == SetEvent.OBJECT_REMOVED) {
            this.fireRemoved(setEvent.getAffected());
        }
    }

    @Override
    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(NOTE_SET_NAME);
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public MeasurementSet getMeasurementSet() {
        if (this.measurementSet == null) {
            this.measurementSet = new MeasurementSet(this);
            this.measurementSet.setDesign(this.getDesign());
            this.measurementSet.setName(MEASUREMENT_SET_NAME);
            this.measurementSet.setParent(this);
            this.measurementSet.addSetListener(this);
        }
        return this.measurementSet;
    }

    public FKArcSet getArcSet() {
        if (this.arcSet == null) {
            this.arcSet = new FKArcSet(this);
            this.arcSet.setDesign(this.getDesign());
            this.arcSet.setName(ARC_SET_NAME);
            this.arcSet.setParent(this);
            this.arcSet.addSetListener(this);
        }
        return this.arcSet;
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.getType() == 1) {
            if (modelObjectSetEvent.getAffected() instanceof DesignObject) {
                DesignObject designObject = (DesignObject)modelObjectSetEvent.getAffected();
                this.fireAdded(designObject);
            }
        } else if (modelObjectSetEvent.getType() == 0 && modelObjectSetEvent.getAffected() instanceof DesignObject) {
            DesignObject designObject = (DesignObject)modelObjectSetEvent.getAffected();
            this.fireRemoved(designObject);
        }
    }

    public Table createTable() {
        return this.getTableSet().createTable(null);
    }

    public Table createTable(String string) {
        Table table = this.createTable();
        table.setName(string);
        return table;
    }

    public FKIndexAssociation createForeignKey() {
        FKIndexAssociation fKIndexAssociation = new FKIndexAssociation(this);
        return fKIndexAssociation;
    }

    public TableView createTableView() {
        return this.getTableViewSet().createTableView(null);
    }

    public TableView createTableView(String string) {
        TableView tableView = this.createTableView();
        tableView.setName(string);
        return tableView;
    }

    public SchemaObject createSchemaObject() {
        return this.getSchemaObjectSet().createSchemaObject(null);
    }

    public SchemaObject createSchemaObject(String string) {
        SchemaObject schemaObject = this.createSchemaObject();
        schemaObject.setName(string);
        return schemaObject;
    }

    public Table recreateTable(String string) {
        return this.getTableSet().createTable(string);
    }

    @Override
    public Note createNote() {
        Note note = this.getNoteSet().createNote(null);
        return note;
    }

    @Override
    public Note recreateNote(String string) {
        return this.getNoteSet().createNote(string);
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList arrayList = new ArrayList();
        this.getSchemaObjectSet().addAllElementsTo(arrayList);
        this.getTableSet().addAllElementsTo(arrayList);
        this.getTableViewSet().addAllElementsTo(arrayList);
        this.getFKIndexAssociationSet().addAllElementsTo(arrayList);
        this.getArcSet().addAllElementsTo(arrayList);
        this.getNoteSet().addAllElementsTo(arrayList);
        this.getLabelSet().addAllElementsTo(arrayList);
        this.getDiagramViewSet().addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    public void clearAll() {
        StorageDesign[] storageDesignArray = this.getStorageDesignFactory().getOpenStorageDesigns();
        for (int i = 0; i < storageDesignArray.length; ++i) {
            storageDesignArray[i].close();
        }
        this.getTableViewSet().removeAll();
        this.getTypeSubstitutionSet().removeAll();
        this.getFKIndexAssociationSet().removeAll();
        this.getTableSet().removeAll();
        this.getColumnSet().removeAll();
        this.getColumnViewSet().removeAll();
        this.getIndexOnlyPlaceHolderSet().removeAll();
        this.getArcSet().removeAll();
        this.getNoteSet().removeAll();
        this.getLabelSet().removeAll();
        this.getDiagramViewSet().removeAll();
        this.getSchemaObjectSet().removeAll();
        this.clearMappings();
        this.clearDocuments();
        this.clearResponsibleParties();
        this.setComment("");
        this.setNotes("");
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    public void sortCollections() {
        this.getTableSet().sort();
        this.getColumnSet().sort();
        this.getColumnViewSet().sort();
        this.getTableViewSet().sort();
        this.getFKIndexAssociationSet().sort();
        this.getSchemaObjectSet().sort();
        this.getPhysicalDesignSubviews().sort();
        Iterator iterator = this.getPhysicalDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
            designPartView.sortCollections();
        }
    }

    @Override
    public int getNumberOfChildren() {
        if (this.isLoaded()) {
            if (this.getMainView().canCreateDisplays()) {
                return 7;
            }
            return 6;
        }
        return 0;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.getTableSet();
            }
            case 1: {
                return this.getTableViewSet();
            }
            case 2: {
                return this.getFKIndexAssociationSet();
            }
            case 3: {
                return this.getSchemaObjectSet();
            }
            case 4: {
                return this.subViews;
            }
            case 5: {
                return this.getStorageDesignFactory().getSorageDesigns();
            }
            case 6: {
                return this.getMainView().getDisplays();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.getTableSet()) {
            return 0;
        }
        if (modelObject == this.getTableViewSet()) {
            return 1;
        }
        if (modelObject == this.getFKIndexAssociationSet()) {
            return 2;
        }
        if (modelObject == this.getSchemaObjectSet()) {
            return 3;
        }
        if (modelObject == this.subViews) {
            return 4;
        }
        if (modelObject == this.getStorageDesignFactory().getSorageDesigns()) {
            return 5;
        }
        if (modelObject == this.getMainView().getDisplays()) {
            return 6;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public StorageDesignFactory getStorageDesignFactory() {
        if (this.storageDesignFactory == null) {
            this.storageDesignFactory = new StorageDesignFactory(this);
        }
        return this.storageDesignFactory;
    }

    public String getRDBMS() {
        return this.rdbms;
    }

    public void setRDBMS(String string) {
        this.rdbms = string;
    }

    public StorageDesign getStorageDesign(RDBMSSite rDBMSSite) {
        StorageDesign storageDesign = this.getStorageDesignFactory().getStorageDesign(rDBMSSite);
        return storageDesign;
    }

    public StorageDesign getStorageDesign() {
        return this.getStorageDesign(this.getSelectedRDBMSSite());
    }

    public void setSelectedRDBMSSite(RDBMSSite rDBMSSite) {
        this.selectedRDBMSSite = rDBMSSite;
    }

    public void closeStorageDesigns() {
        StorageDesign[] storageDesignArray = this.getStorageDesignFactory().getOpenStorageDesigns();
        for (int i = 0; i < storageDesignArray.length; ++i) {
            StorageDesign storageDesign = storageDesignArray[i];
            storageDesign.close();
        }
        this.setSelectedRDBMSSite(null);
        this.getDesign().getAppView().getPersistenceManager().readSystemInit(this.getDesign());
        System.gc();
    }

    @Override
    public RDBMSSite getSelectedRDBMSSite() {
        if (this.selectedRDBMSSite == null) {
            this.selectedRDBMSSite = this.getDesign().getRDBMSSiteSet().getDefaultRDBMSSite(this.getDesign().getAppView().getSettings());
        }
        return this.selectedRDBMSSite;
    }

    @Override
    protected DesignPartView createDesignPartSubView(String string) {
        DPVRelationalSubView dPVRelationalSubView = new DPVRelationalSubView(this.getDesign().getAppView(), this);
        string = this.getNameVersion(this.subViews, string);
        dPVRelationalSubView.setName(string);
        DesignPartViewPlaceHolder designPartViewPlaceHolder = new DesignPartViewPlaceHolder((DesignPart)this, dPVRelationalSubView);
        designPartViewPlaceHolder.setParent(this.subViews);
        this.subViews.add(designPartViewPlaceHolder);
        return dPVRelationalSubView;
    }

    public SubViewObjectSet getPhysicalDesignSubviews() {
        return this.subViews;
    }

    public void clearPhysicalDesign() {
        this.clearDesignPart();
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVRelational(this.getDesign().getAppView(), this);
            this.mainView.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
        }
        return this.mainView;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "RelDesign";
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> arrayList = new ArrayList<DesignObjectSet>();
        arrayList.add(this.getSchemaObjectSet());
        arrayList.add(this.getTableSet());
        arrayList.add(this.getTableViewSet());
        arrayList.add(this.getFKIndexAssociationSet());
        arrayList.add(this.getArcSet());
        arrayList.add(this.getNoteSet());
        return arrayList;
    }

    @Override
    public void doAfterLoad() {
        this.getDesign().setRelationalDesign(this);
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
        boolean bl = this.fixFKColums();
        this.setViewListeners();
    }

    public boolean fixFKColums() {
        boolean bl = false;
        try {
            Iterator iterator = this.getColumnSet().iterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                Object[] objectArray = column.getRefColAndAssocIDs().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    DesignObject designObject;
                    Column.FKColRefNode fKColRefNode = (Column.FKColRefNode)objectArray[i];
                    if (fKColRefNode.fkAssocId == null || (designObject = column.getDesign().getDesignObject(fKColRefNode.fkAssocId)) != null) continue;
                    column.removeFKAssociation(fKColRefNode.fkAssocId);
                    column.setDirty(true);
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public void load() {
        this.getDesign().setRelationalDesign(this);
        XMLPersistenceManager xMLPersistenceManager = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader abstractXMLReader = xMLPersistenceManager.getDesignPartReader(this);
        if (abstractXMLReader != null) {
            if (this.getDesign().getLoadedVersion() < 3.2f) {
                abstractXMLReader.recreateDesign(this.getObjectID(), (DesignPart)this, false);
            } else {
                abstractXMLReader.recreateDesign(this.getPathIDString(), (DesignPart)this, false);
            }
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void doAfterSave() {
        super.doAfterSave();
        this.getDesign().addToLocalLoadedRemovableDesignParts(this);
    }

    public RelationalDesign getImportTo() {
        return this.importTo;
    }

    public void setImportTo(RelationalDesign relationalDesign) {
        this.importTo = relationalDesign;
    }

    public List<DBConnectionStamp> getImportConnectionStamps() {
        return this.importConnectionStamps;
    }

    public void setImportConnectionStamps(List<DBConnectionStamp> list) {
        this.importConnectionStamps = list;
    }

    public DBConnectionStamp createImportConnectionStamp() {
        DBConnectionStamp dBConnectionStamp = new DBConnectionStamp();
        this.importConnectionStamps.add(dBConnectionStamp);
        return dBConnectionStamp;
    }

    public DBConnectionStamp getImportConnectionStamp(int n) {
        if (!this.importConnectionStamps.isEmpty() && n != -1 && n < this.importConnectionStamps.size()) {
            return this.importConnectionStamps.get(n);
        }
        return null;
    }

    public int findImportConnectionStamp(String string) {
        for (int i = 0; i < this.importConnectionStamps.size(); ++i) {
            DBConnectionStamp dBConnectionStamp = this.importConnectionStamps.get(i);
            if (!string.equals(dBConnectionStamp.getConnName())) continue;
            return i;
        }
        return -1;
    }

    public int addImportConnectionStamp(DBConnectionStamp dBConnectionStamp) {
        int n = this.findImportConnectionStamp(dBConnectionStamp.getConnName());
        if (n == -1) {
            this.importConnectionStamps.add(dBConnectionStamp);
            n = this.importConnectionStamps.size() - 1;
            this.setDirty(true);
        }
        return n;
    }

    public int getImportConnectionStampIndex() {
        return this.importConnectionStampIndex;
    }

    public void setImportConnectionStampIndex(int n) {
        this.importConnectionStampIndex = n;
    }

    public boolean isSameDB(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        DBConnectionStamp dBConnectionStamp = this.getImportConnectionStamp(this.findImportConnectionStamp(string));
        DBConnectionStamp dBConnectionStamp2 = this.getImportConnectionStamp(this.findImportConnectionStamp(string2));
        if (dBConnectionStamp != null) {
            return dBConnectionStamp.isSameDB(dBConnectionStamp2);
        }
        return false;
    }

    public List<DDLFileStamp> getImportDDLFileStamps() {
        return this.importDDLFileStamps;
    }

    public void setImportDDLFileStamps(List<DDLFileStamp> list) {
        this.importDDLFileStamps = list;
    }

    public DDLFileStamp createImportDDLFileStamp() {
        DDLFileStamp dDLFileStamp = new DDLFileStamp();
        this.importDDLFileStamps.add(dDLFileStamp);
        return dDLFileStamp;
    }

    public DDLFileStamp getImportDDLFileStamp(int n) {
        return this.importDDLFileStamps.get(n);
    }

    public int findImportDDLFileStamp(String string) {
        for (int i = 0; i < this.importDDLFileStamps.size(); ++i) {
            DDLFileStamp dDLFileStamp = this.importDDLFileStamps.get(i);
            if (!string.equals(dDLFileStamp.getFileName())) continue;
            return i;
        }
        return -1;
    }

    public int addImportDDLFileStamp(DDLFileStamp dDLFileStamp) {
        int n = this.findImportDDLFileStamp(dDLFileStamp.getFileName());
        if (n == -1) {
            this.importDDLFileStamps.add(dDLFileStamp);
            n = this.importDDLFileStamps.size() - 1;
            this.setDirty(true);
        }
        return n;
    }

    public void removeImportDDLFileStamp(DDLFileStamp dDLFileStamp) {
        int n = this.findImportDDLFileStamp(dDLFileStamp.getFileName());
        if (n != -1) {
            this.importDDLFileStamps.remove(n);
            this.setDirty(true);
        }
    }

    public int getImportDDLFileStampIndex() {
        return this.importDDLFileStampIndex;
    }

    public void setImportDDLFileStampIndex(int n) {
        this.importDDLFileStampIndex = n;
    }

    public void stampModelObjectDDL(ModelObject modelObject) {
        if ("".equals(modelObject.getSourceDDLFile()) && this.importDDLFileStampIndex > -1) {
            DDLFileStamp dDLFileStamp = this.getImportDDLFileStamp(this.importDDLFileStampIndex);
            modelObject.setSourceDDLFile(dDLFileStamp.getFileName());
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.getTableSet().size() != 0) {
            return false;
        }
        if (this.getColumnSet().size() != 0) {
            return false;
        }
        if (this.getColumnViewSet().size() != 0) {
            return false;
        }
        if (this.getTableViewSet().size() != 0) {
            return false;
        }
        if (this.getFKIndexAssociationSet().size() != 0) {
            return false;
        }
        if (this.getGlobalIndexSet().size() != 0) {
            return false;
        }
        if (this.getNoteSet().size() != 0) {
            return false;
        }
        if (this.getDiagramViewSet().size() != 0) {
            return false;
        }
        if (this.getStorageDesignFactory().getSorageDesigns().size() != 0) {
            return false;
        }
        return this.getSchemaObjectSet().size() == 0;
    }

    @Override
    public void setLoaded(boolean bl) {
        super.setLoaded(bl);
        Iterator iterator = this.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            table.updateStructure();
        }
    }

    public void rearrangeTables() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        TableSet tableSet = this.getTableSet();
        if (tableSet.size() > 0) {
            Iterator iterator = tableSet.iterator();
            float f = (float)Math.sqrt(tableSet.size());
            long l = (int)f;
            if (Math.sqrt(f * f) != (double)f) {
                ++l;
            }
            ++l;
            while (iterator.hasNext()) {
                Dimension dimension;
                Table table = (Table)iterator.next();
                TopView topView = table.getTopView();
                if (topView == null) continue;
                ++this.count;
                if (topView.getCellView() != null) {
                    dimension = this.getTableSize(table);
                    this.width = dimension.width;
                    this.height = Math.max(dimension.height, this.height);
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
                } else {
                    dimension = this.getTableSize(table);
                    this.width = dimension.width;
                    this.height = Math.max(dimension.height, this.height);
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != l) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
                this.height = 25;
            }
        }
    }

    public void rearrangeTables(List list, Point point) {
        this.left = point.x;
        this.top = point.y;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            float f = (float)Math.sqrt(list.size());
            long l = (int)f;
            if (Math.sqrt(f * f) != (double)f) {
                ++l;
            }
            ++l;
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                TopView topView = table.getFirstViewForDPV(this.getAppView().getCurrentDPV());
                if (topView == null) {
                    topView = table.getTopView();
                }
                if (topView == null) continue;
                ++this.count;
                if (topView.getCellView() != null) {
                    Dimension dimension = this.getTableSize(table);
                    this.width = dimension.width;
                    this.height = Math.max(dimension.height, this.height);
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != l) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
                this.height = 25;
            }
            point.x = this.left;
            point.y = this.top;
        }
    }

    public Dimension getTableSize(Table table) {
        int n;
        int n2 = 35;
        int n3 = 25;
        int n4 = 0;
        StructuredType structuredType = null;
        if (table.isBST() && table.getTypeSubstitution() != null) {
            structuredType = table.getBasedOnStructuredType();
            if (structuredType != null) {
                n4 = structuredType.getElements().length;
            }
        } else {
            n4 = table.getElements().length;
        }
        n3 += n4 * 14;
        if (table.getKeys().length > 0 && !this.allKeysAreFK(table.getKeys())) {
            n3 += 4;
            for (n = 0; n < table.getKeys().length; ++n) {
                if (table.getKeys()[n].isFK()) continue;
                n3 += 14;
            }
        }
        n = table.getName().length() * 6;
        int n5 = 1;
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7;
            DesignObject designObject;
            if (structuredType != null) {
                designObject = structuredType.getElements()[i];
                n7 = designObject.getName().length() * 7;
                n6 = ((TypeElement)designObject).getDataType().length() * 7;
                n = Math.max(n7, n);
                n5 = Math.max(n6, n5);
                continue;
            }
            designObject = (ContainedObjectWithDomain)table.getElement(i);
            n7 = ((ContainedObject)designObject).getName().length() * 7;
            n6 = ((ContainedObjectWithDomain)designObject).getDataType().toString().length() * 7 + 20;
            n = Math.max(n7, n);
            n5 = Math.max(n6, n5);
        }
        if (n == 1) {
            n = table.getName().length() * 7;
        }
        return new Dimension(n2 + n + n5, n3);
    }

    private boolean allKeysAreFK(KeyObject[] keyObjectArray) {
        boolean bl = true;
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (keyObjectArray[i].isFK()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void rearrangeViews() {
        if (this.left > 20) {
            this.left = 20;
            this.top = this.top + this.height + 50;
        }
        this.width = 35;
        this.height = 25;
        TableViewSet tableViewSet = this.getTableViewSet();
        if (tableViewSet.size() > 0) {
            Iterator iterator = tableViewSet.iterator();
            float f = (float)Math.sqrt(tableViewSet.size());
            long l = (int)f;
            if (Math.sqrt(f * f) != (double)f) {
                ++l;
            }
            while (iterator.hasNext()) {
                Dimension dimension;
                TableView tableView = (TableView)iterator.next();
                TopView topView = tableView.getFirstViewForDPV(this.getAppView().getCurrentDPV());
                if (topView == null) {
                    topView = tableView.getTopView();
                }
                if (topView == null) continue;
                ++this.count;
                if (topView.getCellView() != null) {
                    dimension = this.getTableViewSize(tableView);
                    this.width = dimension.width;
                    this.height = Math.max(dimension.height, this.height);
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
                } else {
                    dimension = this.getTableViewSize(tableView);
                    this.width = dimension.width;
                    this.height = Math.max(dimension.height, this.height);
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != l) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
            }
        }
    }

    public void rearrangeViews(List list, Point point) {
        this.left = point.x;
        this.top = point.y;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            float f = (float)Math.sqrt(list.size());
            long l = (int)f;
            if (Math.sqrt(f * f) != (double)f) {
                ++l;
            }
            while (iterator.hasNext()) {
                TableView tableView = (TableView)iterator.next();
                TopView topView = tableView.getTopView();
                if (topView == null) continue;
                ++this.count;
                if (topView.getCellView() != null) {
                    Dimension dimension = this.getTableViewSize(tableView);
                    this.width = dimension.width;
                    this.height = Math.max(dimension.height, this.height);
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != l) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
            }
        }
    }

    public List getDropableSets() {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        arrayList.add(this.getTableSet());
        arrayList.add(this.getIndexOnlyPlaceHolderSet());
        arrayList.add(this.getTableViewSet());
        arrayList.add(this.getFKIndexAssociationSet());
        return arrayList;
    }

    public Dimension getTableViewSize(TableView tableView) {
        int n = 60;
        int n2 = 40;
        int n3 = 0;
        StructuredType structuredType = null;
        if (tableView.isBST() && tableView.getTypeSubstitution() != null) {
            structuredType = tableView.getBasedOnStructuredType();
            if (structuredType != null) {
                n3 = structuredType.getElements().length;
            }
        } else {
            n3 = tableView.getElements().length;
        }
        n2 += n3 * 14;
        int n4 = tableView.getName().length() * 6;
        int n5 = 1;
        for (int i = 0; i < n3; ++i) {
            int n6;
            if (structuredType != null) {
                TypeElement typeElement = structuredType.getElements()[i];
                int n7 = typeElement.getName().length() * 7;
                n6 = typeElement.getDataType().length() * 7;
                n4 = Math.max(n7, n4);
                n5 = Math.max(n6, n5);
                continue;
            }
            if (tableView.getColumns()[i] instanceof ColumnView) {
                ColumnView columnView = (ColumnView)tableView.getColumns()[i];
                String string = columnView.getAlias();
                if ("".equalsIgnoreCase(string)) {
                    string = columnView.getName();
                }
                n6 = string.length() * 7;
                int n8 = columnView.getDataType().length() * 7 + 10;
                n4 = Math.max(n6, n4);
                n5 = Math.max(n8, n5);
                continue;
            }
            int n9 = tableView.getColumns()[i].getName().length() * 7;
            n4 = Math.max(n9, n4);
        }
        if (n4 > 250) {
            n4 = 250;
        }
        return new Dimension(n + n4 + n5, n2);
    }

    @Override
    public boolean canCreateDPSubview() {
        return true;
    }

    public void updateFKViews() {
        Iterator iterator = this.getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            for (TVFKRelation tVFKRelation : fKIndexAssociation.getAllTVRelations()) {
                tVFKRelation.resetEdgeParams(false);
            }
        }
    }

    public boolean hasUsageOfStructuredType(StructuredType structuredType) {
        if (structuredType != null) {
            ContainerObject containerObject;
            Iterator iterator = this.getTableSet().iterator();
            while (iterator.hasNext()) {
                containerObject = (Table)iterator.next();
                if (containerObject.getBasedOnStructuredType() != structuredType) continue;
                return true;
            }
            iterator = this.getTableViewSet().iterator();
            while (iterator.hasNext()) {
                containerObject = (TableView)iterator.next();
                if (containerObject.getBasedOnStructuredType() != structuredType) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTableColumnsToFile(String string) throws IOException {
        File file = new File(string);
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            throw new RuntimeException(MessageFormat.format(Messages.getString("RelationalDesign.FileCanNotBeCreated"), string));
        }
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            Iterator iterator = this.getTableSet().iterator();
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                Column[] columnArray = (Column[])table.getElements();
                for (int i = 0; i < columnArray.length; ++i) {
                    int n;
                    Column column = columnArray[i];
                    String string2 = column.getDatatypeString("DB2/390 8");
                    String string3 = "N";
                    String string4 = column.getSize();
                    String string5 = column.getPrecision();
                    String string6 = column.getScale();
                    if (column.getNullsAllowed()) {
                        string3 = "Y";
                    }
                    if ((n = string2.indexOf(40)) > -1) {
                        string2 = string2.substring(0, n);
                    }
                    String string7 = table.getName().toUpperCase() + "|" + column.getName().toUpperCase() + "|" + string2.toUpperCase() + "|" + string4 + "|" + string5 + "|" + string6 + "|" + string3 + "|" + i + "|" + "\n";
                    writer.write(string7);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void updateFontsAndColors(boolean bl) {
        Object object;
        Iterator iterator = this.getTableSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getTableViewSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getNoteSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getLabelSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
        iterator = this.getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            object = (DesignObject)iterator.next();
            if (bl) {
                ((DesignObject)object).setBackgroundColor(null);
            } else if (((DesignObject)object).getBackgroundColor() == null) {
                ((DesignObject)object).setBackgroundColor(((DesignObject)object).getTopView().getDefaultLineColor());
            }
            ((DesignObject)object).setUseDefaultColor(bl);
        }
        iterator = this.getLabelSet().iterator();
        while (iterator.hasNext()) {
            object = (EditableFonts)iterator.next();
            object.resetFontsAndColors(bl);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RelationalModelDialogEx relationalModelDialogEx = new RelationalModelDialogEx(this.getDesign().getAppView(), this);
            relationalModelDialogEx.initProperties(this);
            relationalModelDialogEx.show();
        }
    }

    @Override
    public List getNamingOptionsHolderList() {
        if (this.namingOptionsHolderList == null) {
            int[] nArray = this.getDefaultMaxNameLengths();
            this.namingOptionsHolderList = new ArrayList();
            this.namingOptionsHolderList.add(new NamingOptionsHolder(Table.class, nArray[0]));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(Column.class, nArray[1]));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(TableView.class, nArray[2]));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(TableLevelConstraint.class, nArray[3]));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(FKIndexAssociation.class, nArray[3]));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(Index.class, nArray[4]));
        }
        return this.namingOptionsHolderList;
    }

    private int[] getDefaultMaxNameLengths() {
        int[] nArray = new int[]{18, 18, 18, 18, 18};
        RDBMSType rDBMSType = this.getSelectedRDBMSType();
        if (rDBMSType != null) {
            if (rDBMSType.equals(StorageDesignDB2v70.RDBMS_TYPE)) {
                nArray[0] = 18;
                nArray[1] = 18;
                nArray[2] = 18;
                nArray[3] = 18;
                nArray[4] = 18;
            } else if (rDBMSType.equals(StorageDesignDB2v80.RDBMS_TYPE)) {
                nArray[0] = 128;
                nArray[1] = 30;
                nArray[2] = 128;
                nArray[3] = 30;
                nArray[4] = 30;
            } else if (rDBMSType.equals(StorageDesignOraclev9i.RDBMS_TYPE)) {
                nArray[0] = 30;
                nArray[1] = 30;
                nArray[2] = 30;
                nArray[3] = 30;
                nArray[4] = 30;
            } else if (rDBMSType.equals(StorageDesignOraclev10g.RDBMS_TYPE)) {
                nArray[0] = 30;
                nArray[1] = 30;
                nArray[2] = 30;
                nArray[3] = 30;
                nArray[4] = 30;
            } else if (rDBMSType.equals(StorageDesignOraclev11g.RDBMS_TYPE)) {
                nArray[0] = 30;
                nArray[1] = 30;
                nArray[2] = 30;
                nArray[3] = 30;
                nArray[4] = 30;
            } else if (rDBMSType.equals(StorageDesignSqlServerv2k.RDBMS_TYPE)) {
                nArray[0] = 128;
                nArray[1] = 128;
                nArray[2] = 128;
                nArray[3] = 128;
                nArray[4] = 128;
            } else if (rDBMSType.equals(StorageDesignSqlServerv2k5.RDBMS_TYPE)) {
                nArray[0] = 128;
                nArray[1] = 128;
                nArray[2] = 128;
                nArray[3] = 128;
                nArray[4] = 128;
            } else if (rDBMSType.equals(StorageDesignUDBv71.RDBMS_TYPE)) {
                nArray[0] = 128;
                nArray[1] = 30;
                nArray[2] = 128;
                nArray[3] = 128;
                nArray[4] = 128;
            } else if (rDBMSType.equals(StorageDesignUDBv81.RDBMS_TYPE)) {
                nArray[0] = 128;
                nArray[1] = 128;
                nArray[2] = 128;
                nArray[3] = 128;
                nArray[4] = 128;
            }
        }
        return nArray;
    }

    @Override
    public void clearDesignPart() {
        super.clearDesignPart();
        this.removeDesignPartListener(this.getMainView());
        this.getDesign().removeDesignPartView(this.getMainView());
        this.getRMExtendedMap().clearMappings();
        this.removeDesignPartListener(this.getRMExtendedMap());
    }

    private List getSelectedTables(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof Table)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    private List getSelectedFKeys(Object[] objectArray, Table table) {
        ArrayList<FKIndexAssociation> arrayList = new ArrayList<FKIndexAssociation>();
        for (int i = 0; i < objectArray.length; ++i) {
            FKIndexAssociation fKIndexAssociation;
            Object object = objectArray[i];
            if (!(object instanceof FKIndexAssociation) || (fKIndexAssociation = (FKIndexAssociation)object).getContainerWithKeyObject() != table) continue;
            arrayList.add(fKIndexAssociation);
        }
        return arrayList;
    }

    private List getSelectedFKeys(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof FKIndexAssociation)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public boolean canCreateArc(Object[] objectArray) {
        Table table;
        List list;
        List list2 = this.getSelectedTables(objectArray);
        List list3 = this.getSelectedFKeys(objectArray);
        if (list2.size() == 0 && list3.size() > 0) {
            list2.add(((FKIndexAssociation)list3.get(0)).getContainerWithKeyObject());
        }
        if (list2.size() == 1 && (list = this.getSelectedFKeys(objectArray, table = (Table)list2.get(0))).size() > 1 && list.size() == list3.size()) {
            for (FKIndexAssociation fKIndexAssociation : list) {
                if (!table.inArc(fKIndexAssociation)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canRemoveFromArc(Object[] objectArray) {
        List list = this.getSelectedArcs(objectArray);
        if (list.size() == 1) {
            FKArc fKArc = (FKArc)list.get(0);
            List list2 = this.getSelectedFKeys(objectArray, fKArc.getTable());
            List list3 = this.getSelectedFKeys(objectArray);
            if (list2.size() == list3.size()) {
                for (FKIndexAssociation fKIndexAssociation : list2) {
                    if (fKArc.containsFKey(fKIndexAssociation)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private List getSelectedArcs(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof FKArc)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public boolean canAddToArc(Object[] objectArray) {
        List list = this.getSelectedArcs(objectArray);
        if (list.size() == 1) {
            FKArc fKArc = (FKArc)list.get(0);
            List list2 = this.getSelectedFKeys(objectArray, fKArc.getTable());
            List list3 = this.getSelectedFKeys(objectArray);
            if (list2.size() == list3.size()) {
                for (FKIndexAssociation fKIndexAssociation : list2) {
                    if (!fKArc.getTable().inArc(fKIndexAssociation)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public FKArc createArc() {
        return this.getArcSet().createArc(null);
    }

    public FKArc createArc(String string) {
        FKArc fKArc = this.getArcSet().createArc(null);
        fKArc.setName(string);
        return fKArc;
    }

    public FKArc recreateArc(String string) {
        return this.getArcSet().createArc(string);
    }

    public FKArc createArc(Object[] objectArray) {
        Table table;
        List list;
        ApplicationView.log(Messages.getString("RelationalDesign.CreateArc"));
        List list2 = this.getSelectedTables(objectArray);
        List list3 = this.getSelectedFKeys(objectArray);
        if (list2.size() == 0 && list3.size() > 0) {
            list2.add(((FKIndexAssociation)list3.get(0)).getContainerWithKeyObject());
        }
        if (list2.size() == 1 && (list = this.getSelectedFKeys(objectArray, table = (Table)list2.get(0))).size() > 1 && list.size() == list3.size()) {
            FKArc fKArc = this.createArc();
            table.addArc(fKArc);
            for (FKIndexAssociation fKIndexAssociation : list) {
                fKArc.addFkey(fKIndexAssociation);
            }
            return fKArc;
        }
        return null;
    }

    public void addToArc(Object[] objectArray) {
        List list = this.getSelectedArcs(objectArray);
        if (list.size() == 1) {
            FKArc fKArc = (FKArc)list.get(0);
            List list2 = this.getSelectedFKeys(objectArray, fKArc.getTable());
            for (FKIndexAssociation fKIndexAssociation : list2) {
                if (fKArc.getTable().inArc(fKIndexAssociation)) continue;
                fKArc.addFkey(fKIndexAssociation);
            }
            fKArc.setDirty(true);
            this.getMainView().getWorkSpace().updateUI();
        }
    }

    public void removeFromArc(Object[] objectArray) {
        List list = this.getSelectedArcs(objectArray);
        if (list.size() == 1) {
            FKArc fKArc = (FKArc)list.get(0);
            List list2 = this.getSelectedFKeys(objectArray, fKArc.getTable());
            for (FKIndexAssociation fKIndexAssociation : list2) {
                if (!fKArc.containsFKey(fKIndexAssociation)) continue;
                fKArc.removeFkey(fKIndexAssociation);
            }
            fKArc.setDirty(true);
            if (fKArc.getFkeys().size() <= 1) {
                fKArc.remove();
            }
            this.getMainView().getWorkSpace().updateUI();
        }
    }

    public void postTableCreateEdit(Table table) {
        TableCreateEdit tableCreateEdit = new TableCreateEdit(table);
        tableCreateEdit.end();
        this.postUndoableEdit(tableCreateEdit);
    }

    public void postTableRemoveEdit(Table table) {
        TableRemoveEdit tableRemoveEdit = new TableRemoveEdit(table);
        tableRemoveEdit.end();
        this.postUndoableEdit(tableRemoveEdit);
    }

    public void postFKRemoveEdit(FKIndexAssociation fKIndexAssociation) {
        FKRemoveEdit fKRemoveEdit = new FKRemoveEdit(fKIndexAssociation);
        fKRemoveEdit.end();
        this.postUndoableEdit(fKRemoveEdit);
    }

    public void postFKCreateEdit(FKIndexAssociation fKIndexAssociation) {
        FKCreateEdit fKCreateEdit = new FKCreateEdit(fKIndexAssociation);
        fKCreateEdit.end();
        this.postUndoableEdit(fKCreateEdit);
    }

    public void postFKArcCreateEdit(FKArc fKArc) {
        FKArcCreateEdit fKArcCreateEdit = new FKArcCreateEdit(fKArc);
        fKArcCreateEdit.end();
        this.postUndoableEdit(fKArcCreateEdit);
    }

    public void postFKArcRemoveEdit(FKArc fKArc) {
        FKArcRemoveEdit fKArcRemoveEdit = new FKArcRemoveEdit(fKArc);
        fKArcRemoveEdit.end();
        this.postUndoableEdit(fKArcRemoveEdit);
    }

    @Override
    public void postUndoableRemoveEditForObject(DesignObject designObject) {
        super.postUndoableRemoveEditForObject(designObject);
        if (designObject instanceof Table) {
            this.postTableRemoveEdit((Table)designObject);
        } else if (designObject instanceof FKIndexAssociation) {
            this.postFKRemoveEdit((FKIndexAssociation)designObject);
        } else if (designObject instanceof FKArc) {
            this.postFKArcRemoveEdit((FKArc)designObject);
        } else if (designObject instanceof Column) {
            this.postColumnRemoveEdit((Column)designObject);
        } else if (designObject instanceof Index) {
            this.postIndexRemoveEdit((Index)designObject);
        }
    }

    public void postColumnRemoveEdit(Column column) {
        ColumnRemoveEdit columnRemoveEdit = new ColumnRemoveEdit(column);
        columnRemoveEdit.end();
        this.postUndoableEdit(columnRemoveEdit);
    }

    public void postIndexRemoveEdit(Index index) {
        IndexRemoveEdit indexRemoveEdit = new IndexRemoveEdit(index);
        indexRemoveEdit.end();
        this.postUndoableEdit(indexRemoveEdit);
    }

    public void createSubviewsOnSchema(StorageDesign storageDesign) {
        List<DesignObject> list;
        Object object;
        Object object2;
        Object object3;
        Object object42;
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        TreeMap treeMap = new TreeMap();
        Iterator iterator = storageDesign.getTableProxySet().iterator();
        while (iterator.hasNext()) {
            object42 = (TableProxy)iterator.next();
            object3 = ((TableProxy)object42).getUserSchema();
            if (object3 != null) {
                object2 = ((StorageObject)object3).getName();
                object = (List)treeMap.get(object2);
                if (object == null) {
                    object = new ArrayList<DesignObject>();
                    treeMap.put(object2, object);
                }
                object.add(((RelationalObjectProxy)object42).getObject());
                continue;
            }
            object2 = ((Table)((RelationalObjectProxy)object42).getObject()).getSchemaObject();
            if (object2 != null) {
                object = ((DesignObject)object2).getName();
                list = (ArrayList<DesignObject>)treeMap.get(object);
                if (list == null) {
                    list = new ArrayList<DesignObject>();
                    treeMap.put(object, list);
                }
                list.add(((RelationalObjectProxy)object42).getObject());
                continue;
            }
            arrayList.add(((RelationalObjectProxy)object42).getObject());
        }
        iterator = storageDesign.getTableViewProxySet().iterator();
        while (iterator.hasNext()) {
            object42 = (TableViewProxy)iterator.next();
            object3 = ((TableViewProxy)object42).getUserSchema();
            if (object3 != null) {
                object2 = ((StorageObject)object3).getName();
                object = (List)treeMap.get(object2);
                if (object == null) {
                    object = new ArrayList<DesignObject>();
                    treeMap.put(object2, object);
                }
                object.add(((RelationalObjectProxy)object42).getObject());
                continue;
            }
            object2 = ((TableView)((RelationalObjectProxy)object42).getObject()).getSchemaObject();
            if (object2 != null) {
                object = ((DesignObject)object2).getName();
                list = (List)treeMap.get(object);
                if (list == null) {
                    list = new ArrayList();
                    treeMap.put(object, list);
                }
                list.add(((RelationalObjectProxy)object42).getObject());
                continue;
            }
            arrayList.add(((RelationalObjectProxy)object42).getObject());
        }
        if (arrayList.size() > 0 && treeMap.size() > 0 || treeMap.size() > 1) {
            if (arrayList.size() > 0) {
                this.createSubview("SV_noschema", arrayList);
            }
            for (Object object42 : treeMap.keySet()) {
                object3 = (List)treeMap.get(object42);
                object2 = this.createSubview((String)object42, (List)object3);
                object = (SchemaObject)this.getSchemaObjectSet().getByName((String)object42);
                if (object == null) continue;
                ((DesignPartView)object2).setSchemaObject((SchemaObject)object);
            }
        }
    }

    public DesignPartView createSubview(String string, List list) {
        DesignPartView designPartView = this.createDesignPartSubView();
        if (string != null) {
            designPartView.setName(string);
        }
        designPartView.setMustBeVisible(false);
        for (DesignObject designObject : list) {
            TopView topView = designPartView.createTopViewFor(designObject);
            if (topView instanceof TVTable) {
                ((TVTable)topView).addTVFKRelations();
                ((TVTable)topView).addTVTypeSubstitutions();
                continue;
            }
            if (!(topView instanceof TVView)) continue;
            ((TVView)topView).addTVTypeSubstitutions();
        }
        ((DPVRelationalSubView)designPartView).rearrangeNewDiagram();
        return designPartView;
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("SchemaObject");
        arrayList.add("Table");
        arrayList.add("View");
        arrayList.add("FKIndexAssociation");
        arrayList.add("FKArc");
        arrayList.add("Note");
        arrayList.add("MainView");
        arrayList.add("SubView");
        return arrayList;
    }

    @Override
    public int getPathID() {
        if (this.pathID == 0) {
            this.pathID = this.getDesign().getRelationalDesigns().nextIndex();
        }
        return this.pathID;
    }

    public void showFkeysInSubviews() {
        Iterator iterator = this.getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            fKIndexAssociation.addToAllDPVs();
        }
    }

    public void showFKArcs() {
        Iterator iterator = this.getArcSet().iterator();
        while (iterator.hasNext()) {
            FKArc fKArc = (FKArc)iterator.next();
            fKArc.showArcInAllDPVs();
        }
    }

    @Override
    public String getStoragePath() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                String string2 = this.getDesign().getLoadedVersion() < 3.2f ? "relational" : "rel";
                String string3 = this.getDesign().getLoadedVersion() < 3.2f ? this.getObjectID() : (this.getDesign().getLoadedVersion() < 3.4f ? this.getPathIDString() : this.getShortObjectID());
                return new File(string, string2 + "/" + string3).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                String string2 = this.getDesign().getLoadedVersion() < 3.4f ? this.getPathIDString() : this.getShortObjectID();
                return new File(string, "rel/" + string2 + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StorableObject createObject(String string, String string2, String string3) {
        DesignObject designObject = null;
        if ("Table".equalsIgnoreCase(string)) {
            designObject = this.getTableSet().createTable(string2);
        } else if ("View".equalsIgnoreCase(string)) {
            designObject = this.getTableViewSet().createTableView(string2);
        } else if ("FKIndexAssociation".equalsIgnoreCase(string)) {
            FKIndexAssociation fKIndexAssociation = new FKIndexAssociation(this);
            fKIndexAssociation.setObjectID(string2);
            designObject = fKIndexAssociation;
        } else if ("FKArc".equalsIgnoreCase(string)) {
            designObject = this.getArcSet().createArc(string2);
        } else if ("Note".equalsIgnoreCase(string)) {
            designObject = this.getNoteSet().createNote(string2);
        } else if ("SchemaObject".equalsIgnoreCase(string)) {
            designObject = this.getSchemaObjectSet().createSchemaObject(string2);
        }
        if (designObject != null && string3 != null && string3.length() > 0) {
            ((DesignObject)designObject).setName(string3);
        }
        return designObject;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("schema", "SchemaObject");
            this.f2tMap.put("table", "Table");
            this.f2tMap.put("view", "View");
            this.f2tMap.put("foreignkey", "FKIndexAssociation");
            this.f2tMap.put("arc", "FKArc");
            this.f2tMap.put("note", "Note");
        }
        return this.f2tMap;
    }

    public static void initObjectDetails(Design design, File file, SVNUrl sVNUrl, boolean bl, String string, StorableObjectStatusHelper storableObjectStatusHelper, String string2, String string3) {
        if ("phys".equalsIgnoreCase(string)) {
            String string4 = "/phys";
            String string5 = string3.substring(string3.indexOf(string4) + string4.length() + 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string5, "/");
            String string6 = stringTokenizer.nextToken();
            RDBMSSite rDBMSSite = design.getRDBMSSiteSet().getByShortObjectIDString(string6);
            if (string2.equalsIgnoreCase(string6)) {
                File file2 = file.getParentFile();
                File file3 = file2.getParentFile().getParentFile();
                RelationalDesign.addDesignPartPaths(storableObjectStatusHelper, string2, file3);
                storableObjectStatusHelper.treePath.add(new TreePathHelper(StorageDesignFactory.getStorageDesignSetName(), file2.getParentFile(), StorageDesign.class));
                storableObjectStatusHelper.objectClass = StorageDesign.class;
                storableObjectStatusHelper.objectType = StorageDesign.TYPE_NAME;
                if (storableObjectStatusHelper.designPart != null && rDBMSSite != null && storableObjectStatusHelper.designPart != null) {
                    storableObjectStatusHelper.storableObject = ((RelationalDesign)storableObjectStatusHelper.designPart).getStorageDesign(rDBMSSite);
                }
            } else {
                File file4 = file.getParentFile();
                if (file4.getName().startsWith(SegmentNameManager.NAME_PREFIX)) {
                    file4 = file4.getParentFile();
                }
                File file5 = file4.getParentFile();
                File file6 = file5.getParentFile().getParentFile();
                RelationalDesign.addDesignPartPaths(storableObjectStatusHelper, string2, file6);
                storableObjectStatusHelper.treePath.add(new TreePathHelper(StorageDesignFactory.getStorageDesignSetName(), file5.getParentFile(), StorageDesign.class));
                String string7 = stringTokenizer.nextToken();
                if (rDBMSSite != null) {
                    storableObjectStatusHelper.rdbmsSite = rDBMSSite;
                    StorageDesign.initObjectDetails(design, file, sVNUrl, bl, string7, storableObjectStatusHelper, string2, design.getStorageDesign(rDBMSSite));
                }
            }
        } else {
            File file7 = file.getParentFile();
            if (file7.getName().startsWith(SegmentNameManager.NAME_PREFIX)) {
                file7 = file7.getParentFile();
            }
            File file8 = file7.getParentFile();
            RelationalDesign.addDesignPartPaths(storableObjectStatusHelper, string2, file8);
            if ("schema".equalsIgnoreCase(string)) {
                storableObjectStatusHelper.objectClass = SchemaObject.class;
                storableObjectStatusHelper.objectType = "SchemaObject";
                storableObjectStatusHelper.treePath.add(new TreePathHelper(SCHEMA_SET_NAME, file7, SchemaObjectSet.class));
                if (storableObjectStatusHelper.designPart != null) {
                    storableObjectStatusHelper.objectSet = ((RelationalDesign)storableObjectStatusHelper.designPart).getSchemaObjectSet();
                    storableObjectStatusHelper.storableObject = ((RelationalDesign)storableObjectStatusHelper.designPart).getSchemaObjectSet().getObjectByID(string2);
                }
            } else if ("table".equalsIgnoreCase(string)) {
                storableObjectStatusHelper.objectClass = Table.class;
                storableObjectStatusHelper.objectType = "Table";
                storableObjectStatusHelper.treePath.add(new TreePathHelper(TABLE_SET_NAME, file7, TableSet.class));
                if (storableObjectStatusHelper.designPart != null) {
                    storableObjectStatusHelper.objectSet = ((RelationalDesign)storableObjectStatusHelper.designPart).getTableSet();
                    storableObjectStatusHelper.storableObject = ((RelationalDesign)storableObjectStatusHelper.designPart).getTableSet().getObjectByID(string2);
                }
            } else if ("view".equalsIgnoreCase(string)) {
                storableObjectStatusHelper.objectClass = TableView.class;
                storableObjectStatusHelper.objectType = "View";
                storableObjectStatusHelper.treePath.add(new TreePathHelper(VIEW_SET_NAME, file7, TableViewSet.class));
                if (storableObjectStatusHelper.designPart != null) {
                    storableObjectStatusHelper.objectSet = ((RelationalDesign)storableObjectStatusHelper.designPart).getTableViewSet();
                    storableObjectStatusHelper.storableObject = ((RelationalDesign)storableObjectStatusHelper.designPart).getTableViewSet().getObjectByID(string2);
                }
            } else if ("foreignkey".equalsIgnoreCase(string)) {
                storableObjectStatusHelper.objectClass = FKIndexAssociation.class;
                storableObjectStatusHelper.objectType = "FKIndexAssociation";
                storableObjectStatusHelper.treePath.add(new TreePathHelper(FK_SET_NAME, file7, FKIndexAssociationSet.class));
                if (storableObjectStatusHelper.designPart != null) {
                    storableObjectStatusHelper.objectSet = ((RelationalDesign)storableObjectStatusHelper.designPart).getFKIndexAssociationSet();
                    storableObjectStatusHelper.storableObject = ((RelationalDesign)storableObjectStatusHelper.designPart).getFKIndexAssociationSet().getObjectByID(string2);
                }
            } else if ("arc".equalsIgnoreCase(string)) {
                storableObjectStatusHelper.objectClass = FKArc.class;
                storableObjectStatusHelper.objectType = "FKArc";
                storableObjectStatusHelper.treePath.add(new TreePathHelper(ARC_SET_NAME, file7, FKArcSet.class));
                if (storableObjectStatusHelper.designPart != null) {
                    storableObjectStatusHelper.objectSet = ((RelationalDesign)storableObjectStatusHelper.designPart).getArcSet();
                    storableObjectStatusHelper.storableObject = ((RelationalDesign)storableObjectStatusHelper.designPart).getArcSet().getObjectByID(string2);
                }
            } else if ("note".equalsIgnoreCase(string)) {
                storableObjectStatusHelper.objectClass = Note.class;
                storableObjectStatusHelper.objectType = "Note";
                storableObjectStatusHelper.treePath.add(new TreePathHelper(NOTE_SET_NAME, file7, NoteSet.class));
                if (storableObjectStatusHelper.designPart != null) {
                    storableObjectStatusHelper.objectSet = ((RelationalDesign)storableObjectStatusHelper.designPart).getNoteSet();
                    storableObjectStatusHelper.storableObject = ((RelationalDesign)storableObjectStatusHelper.designPart).getNoteSet().getObjectByID(string2);
                }
            } else if ("subviews".equalsIgnoreCase(string)) {
                storableObjectStatusHelper.objectClass = DPVRelationalSubView.class;
                storableObjectStatusHelper.treePath.add(new TreePathHelper(DIAGRAM_SET_NAME, file7, DPVRelationalSubView.class));
                if (storableObjectStatusHelper.designPart != null) {
                    RelationalDesign relationalDesign = (RelationalDesign)storableObjectStatusHelper.designPart;
                    storableObjectStatusHelper.storableObject = relationalDesign.getMainView().getDPVId().equals(string2) ? relationalDesign.getMainView() : relationalDesign.getSubViewByID(string2);
                }
            }
        }
    }

    private static void addDesignPartPaths(StorableObjectStatusHelper storableObjectStatusHelper, String string, File file) {
        storableObjectStatusHelper.treePath.add(new TreePathHelper(Design.getRelationalModelsSetName(), file.getParentFile(), RelationalDesignSet.class));
        if (storableObjectStatusHelper.designPart != null) {
            storableObjectStatusHelper.treePath.add(new TreePathHelper(storableObjectStatusHelper.designPart.getName(), new File(storableObjectStatusHelper.designPart.getStorageName()), RelationalDesign.class));
        } else {
            SVNObjectHelper sVNObjectHelper;
            SVNObjectHelper sVNObjectHelper2 = SVNClientHelper.svnOHMap.get(string);
            if (sVNObjectHelper2 != null && (sVNObjectHelper = SVNClientHelper.svnOHMap.get(sVNObjectHelper2.parentID)) != null) {
                storableObjectStatusHelper.treePath.add(new TreePathHelper(sVNObjectHelper.propName, new File(sVNObjectHelper.fileName), RelationalDesign.class));
            }
        }
    }

    public List<StorableObject> getNotMarkedGenerateObjects() {
        ArrayList<StorableObject> arrayList = new ArrayList<StorableObject>();
        this.addNotMarkedGenerateTables(arrayList);
        this.addNotMarkedGenerateTableViews(arrayList);
        return arrayList;
    }

    private void addNotMarkedGenerateTables(List<StorableObject> list) {
        Iterator iterator = this.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            KeyObject[] keyObjectArray = table.getKeys();
            for (int i = 0; i < keyObjectArray.length; ++i) {
                DesignObject designObject;
                KeyObject keyObject = keyObjectArray[i];
                DesignObject designObject2 = designObject = keyObject.isFK() ? keyObject.getFKAssociation() : keyObject;
                if (designObject.isMarkedGenerate()) continue;
                list.add(designObject);
            }
            if (table.isMarkedGenerate()) continue;
            list.add(table);
        }
    }

    private void addNotMarkedGenerateTableViews(List<StorableObject> list) {
        Iterator iterator = this.getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            if (tableView.isMarkedGenerate()) continue;
            list.add(tableView);
        }
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        if ("selectedRDBMSSite".equalsIgnoreCase(string)) {
            RDBMSSite rDBMSSite = this.getDesign().getRDBMSSiteSet().getByObjectID(string2);
            if (rDBMSSite == null) {
                rDBMSSite = this.getDesign().getRDBMSSiteSet().getDefaultRDBMSSite(this.getDesign().getAppView().getSettings());
            }
            return rDBMSSite;
        }
        return super.translateIdToObject(string, string2);
    }

    @Override
    public String translateObjectToID(String string, Object object) {
        if ("selectedRDBMSSite".equalsIgnoreCase(string) && object instanceof RDBMSSite) {
            return ((RDBMSSite)object).getObjectID();
        }
        return super.translateObjectToID(string, object);
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        if (this.getMainView() != null) {
            this.getMainView().getWorkSpace().updateSettings();
        }
        this.sortCollections();
    }

    public void openRelationalModel() {
        if (!this.isLoaded()) {
            this.getAppView().getXMLTransformationManager().openDesignPart(this);
            this.setLoaded(true);
        }
    }

    public StorageDesignSet getSorageDesigns() {
        return this.getStorageDesignFactory().getSorageDesigns();
    }

    @Override
    public List getObjectsWithMeasurements() {
        DesignObject designObject;
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        Iterator iterator = this.getTableSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Table)iterator.next();
            if (designObject.getMeasurements().size() > 0) {
                arrayList.add(designObject);
            }
            for (ContainedObject containedObject : Arrays.asList(((ContainerObject)designObject).getElements())) {
                if (containedObject.getMeasurements().size() <= 0) continue;
                arrayList.add(containedObject);
            }
        }
        iterator = this.getTableViewSet().iterator();
        while (iterator.hasNext()) {
            designObject = (TableView)iterator.next();
            if (designObject.getMeasurements().size() > 0) {
                arrayList.add(designObject);
            }
            for (ContainedObject containedObject : Arrays.asList(((ContainerObject)designObject).getElements())) {
                if (containedObject.getMeasurements().size() <= 0) continue;
                arrayList.add(containedObject);
            }
        }
        iterator = this.getSchemaObjectSet().iterator();
        while (iterator.hasNext()) {
            designObject = (SchemaObject)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            designObject = (FKIndexAssociation)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getArcSet().iterator();
        while (iterator.hasNext()) {
            designObject = (FKArc)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getGlobalIndexSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Index)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getTypeSubstitutionSet().iterator();
        while (iterator.hasNext()) {
            designObject = (TypeSubstitution)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        iterator = this.getNoteSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Note)iterator.next();
            if (designObject.getMeasurements().size() <= 0) continue;
            arrayList.add(designObject);
        }
        return arrayList;
    }

    private void setViewListeners() {
        Iterator iterator = this.getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            if (!tableView.isParsed()) continue;
            for (SQLNameHelper sQLNameHelper : tableView.getSQLNames()) {
                DesignObject designObject = this.getDesign().getDesignObject(sQLNameHelper.getID());
                if (designObject == null) continue;
                designObject.addObjectListener(tableView);
            }
        }
    }

    public static void collectNeighbors(Table table, List list, int n, boolean bl, int n2) {
        int n3 = --n;
        Iterator iterator = n2 == 1 ? ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getParentTables(table).iterator() : (n2 == 2 ? ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getChildTables(table).iterator() : ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getRelatedTablesTo(table).iterator());
        while (iterator.hasNext()) {
            Table table2 = (Table)iterator.next();
            if (list.contains(table2)) continue;
            list.add(table2);
            if (!bl && n3 <= 0) continue;
            RelationalDesign.collectNeighbors(table2, list, n3, bl, n2);
        }
    }

    public RMExtendedMap getRMExtendedMap() {
        if (this.extendedMap == null) {
            this.extendedMap = new RMExtendedMap(this.getDesign(), this);
            this.getDesign().getLogicalDesign().addDesignPartListener(this.extendedMap);
            this.addDesignPartListener(this.extendedMap);
        }
        return this.extendedMap;
    }

    public RelationalDesign getRelatedSyncModel() {
        return this.relatedSyncModel;
    }

    public void setRelatedSyncModel(RelationalDesign relationalDesign) {
        this.relatedSyncModel = relationalDesign;
    }

    public void clearMappings() {
        this.getRMExtendedMap().clearMappings();
    }

    @Override
    protected List getObjectWichAllowClassificationTypes() {
        ArrayList arrayList = new ArrayList();
        this.getTableSet().addAllElementsTo(arrayList);
        return arrayList;
    }

    public class ColumnPlaceHolder
    extends DesignObjectPlaceHolder {
        public ColumnPlaceHolder(DesignObject designObject) {
            super(designObject);
        }

        @Override
        public String toString() {
            return this.getDesignObject().getLongName();
        }
    }
}

