/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;

public class Oracle_CSV_CTLFileGenerator {
    private RelationalDesign phdes;
    private String directory = "d:/rep_load_ctl/";
    private String filemap = "";
    private Map tableMap = new TreeMap();
    private String dataDir = "e:/CSVFiles_Test/";
    private char delimiter = (char)59;
    int typePos = 45;
    int positionPos = 22;
    int current_length = 0;
    List sortedTables = new ArrayList();
    List tracedTables = new ArrayList();
    boolean cyclicRef = false;

    public Oracle_CSV_CTLFileGenerator(RelationalDesign relationalDesign) {
        this.phdes = relationalDesign;
        RDBMSSite rDBMSSite = relationalDesign.getDesign().getFirstOfType(StorageDesignDB2v80.RDBMS_TYPE);
        relationalDesign.setSelectedRDBMSSite(rDBMSSite);
    }

    public Oracle_CSV_CTLFileGenerator(RelationalDesign relationalDesign, String string, String string2, String string3, char c) {
        this.phdes = relationalDesign;
        RDBMSSite rDBMSSite = relationalDesign.getDesign().getFirstOfType(StorageDesignDB2v80.RDBMS_TYPE);
        relationalDesign.setSelectedRDBMSSite(rDBMSSite);
        relationalDesign.getStorageDesign(rDBMSSite);
        this.directory = string;
        this.dataDir = string2;
        this.filemap = string3;
        this.delimiter = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFileMap(String string) throws IOException {
        this.tableMap.clear();
        if (string == null || "".equals(string)) {
            return;
        }
        File file = new File(string);
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            throw new RuntimeException(MessageFormat.format(Messages.getString("Oracle_CSV_CTLFileGenerator.FileCanNotBeCreated"), string));
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        try {
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                int n2;
                int n3 = string2.length();
                if (string2.charAt(n3 - 1) == this.delimiter) {
                    string2 = string2.substring(0, n3 - 1);
                }
                if ((n2 = string2.indexOf(this.delimiter)) <= 0) continue;
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1);
                if (string4.charAt(0) == '\'') {
                    string4 = string4.substring(1);
                }
                if (string4.charAt((n = string4.length()) - 1) == '\'') {
                    string4 = string4.substring(0, n - 1);
                }
                this.tableMap.put(string3.toUpperCase(), string4);
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToFile(String string, Table table) throws IOException {
        File file = new File(string);
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            throw new RuntimeException(Messages.getString("Oracle_CSV_CTLFileGenerator.FileCanNotBeCreated") + string + " cannot be created");
        }
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = this.createColumnPart(table, stringBuffer2);
            this.addFixedPart(stringBuffer, table.getName().toUpperCase(), table, n);
            stringBuffer.append(stringBuffer2);
            writer.write(stringBuffer.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int createColumnPart(Table table, StringBuffer stringBuffer) {
        int n = 1;
        Column[] columnArray = (Column[])table.getElements();
        int n2 = columnArray.length - 1;
        String string = "";
        stringBuffer.append("(\n");
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            string = column.getName().toUpperCase();
            String string2 = column.getDatatypeString("Oracle Database 10g");
            int n3 = string2.indexOf(40);
            if (n3 > -1) {
                string2 = string2.substring(0, n3).trim();
            }
            String string3 = column.getSize();
            String string4 = column.getPrecision();
            String string5 = column.getScale();
            String string6 = this.makeDatatype(string2, string3, string4, string5);
            string = this.addWithSpacesAtPos(string, this.typePos, string6);
            n += this.current_length;
            if (i != n2) {
                string = string + ",";
            }
            string = string + "\n";
            stringBuffer.append(string);
        }
        stringBuffer.append(")\n");
        return n - 1;
    }

    private String makeDatatype(String string, String string2, String string3, String string4) {
        String string5 = "";
        if (string.equalsIgnoreCase("VARCHAR2")) {
            this.current_length = Integer.valueOf(string2) + 2;
            string5 = "CHAR(" + string2 + ")";
        } else if (string.equalsIgnoreCase("SMALLINT")) {
            this.current_length = 2;
            string5 = "INTEGER(" + String.valueOf(2) + ")";
        } else if (string.equalsIgnoreCase("INTEGER")) {
            this.current_length = 4;
            string5 = "INTEGER(" + String.valueOf(4) + ")";
        } else if (string.equalsIgnoreCase("DECIMAL") || string.equalsIgnoreCase("NUMBER")) {
            string5 = "DECIMAL EXTERNAL";
        } else if (string.equalsIgnoreCase("CHAR")) {
            this.current_length = Integer.valueOf(string2);
            string5 = "CHAR(" + string2 + ")";
        } else if (string.equalsIgnoreCase("DATE")) {
            this.current_length = 10;
            string5 = "DATE EXTERNAL(10) \"YYYY-MM-DD\"";
        } else if (string.equalsIgnoreCase("TIME")) {
            this.current_length = 8;
            string5 = "DATE EXTERNAL(8) \"HH24.MI.SS\"";
        } else if (string.equalsIgnoreCase("TIMESTAMP")) {
            this.current_length = 26;
            string5 = "TIMESTAMP \"YYYY-MM-DD-HH24.MI.SS.FF6 \"";
        }
        return string5;
    }

    private void addFixedPart(StringBuffer stringBuffer, String string, Table table, int n) {
        stringBuffer.append("OPTIONS(SILENT=(FEEDBACK),DIRECT=YES,SKIP=1)\n");
        stringBuffer.append("LOAD DATA \n");
        String string2 = (String)this.tableMap.get(string);
        string2 = string2 != null ? (string2.charAt(0) == '\'' ? "''" + new File(this.dataDir, string2).getAbsolutePath() + ".csv''" : "'" + new File(this.dataDir, string2).getAbsolutePath() + ".csv'") : "'" + new File(this.dataDir, string).getAbsolutePath() + ".csv'";
        stringBuffer.append("INFILE ").append(string2).append(" \n");
        stringBuffer.append("BADFILE ").append(string).append(".bad\n");
        stringBuffer.append("DISCARDFILE ").append(string).append(".dis\n");
        stringBuffer.append("INTO TABLE ").append(string).append("\n");
        stringBuffer.append("FIELDS TERMINATED BY \",\" OPTIONALLY ENCLOSED BY '\"'\n");
    }

    private String addWithSpacesAtPos(String string, int n, String string2) {
        int n2;
        for (int i = n2 = string.length() - 1; i < n; ++i) {
            string = string + ' ';
        }
        string = string + string2;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFiles() {
        Object object;
        Object object2;
        File file = new File(this.directory, this.phdes.getName());
        if (!file.exists()) {
            file.mkdirs();
        }
        this.directory = file.getAbsolutePath();
        this.sortedTables.clear();
        this.phdes.getTableSet().addAllElementsTo(this.sortedTables);
        try {
            this.loadFileMap(this.filemap);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Rem Usage:\n");
        stringBuffer.append("Rem sqlplus scott/tiger@ora102db @load_all.sql scott tiger\n\n\n");
        stringBuffer.append("DEFINE user_ = &1\n");
        stringBuffer.append("DEFINE pass = &2\n\n\n");
        for (int i = 0; i < this.sortedTables.size(); ++i) {
            object2 = (Table)this.sortedTables.get(i);
            object = ((DesignObject)object2).getName().toUpperCase() + ".ctl";
            String string = new File(this.directory, (String)object).getAbsolutePath();
            try {
                this.exportToFile(string, (Table)object2);
                stringBuffer.append("prompt\n");
                stringBuffer.append("prompt loading " + ((DesignObject)object2).getName().toUpperCase() + " \n\n");
                stringBuffer.append("HOST sqlldr &user_/&pass - \n   silent=(HEADER,FEEDBACK) - \n   control=" + string + " \n");
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        stringBuffer.append("prompt\n");
        stringBuffer.append("prompt end loading \n");
        stringBuffer.append("exit \n");
        String string = new File(this.directory, "load_all.sql").getAbsolutePath();
        object2 = new File(string);
        try {
            ((File)object2).createNewFile();
        }
        catch (IOException iOException) {
            throw new RuntimeException(Messages.getString("Oracle_CSV_CTLFileGenerator.FileCanNotBeCreated") + string + " cannot be created");
        }
        object = null;
        try {
            object = new BufferedWriter(new OutputStreamWriter(new FileOutputStream((File)object2)));
            ((Writer)object).write(stringBuffer.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (object != null) {
                try {
                    ((Writer)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] stringArray) {
    }
}

