/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class IndexSet
extends KeyObjectSet {
    protected static final Object[] PROTOARRAY = new Index[0];
    private Table table;
    private NamingStandardRule nsr;

    public IndexSet(DesignPart designPart, Table table) {
        super(designPart);
        this.table = table;
        if (designPart.getAppView() != null) {
            this.nsr = designPart.getDesign().getDLSettings().getNamingStandardRule();
        }
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTOARRAY;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default index name");
    }

    @Override
    protected String getSeparator() {
        return "_";
    }

    @Override
    public String createName() {
        if (this.nsr != null) {
            return ApplyNamingStandards.createIndexName(this.table.getName(), this.count, this.nsr, this.getDesignPart().getName(), this.table.getAbbreviation());
        }
        return super.createName();
    }

    @Override
    protected boolean doAdd(DesignObject designObject) {
        this.elements.add(designObject);
        this.addToNameMap(designObject);
        SetEvent.OBJECT_ADDED.setAffected(designObject);
        this.fireChange(SetEvent.OBJECT_ADDED);
        return true;
    }

    public void addAndApplyOrderFromList(List list) {
        ArrayList<Index> arrayList = new ArrayList<Index>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            if (!index.isFK()) continue;
            arrayList.add(index);
        }
        this.elements.clear();
        this.elements.addAll(list);
        this.elements.addAll(arrayList);
    }

    @Override
    public void sort() {
    }

    public Index getByIdOfRecoveredIntegrityIndex(String string) {
        if (string != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Index index = (Index)iterator.next();
                if (!string.equals(index.getIdOfRecoveredIntegrityIndex())) continue;
                return index;
            }
        }
        return null;
    }

    @Override
    public boolean changeName(String string, String string2, DesignObject designObject) {
        Object v = this.names.get(string2.toUpperCase());
        if (v == null || v == designObject || this.checkIndexStates((Index)designObject, (Index)v)) {
            this.doRenaming(string, string2, designObject);
            return true;
        }
        return false;
    }

    private boolean checkIndexStates(Index index, Index index2) {
        return index.getIndexState().endsWith("Plain Index") != index2.getIndexState().endsWith("Plain Index");
    }

    private void doRenaming(String string, String string2, DesignObject designObject) {
        String string3;
        DesignObject designObject2;
        if (string != null && (designObject2 = (DesignObject)this.names.get(string3 = string.toUpperCase())) == designObject) {
            this.names.remove(string3);
        }
        this.names.put(string2.toUpperCase(), designObject);
        if (!designObject.getDesign().isLoading()) {
            SetEvent.NAME_CHANGED.setAffected(designObject);
            this.fireChange(SetEvent.NAME_CHANGED);
        }
    }

    @Override
    public boolean updateNamesMap(SchemaObject schemaObject, String string, SchemaObject schemaObject2, String string2, DesignObject designObject) {
        return super.updateNamesMap(null, string, null, string2, designObject);
    }
}

