/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.CompoundEdit;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.GroupRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKCreateEdit;

public class FKDiscoverer {
    public static int NAME_POLICY_REFERRED = 0;
    public static int NAME_POLICY_TEMPLATE = 1;
    public static int NAME_POLICY_REF_AND_TEMPLATE = 2;
    public static int NAME_POLICY_TEMPLATE_AND_REF = 3;
    public static int NAME_POLICY = NAME_POLICY_REF_AND_TEMPLATE;
    public static boolean IN_ONE_FK_ONLY = true;
    public static boolean LONGEST_KEYS_FIRST = true;
    private RelationalDesign rd;
    private List allFKeys = new ArrayList();
    private List allTables = new ArrayList();
    private List allPKeys = new ArrayList();
    private List allUKeys = new ArrayList();
    private List prepareList = new ArrayList();
    private static IndexComparator INDEX_COMPARATOR = new IndexComparator();
    private static IndexComparatorReverse INDEX_COMPARATOR_REVERSE = new IndexComparatorReverse();
    private static String PROPERTY_NAME = "createdByFKDiscoverer";
    private static String TRUE = "true";

    public static void main(String[] stringArray) {
    }

    public FKDiscoverer(RelationalDesign relationalDesign) {
        this.rd = relationalDesign;
        this.init();
    }

    private void init() {
        this.allPKeys.clear();
        this.allUKeys.clear();
        this.allTables.clear();
        this.prepareList.clear();
        Iterator iterator = this.rd.getGlobalIndexSet().iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            if (index.isPK()) {
                this.allPKeys.add(index);
                continue;
            }
            if (!index.isUnique()) continue;
            this.allUKeys.add(index);
        }
        iterator = this.rd.getTableSet().iterator();
        while (iterator.hasNext()) {
            this.allTables.add(iterator.next());
        }
        if (LONGEST_KEYS_FIRST) {
            Collections.sort(this.allPKeys, INDEX_COMPARATOR_REVERSE);
            Collections.sort(this.allUKeys, INDEX_COMPARATOR_REVERSE);
        } else {
            Collections.sort(this.allPKeys, INDEX_COMPARATOR);
            Collections.sort(this.allUKeys, INDEX_COMPARATOR);
        }
    }

    private Index getKey() {
        Index index = null;
        if (this.allPKeys.size() > 0) {
            index = (Index)this.allPKeys.get(0);
            index = this.getKey(index, this.allPKeys);
        }
        if (index == null && this.allUKeys.size() > 0) {
            index = (Index)this.allUKeys.get(0);
            index = this.getKey(index, this.allUKeys);
        }
        return index;
    }

    private Index getKey(Index index, List list) {
        Index index2 = index;
        return index2;
    }

    public List prepareFKs() {
        this.prepareList.clear();
        Index index = this.getKey();
        while (index != null) {
            this.removeKeyFromLists(index);
            this.processKey(index);
            index = this.getKey();
        }
        return this.prepareList;
    }

    private boolean isprocessingReferred() {
        return NAME_POLICY == NAME_POLICY_REF_AND_TEMPLATE || NAME_POLICY == NAME_POLICY_REFERRED || NAME_POLICY == NAME_POLICY_TEMPLATE_AND_REF;
    }

    private boolean isprocessingTempalte() {
        return NAME_POLICY == NAME_POLICY_REF_AND_TEMPLATE || NAME_POLICY == NAME_POLICY_TEMPLATE || NAME_POLICY == NAME_POLICY_TEMPLATE_AND_REF;
    }

    private boolean isReferenceColumnFirst() {
        return NAME_POLICY == NAME_POLICY_REF_AND_TEMPLATE || NAME_POLICY == NAME_POLICY_REFERRED;
    }

    private void processKey(Index index) {
        Column[] columnArray = index.getColumns();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Table table : this.allTables) {
            arrayList.clear();
            for (int i = 0; i < columnArray.length; ++i) {
                String string;
                Column column = null;
                if (this.isReferenceColumnFirst()) {
                    if (this.isprocessingReferred()) {
                        column = table.getEquivelentColumn(columnArray[i], null, IN_ONE_FK_ONLY);
                    }
                    if (column == null && this.isprocessingTempalte()) {
                        string = table.createFKColumnName(columnArray[i]);
                        column = table.getEquivelentColumn(columnArray[i], string, IN_ONE_FK_ONLY);
                    }
                } else {
                    if (this.isprocessingTempalte()) {
                        string = table.createFKColumnName(columnArray[i]);
                        column = table.getEquivelentColumn(columnArray[i], string, IN_ONE_FK_ONLY);
                    }
                    if (column == null && this.isprocessingReferred()) {
                        column = table.getEquivelentColumn(columnArray[i], null, IN_ONE_FK_ONLY);
                    }
                }
                if (column == null) break;
                if (this.isFKColumn(column) && IN_ONE_FK_ONLY) continue;
                arrayList.add(column);
            }
            if (arrayList.size() != columnArray.length) continue;
            FKPrepare fKPrepare = new FKPrepare();
            fKPrepare.parentTable = index.getTable();
            fKPrepare.referredKey = index;
            fKPrepare.childTable = table;
            fKPrepare.childColumns.addAll(arrayList);
            this.prepareList.add(fKPrepare);
        }
    }

    private boolean isFKColumn(Column column) {
        for (FKPrepare fKPrepare : this.prepareList) {
            if (!fKPrepare.childColumns.contains(column)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createForeignKeys() {
        CompoundEdit compoundEdit = null;
        this.rd.getUndoManager().setLocked(true);
        try {
            for (FKPrepare fKPrepare : this.prepareList) {
                if (fKPrepare.selected) {
                    fKPrepare.fk = fKPrepare.childTable.addForeignKey(fKPrepare.referredKey, fKPrepare.childColumns);
                    if (fKPrepare.fk == null) continue;
                    if (compoundEdit == null) {
                        compoundEdit = new GroupRemoveEdit(fKPrepare.fk, "Create discovered Foreign keys", "Remove discovered Foreign keys");
                    }
                    fKPrepare.fk.resetMandatoryUsingColumns();
                    fKPrepare.fk.addToAllDPVs();
                    fKPrepare.fk.resetEdgeParams();
                    fKPrepare.fk.setProperty(PROPERTY_NAME, TRUE);
                    FKCreateEdit fKCreateEdit = new FKCreateEdit(fKPrepare.fk);
                    fKCreateEdit.end();
                    compoundEdit.addEdit(fKCreateEdit);
                    continue;
                }
                fKPrepare.fk = null;
            }
        }
        finally {
            this.rd.getUndoManager().setLocked(false);
        }
        if (compoundEdit != null) {
            compoundEdit.end();
            this.rd.postUndoableEdit(compoundEdit);
        }
    }

    private void removeKeyFromLists(Index index) {
        if (index.isPK()) {
            this.allPKeys.remove(index);
        } else {
            this.allUKeys.remove(index);
        }
    }

    public List getPrepareList() {
        return this.prepareList;
    }

    public void rescane() {
        this.init();
        this.prepareFKs();
    }

    static class IndexComparatorReverse
    implements Comparator {
        IndexComparatorReverse() {
        }

        public int compare(Object object, Object object2) {
            int n = -1;
            int n2 = -1;
            if (object instanceof Index) {
                n = ((Index)object).getElementsCollection().size();
            }
            if (object2 instanceof Index) {
                n2 = ((Index)object2).getElementsCollection().size();
            }
            if (n < n2) {
                return 1;
            }
            if (n2 < n) {
                return -1;
            }
            return 0;
        }
    }

    static class IndexComparator
    implements Comparator {
        IndexComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = -1;
            int n2 = -1;
            if (object instanceof Index) {
                n = ((Index)object).getElementsCollection().size();
            }
            if (object2 instanceof Index) {
                n2 = ((Index)object2).getElementsCollection().size();
            }
            if (n > n2) {
                return 1;
            }
            if (n2 > n) {
                return -1;
            }
            return 0;
        }
    }

    public static class FKPrepare {
        public Table parentTable;
        public Table childTable;
        public Index referredKey;
        public List childColumns = new ArrayList();
        public boolean selected = true;
        public FKIndexAssociation fk;
    }
}

