/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.editor.relational.FKArcPropertiesDialogEx;
import oracle.dbtools.crest.swingui.relational.TVTable;

public class FKArc
extends ContainerObject
implements ObjectListener {
    private Table table;
    private List fkeys;
    private int sizeIndex;
    private List fkIDs = new ArrayList();
    private boolean mandatory = false;
    public static final String TYPE_NAME = "FKArc";

    public FKArc(DesignPart designPart) {
        super(designPart);
        this.fkeys = new ArrayList();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (designObject instanceof FKIndexAssociation && objectChangeEvent == ObjectChangeEvent.OBJECT_REMOVED) {
            this.removeFkey((FKIndexAssociation)designObject);
            if (this.fkeys.size() <= 1) {
                this.remove();
            }
        }
    }

    @Override
    public void remove() {
        Object[] objectArray = this.fkeys.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)objectArray[i];
            this.removeFkey(fKIndexAssociation);
        }
        super.remove();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FKArcPropertiesDialogEx fKArcPropertiesDialogEx = new FKArcPropertiesDialogEx(this.getDesign().getAppView(), this);
            fKArcPropertiesDialogEx.initProperties(this);
            fKArcPropertiesDialogEx.show();
        }
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
        if (table != null && !table.arcExists(this)) {
            table.addArc(this);
        }
    }

    public List getFkeys() {
        if (this.fkIDs.size() > 0) {
            this.updateFKs();
        }
        return this.fkeys;
    }

    public boolean containsFKey(FKIndexAssociation fKIndexAssociation) {
        return this.fkeys.contains(fKIndexAssociation);
    }

    public void addFkey(FKIndexAssociation fKIndexAssociation) {
        if (!this.fkeys.contains(fKIndexAssociation)) {
            this.fkeys.add(fKIndexAssociation);
            fKIndexAssociation.addObjectListener(this);
            fKIndexAssociation.setArc(this);
        }
    }

    public void removeFkey(FKIndexAssociation fKIndexAssociation) {
        this.fkeys.remove(fKIndexAssociation);
        fKIndexAssociation.removeObjectListener(this);
        fKIndexAssociation.setArc(null);
    }

    public void clearFkeys() {
        this.fkeys.clear();
    }

    public int getSizeIndex() {
        return this.sizeIndex;
    }

    public void setSizeIndex(int n) {
        this.sizeIndex = n;
    }

    @Override
    protected void clearStructure() {
    }

    @Override
    public ContainedObject createContainedObject(String string) {
        return null;
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return null;
    }

    @Override
    protected void updateStructure() {
    }

    public void addFKid(String string) {
        if (!this.fkIDs.contains(string)) {
            this.fkIDs.add(string);
        }
    }

    private void updateFKs() {
        for (int i = this.fkIDs.size() - 1; i >= 0; --i) {
            String string = (String)this.fkIDs.get(i);
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)this.getDesign().getDesignObject(string);
            if (fKIndexAssociation == null) continue;
            this.addFkey(fKIndexAssociation);
            this.fkIDs.remove(i);
        }
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean bl) {
        if (this.mandatory != bl) {
            this.mandatory = bl;
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "arc/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void showArcInAllDPVs() {
        if (this.table != null) {
            for (TVTable tVTable : this.table.getAllTopViews()) {
                if (tVTable == null) continue;
                tVTable.addArcs();
            }
        }
    }
}

