/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.AbstractConstraint;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeSet;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.editor.relational.ColumnPropertiesDialogEx;

public class Column
extends ContainedObjectWithDomain
implements ObjectListener,
ConstrainedObject {
    public static final String TYPE_NAME = "Column";
    public static final String DISPLAY_AS_TEXT = "Text";
    public static final String DISPLAY_AS_COMBOBOX = "Combo Box";
    public static final String DISPLAY_AS_TEXTAREA = "Text Area";
    public static final String DISPLAY_AS_SELECTLIST = "Select List";
    public static final String DISPLAY_AS_RADIOGROUP = "Radio Group";
    public static final String DISPLAY_AS_CHECKBOX = "Checkbox";
    public static final String DISPLAY_AS_OTHER = "Other";
    public static final String[] DISPLAY_AS_INTERNAL = new String[]{"Text", "Text Area", "Select List", "Combo Box", "Radio Group", "Checkbox", "Other"};
    public static final String[] DISPLAY_AS_DISPLAY = new String[]{Messages.getString("Column.Text"), Messages.getString("Column.ComboBox"), Messages.getString("Column.TextArea"), Messages.getString("Column.SelectList"), Messages.getString("Column.RadioGroup"), Messages.getString("Column.Checkbox"), Messages.getString("Column.Other")};
    private static String REFERRED_COLUMN = "referredColumn";
    private static String FK_ASSOCIATION = "fkAssociation";
    private boolean previousColumn = true;
    private Collection allrefs = new ArrayList();
    private String fkAssociationId;
    private FKIndexAssociationReference fkAssociationReference;
    private String referencedColumnId;
    private Column delegate = null;
    private boolean realFKPlaceHolder = false;
    private boolean computed = false;
    private String abbreviation = "";
    String engAttributeID = "none";
    private String defaultLabel;
    private String defaultFormatMask;
    private Integer defaultFormDisplayWidth;
    private Integer defaultFormMaximumWidth;
    private Integer defaultFormHeight;
    private String defaultHelpText;
    private boolean defaultReadOnly;
    private boolean defaultDisplayedOnReports = true;
    private boolean defaultDisplayedOnForms = true;
    private String defaultDisplayAs = "Text";
    private Boolean containsPII;
    private Boolean containsSensitiveInformation;
    private Boolean maskData;
    private boolean autoIncrementColumn;
    private boolean identityColumn;
    private boolean autoIncrementGenerateAlways = false;
    private String autoIncrementStartWith = "1";
    private Integer autoIncrementIncrementBy = 1;
    private String autoIncrementMinValue;
    private String autoIncrementMaxValue;
    private boolean autoIncrementCycle = false;
    private boolean autoIncrementDisableCache = true;
    private Integer autoIncrementCache;
    private boolean autoIncrementOrder = true;
    private String autoIncrementSequenceName;
    private String autoIncrementTriggerName;
    private boolean autoIncrementGenerateTrigger = true;
    private String notNullConstraintName;
    List checkedCols;

    public Column(DesignPart designPart) {
        super(designPart);
    }

    public Column(DesignPart designPart, Column column, FKIndexAssociationReference fKIndexAssociationReference) {
        super(designPart);
        this.fkAssociationReference = fKIndexAssociationReference;
        this.referencedColumnId = column.getObjectID();
        FKColRefNode fKColRefNode = new FKColRefNode();
        fKColRefNode.fkAssociationRef = fKIndexAssociationReference;
        fKColRefNode.refColumnId = column.getObjectID();
        this.allrefs.add(fKColRefNode);
        this.setPreviousColumn(false);
    }

    public Column(DesignPart designPart, Column column, FKIndexAssociation fKIndexAssociation) {
        super(designPart);
        this.fkAssociationId = fKIndexAssociation.getObjectID();
        this.referencedColumnId = column.getObjectID();
        FKColRefNode fKColRefNode = new FKColRefNode();
        fKColRefNode.fkAssocId = fKIndexAssociation.getObjectID();
        fKColRefNode.refColumnId = column.getObjectID();
        this.allrefs.add(fKColRefNode);
        this.setPreviousColumn(false);
    }

    public void addFKAssociation(Column column, FKIndexAssociation fKIndexAssociation) {
        String string = fKIndexAssociation.getObjectID();
        String string2 = column.getObjectID();
        this.addFKAssociation(string2, string);
    }

    public void addFKAssociation(String string, String string2) {
        if (this.allrefs.size() == 0) {
            this.fkAssociationId = string2;
            this.referencedColumnId = string;
        }
        boolean bl = false;
        for (FKColRefNode fKColRefNode : this.allrefs) {
            if (fKColRefNode.fkAssocId.equalsIgnoreCase(string2)) {
                fKColRefNode.refColumnId = string;
                bl = true;
                continue;
            }
            if (fKColRefNode.fkAssociationRef == null || !string2.equalsIgnoreCase(fKColRefNode.fkAssociationRef.getObject().getObjectID())) continue;
            fKColRefNode.refColumnId = string;
            bl = true;
        }
        if (!bl) {
            FKColRefNode fKColRefNode;
            fKColRefNode = new FKColRefNode();
            fKColRefNode.fkAssocId = string2;
            fKColRefNode.refColumnId = string;
            this.allrefs.add(fKColRefNode);
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("column id prefix");
    }

    public boolean isFKColumn() {
        return this.getAssociationsCount() > 0;
    }

    @Override
    public boolean isFKElement() {
        return this.isFKColumn();
    }

    public FKIndexAssociation getFKIndexAssociation() {
        FKIndexAssociation fKIndexAssociation = null;
        if (this.fkAssociationId != null) {
            fKIndexAssociation = this.getFKIndexAssociation(this.fkAssociationId);
        }
        if (fKIndexAssociation != null) {
            return fKIndexAssociation;
        }
        if (this.allrefs.size() > 0) {
            for (FKColRefNode fKColRefNode : this.allrefs) {
                if (fKColRefNode.fkAssocId != null && (fKIndexAssociation = this.getFKIndexAssociation(fKColRefNode.fkAssocId)) != null) {
                    return fKIndexAssociation;
                }
                if (fKColRefNode.fkAssociationRef == null) continue;
                if (fKColRefNode.fkAssociationRef.getObject() != null) {
                    fKIndexAssociation = this.getFKIndexAssociation(fKColRefNode.fkAssociationRef.getObject().getObjectID());
                }
                if (fKIndexAssociation == null) continue;
                return fKIndexAssociation;
            }
        }
        return null;
    }

    public boolean isFKPlaceHolderColumn() {
        return this.isRealFKPlaceHolder() && !this.isAdapterLoaded();
    }

    public boolean isAdapter() {
        return false;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean isPreviousColumn() {
        return this.previousColumn;
    }

    public void setPreviousColumn(boolean bl) {
        this.previousColumn = bl;
    }

    public int getAssociationsCount() {
        return this.allrefs.size();
    }

    public boolean isReferingTo(Column column) {
        Iterator iterator = this.allrefs.iterator();
        String string = column.getObjectID();
        while (iterator.hasNext()) {
            FKColRefNode fKColRefNode = (FKColRefNode)iterator.next();
            if (fKColRefNode.refColumnId == null || column == null || !fKColRefNode.refColumnId.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isReferingTo(FKIndexAssociation fKIndexAssociation, Column column) {
        String string = fKIndexAssociation.getObjectID();
        Iterator iterator = this.allrefs.iterator();
        String string2 = column.getObjectID();
        while (iterator.hasNext()) {
            FKColRefNode fKColRefNode = (FKColRefNode)iterator.next();
            if (fKColRefNode.refColumnId == null || column == null || !fKColRefNode.refColumnId.equalsIgnoreCase(string2) || !string.equals(fKColRefNode.fkAssocId)) continue;
            return true;
        }
        return false;
    }

    public void removeReferencesTo(Column column) {
        FKColRefNode[] fKColRefNodeArray = this.allrefs.toArray(new FKColRefNode[0]);
        String string = column.getObjectID();
        for (int i = 0; i < fKColRefNodeArray.length; ++i) {
            if (fKColRefNodeArray[i].refColumnId == null || !fKColRefNodeArray[i].refColumnId.equalsIgnoreCase(string)) continue;
            if (fKColRefNodeArray[i].fkAssocId != null) {
                this.removeFKAssociation(fKColRefNodeArray[i].fkAssocId);
                continue;
            }
            if (fKColRefNodeArray[i].fkAssociationRef == null) continue;
            this.removeFKAssociation(fKColRefNodeArray[i].fkAssociationRef);
        }
    }

    public Column getReferencedColumn() {
        FKIndexAssociation fKIndexAssociation;
        if (this.referencedColumnId != null && this.fkAssociationId != null && (fKIndexAssociation = this.getFKIndexAssociation(this.fkAssociationId)) != null && fKIndexAssociation.getRemoteTable() != null) {
            return (Column)fKIndexAssociation.getRemoteTable().getElementByID(this.referencedColumnId);
        }
        return null;
    }

    public Column getReferencedColumn(FKIndexAssociation fKIndexAssociation) {
        Iterator iterator = this.allrefs.iterator();
        String string = fKIndexAssociation.getObjectID();
        while (iterator.hasNext()) {
            Table table;
            FKIndexAssociation fKIndexAssociation2;
            FKColRefNode fKColRefNode = (FKColRefNode)iterator.next();
            if (!fKColRefNode.fkAssocId.equalsIgnoreCase(string) || fKColRefNode.refColumnId == null || (fKIndexAssociation2 = this.getFKIndexAssociation(fKColRefNode.fkAssocId)) == null || (table = fKIndexAssociation2.getRemoteTable()) == null) continue;
            return (Column)table.getElementByID(fKColRefNode.refColumnId);
        }
        return null;
    }

    public FKIndexAssociation getAssocToColumn(Column column) {
        FKColRefNode[] fKColRefNodeArray = this.allrefs.toArray(new FKColRefNode[0]);
        for (int i = 0; i < fKColRefNodeArray.length; ++i) {
            if (!fKColRefNodeArray[i].refColumnId.equalsIgnoreCase(column.getObjectID())) continue;
            if (fKColRefNodeArray[i].fkAssocId != null) {
                return this.getFKIndexAssociation(fKColRefNodeArray[i].fkAssocId);
            }
            if (fKColRefNodeArray[i].fkAssociationRef == null) continue;
            return (FKIndexAssociation)fKColRefNodeArray[i].fkAssociationRef.getObject();
        }
        return null;
    }

    public Collection getRefColAndAssocIDs() {
        for (FKColRefNode fKColRefNode : this.allrefs) {
            FKIndexAssociation fKIndexAssociation;
            if (fKColRefNode.fkAssocId != null) {
                fKIndexAssociation = this.getFKIndexAssociation(fKColRefNode.fkAssocId);
                if (fKIndexAssociation != null) {
                    fKColRefNode.remoteTableId = fKIndexAssociation.getRemoteTable().getObjectID();
                    fKColRefNode.remoteKeyId = fKIndexAssociation.getKeyObject().getObjectID();
                    continue;
                }
                fKColRefNode.remoteTableId = "null";
                fKColRefNode.remoteKeyId = "null";
                continue;
            }
            if (fKColRefNode.fkAssociationRef != null) {
                fKColRefNode.fkAssocId = fKColRefNode.fkAssociationRef.getObject().getObjectID();
                fKIndexAssociation = this.getFKIndexAssociation(fKColRefNode.fkAssocId);
                if (fKIndexAssociation != null) {
                    fKColRefNode.remoteTableId = fKIndexAssociation.getRemoteTable().getObjectID();
                    fKColRefNode.remoteKeyId = fKIndexAssociation.getKeyObject().getObjectID();
                    continue;
                }
                fKColRefNode.remoteTableId = "null";
                fKColRefNode.remoteKeyId = "null";
                continue;
            }
            fKColRefNode.fkAssocId = "null";
            fKColRefNode.remoteKeyId = "null";
            fKColRefNode.remoteTableId = "null";
        }
        return this.allrefs;
    }

    public List getAllDelegatesAndFK() {
        ArrayList<FK_And_Delegate_Holder> arrayList = new ArrayList<FK_And_Delegate_Holder>();
        for (FKColRefNode fKColRefNode : this.allrefs) {
            Column column;
            FKIndexAssociation fKIndexAssociation = null;
            if (fKColRefNode.fkAssocId != null) {
                fKIndexAssociation = this.getFKIndexAssociation(fKColRefNode.fkAssocId);
            } else if (fKColRefNode.fkAssociationRef != null) {
                fKColRefNode.fkAssocId = fKColRefNode.fkAssociationRef.getObject().getObjectID();
                fKIndexAssociation = this.getFKIndexAssociation(fKColRefNode.fkAssocId);
            }
            if (fKIndexAssociation == null || fKColRefNode.refColumnId == null || (column = (Column)fKIndexAssociation.getRemoteTable().getElementByID(fKColRefNode.refColumnId)) == null) continue;
            FK_And_Delegate_Holder fK_And_Delegate_Holder = new FK_And_Delegate_Holder();
            fK_And_Delegate_Holder.delegateColumn = column;
            fK_And_Delegate_Holder.fk = fKIndexAssociation;
            arrayList.add(fK_And_Delegate_Holder);
        }
        return arrayList;
    }

    public List getAllFKs() {
        ArrayList<FKIndexAssociation> arrayList = new ArrayList<FKIndexAssociation>();
        for (FKColRefNode fKColRefNode : this.allrefs) {
            FKIndexAssociation fKIndexAssociation = null;
            if (fKColRefNode.fkAssocId != null) {
                fKIndexAssociation = this.getFKIndexAssociation(fKColRefNode.fkAssocId);
            } else if (fKColRefNode.fkAssociationRef != null) {
                fKColRefNode.fkAssocId = fKColRefNode.fkAssociationRef.getObject().getObjectID();
                fKIndexAssociation = this.getFKIndexAssociation(fKColRefNode.fkAssocId);
            }
            if (fKIndexAssociation == null) continue;
            arrayList.add(fKIndexAssociation);
        }
        return arrayList;
    }

    public boolean isInFKinArc() {
        for (FKIndexAssociation fKIndexAssociation : this.getAllFKs()) {
            if (!fKIndexAssociation.isInArc()) continue;
            return true;
        }
        return false;
    }

    public boolean isInOptionalFK() {
        return this.getOptionalFK() != null;
    }

    public boolean isInMandatoryFK() {
        for (FKIndexAssociation fKIndexAssociation : this.getAllFKs()) {
            if (!fKIndexAssociation.isMandatory()) continue;
            return true;
        }
        return false;
    }

    public FKIndexAssociation getOptionalFK() {
        for (FKIndexAssociation fKIndexAssociation : this.getAllFKs()) {
            if (fKIndexAssociation.isMandatory()) continue;
            return fKIndexAssociation;
        }
        return null;
    }

    public boolean isPartOfFKIndexAssociation(FKIndexAssociation fKIndexAssociation) {
        FKColRefNode[] fKColRefNodeArray = this.allrefs.toArray(new FKColRefNode[0]);
        String string = fKIndexAssociation.getObjectID();
        for (int i = 0; i < fKColRefNodeArray.length; ++i) {
            if (string.equalsIgnoreCase(fKColRefNodeArray[i].fkAssocId)) {
                return true;
            }
            if (fKColRefNodeArray[i].fkAssociationRef == null) continue;
            return string.equalsIgnoreCase(fKColRefNodeArray[i].fkAssociationRef.getObject().getObjectID());
        }
        return false;
    }

    public Collection getFKAssociationsForDelegate(String string) {
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        for (FKColRefNode fKColRefNode : this.allrefs) {
            if (fKColRefNode.fkAssocId != null) {
                if (!fKColRefNode.refColumnId.equalsIgnoreCase(string)) continue;
                arrayList.add(this.getFKIndexAssociation(fKColRefNode.fkAssocId));
                continue;
            }
            if (fKColRefNode.fkAssociationRef == null || fKColRefNode.fkAssociationRef.getObject() == null || !fKColRefNode.refColumnId.equalsIgnoreCase(string)) continue;
            arrayList.add(fKColRefNode.fkAssociationRef.getObject());
        }
        return arrayList;
    }

    public void removeFKAssociation(FKIndexAssociationReference fKIndexAssociationReference) {
        FKColRefNode[] fKColRefNodeArray;
        if (this.fkAssociationReference == fKIndexAssociationReference) {
            fKColRefNodeArray = this.getReferencedColumn();
            this.fkAssociationReference = null;
            this.fkAssociationId = null;
            this.referencedColumnId = null;
            if (fKColRefNodeArray != null) {
                MergingModels.copyDataTypeFromCOWD_To_COWD((ContainedObjectWithDomain)fKColRefNodeArray, this, false);
            }
        }
        if (this.allrefs.size() > 0) {
            Iterator iterator;
            fKColRefNodeArray = this.allrefs.toArray(new FKColRefNode[0]);
            for (int i = 0; i < fKColRefNodeArray.length; ++i) {
                if (fKIndexAssociationReference != fKColRefNodeArray[i].fkAssociationRef && (fKIndexAssociationReference.getObject() == null || fKIndexAssociationReference.getObject() != fKColRefNodeArray[i].fkAssociationRef.getObject())) continue;
                this.allrefs.remove(fKColRefNodeArray[i]);
                break;
            }
            if ((iterator = this.allrefs.iterator()).hasNext()) {
                FKColRefNode fKColRefNode = (FKColRefNode)iterator.next();
                this.fkAssociationReference = fKColRefNode.fkAssociationRef;
                this.fkAssociationId = fKColRefNode.fkAssocId;
                this.referencedColumnId = fKColRefNode.refColumnId;
            }
        }
    }

    public void removeFKAssociation(String string) {
        FKColRefNode[] fKColRefNodeArray;
        if (this.fkAssociationId != null && this.fkAssociationId.equalsIgnoreCase(string)) {
            fKColRefNodeArray = this.getReferencedColumn();
            this.fkAssociationReference = null;
            this.fkAssociationId = null;
            this.referencedColumnId = null;
            if (fKColRefNodeArray != null) {
                MergingModels.copyDataTypeFromCOWD_To_COWD((ContainedObjectWithDomain)fKColRefNodeArray, this, false);
            }
        }
        if (this.allrefs.size() > 0) {
            Iterator iterator;
            fKColRefNodeArray = this.allrefs.toArray(new FKColRefNode[0]);
            for (int i = 0; i < fKColRefNodeArray.length; ++i) {
                if (!string.equalsIgnoreCase(fKColRefNodeArray[i].fkAssocId) && (fKColRefNodeArray[i].fkAssociationRef == null || fKColRefNodeArray[i].fkAssociationRef.getObject() == null || !string.equalsIgnoreCase(fKColRefNodeArray[i].fkAssociationRef.getObject().getObjectID()))) continue;
                this.allrefs.remove(fKColRefNodeArray[i]);
                break;
            }
            if ((iterator = this.allrefs.iterator()).hasNext()) {
                FKColRefNode fKColRefNode = (FKColRefNode)iterator.next();
                this.fkAssociationReference = fKColRefNode.fkAssociationRef;
                this.fkAssociationId = fKColRefNode.fkAssocId;
                this.referencedColumnId = fKColRefNode.refColumnId;
            } else {
                this.fkAssociationReference = null;
                this.fkAssociationId = null;
                this.referencedColumnId = null;
            }
        }
    }

    private FKIndexAssociation getFKIndexAssociation(String string) {
        if (this.getContainerWithKeyObject() == null) {
            return null;
        }
        Index[] indexArray = (Index[])this.getContainerWithKeyObject().getKeys();
        for (int i = 0; i < indexArray.length; ++i) {
            if (!indexArray[i].isFK() || !indexArray[i].getFKAssociation().getObjectID().equalsIgnoreCase(string)) continue;
            return indexArray[i].getFKAssociation();
        }
        return null;
    }

    public boolean hasCircularRef() {
        this.checkedCols = new ArrayList();
        if (this.isFKColumn()) {
            for (FKColRefNode fKColRefNode : this.getRefColAndAssocIDs()) {
                Column column = (Column)this.getDesign().getDesignObject(fKColRefNode.refColumnId);
                if (column == null) continue;
                if (this == column) {
                    return true;
                }
                if (this.checkedCols.contains(column)) continue;
                this.checkedCols.add(column);
                boolean bl = this.testColumn(column);
                if (!bl) continue;
                return bl;
            }
        }
        return false;
    }

    private boolean testColumn(Column column) {
        if (column.isFKColumn()) {
            for (FKColRefNode fKColRefNode : column.getRefColAndAssocIDs()) {
                Column column2 = (Column)this.getDesign().getDesignObject(fKColRefNode.refColumnId);
                if (column2 == null) continue;
                if (this == column2) {
                    return true;
                }
                if (this.checkedCols.contains(column2)) continue;
                this.checkedCols.add(column2);
                boolean bl = this.testColumn(column2);
                if (!bl) continue;
                return bl;
            }
        }
        return false;
    }

    @Override
    public Domain getDomain() {
        if (this.fkAssociationId != null && this.referencedColumnId != null && !this.referencedColumnId.equalsIgnoreCase(this.getObjectID())) {
            if (this.getReferencedColumn() != null && !this.hasCircularRef()) {
                return this.getReferencedColumn().getDomain();
            }
            return super.getDomain();
        }
        return super.getDomain();
    }

    @Override
    public short getUse() {
        if (this.fkAssociationId != null && this.referencedColumnId != null && !this.referencedColumnId.equalsIgnoreCase(this.getObjectID())) {
            if (this.getReferencedColumn() != null && !this.hasCircularRef()) {
                return this.getReferencedColumn().getUse();
            }
            return super.getUse();
        }
        return super.getUse();
    }

    @Override
    public Datatype getDataType() {
        if (!(this.fkAssociationId == null || this.referencedColumnId == null || this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) || this.getUse() == 3 && this.isReference() || this.getReferencedColumn() == null || this.getReferencedColumn().isOid() || this.hasCircularRef())) {
            return this.getReferencedColumn().getDataType();
        }
        return super.getDataType();
    }

    @Override
    public Datatype getDataType(String string) {
        if (this.fkAssociationId != null && this.referencedColumnId != null && !this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) && this.getReferencedColumn() != null && !this.hasCircularRef()) {
            return this.getReferencedColumn().getDataType(string);
        }
        return super.getDataType(string);
    }

    @Override
    public String getDataTypeParameter(String string) {
        if (this.fkAssociationId != null && this.referencedColumnId != null && !this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) && this.getReferencedColumn() != null && !this.hasCircularRef()) {
            return this.getReferencedColumn().getDataTypeParameter(string);
        }
        return super.getDataTypeParameter(string);
    }

    @Override
    public String getDatatypeString(String string) {
        if (this.fkAssociationId != null && this.referencedColumnId != null && !this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) && this.getReferencedColumn() != null && !this.hasCircularRef()) {
            return this.getReferencedColumn().getDatatypeString(string);
        }
        return super.getDatatypeString(string);
    }

    public String getDatatypeText() {
        DistinctType distinctType;
        String string;
        Datatype datatype = this.getDataType();
        if (datatype instanceof StructuredType && this.isReference()) {
            return "REF " + datatype.toString();
        }
        if (datatype instanceof DistinctType) {
            string = this.getSelectedRDBMSType().toString();
            if (string.startsWith("DB2")) {
                return datatype.getName();
            }
            datatype = this.getDataType(string);
        }
        string = "";
        if (datatype != null) {
            string = datatype.toString();
        }
        if (this.getUse() == 0) {
            string = string + " {" + this.getDomain().getName() + "}";
        } else if (this.getUse() == 1) {
            string = string + " [" + this.getLogicalDatatype().getName() + "]";
        } else if (this.getUse() == 2 && (distinctType = this.getDistinctType()) != null) {
            string = string + " [" + distinctType.getName() + "]";
        }
        return string;
    }

    @Override
    public LogicalDatatype getLogicalDatatype() {
        if (this.fkAssociationId != null && this.referencedColumnId != null && !this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) && this.getReferencedColumn() != null && !this.hasCircularRef()) {
            return this.getReferencedColumn().getLogicalDatatype();
        }
        return super.getLogicalDatatype();
    }

    @Override
    public DistinctType getDistinctType() {
        if (this.fkAssociationId != null && this.referencedColumnId != null && !this.referencedColumnId.equalsIgnoreCase(this.getObjectID()) && this.getReferencedColumn() != null && !this.hasCircularRef()) {
            return this.getReferencedColumn().getDistinctType();
        }
        return super.getDistinctType();
    }

    @Override
    public void addAVT(AVT aVT) {
        if (!this.getUseDomainConstraints()) {
            super.addAVT(aVT);
        }
    }

    @Override
    public Set getAVTs() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getAVTs();
        }
        return super.getAVTs();
    }

    @Override
    public void removeAVT(AVT aVT) {
        if (!this.getUseDomainConstraints()) {
            super.removeAVT(aVT);
        }
    }

    @Override
    public void clearAVTs() {
        if (!this.getUseDomainConstraints()) {
            super.clearAVTs();
        }
    }

    public String getAVTString() {
        return "View";
    }

    @Override
    public ConstraintEnumeration getValueList() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getValueList();
        }
        return super.getValueList();
    }

    @Override
    public void setValueList(ConstraintEnumeration constraintEnumeration) {
        if (!this.getUseDomainConstraints()) {
            super.setValueList(constraintEnumeration);
        }
    }

    @Override
    public CheckConstraint getCheck() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getCheck();
        }
        return super.getCheck();
    }

    @Override
    public void setCheck(CheckConstraint checkConstraint) {
        if (!this.getUseDomainConstraints()) {
            super.setCheck(checkConstraint);
        }
    }

    public void loadDelegate() {
        Column column = (Column)this.getDesign().getDesignObject(this.referencedColumnId);
        this.setDelegate(column);
    }

    public boolean isAdapterLoaded() {
        return this.delegate != null;
    }

    public void setDelegate(Column column) {
        this.delegate = column;
    }

    public Column getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.getReferencedColumn();
    }

    @Override
    public void setDomain(Domain domain) {
        if (this.getReferencedColumn() != null && !this.hasCircularRef()) {
            this.getReferencedColumn().setDomain(domain);
        } else {
            super.setDomain(domain);
        }
    }

    private boolean isRealFKPlaceHolder() {
        return this.realFKPlaceHolder;
    }

    public void setRealFKPlaceHolder(boolean bl) {
        this.realFKPlaceHolder = bl;
    }

    @Override
    public boolean hasAliveGenerator() {
        DesignObject designObject;
        AttributeSet attributeSet = this.getDesign().getLogicalDesign().getAttributeSet();
        return ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID()) || (designObject = attributeSet.getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnPropertiesDialogEx columnPropertiesDialogEx = new ColumnPropertiesDialogEx(this.getDesign().getAppView(), this, false);
            columnPropertiesDialogEx.initProperties(this);
            columnPropertiesDialogEx.show();
        }
    }

    public Attribute getEngAttribute() {
        RepositoryObject repositoryObject;
        Attribute attribute;
        MappingCollector mappingCollector = this.getRMExtendedMap().getOrCreateCollector(this);
        List list = mappingCollector.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (attribute = (Attribute)(repositoryObject = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null) {
            return attribute;
        }
        repositoryObject = null;
        repositoryObject = (Attribute)this.getGenerator();
        if (repositoryObject == null) {
            if (!ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID())) {
                repositoryObject = (Attribute)this.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(this.getGeneratorID());
            }
            if (repositoryObject == null) {
                repositoryObject = (Attribute)this.getDesign().getLogicalDesign().getAttributeSet().getObjectGeneratedBy(this.getObjectID());
            }
        }
        return repositoryObject;
    }

    public Attribute getEngAttribute(Entity entity) {
        List list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                Attribute attribute = (Attribute)xtdMapping.getObjectMappedTo(this);
                if (attribute == null || attribute.getContainerWithKeyObject() != entity) continue;
                return attribute;
            }
        }
        return null;
    }

    public XtdMapping getMappingFor(Entity entity) {
        List list;
        if (entity != null && (list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID())).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                Attribute attribute = (Attribute)xtdMapping.getObjectMappedTo(this);
                if (attribute == null || attribute.getContainerWithKeyObject() != entity) continue;
                return xtdMapping;
            }
        }
        return null;
    }

    public List getMappingsFor(Entity entity) {
        List list;
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        if (entity != null && (list = this.getRMExtendedMap().getMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID())).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                Attribute attribute = (Attribute)xtdMapping.getObjectMappedTo(this);
                if (attribute == null || attribute.getContainerWithKeyObject() != entity) continue;
                arrayList.add(xtdMapping);
            }
        }
        return arrayList;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public void copy(DesignObject designObject) {
        Column column = (Column)designObject;
        super.copy(column);
        column.setOid(this.isOid());
        column.setNullsAllowed(this.getNullsAllowed());
        column.setUse(this.getUse());
        if (this.getUse() == 0) {
            column.setDomain(this.getDomain());
        } else if (this.getUse() == 1) {
            column.setLogicalDatatype(this.getLogicalDatatype());
        } else if (this.getUse() == 3) {
            column.setStructuredType(this.getStructuredType());
            List list = column.getPermittedSubTypes();
            list.clear();
            list.addAll(this.getPermittedSubTypes());
        } else if (this.getUse() == 4) {
            column.setCollectionType(this.getCollectionType());
        } else if (this.getUse() == 2) {
            column.setDistinctType(this.getDistinctType());
        }
        column.setReference(this.isReference());
        if (this.getUse() == 1) {
            column.setDataTypeParameter("size", this.getSize());
            column.setDataTypeParameter("precision", this.getPrecision());
            column.setDataTypeParameter("scale", this.getScale());
        }
        column.setPreviousColumn(this.isPreviousColumn());
        column.setUsesDefaultValue(this.getUsesDefaultValue());
        column.setUseDomainConstraints(this.getUseDomainConstraints());
        column.setConstraintName(this.getConstraintName());
        column.setNotNullConstraintName(this.getNotNullConstraintName());
        column.setDefaultValue(this.getDefaultValue());
        column.setSourceType(this.getSourceType());
        column.setComputed(this.isComputed());
        column.setFormulaDesc(this.getFormulaDesc());
        column.setScopeId(this.getScopeId());
        column.setAllowSubtypeSubstitution(this.isAllowSubtypeSubstitution());
        column.setRestrictedTypeSubstitution(this.isRestrictedTypeSubstitution());
        column.setAbbreviation(this.getAbbreviation());
        column.setDefaultLabel(this.getDefaultLabel());
        column.setDefaultFormatMask(this.getDefaultFormatMask());
        column.setDefaultFormDisplayWidth(this.getDefaultFormDisplayWidth());
        column.setDefaultFormMaximumWidth(this.getDefaultFormMaximumWidth());
        column.setDefaultFormHeight(this.getDefaultFormHeight());
        column.setDefaultHelpText(this.getDefaultHelpText());
        column.setDefaultReadOnly(this.isDefaultReadOnly());
        column.setDefaultDisplayedOnReports(this.isDefaultDisplayedOnReports());
        column.setDefaultDisplayedOnForms(this.isDefaultDisplayedOnForms());
        column.setDefaultDisplayAs(this.getDefaultDisplayAs());
        column.setContainsPII(this.isContainsPII());
        column.setContainsSensitiveInformation(this.isContainsSensitiveInformation());
        column.setMaskData(this.isMaskData());
        column.setAutoIncrementColumn(this.isAutoIncrementColumn());
        column.setIdentityColumn(this.isIdentityColumn());
        column.setAutoIncrementGenerateAlways(this.isAutoIncrementGenerateAlways());
        column.setAutoIncrementStartWith(this.getAutoIncrementStartWith());
        column.setAutoIncrementIncrementBy(this.getAutoIncrementIncrementBy());
        column.setAutoIncrementMinValue(this.getAutoIncrementMinValue());
        column.setAutoIncrementMaxValue(this.getAutoIncrementMaxValue());
        column.setAutoIncrementCycle(this.isAutoIncrementCycle());
        column.setAutoIncrementDisableCache(this.isAutoIncrementDisableCache());
        column.setAutoIncrementCache(this.getAutoIncrementCache());
        column.setAutoIncrementOrder(this.isAutoIncrementOrder());
        column.setAutoIncrementSequenceName(this.getAutoIncrementSequenceName());
        column.setAutoIncrementTriggerName(this.getAutoIncrementTriggerName());
        column.setAutoIncrementGenerateTrigger(this.isAutoIncrementGenerateTrigger());
        if (!this.getUseDomainConstraints()) {
            EngCOPropertiesComparator.copyCheckConstraint(this, column);
            EngCOPropertiesComparator.copyRangeConstraint(this, column);
            EngCOPropertiesComparator.copyLOVConstraint(this, column);
        }
    }

    public void importColumn(DesignObject designObject) {
        Object object4;
        Object object2;
        Column column = (Column)designObject;
        super.copy(column);
        column.setDesignObjectSet(this.getDesignObjectSet());
        column.setUnique(this.isUnique());
        column.setNullsAllowed(this.getNullsAllowed());
        column.setUse(this.getUse());
        column.setReference(this.isReference());
        if (this.getDomain() != null) {
            object2 = this.getDomain();
            object4 = (Domain)column.getDesign().getDomainSet().getByName(((DesignObject)object2).getName());
            if (object4 != null) {
                column.setDomain((Domain)object4);
            } else {
                object4 = object2;
                object4.copy((DesignObject)object2);
                object4.setDesign(column.getDesign());
                object4.setOwnerDesign(column.getDesign());
                object4.setDirty(true);
                column.getDesign().getDomainSet().add((DesignObject)object4);
                column.setDomain((Domain)object4);
            }
        }
        column.setLogicalDatatype(this.getLogicalDatatype());
        column.setDataTypeParameter("size", this.getSize());
        column.setDataTypeParameter("precision", this.getPrecision());
        column.setDataTypeParameter("scale", this.getScale());
        column.setUsesDefaultValue(this.getUsesDefaultValue());
        column.setUseDomainConstraints(this.getUseDomainConstraints());
        column.setDefaultValue(this.getDefaultValue());
        column.setComputed(this.isComputed());
        column.setSourceType(this.getSourceType());
        column.setFormulaDesc(this.getFormulaDesc());
        column.setScopeId(this.getScopeId());
        column.setAllowSubtypeSubstitution(this.isAllowSubtypeSubstitution());
        if (!this.getUseDomainConstraints() && (object2 = this.getCheck()) != null) {
            object4 = new CheckConstraint();
            column.setCheck((CheckConstraint)object4);
            if (column.getCheck().getDesign() == null) {
                column.getCheck().setDesign(column.getDesign());
            }
            ((AbstractConstraint)object2).copyTo((Constraint)object4);
        }
        if (!this.getUseDomainConstraints()) {
            Object object3;
            for (Object object4 : this.getAVTs()) {
                object3 = new AVT(object4.getBeginValue(), object4.getEndValue(), object4.getDescription());
                column.addAVT((AVT)object3);
            }
            if (this.getValueList() != null && ((Object[])(object4 = this.getValues().toArray())).length > 0) {
                if (column.getValueList() == null) {
                    object3 = new ConstraintEnumeration();
                    column.setValueList((ConstraintEnumeration)object3);
                }
                this.getValueList().copyTo(column.getValueList());
            }
        }
        column.setImportedId(this.getObjectID());
        column.setImportedDesign(this.getDesign());
    }

    @Override
    public boolean isAtomic() {
        return this.getStructuredType() == null || this.isReference();
    }

    public Column getOriginatingColumn() {
        if (!this.isFKColumn()) {
            return null;
        }
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(this);
        Column column = this.getDelegate();
        if (column != null) {
            boolean bl = false;
            while (!bl) {
                arrayList.add(column);
                if (column.isFKColumn()) {
                    if (!arrayList.contains(column = column.getDelegate())) continue;
                    column = null;
                    bl = true;
                    continue;
                }
                bl = true;
            }
        }
        return column;
    }

    public Column getOriginatingColumn(FKIndexAssociation fKIndexAssociation) {
        if (!this.isFKColumn()) {
            return null;
        }
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(this);
        Column column = this.getReferencedColumn(fKIndexAssociation);
        boolean bl = false;
        while (!bl) {
            arrayList.add(column);
            if (column.isFKColumn()) {
                if (!arrayList.contains(column = column.getDelegate())) continue;
                column = null;
                bl = true;
                continue;
            }
            bl = true;
        }
        return column;
    }

    public boolean shouldBeEngineered(XtdMapping xtdMapping) {
        Entity entity;
        DesignObject designObject;
        if (this.isFKColumn() && (designObject = xtdMapping.getObjectMappedTo(this.getContainerWithKeyObject())) != null && designObject instanceof Entity && this.getMappingFor(entity = (Entity)designObject) == null) {
            Iterator iterator = this.getAllFKs().iterator();
            if (iterator.hasNext()) {
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
                if (fKIndexAssociation.shouldBeEngineered() || fKIndexAssociation.getEngRelation(entity) != null) {
                    Index index = fKIndexAssociation.getRemoteIndex();
                    if (index.shouldBeEngineered() || index.getMappingFor(entity) != null) {
                        if (index.getMappingFor(entity) != null) {
                            return xtdMapping.getColumns().contains(this.getObjectID());
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        return xtdMapping.getColumns().contains(this.getObjectID());
    }

    @Override
    public void setStructuredType(StructuredType structuredType) {
        super.setStructuredType(structuredType);
        if (structuredType != null && this.getContainerWithKeyObject() != null && !this.getContainerWithKeyObject().isBackup()) {
            structuredType.addObjectListener(this);
        }
    }

    public boolean hasAssignedUIDefaults() {
        return this.defaultLabel != null || this.defaultFormatMask != null || this.defaultFormDisplayWidth != null || this.defaultFormMaximumWidth != null || this.defaultFormHeight != null || this.defaultHelpText != null || this.defaultReadOnly || !this.defaultDisplayedOnReports || !this.defaultDisplayedOnForms || !DISPLAY_AS_TEXT.equals(this.defaultDisplayAs);
    }

    public void setAbbreviation(String string) {
        this.abbreviation = string;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setComputed(Boolean bl) {
        this.computed = bl;
    }

    public Boolean isComputed() {
        return this.computed;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String string) {
        this.defaultLabel = string;
    }

    public String getDefaultFormatMask() {
        return this.defaultFormatMask;
    }

    public void setDefaultFormatMask(String string) {
        this.defaultFormatMask = string;
    }

    public Integer getDefaultFormDisplayWidth() {
        return this.defaultFormDisplayWidth;
    }

    public void setDefaultFormDisplayWidth(Integer n) {
        this.defaultFormDisplayWidth = n;
    }

    public Integer getDefaultFormMaximumWidth() {
        return this.defaultFormMaximumWidth;
    }

    public void setDefaultFormMaximumWidth(Integer n) {
        this.defaultFormMaximumWidth = n;
    }

    public Integer getDefaultFormHeight() {
        return this.defaultFormHeight;
    }

    public void setDefaultFormHeight(Integer n) {
        this.defaultFormHeight = n;
    }

    public String getDefaultHelpText() {
        return this.defaultHelpText;
    }

    public void setDefaultHelpText(String string) {
        this.defaultHelpText = string;
    }

    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean bl) {
        this.defaultReadOnly = bl;
    }

    public boolean isDefaultDisplayedOnReports() {
        return this.defaultDisplayedOnReports;
    }

    public void setDefaultDisplayedOnReports(boolean bl) {
        this.defaultDisplayedOnReports = bl;
    }

    public boolean isDefaultDisplayedOnForms() {
        return this.defaultDisplayedOnForms;
    }

    public void setDefaultDisplayedOnForms(boolean bl) {
        this.defaultDisplayedOnForms = bl;
    }

    public String getDefaultDisplayAs() {
        return this.defaultDisplayAs;
    }

    public void setDefaultDisplayAs(String string) {
        this.defaultDisplayAs = string;
    }

    public Boolean isContainsPII() {
        return this.containsPII;
    }

    public void setContainsPII(Boolean bl) {
        this.containsPII = bl;
    }

    public Boolean isContainsSensitiveInformation() {
        return this.containsSensitiveInformation;
    }

    public void setContainsSensitiveInformation(Boolean bl) {
        this.containsSensitiveInformation = bl;
    }

    public Boolean isMaskData() {
        return this.maskData;
    }

    public void setMaskData(Boolean bl) {
        this.maskData = bl;
    }

    public List getFKAssociationMaps() {
        ArrayList arrayList = new ArrayList();
        try {
            for (FKColRefNode fKColRefNode : this.getRefColAndAssocIDs()) {
                FKIndexAssociation fKIndexAssociation;
                if (fKColRefNode.fkAssocId == null || (fKIndexAssociation = this.getFKIndexAssociation(fKColRefNode.fkAssocId)) == null) continue;
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                treeMap.put(REFERRED_COLUMN, fKColRefNode.refColumnId);
                treeMap.put(FK_ASSOCIATION, fKColRefNode.fkAssocId);
                arrayList.add(treeMap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public void addFKAssociationMaps(List list) {
        for (Object e : list) {
            if (!(e instanceof Map)) continue;
            Map map = (Map)e;
            String string = (String)map.get(REFERRED_COLUMN);
            String string2 = (String)map.get(FK_ASSOCIATION);
            if (string == null || string2 == null) continue;
            this.addFKAssociation(string, string2);
        }
    }

    @Override
    public void setDirty(boolean bl) {
        super.setDirty(bl);
    }

    public boolean isAutoIncrementColumn() {
        return this.autoIncrementColumn;
    }

    public void setAutoIncrementColumn(boolean bl) {
        this.autoIncrementColumn = bl;
    }

    public boolean isIdentityColumn() {
        return this.identityColumn;
    }

    public void setIdentityColumn(boolean bl) {
        Table table;
        if (bl && (table = (Table)this.getParent()) != null) {
            for (Object e : table.getElementsCollection()) {
                if (e == this) continue;
                ((Column)e).setIdentityColumn(false);
            }
        }
        this.identityColumn = bl;
    }

    public boolean isAutoIncrementGenerateAlways() {
        return this.autoIncrementGenerateAlways;
    }

    public void setAutoIncrementGenerateAlways(boolean bl) {
        this.autoIncrementGenerateAlways = bl;
    }

    public String getAutoIncrementStartWith() {
        return this.autoIncrementStartWith;
    }

    public void setAutoIncrementStartWith(String string) {
        this.autoIncrementStartWith = string;
    }

    public Integer getAutoIncrementIncrementBy() {
        return this.autoIncrementIncrementBy;
    }

    public void setAutoIncrementIncrementBy(Integer n) {
        this.autoIncrementIncrementBy = n;
    }

    public String getAutoIncrementMinValue() {
        return this.autoIncrementMinValue;
    }

    public void setAutoIncrementMinValue(String string) {
        this.autoIncrementMinValue = string;
    }

    public String getAutoIncrementMaxValue() {
        return this.autoIncrementMaxValue;
    }

    public void setAutoIncrementMaxValue(String string) {
        this.autoIncrementMaxValue = string;
    }

    public boolean isAutoIncrementCycle() {
        return this.autoIncrementCycle;
    }

    public void setAutoIncrementCycle(boolean bl) {
        this.autoIncrementCycle = bl;
    }

    public boolean isAutoIncrementDisableCache() {
        return this.autoIncrementDisableCache;
    }

    public void setAutoIncrementDisableCache(boolean bl) {
        this.autoIncrementDisableCache = bl;
    }

    public Integer getAutoIncrementCache() {
        return this.autoIncrementCache;
    }

    public void setAutoIncrementCache(Integer n) {
        this.autoIncrementCache = n;
    }

    public boolean isAutoIncrementOrder() {
        return this.autoIncrementOrder;
    }

    public void setAutoIncrementOrder(boolean bl) {
        this.autoIncrementOrder = bl;
    }

    public String getAutoIncrementSequenceName() {
        return this.autoIncrementSequenceName;
    }

    public void setAutoIncrementSequenceName(String string) {
        this.autoIncrementSequenceName = string;
    }

    public String getAutoIncrementTriggerName() {
        return this.autoIncrementTriggerName;
    }

    public void setAutoIncrementTriggerName(String string) {
        this.autoIncrementTriggerName = string;
    }

    public boolean isAutoIncrementGenerateTrigger() {
        return this.autoIncrementGenerateTrigger;
    }

    public void setAutoIncrementGenerateTrigger(boolean bl) {
        this.autoIncrementGenerateTrigger = bl;
    }

    public String getNotNullConstraintName() {
        return this.notNullConstraintName;
    }

    public void setNotNullConstraintName(String string) {
        this.notNullConstraintName = string;
    }

    public boolean hasOtherFK_forRelation(FKIndexAssociation fKIndexAssociation, Relation relation) {
        for (FKIndexAssociation fKIndexAssociation2 : this.getAllFKs()) {
            if (fKIndexAssociation2 == fKIndexAssociation || !fKIndexAssociation2.getGeneratorID().equals(relation.getObjectID()) && !relation.getGeneratorID().equals(fKIndexAssociation2.getObjectID())) continue;
            return true;
        }
        return false;
    }

    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }

    public class DelegateHolder {
        public String fkid;
        public String delegateID;
    }

    public class FKColRefNode {
        public String fkAssocId;
        public String refColumnId;
        public String remoteKeyId;
        public String remoteTableId;
        public FKIndexAssociationReference fkAssociationRef;
    }

    public class FK_And_Delegate_Holder {
        public Column delegateColumn;
        public FKIndexAssociation fk;
    }
}

