/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.util.GUID;

public class TransformationTaskSet
extends ModelIDObjectSet {
    private static final ModelIDObject[] PROTO_ARRAY = new TransformationTask[0];
    private Object elDescriptor;
    private ProcessModel processModel;
    private Design dsn;
    private TransformationPackage transformationPackage;

    public TransformationTaskSet(ProcessModel processModel) {
        this.processModel = processModel;
        this.setDesign(processModel.getDesign());
        this.setElementDescriptor(TransformationTask.class);
    }

    @Override
    public ModelIDObject createElement(String string) {
        TransformationTask transformationTask = new TransformationTask(this.getProcessModel(), this.transformationPackage);
        transformationTask.setDesign(this.getDesign());
        if (string == null || "".equalsIgnoreCase(string)) {
            transformationTask.setObjectID(new GUID().toString());
        } else {
            transformationTask.setObjectID(string);
        }
        transformationTask.setName(this.createName());
        transformationTask.setParent(this);
        this.add(transformationTask);
        return transformationTask;
    }

    @Override
    protected String createName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDefaultNamePrefix());
        stringBuffer.append(this.getSeparator());
        int n = this.size() + 1;
        while (this.getByName(stringBuffer.toString() + String.valueOf(n)) != null) {
            ++n;
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "Transformation Task";
    }

    @Override
    public boolean canCreateElement() {
        return true;
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    public Object getElementDescriptor() {
        return this.elDescriptor;
    }

    public void setElementDescriptor(Object object) {
        this.elDescriptor = object;
    }

    @Override
    public Design getDesign() {
        return this.dsn;
    }

    @Override
    public void setDesign(Design design) {
        this.dsn = design;
    }

    public TransformationPackage getTransformationPackage() {
        return this.transformationPackage;
    }

    public void setTransformationPackage(TransformationPackage transformationPackage) {
        this.transformationPackage = transformationPackage;
        this.setParent(transformationPackage);
    }
}

