/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;

public class TargetElement
implements ID_ObjectPropertyTranslator {
    private DesignObject target;
    private List sources = new ArrayList();
    private String transformationType = Transformation.TRANSFORMATION_TYPES[0];
    private String Description = "";
    private String objectID;
    private String name;
    private DesignPart designPart;
    private Process process;

    public TargetElement(DesignPart designPart) {
        this.designPart = designPart;
    }

    public TargetElement(DesignObject designObject) {
        this.target = designObject;
        this.designPart = designObject.getDesignPart();
    }

    public TargetElement(DesignObject designObject, Process process) {
        this.target = designObject;
        this.designPart = designObject.getDesignPart();
        this.process = process;
    }

    public TargetElement(TargetElement targetElement) {
        this.target = targetElement.getTarget();
        this.sources.addAll(targetElement.getSources());
        this.transformationType = targetElement.getTransformationType();
        this.Description = targetElement.getDescription();
        this.designPart = this.target.getDesignPart();
    }

    public DesignObject getTarget() {
        return this.target;
    }

    public void setTarget(DesignObject designObject) {
        this.target = designObject;
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String string) {
        this.Description = string;
    }

    public List getSources() {
        return this.sources;
    }

    public void addSource(DesignObject designObject) {
        this.sources.add(designObject);
    }

    public void removeSource(DesignObject designObject) {
        this.sources.remove(designObject);
    }

    public DesignObject getSourceByID(String string) {
        for (DesignObject designObject : this.sources) {
            if (!designObject.getObjectID().equals(string)) continue;
            return designObject;
        }
        return null;
    }

    public String getTransformationType() {
        return this.transformationType;
    }

    public void setTransformationType(String string) {
        this.transformationType = string;
    }

    public String getObjectID() {
        if (this.target != null) {
            return this.target.getObjectID();
        }
        return this.objectID;
    }

    public void setObjectID(String string) {
        this.objectID = string;
    }

    public String getName() {
        if (this.target != null) {
            return this.target.getName();
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        Object object = null;
        if (this.process != null && (object = this.process.translateIdToObject(string, string2)) != null) {
            return object;
        }
        Design design = this.designPart.getDesign();
        if (design != null) {
            object = design.getDesignObject(string2);
            return object;
        }
        return null;
    }

    @Override
    public String translateObjectToID(String string, Object object) {
        if (object != null && object instanceof ModelIDObject) {
            return ((ModelIDObject)object).getObjectID();
        }
        return null;
    }

    public void setProcess(Process process) {
        this.process = process;
    }
}

