/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.MeasurementSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesignSet;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.EventSet;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ExternalDataSet;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStoreSet;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.InfoStructureSet;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.model.design.process.RecordStructureSet;
import oracle.dbtools.crest.model.design.process.Role;
import oracle.dbtools.crest.model.design.process.RoleSet;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationPackageSet;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.process.ProcessModelPropertiesDialog;
import oracle.dbtools.crest.util.GUID;

public class ProcessModel
extends DesignPart
implements ModelObjectSetListener,
DesignListener {
    public static final String OBJECT_TYPE_NAME = "Process Model";
    public static final String REC_STRUCTURE_SET_NAME = "Record Structures";
    public static final String EXT_DATA_SET_NAME = "External Datas";
    public static final String EVENT_SET_NAME = "Events";
    public static final String INFOSTRUCTURE_SET_NAME = "Information Structures";
    public static final String STORE_SET_NAME = "Information Stores";
    public static final String ROLE_SET_NAME = "Roles";
    private EventSet eventSet;
    private InfoStructureSet infoStructureSet;
    private InfoStoreSet infoStoreSet;
    private RoleSet roleSet;
    private DataFlowDesign dataFlowDesign;
    private DataFlowDesignSet dfdSet;
    private TransformationPackageSet trPackageSet;
    private MeasurementSet measurementSet;
    private DesignObjectCollection topDataFlowDesigns = new DesignObjectCollection();
    private TransformationPackage transformationPackage;
    private TransformationTask transformationTask;
    private ExternalDataSet extDataSet;
    private RecordStructureSet recStructureSet;
    private boolean hasOpenedDFDesigns = false;
    private Map entityFlowMap = new TreeMap();
    private Map attributeFlowMap = new TreeMap();

    public ProcessModel(Design design) {
        this.setDesign(design);
        this.createDataFlowDesignSet();
        this.topDataFlowDesigns.setName(Messages.getString("ProcessModel.DataFlowDiagrams"));
        this.topDataFlowDesigns.setElementDescriptor(DataFlowDesignSet.class);
        this.topDataFlowDesigns.setParent(this);
        this.topDataFlowDesigns.setDesign(design.getDesign());
        this.setDirty(true);
    }

    public static final String getDataFlowDesignSetName() {
        return Messages.getString("ProcessModel.DataFlowDiagrams");
    }

    private void createDataFlowDesignSet() {
        this.dfdSet = new DataFlowDesignSet(this);
        this.dfdSet.setDesign(this.getDesign());
        this.dfdSet.setName(Messages.getString("ProcessModel.DataFlowDiagrams"));
        this.dfdSet.setElementDescriptor(DataFlowDesign.class);
        this.dfdSet.setParent(this);
        this.dfdSet.addSetListener(this);
    }

    @Override
    public String getName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String toString() {
        return Messages.getString("ProcessModel.ProcessModel");
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList arrayList = new ArrayList();
        this.getDataFlowDesigns().addAllElementsTo(arrayList);
        this.getRecordStructureSet().addAllElementsTo(arrayList);
        this.getExternalDataSet().addAllElementsTo(arrayList);
        this.getEventSet().addAllElementsTo(arrayList);
        this.getInfoStructureSet().addAllElementsTo(arrayList);
        this.getInfoStoreSet().addAllElementsTo(arrayList);
        this.getRoleSet().addAllElementsTo(arrayList);
        this.getTransformationPackageSet().addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getNumberOfChildren() {
        return 7;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.topDataFlowDesigns;
            }
            case 1: {
                return this.getInfoStructureSet();
            }
            case 2: {
                return this.getEventSet();
            }
            case 3: {
                return this.getInfoStoreSet();
            }
            case 4: {
                return this.getRoleSet();
            }
            case 5: {
                return this.getRecordStructureSet();
            }
            case 6: {
                return this.getTransformationPackageSet();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.topDataFlowDesigns) {
            return 0;
        }
        if (modelObject == this.getInfoStructureSet()) {
            return 1;
        }
        if (modelObject == this.getEventSet()) {
            return 2;
        }
        if (modelObject == this.getInfoStoreSet()) {
            return 3;
        }
        if (modelObject == this.getRoleSet()) {
            return 4;
        }
        if (modelObject == this.getRecordStructureSet()) {
            return 5;
        }
        if (modelObject == this.getTransformationPackageSet()) {
            return 6;
        }
        return -1;
    }

    public DataFlowDesign addDataFlowDesign(String string) {
        DataFlowDesign dataFlowDesign = (DataFlowDesign)this.dfdSet.createElement(null);
        dataFlowDesign.setDesign(this.getDesign());
        if (string != null) {
            dataFlowDesign.setName(string);
        }
        this.getDesign().setModelListChanged(true);
        return dataFlowDesign;
    }

    public DataFlowDesign addDataFlowDesign() {
        return this.addDataFlowDesign(null);
    }

    public DataFlowDesign addDataFlowDesign(String string, boolean bl) {
        DataFlowDesign dataFlowDesign = (DataFlowDesign)this.dfdSet.createElement(null, bl);
        dataFlowDesign.setDesign(this.getDesign());
        if (string != null) {
            dataFlowDesign.setName(string);
        }
        this.setDirty(true);
        this.getDesign().setDirty(true);
        this.getDesign().setModelListChanged(true);
        return dataFlowDesign;
    }

    public void showAllDataFlowDesigns() {
        Iterator iterator = this.dfdSet.iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            if (!dataFlowDesign.isLoaded()) continue;
            dataFlowDesign.setMainViewVisible(true);
        }
    }

    public void clearDesign() {
        Object[] objectArray = this.dfdSet.toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)objectArray[i];
            if (dataFlowDesign.isClean()) continue;
            dataFlowDesign.clearDesignPart();
        }
        this.dfdSet.removeAll();
        this.dfdSet.resetCounter();
        this.entityFlowMap.clear();
        this.attributeFlowMap.clear();
        this.setDataFlowDesign(null);
    }

    public DataFlowDesign getDataFlowDesign() {
        if (this.dataFlowDesign == null) {
            this.dataFlowDesign = this.addDataFlowDesign(null);
        }
        return this.dataFlowDesign;
    }

    public void setDataFlowDesign(DataFlowDesign dataFlowDesign) {
        this.dataFlowDesign = dataFlowDesign;
    }

    public void removeDataFlowDesign(DataFlowDesign dataFlowDesign) {
        if (dataFlowDesign != null) {
            this.dfdSet.remove(dataFlowDesign);
            dataFlowDesign.clearDesignPart();
            dataFlowDesign.fireDeleted();
            this.setDirty(true);
            this.getDesign().setDirty(true);
            this.getDesign().setModelListChanged(true);
        }
    }

    public DataFlowDesignSet getDataFlowDesigns() {
        return this.dfdSet;
    }

    public EventSet getEventSet() {
        if (this.eventSet == null) {
            this.eventSet = new EventSet(this);
            this.eventSet.setDesign(this.getDesign());
            this.eventSet.setName(Messages.getString("ProcessModel.Events"));
            this.eventSet.setParent(this);
            this.eventSet.addSetListener(this);
        }
        return this.eventSet;
    }

    public InfoStructureSet getInfoStructureSet() {
        if (this.infoStructureSet == null) {
            this.infoStructureSet = new InfoStructureSet(this);
            this.infoStructureSet.setDesign(this.getDesign());
            this.infoStructureSet.setName(Messages.getString("ProcessModel.InformationStructures"));
            this.infoStructureSet.setParent(this);
            this.infoStructureSet.addSetListener(this);
        }
        return this.infoStructureSet;
    }

    public InfoStoreSet getInfoStoreSet() {
        if (this.infoStoreSet == null) {
            this.infoStoreSet = new InfoStoreSet(this);
            this.infoStoreSet.setDesign(this.getDesign());
            this.infoStoreSet.setName(Messages.getString("ProcessModel.AllInformationStores"));
            this.infoStoreSet.setParent(this);
            this.infoStoreSet.addSetListener(this);
        }
        return this.infoStoreSet;
    }

    public ExternalDataSet getExternalDataSet() {
        if (this.extDataSet == null) {
            this.extDataSet = new ExternalDataSet(this);
            this.extDataSet.setDesign(this.getDesign());
            this.extDataSet.setName(Messages.getString("ProcessModel.ExternalDatas"));
            this.extDataSet.setParent(this);
            this.extDataSet.addSetListener(this);
        }
        return this.extDataSet;
    }

    public static final String getTransformationPackageSetName() {
        return Messages.getString("ProcessModel.TransformationPackages");
    }

    public TransformationPackageSet getTransformationPackageSet() {
        if (this.trPackageSet == null) {
            this.trPackageSet = new TransformationPackageSet(this);
            this.trPackageSet.setDesign(this.getDesign());
            this.trPackageSet.setName(Messages.getString("ProcessModel.TransformationPackages"));
            this.trPackageSet.setParent(this);
            this.trPackageSet.addSetListener(this);
        }
        return this.trPackageSet;
    }

    public RoleSet getRoleSet() {
        if (this.roleSet == null) {
            this.roleSet = new RoleSet(this);
            this.roleSet.setDesign(this.getDesign());
            this.roleSet.setName(Messages.getString("ProcessModel.Roles"));
            this.roleSet.setParent(this);
            this.roleSet.addSetListener(this);
        }
        return this.roleSet;
    }

    public RecordStructureSet getRecordStructureSet() {
        if (this.recStructureSet == null) {
            this.recStructureSet = new RecordStructureSet(this);
            this.recStructureSet.setDesign(this.getDesign());
            this.recStructureSet.setName(Messages.getString("ProcessModel.RecordStructures"));
            this.recStructureSet.setParent(this);
            this.recStructureSet.addSetListener(this);
        }
        return this.recStructureSet;
    }

    public MeasurementSet getMeasurementSet() {
        if (this.measurementSet == null) {
            this.measurementSet = new MeasurementSet(this);
            this.measurementSet.setDesign(this.getDesign());
            this.measurementSet.setName(Messages.getString("ProcessModel.Measurement"));
            this.measurementSet.setParent(this);
            this.measurementSet.addSetListener(this);
        }
        return this.measurementSet;
    }

    public Event createEvent(int n) {
        return this.getEventSet().createEvent(null, n);
    }

    public Event createEvent() {
        return this.createEvent(0);
    }

    public InfoStructure createInfoStructure() {
        return this.getInfoStructureSet().createInfoStructure(null);
    }

    public InfoStore createInfoStore() {
        return this.getInfoStoreSet().createInfoStore(null);
    }

    public ExternalData createExternalData() {
        return this.getExternalDataSet().createExternalData(null);
    }

    public RecordStructure createRecordStructure() {
        return this.getRecordStructureSet().createRecordStructure(null);
    }

    public TransformationPackage createTransformationPackage() {
        return this.createTransformationPackage(null);
    }

    public TransformationPackage createTransformationPackage(String string) {
        this.transformationPackage = this.getTransformationPackageSet().createTransformationPackage(string);
        return this.transformationPackage;
    }

    public Role createRole() {
        return this.getRoleSet().createRole(null);
    }

    @Override
    public void clearAll() {
        this.clearDesign();
        Iterator iterator = this.getTransformationPackageSet().iterator();
        while (iterator.hasNext()) {
            TransformationPackage transformationPackage = (TransformationPackage)iterator.next();
            transformationPackage.clearTasks();
        }
        this.getTransformationPackageSet().removeAll();
        this.getInfoStoreSet().removeAll();
        this.getEventSet().removeAll();
        this.getInfoStructureSet().removeAll();
        this.getRoleSet().removeAll();
        this.getExternalDataSet().removeAll();
        this.getRecordStructureSet().removeAll();
        this.setObjectID(new GUID().toString());
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
    }

    @Override
    public void sortCollections() {
        this.getTransformationPackageSet().sort();
        this.getInfoStoreSet().sort();
        this.getEventSet().sort();
        this.getInfoStructureSet().sort();
        this.getRoleSet().sort();
        this.getExternalDataSet().sort();
        this.getRecordStructureSet().sort();
    }

    @Override
    protected DesignPartView createDesignPartSubView(String string) {
        return null;
    }

    @Override
    public DesignPartView getMainView() {
        return null;
    }

    @Override
    public void updateActions() {
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ProcessModel";
    }

    @Override
    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (setEvent == SetEvent.OBJECT_ADDED) {
            this.fireAdded(setEvent.getAffected());
        } else if (setEvent == SetEvent.OBJECT_REMOVED) {
            this.fireRemoved(setEvent.getAffected());
        }
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> arrayList = new ArrayList<DesignObjectSet>();
        arrayList.add(this.getRecordStructureSet());
        arrayList.add(this.getEventSet());
        arrayList.add(this.getInfoStructureSet());
        arrayList.add(this.getInfoStoreSet());
        arrayList.add(this.getRoleSet());
        arrayList.add(this.getTransformationPackageSet());
        return arrayList;
    }

    @Override
    public void doAfterLoad() {
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        if (this.getMainView() != null) {
            this.getMainView().setDirty(false);
        }
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void load() {
        XMLPersistenceManager xMLPersistenceManager = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader abstractXMLReader = xMLPersistenceManager.getDesignPartReader(this);
        if (abstractXMLReader != null) {
            abstractXMLReader.recreateDesign(this.getObjectID(), (DesignPart)this, false);
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        if (this.getMainView() != null) {
            this.getMainView().setDirty(false);
        }
        this.setDirty(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            DataFlowDesign dataFlowDesign;
            if (modelObjectSetEvent.getAffected() instanceof DataFlowDesign && (dataFlowDesign = (DataFlowDesign)modelObjectSetEvent.getAffected()).isTopLevel()) {
                dataFlowDesign.setParent(this.topDataFlowDesigns);
                this.topDataFlowDesigns.add(dataFlowDesign);
                dataFlowDesign.addDesignListener(this);
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof DataFlowDesign) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)modelObjectSetEvent.getAffected();
            this.topDataFlowDesigns.remove(dataFlowDesign);
            dataFlowDesign.addDesignListener(this);
        }
    }

    public List getAllPrimitiveProcesses() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            if (!dataFlowDesign.isTopLevel()) continue;
            dataFlowDesign.addAllPrimitiveProcesses(arrayList);
        }
        return arrayList;
    }

    public List getAllPrimitiveProcessesConnectedToStore() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            if (!dataFlowDesign.isTopLevel()) continue;
            dataFlowDesign.addAllPrimitiveProcessesConnectedToStore(arrayList);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        if (this.getEventSet().size() != 0) {
            return false;
        }
        if (this.getInfoStructureSet().size() != 0) {
            return false;
        }
        if (this.getInfoStoreSet().size() != 0) {
            return false;
        }
        if (this.getRoleSet().size() != 0) {
            return false;
        }
        if (this.getRecordStructureSet().size() != 0) {
            return false;
        }
        if (this.getDataFlowDesigns().size() != 0) {
            return false;
        }
        return this.getTransformationPackageSet().size() == 0;
    }

    public TransformationPackage getTransformationPackage() {
        return this.transformationPackage;
    }

    public void setTransformationPackage(TransformationPackage transformationPackage) {
        this.transformationPackage = transformationPackage;
    }

    public TransformationTask getTransformationTask() {
        return this.transformationTask;
    }

    public TransformationTask getTransformationTaskById(String string) {
        Iterator iterator = this.getTransformationPackageSet().iterator();
        while (iterator.hasNext()) {
            TransformationPackage transformationPackage = (TransformationPackage)iterator.next();
            Iterator iterator2 = transformationPackage.getTransformationTaskSet().iterator();
            while (iterator2.hasNext()) {
                TransformationTask transformationTask = (TransformationTask)iterator2.next();
                if (!transformationTask.getObjectID().equalsIgnoreCase(string)) continue;
                return transformationTask;
            }
        }
        return null;
    }

    public List getTransformations() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getTransformationPackageSet().iterator();
        while (iterator.hasNext()) {
            TransformationPackage transformationPackage = (TransformationPackage)iterator.next();
            Iterator iterator2 = transformationPackage.getTransformationTaskSet().iterator();
            while (iterator2.hasNext()) {
                TransformationTask transformationTask = (TransformationTask)iterator2.next();
                Iterator iterator3 = transformationTask.getTransformationSet().iterator();
                while (iterator3.hasNext()) {
                    arrayList.add(iterator3.next());
                }
            }
        }
        return arrayList;
    }

    public void setTransformationTask(TransformationTask transformationTask) {
        this.transformationTask = transformationTask;
    }

    public List getAllTransformationTasks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getTransformationPackageSet().iterator();
        while (iterator.hasNext()) {
            TransformationPackage transformationPackage = (TransformationPackage)iterator.next();
            transformationPackage.getTransformationTaskSet().addAllElementsTo(arrayList);
        }
        return arrayList;
    }

    public void updateRoles() {
        Iterator iterator = this.getRoleSet().iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            role.updateProcesses();
        }
    }

    public void updateRecordStructures() {
        Iterator iterator = this.getRecordStructureSet().iterator();
        while (iterator.hasNext()) {
            RecordStructure recordStructure = (RecordStructure)iterator.next();
            recordStructure.updatedExtDatas();
        }
    }

    public void updateObjects() {
        this.updateRoles();
        this.updateRecordStructures();
    }

    public boolean hasOpenedDFDesigns() {
        return this.hasOpenedDFDesigns;
    }

    public void setHasOpenedDFDesigns(boolean bl) {
        this.hasOpenedDFDesigns = bl;
    }

    @Override
    public Note createNote() {
        return null;
    }

    public void buidEntAttrFlowMaps() {
        this.entityFlowMap.clear();
        this.attributeFlowMap.clear();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ProcessModelPropertiesDialog processModelPropertiesDialog = new ProcessModelPropertiesDialog(this.getDesign().getAppView(), this, true);
            processModelPropertiesDialog.initProperties(this);
            processModelPropertiesDialog.show();
        }
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("RecordStructure");
        arrayList.add("ExternalData");
        arrayList.add("Event");
        arrayList.add("InfoStructure");
        arrayList.add("InfoStore");
        arrayList.add("Role");
        arrayList.add("TransformationPackage");
        arrayList.add("MainView");
        arrayList.add("SubView");
        return arrayList;
    }

    @Override
    public String getStoragePath() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "pm").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "pm/" + this.getName() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StorableObject createObject(String string, String string2, String string3) {
        DesignObject designObject = null;
        if ("RecordStructure".equalsIgnoreCase(string)) {
            designObject = this.getRecordStructureSet().createRecordStructure(string2);
        } else if ("ExternalData".equalsIgnoreCase(string)) {
            designObject = this.getExternalDataSet().createExternalData(string2);
        } else if ("Event".equalsIgnoreCase(string)) {
            designObject = this.getEventSet().createEvent(string2, 0);
        } else if ("InfoStructure".equalsIgnoreCase(string)) {
            designObject = this.getInfoStructureSet().createInfoStructure(string2);
        } else if ("InfoStore".equalsIgnoreCase(string)) {
            designObject = this.getInfoStoreSet().createInfoStore(string2);
        } else if ("Role".equalsIgnoreCase(string)) {
            designObject = this.getRoleSet().createRole(string2);
        } else if ("TransformationPackage".equalsIgnoreCase(string)) {
            designObject = this.getTransformationPackageSet().createTransformationPackage(string2);
        } else if ("Note".equalsIgnoreCase(string)) {
            designObject = this.getNoteSet().createNote(string2);
        }
        if (designObject != null && string3 != null && string3.length() > 0) {
            designObject.setName(string3);
        }
        return designObject;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("recordstructure", "RecordStructure");
            this.f2tMap.put("extdata", "ExternalData");
            this.f2tMap.put("event", "Event");
            this.f2tMap.put("infostructure", "InfoStructure");
            this.f2tMap.put("store", "InfoStore");
            this.f2tMap.put("role", "Role");
            this.f2tMap.put("tp", "TransformationPackage");
        }
        return this.f2tMap;
    }

    public static void initObjectDetails(Design design, File file, String string, StorableObjectStatusHelper storableObjectStatusHelper, String string2) {
        storableObjectStatusHelper.treePath.add(new TreePathHelper(OBJECT_TYPE_NAME, new File(design.getProcessModel().getStorageName()), ProcessModel.class));
        if ("recordstructure".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = RecordStructure.class;
            storableObjectStatusHelper.objectType = "RecordStructure";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(REC_STRUCTURE_SET_NAME, file.getParentFile(), RecordStructureSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((ProcessModel)storableObjectStatusHelper.designPart).getRecordStructureSet();
                storableObjectStatusHelper.storableObject = ((ProcessModel)storableObjectStatusHelper.designPart).getRecordStructureSet().getObjectByID(string2);
            }
        } else if ("extdata".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = ExternalData.class;
            storableObjectStatusHelper.objectType = "ExternalData";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(EXT_DATA_SET_NAME, file.getParentFile(), ExternalDataSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((ProcessModel)storableObjectStatusHelper.designPart).getExternalDataSet();
                storableObjectStatusHelper.storableObject = ((ProcessModel)storableObjectStatusHelper.designPart).getExternalDataSet().getObjectByID(string2);
            }
        } else if ("event".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Event.class;
            storableObjectStatusHelper.objectType = "Event";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(EVENT_SET_NAME, file.getParentFile(), EventSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((ProcessModel)storableObjectStatusHelper.designPart).getEventSet();
                storableObjectStatusHelper.storableObject = ((ProcessModel)storableObjectStatusHelper.designPart).getEventSet().getObjectByID(string2);
            }
        } else if ("infostructure".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = InfoStructure.class;
            storableObjectStatusHelper.objectType = "InfoStructure";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(INFOSTRUCTURE_SET_NAME, file.getParentFile(), InfoStructureSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((ProcessModel)storableObjectStatusHelper.designPart).getInfoStructureSet();
                storableObjectStatusHelper.storableObject = ((ProcessModel)storableObjectStatusHelper.designPart).getInfoStructureSet().getObjectByID(string2);
            }
        } else if ("store".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = InfoStore.class;
            storableObjectStatusHelper.objectType = "InfoStore";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(STORE_SET_NAME, file.getParentFile(), InfoStoreSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((ProcessModel)storableObjectStatusHelper.designPart).getInfoStoreSet();
                storableObjectStatusHelper.storableObject = ((ProcessModel)storableObjectStatusHelper.designPart).getInfoStoreSet().getObjectByID(string2);
            }
        } else if ("role".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = Role.class;
            storableObjectStatusHelper.objectType = "Role";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(ROLE_SET_NAME, file.getParentFile(), RoleSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((ProcessModel)storableObjectStatusHelper.designPart).getRoleSet();
                storableObjectStatusHelper.storableObject = ((ProcessModel)storableObjectStatusHelper.designPart).getRoleSet().getObjectByID(string2);
            }
        } else if ("tp".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = TransformationPackage.class;
            storableObjectStatusHelper.objectType = "TransformationPackage";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(ProcessModel.getTransformationPackageSetName(), file.getParentFile(), TransformationPackageSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((ProcessModel)storableObjectStatusHelper.designPart).getTransformationPackageSet();
                storableObjectStatusHelper.storableObject = ((ProcessModel)storableObjectStatusHelper.designPart).getTransformationPackageSet().getObjectByID(string2);
            }
        } else if ("dflows".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.objectClass = DataFlowDesign.class;
            storableObjectStatusHelper.objectType = "Data Flow Diagram";
            storableObjectStatusHelper.treePath.add(new TreePathHelper(ProcessModel.getDataFlowDesignSetName(), file.getParentFile(), DataFlowDesignSet.class));
            if (storableObjectStatusHelper.designPart != null) {
                storableObjectStatusHelper.objectSet = ((ProcessModel)storableObjectStatusHelper.designPart).getDataFlowDesigns();
                storableObjectStatusHelper.storableObject = ((ProcessModel)storableObjectStatusHelper.designPart).getDataFlowDesigns().getObjectByID(string2);
            }
        }
    }

    public StorableObjectStatusHelper initDesignPart(String string, String string2, StorableObjectStatusHelper storableObjectStatusHelper) {
        if ("dflows".equalsIgnoreCase(string)) {
            storableObjectStatusHelper.designPartClass = DataFlowDesign.class;
            storableObjectStatusHelper.designPart = null;
            Iterator iterator = this.getDataFlowDesigns().iterator();
            while (iterator.hasNext()) {
                DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
                if (!string2.equalsIgnoreCase(dataFlowDesign.getObjectID())) continue;
                storableObjectStatusHelper.designPart = dataFlowDesign;
                break;
            }
            return storableObjectStatusHelper;
        }
        return null;
    }

    public void orderDataFlowDesigns() {
        this.getDataFlowDesigns().orderDataFlowDesigns();
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        this.sortCollections();
        this.updateObjects();
    }

    @Override
    public void designChanged(DesignEvent designEvent) {
        if (designEvent.isType("DFD top level flag changed") && designEvent.getDesignPart() instanceof DataFlowDesign) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)designEvent.getDesignPart();
            if (dataFlowDesign.isTopLevel() && !this.topDataFlowDesigns.contains(dataFlowDesign)) {
                dataFlowDesign.setParent(this.topDataFlowDesigns);
                this.topDataFlowDesigns.add(dataFlowDesign);
            } else if (!dataFlowDesign.isTopLevel()) {
                this.topDataFlowDesigns.remove(dataFlowDesign);
            }
        }
    }

    @Override
    public List<Object> getObjectsWithMeasurements() {
        AbstractProcessObject abstractProcessObject;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.getEventSet().iterator();
        while (iterator.hasNext()) {
            abstractProcessObject = (Event)iterator.next();
            if (abstractProcessObject.getMeasurements().size() <= 0) continue;
            arrayList.add(abstractProcessObject);
        }
        iterator = this.getInfoStructureSet().iterator();
        while (iterator.hasNext()) {
            abstractProcessObject = (InfoStructure)iterator.next();
            if (abstractProcessObject.getMeasurements().size() <= 0) continue;
            arrayList.add(abstractProcessObject);
        }
        iterator = this.getInfoStoreSet().iterator();
        while (iterator.hasNext()) {
            abstractProcessObject = (InfoStore)iterator.next();
            if (abstractProcessObject.getMeasurements().size() <= 0) continue;
            arrayList.add(abstractProcessObject);
        }
        iterator = this.getRoleSet().iterator();
        while (iterator.hasNext()) {
            abstractProcessObject = (Role)iterator.next();
            if (abstractProcessObject.getMeasurements().size() <= 0) continue;
            arrayList.add(abstractProcessObject);
        }
        iterator = this.getTransformationPackageSet().iterator();
        while (iterator.hasNext()) {
            abstractProcessObject = (TransformationPackage)iterator.next();
            if (abstractProcessObject.getMeasurements().size() <= 0) continue;
            arrayList.add(abstractProcessObject);
        }
        iterator = this.getExternalDataSet().iterator();
        while (iterator.hasNext()) {
            abstractProcessObject = (ExternalData)iterator.next();
            if (abstractProcessObject.getMeasurements().size() <= 0) continue;
            arrayList.add(abstractProcessObject);
        }
        iterator = this.getRecordStructureSet().iterator();
        while (iterator.hasNext()) {
            abstractProcessObject = (RecordStructure)iterator.next();
            if (abstractProcessObject.getMeasurements().size() <= 0) continue;
            arrayList.add(abstractProcessObject);
        }
        return arrayList;
    }
}

