/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.editor.process.StorePropertiesDialogEx;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class InfoStore
extends AbstractProcessObject
implements EditableFonts {
    public static final String RDBMS = "RDBMS";
    public static final String FILE = "File";
    public static final String OBJECT = "Object";
    public static final String TEMPORARY = "Temporary";
    public static final String[] INFOSTORE_TYPES_DISPLAY = new String[]{Messages.getString("InfoStore.RDBMS"), Messages.getString("InfoStore.File"), Messages.getString("InfoStore.Object"), Messages.getString("InfoStore.Temporary")};
    public static final String[] INFOSTORE_TYPES_INTERNAL = new String[]{"RDBMS", "File", "Object", "Temporary"};
    public static final String[] FILE_TYPES_DISPLAY = new String[]{Messages.getString("InfoStore.CSV"), Messages.getString("InfoStore.FixedLengthFields"), Messages.getString("InfoStore.Excel"), Messages.getString("InfoStore.PlainText")};
    public static final String[] FILE_TYPES_INTERNAL = new String[]{"CSV", "Fixed Length Fields", "Excel", "Plain Text"};
    public static final String[] TRANSFER_TYPES_DISPLAY = new String[]{Messages.getString("InfoStore.FullRefresh"), Messages.getString("InfoStore.ChangesCapture"), Messages.getString("InfoStore.TriggeredCapture"), Messages.getString("InfoStore.ApplicationAssistedCapture"), Messages.getString("InfoStore.TimeStampBasedCapture"), Messages.getString("InfoStore.FileComparisonCapture")};
    public static final String[] TRANSFER_TYPES_INTERNAL = new String[]{"Full Refresh", "Changes Capture", "Triggered Capture", "Application Assisted Capture", "Time-Stamp based Capture", "File Comparison Capture"};
    private String type = "RDBMS";
    private String owner = "";
    private String source = "";
    private String fileName = "";
    private String location = "";
    private String fileType = FILE_TYPES_INTERNAL[0];
    private String fieldSeparator = ",";
    private String transferType = TRANSFER_TYPES_INTERNAL[0];
    private String scope = "";
    private String objectType = "";
    private String implementationName = "";
    private boolean isSelfDescribing = false;
    private int skipRecords = 0;
    private String textDelimiter = "";
    private Map entityImplementations = new HashMap();
    private String rdbmsSite = "";
    private List editableFonts;
    private String systemObjective = "";
    private List datas = new ArrayList();
    public static final String TYPE_NAME = "InfoStore";

    public InfoStore(DesignPart designPart) {
        super(designPart);
        this.initEditableFonts();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "IST";
    }

    public List getAttributes() {
        Iterator iterator;
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Iterator iterator2 = this.getIncomingFlows().iterator();
        while (iterator2.hasNext()) {
            iterator = ((Flow)iterator2.next()).getInfoStructures().iterator();
            while (iterator.hasNext()) {
                for (Attribute attribute : ((InfoStructure)iterator.next()).getAttributes()) {
                    if (arrayList.contains(attribute)) continue;
                    arrayList.add(attribute);
                }
            }
        }
        iterator2 = this.getOutgoingFlows().iterator();
        while (iterator2.hasNext()) {
            iterator = ((Flow)iterator2.next()).getInfoStructures().iterator();
            while (iterator.hasNext()) {
                for (Attribute attribute : ((InfoStructure)iterator.next()).getAttributes()) {
                    if (arrayList.contains(attribute)) continue;
                    arrayList.add(attribute);
                }
            }
        }
        return arrayList;
    }

    public List getProcesses() {
        ArrayList<AbstractProcessObject> arrayList = new ArrayList<AbstractProcessObject>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof Process)) continue;
            arrayList.add(flow.getSourceProcessObject());
        }
        return arrayList;
    }

    public String getSystemObjective() {
        return this.systemObjective;
    }

    public void setSystemObjective(String string) {
        this.systemObjective = string;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StorePropertiesDialogEx storePropertiesDialogEx = new StorePropertiesDialogEx(this.getDesign().getAppView(), this);
            storePropertiesDialogEx.initProperties(this);
            storePropertiesDialogEx.show();
        }
    }

    public void addData(ExternalData externalData) {
        this.datas.add(externalData);
        externalData.remove();
    }

    public void removeData(ExternalData externalData) {
        this.datas.remove(externalData);
    }

    public ExternalData createExternalData() {
        ExternalData externalData = ((ProcessModel)this.getDesignPart()).createExternalData();
        this.addData(externalData);
        return externalData;
    }

    public ExternalData getExternalDataByID(String string) {
        for (ExternalData externalData : this.datas) {
            if (!externalData.getObjectID().equals(string)) continue;
            return externalData;
        }
        return null;
    }

    public List getDatas() {
        return this.datas;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String string) {
        this.fieldSeparator = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String string) {
        this.fileType = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getTransferType() {
        return this.transferType;
    }

    public void setTransferType(String string) {
        this.transferType = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getImplementationName() {
        return this.implementationName;
    }

    public void setImplementationName(String string) {
        this.implementationName = string;
    }

    public boolean isSelfDescribing() {
        return this.isSelfDescribing;
    }

    public void setSelfDescribing(boolean bl) {
        this.isSelfDescribing = bl;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String string) {
        this.objectType = string;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public int getSkipRecords() {
        return this.skipRecords;
    }

    public void setSkipRecords(int n) {
        this.skipRecords = n;
    }

    public String getTextDelimiter() {
        return this.textDelimiter;
    }

    public void setTextDelimiter(String string) {
        this.textDelimiter = string;
    }

    public Map getEntityImplementations() {
        return this.entityImplementations;
    }

    public Object getEntityImpl(Entity entity) {
        return this.entityImplementations.get(entity);
    }

    public void addEntityImpl(Entity entity, Object object) {
        this.entityImplementations.put(entity, object);
    }

    public List getImplementationsForEntity(Entity entity) {
        ArrayList<ModelIDObject> arrayList = new ArrayList<ModelIDObject>();
        if (entity.getGenerator() != null) {
            arrayList.add(entity.getGenerator());
        } else {
            Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
            while (iterator.hasNext()) {
                RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
                ModelIDObject modelIDObject = relationalDesign.getTableSet().getObjectGeneratedBy(entity);
                if (modelIDObject == null) continue;
                arrayList.add(modelIDObject);
            }
        }
        return arrayList;
    }

    public String getRdbmsSite() {
        return this.rdbmsSite;
    }

    public void setRdbmsSite(String string) {
        this.rdbmsSite = string;
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && this.getDesignPart().getAppView() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject("Information Store")) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject("Information Store")) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
            this.setUseDefaultColor(true);
        } else if (DefaultFontAndColor.isModified("Information Store")) {
            DefaultFontAndColor defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject("Information Store");
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
            this.setUseDefaultColor(bl);
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "store/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void copy(DesignObject designObject) {
        InfoStore infoStore = (InfoStore)designObject;
        super.copy(designObject);
        infoStore.setSynonym(this.getSynonym());
        infoStore.setType(this.getType());
        infoStore.setRdbmsSite(this.getRdbmsSite());
        infoStore.setObjectType(this.getObjectType());
        infoStore.setImplementationName(this.getImplementationName());
        infoStore.setScope(this.getScope());
        infoStore.setOwner(this.getOwner());
        infoStore.setSource(this.getSource());
        infoStore.setFileName(this.getFileName());
        infoStore.setLocation(this.getLocation());
        infoStore.setFileType(this.getFileType());
        infoStore.setFieldSeparator(this.getFieldSeparator());
        infoStore.setTransferType(this.getTransferType());
        infoStore.setSelfDescribing(this.isSelfDescribing);
        infoStore.setSkipRecords(this.getSkipRecords());
        infoStore.setTextDelimiter(this.getTextDelimiter());
        for (ExternalData externalData : this.getDatas()) {
            ExternalData externalData2 = infoStore.createExternalData();
            externalData2.setName(externalData.getName());
            externalData2.setComment(externalData.getComment());
            externalData2.setType(externalData.getType());
            externalData2.setStartingPos(externalData.getStartingPos());
            externalData2.setDescription(externalData.getDescription());
            externalData2.setStructured(externalData.isStructured());
            externalData2.setRecordStructure(externalData.getRecordStructure());
        }
    }
}

