/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.editor.process.InOutParamsPropertiesDialogEx;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class InOutParams
extends AbstractProcessObject
implements EditableFonts {
    public static final String INPUT = "Input";
    public static final String OUTPUT = "Output";
    public static final String SINGLE_RECORD = "Single Record";
    public static final String SET_OF_RECORDS = "Set Of Records";
    public static final String[] MULTIPLICITY_TYPES_INTERNAL = new String[]{"Single Record", "Set Of Records"};
    public static final String[] MULTIPLICITY_TYPES_DISPLAY = new String[]{Messages.getString("InOutParams.SingleRecord"), Messages.getString("InOutParams.SetOfRecords")};
    private String inOutType = "Input";
    private String parametersMultiplicity = "Single Record";
    private String systemObjective = "";
    private TransformationTask task;
    private List editableFonts;

    public InOutParams(DesignPart designPart, String string) {
        super(designPart);
        this.inOutType = string;
        this.task = (TransformationTask)designPart;
    }

    @Override
    public void setDesign(Design design) {
        super.setDesign(design);
        this.initEditableFonts(design);
    }

    @Override
    public String getObjectTypeName() {
        return "InOutParams";
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        if (this.inOutType.equalsIgnoreCase(INPUT)) {
            return "INPAR";
        }
        return "OUTPAR";
    }

    public List getAttributes() {
        Iterator iterator;
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Iterator iterator2 = this.getIncomingFlows().iterator();
        while (iterator2.hasNext()) {
            iterator = ((Flow)iterator2.next()).getInfoStructures().iterator();
            while (iterator.hasNext()) {
                for (Attribute attribute : ((InfoStructure)iterator.next()).getAttributes()) {
                    if (arrayList.contains(attribute)) continue;
                    arrayList.add(attribute);
                }
            }
        }
        iterator2 = this.getOutgoingFlows().iterator();
        while (iterator2.hasNext()) {
            iterator = ((Flow)iterator2.next()).getInfoStructures().iterator();
            while (iterator.hasNext()) {
                for (Attribute attribute : ((InfoStructure)iterator.next()).getAttributes()) {
                    if (arrayList.contains(attribute)) continue;
                    arrayList.add(attribute);
                }
            }
        }
        return arrayList;
    }

    public List getProcesses() {
        ArrayList<AbstractProcessObject> arrayList = new ArrayList<AbstractProcessObject>();
        for (Flow flow : this.getIncomingFlows()) {
            if (!(flow.getSourceProcessObject() instanceof Process)) continue;
            arrayList.add(flow.getSourceProcessObject());
        }
        return arrayList;
    }

    public String getSystemObjective() {
        return this.systemObjective;
    }

    public void setSystemObjective(String string) {
        this.systemObjective = string;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            InOutParamsPropertiesDialogEx inOutParamsPropertiesDialogEx = new InOutParamsPropertiesDialogEx(this.getDesign().getAppView(), this);
            inOutParamsPropertiesDialogEx.initProperties(this);
            inOutParamsPropertiesDialogEx.show();
        }
    }

    public void addParam(ParameterObject parameterObject) {
        if (this.inOutType.equalsIgnoreCase(INPUT)) {
            this.task.addInputParam(parameterObject);
        } else {
            this.task.addOutputParam(parameterObject);
        }
    }

    public void addParam(String string, String string2, String string3) {
        if (this.inOutType.equalsIgnoreCase(INPUT)) {
            this.task.addInputParam(string, string2, string3);
        } else {
            this.task.addOutputParam(string, string2, string3);
        }
    }

    public List getParams() {
        if (this.inOutType.equalsIgnoreCase(INPUT)) {
            return this.task.getInputParameters();
        }
        return this.task.getOutputParameters();
    }

    public String getInOutType() {
        return this.inOutType;
    }

    public String getParametersMultiplicity() {
        return this.parametersMultiplicity;
    }

    public void setParametersMultiplicity(String string) {
        this.parametersMultiplicity = string;
    }

    @Override
    public String getName() {
        if (this.inOutType.equalsIgnoreCase(INPUT)) {
            return "Input Parameters";
        }
        return "Output Parameters";
    }

    public DesignObject getElementByID(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.inOutType.equalsIgnoreCase(INPUT) ? this.task.getInputParameters().iterator() : this.task.getOutputParameters().iterator();
        while (iterator.hasNext()) {
            DesignObject designObject = (DesignObject)iterator.next();
            if (!string.equals(designObject.getObjectID())) continue;
            return designObject;
        }
        return null;
    }

    private void initEditableFonts(Design design) {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject("In-Out Parameters")) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.design.getDLSettings().getDefaultFCObject("In-Out Parameters")) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
            this.setUseDefaultColor(true);
        } else if (DefaultFontAndColor.isModified("In-Out Parameters")) {
            DefaultFontAndColor defaultFontAndColor = this.design.getDLSettings().getDefaultFCObject("In-Out Parameters");
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
            this.setUseDefaultColor(bl);
        }
    }

    public ParameterObject createParameter() {
        ParameterObject parameterObject = new ParameterObject(this.getDesignPart());
        this.addParam(parameterObject);
        return parameterObject;
    }

    public ParameterObject getParemeterByID(String string) {
        for (ParameterObject parameterObject : this.getParams()) {
            if (!parameterObject.getObjectID().equals(string)) continue;
            return parameterObject;
        }
        return null;
    }
}

