/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.editor.process.FlowPropertiesDialogEx;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.DPVTransformation;
import oracle.dbtools.crest.swingui.process.TVFlow;

public class Flow
extends AbstractProcessObject
implements ConnectionInterface {
    public static final Object[] CONNECTION_PROTO_ARRAY = new Connection[0];
    public static final int SOURCE = 0;
    public static final int DESTINATION = 1;
    private final AbstractProcessObject[] PROCESS_OBJECTS = new AbstractProcessObject[2];
    private final Connection[] CONNECTIONS = new Connection[]{new SourceConnection(), new DestinationConnection()};
    private AbstractProcessObject source;
    private AbstractProcessObject destination;
    private AbstractProcessObject parent;
    private Event event;
    private String systemObjective = "";
    private boolean logging = false;
    private boolean opCreate;
    private boolean opRead;
    private boolean opUpdate;
    private boolean opDelete;
    private List infoStructures = new ArrayList();
    Collection dpvCol = new ArrayList();
    public static String TYPE_NAME = "Flow";

    public Flow(DesignPart designPart) {
        super(designPart);
    }

    public void setProcessObject(int n, AbstractProcessObject abstractProcessObject) {
        if (this.PROCESS_OBJECTS[n] == abstractProcessObject) {
            return;
        }
        if (this.PROCESS_OBJECTS[n] != null) {
            if (this.PROCESS_OBJECTS[0] != this.PROCESS_OBJECTS[1]) {
                // empty if block
            }
            this.PROCESS_OBJECTS[n].remove(this.CONNECTIONS[n]);
        }
        if (abstractProcessObject != null) {
            abstractProcessObject.add(this.CONNECTIONS[n]);
        }
        this.PROCESS_OBJECTS[n] = abstractProcessObject;
        if (abstractProcessObject != null) {
            // empty if block
        }
        this.fireChange(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED);
    }

    public AbstractProcessObject getProcessObject(int n) {
        return this.PROCESS_OBJECTS[n];
    }

    public AbstractProcessObject getTargetProcessObject() {
        return this.getProcessObject(1);
    }

    public void setTargetProcessObject(AbstractProcessObject abstractProcessObject) {
        AbstractProcessObject abstractProcessObject2 = this.getTargetProcessObject();
        this.setProcessObject(1, abstractProcessObject);
        this.setDestination(abstractProcessObject);
        if (abstractProcessObject2 != abstractProcessObject && abstractProcessObject2 != null) {
            this.clearTargetTV();
        }
        this.addSynonymToCompositeProcDiagram();
        this.createOrSetParentFlow();
        this.addToAllDPVs(null);
    }

    public AbstractProcessObject getSourceProcessObject() {
        return this.getProcessObject(0);
    }

    public void setSourceProcessObject(AbstractProcessObject abstractProcessObject) {
        AbstractProcessObject abstractProcessObject2 = this.getSourceProcessObject();
        this.setProcessObject(0, abstractProcessObject);
        this.setSource(abstractProcessObject);
        if (abstractProcessObject2 != abstractProcessObject && abstractProcessObject2 != null) {
            this.clearSourceTV();
        }
        if (this.getDesignPart() instanceof DataFlowDesign) {
            this.addSynonymToCompositeProcDiagram();
            this.createOrSetParentFlow();
            this.addToAllDPVs(null);
        }
    }

    public void addToAllDPVs(DesignPartView designPartView) {
        AbstractProcessObject abstractProcessObject = this.getTargetProcessObject();
        AbstractProcessObject abstractProcessObject2 = this.getSourceProcessObject();
        if (abstractProcessObject2 != null && abstractProcessObject != null) {
            Collection collection = this.getTargetProcessObject().getAffectedDPVs();
            Collection collection2 = this.getSourceProcessObject().getAffectedDPVs();
            for (DesignPartView designPartView2 : collection) {
                Object object;
                if (designPartView2 == designPartView || (object = this.getFirstViewForDPV(designPartView2)) != null || this.getTargetTV(designPartView2) == null || this.getSourceTV(designPartView2) == null) continue;
                ((TVFlow)this.getViewFor(designPartView2)).addConnection();
                collection2.remove(designPartView2);
            }
            for (DesignPartView designPartView2 : collection2) {
                TopView topView;
                if (designPartView2 == designPartView || (topView = this.getFirstViewForDPV(designPartView2)) != null || this.getSourceTV(designPartView2) == null || this.getTargetTV(designPartView2) == null) continue;
                ((TVFlow)this.getViewFor(designPartView2)).addConnection();
            }
        }
    }

    @Override
    public void removeAllViews() {
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.dpv == null || dpvInfo2.tv == null) continue;
            dpvInfo2.dpv.unregisterFromTreemodel(dpvInfo2.tv);
            dpvInfo2.dpv.getWorkSpace().removeConnection(this);
            dpvInfo2.tv = null;
        }
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView designPartView) {
        return this.getViewFor(designPartView);
    }

    public void clearSourceTV() {
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            dpvInfo2.sourceTV = null;
        }
    }

    public void clearTargetTV() {
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            dpvInfo2.targetTV = null;
        }
    }

    public dpvInfo getDPVInfoFor(DesignPartView designPartView) {
        dpvInfo dpvInfo22;
        for (dpvInfo dpvInfo22 : this.dpvCol) {
            if (dpvInfo22.dpv != designPartView) continue;
            return dpvInfo22;
        }
        dpvInfo22 = new dpvInfo();
        dpvInfo22.dpv = designPartView;
        this.dpvCol.add(dpvInfo22);
        return dpvInfo22;
    }

    @Override
    public TopView getViewFor(DesignPartView designPartView) {
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        return dpvInfo2.tv;
    }

    public AbstractDataFlowTV getSourceTV(DesignPartView designPartView) {
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.sourceTV == null && this.getSourceProcessObject() != null) {
            dpvInfo2.sourceTV = (AbstractDataFlowTV)this.getSourceProcessObject().getFirstViewForDPV(designPartView);
            if (dpvInfo2.sourceTV != null) {
                dpvInfo2.sourceTV.addTopViewListener(this);
                this.addTVFlow(dpvInfo2);
            }
        }
        return dpvInfo2.sourceTV;
    }

    public AbstractDataFlowTV getTargetTV(DesignPartView designPartView) {
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.targetTV == null && this.getTargetProcessObject() != null) {
            dpvInfo2.targetTV = (AbstractDataFlowTV)this.getTargetProcessObject().getFirstViewForDPV(designPartView);
            if (dpvInfo2.targetTV != null) {
                dpvInfo2.targetTV.addTopViewListener(this);
                this.addTVFlow(dpvInfo2);
            }
        }
        return dpvInfo2.targetTV;
    }

    public void addTVFlow(dpvInfo dpvInfo2) {
        if (dpvInfo2.tv == null && dpvInfo2.sourceTV != null && dpvInfo2.targetTV != null && dpvInfo2.dpv != null) {
            TVFlow tVFlow = dpvInfo2.dpv instanceof DPVProcess ? (TVFlow)((DPVProcess)dpvInfo2.dpv).createViewSynonim(this) : (TVFlow)((DPVTransformation)dpvInfo2.dpv).createViewSynonim(this);
            dpvInfo2.tv = tVFlow;
            tVFlow.setSize(new Dimension(100, 100));
            this.addObjectListener(tVFlow);
        }
    }

    public void setSourceTV(AbstractDataFlowTV abstractDataFlowTV) {
        if (abstractDataFlowTV != null) {
            this.setSourceProcessObject((AbstractProcessObject)abstractDataFlowTV.getModel());
            DesignPartView designPartView = abstractDataFlowTV.getDesignPartView();
            dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            boolean bl = false;
            if (dpvInfo2.sourceTV != null) {
                bl = true;
                if (dpvInfo2.tv != null) {
                    ((TVFlow)dpvInfo2.tv).removeConnection();
                }
                dpvInfo2.sourceTV.removeTopViewListener(this);
            }
            dpvInfo2.sourceTV = abstractDataFlowTV;
            dpvInfo2.sourceTV.addTopViewListener(this);
            this.addTVFlow(dpvInfo2);
            if (bl && dpvInfo2.tv != null) {
                ((TVFlow)dpvInfo2.tv).addConnection();
            }
        }
    }

    public void setTargetTV(AbstractDataFlowTV abstractDataFlowTV) {
        if (abstractDataFlowTV != null) {
            this.setTargetProcessObject((AbstractProcessObject)abstractDataFlowTV.getModel());
            DesignPartView designPartView = abstractDataFlowTV.getDesignPartView();
            dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            boolean bl = false;
            if (dpvInfo2.targetTV != null) {
                bl = true;
                if (dpvInfo2.tv != null) {
                    ((TVFlow)dpvInfo2.tv).removeConnection();
                }
                dpvInfo2.targetTV.removeTopViewListener(this);
            }
            dpvInfo2.targetTV = abstractDataFlowTV;
            dpvInfo2.targetTV.addTopViewListener(this);
            this.addTVFlow(dpvInfo2);
            if (bl && dpvInfo2.tv != null) {
                ((TVFlow)dpvInfo2.tv).addConnection();
            }
        }
    }

    public void callRemoveListeners() {
        ObjectChangeEvent objectChangeEvent = ObjectChangeEvent.OBJECT_REMOVED;
        objectChangeEvent.setAffected(this);
        this.fireChange(objectChangeEvent);
    }

    public boolean isValid() {
        return this.getProcessObject(0) != null && this.getProcessObject(1) != null;
    }

    public Connection getConnection(int n) {
        return this.CONNECTIONS[n];
    }

    public Connection getSourceConnection() {
        return this.getConnection(0);
    }

    public Connection getTargetConnection() {
        return this.getConnection(1);
    }

    @Override
    public void setTopView(TopView topView) {
        this.addTopView(topView);
    }

    @Override
    public TopView getTopView() {
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.tv == null) continue;
            return dpvInfo2.tv;
        }
        return null;
    }

    @Override
    public List getAllViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.tv == null) continue;
            arrayList.add(dpvInfo2.tv);
        }
        return arrayList;
    }

    @Override
    public void addTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.tv != null) {
            throw new RuntimeException(Messages.getString("Flow.AssociationAlreadyexists"));
        }
        dpvInfo2.tv = topView;
    }

    @Override
    public void removeTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.tv == null) {
            return;
        }
        this.dpvCol.remove(dpvInfo2);
        this.removeObjectListener(topView);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "FLOW";
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        if (this.event != event) {
            if (this.event != null) {
                this.event.setFlow(null);
            }
            this.event = event;
            if (this.event != null) {
                this.event.setFlow(this);
            }
            if (this.event != null) {
                DefaultEdge defaultEdge = ((TVFlow)this.getTopView()).getEdge();
                if (defaultEdge != null) {
                    Map map = defaultEdge.getAttributes();
                    DiagramConstants.setLineEnd(map, 9);
                    defaultEdge.setAttributes(map);
                    EdgeView edgeView = (EdgeView)defaultEdge.getDiagram().getDiagramLayoutCache().getMapping(defaultEdge, false);
                    edgeView.update();
                    edgeView.getDiagram().repaint();
                }
            } else {
                DefaultEdge defaultEdge = ((TVFlow)this.getTopView()).getEdge();
                if (defaultEdge != null) {
                    Map map = defaultEdge.getAttributes();
                    DiagramConstants.setLineEnd(map, 1);
                    defaultEdge.setAttributes(map);
                    EdgeView edgeView = (EdgeView)defaultEdge.getDiagram().getDiagramLayoutCache().getMapping(defaultEdge, false);
                    edgeView.update();
                    edgeView.getDiagram().repaint();
                }
            }
        }
    }

    public boolean isOpCreate() {
        return this.opCreate;
    }

    public void setOpCreate(boolean bl) {
        this.opCreate = bl;
    }

    public boolean isOpDelete() {
        return this.opDelete;
    }

    public void setOpDelete(boolean bl) {
        this.opDelete = bl;
    }

    public boolean isOpRead() {
        return this.opRead || this.getSourceProcessObject() instanceof InfoStore;
    }

    public void setOpRead(boolean bl) {
        this.opRead = bl;
    }

    public boolean isOpUpdate() {
        return this.opUpdate;
    }

    public void setOpUpdate(boolean bl) {
        this.opUpdate = bl;
    }

    public String getSystemObjective() {
        return this.systemObjective;
    }

    public void setSystemObjective(String string) {
        this.systemObjective = string;
    }

    public List getInfoStructures() {
        ArrayList arrayList = new ArrayList();
        if (this.isConnecedTotCompositeProc()) {
            for (Flow flow : this.getComponentFlows()) {
                arrayList.addAll(flow.getInfoStructures());
            }
            return arrayList;
        }
        return this.infoStructures;
    }

    public void addInfoStructure(InfoStructure infoStructure) {
        this.infoStructures.add(infoStructure);
    }

    public void removeInfoStructure(InfoStructure infoStructure) {
        this.infoStructures.remove(infoStructure);
    }

    public InfoStructure getInfoStructureByID(String string) {
        for (InfoStructure infoStructure : this.infoStructures) {
            if (!infoStructure.getObjectID().equals(string)) continue;
            return infoStructure;
        }
        return null;
    }

    public AbstractProcessObject getDestination() {
        return this.destination;
    }

    public void setDestination(AbstractProcessObject abstractProcessObject) {
        this.destination = abstractProcessObject;
    }

    public AbstractProcessObject getParentObject() {
        return this.parent;
    }

    public void setParentObject(AbstractProcessObject abstractProcessObject) {
        this.parent = abstractProcessObject;
    }

    public AbstractProcessObject getSource() {
        return this.source;
    }

    public void setSource(AbstractProcessObject abstractProcessObject) {
        this.source = abstractProcessObject;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean bl) {
        this.logging = bl;
    }

    public List getExternalData() {
        AbstractProcessObject abstractProcessObject;
        ArrayList arrayList = new ArrayList();
        if (this.getSourceProcessObject() instanceof ExternalAgent) {
            abstractProcessObject = (ExternalAgent)this.getSourceProcessObject();
            arrayList.addAll(((ExternalAgent)abstractProcessObject).getExternalDatas());
        }
        if (this.getTargetProcessObject() instanceof ExternalAgent) {
            abstractProcessObject = (ExternalAgent)this.getTargetProcessObject();
            arrayList.addAll(((ExternalAgent)abstractProcessObject).getExternalDatas());
        }
        if (this.getSourceProcessObject() instanceof InfoStore) {
            abstractProcessObject = (InfoStore)this.getSourceProcessObject();
            arrayList.addAll(((InfoStore)abstractProcessObject).getDatas());
        }
        if (this.getTargetProcessObject() instanceof InfoStore) {
            abstractProcessObject = (InfoStore)this.getTargetProcessObject();
            arrayList.addAll(((InfoStore)abstractProcessObject).getDatas());
        }
        return arrayList;
    }

    public List getComponentFlows() {
        Process process;
        ArrayList arrayList = new ArrayList();
        if (this.getSourceProcessObject() instanceof Process && (process = (Process)this.getSourceProcessObject()).isComposite()) {
            arrayList.addAll(process.getComponentFlowsFor(this));
        }
        if (this.getTargetProcessObject() instanceof Process && (process = (Process)this.getTargetProcessObject()).isComposite()) {
            arrayList.addAll(process.getComponentFlowsFor(this));
        }
        return arrayList;
    }

    public boolean isBalanced() {
        Process process;
        if (this.getSourceProcessObject() instanceof Process && (process = (Process)this.getSourceProcessObject()).isComposite() && process.getComponentFlowsFor(this).size() == 0) {
            return false;
        }
        return !(this.getTargetProcessObject() instanceof Process) || !(process = (Process)this.getTargetProcessObject()).isComposite() || process.getComponentFlowsFor(this).size() != 0;
    }

    @Override
    public void remove() {
        Object object;
        ArrayList arrayList = new ArrayList();
        AbstractProcessObject abstractProcessObject = this.getSourceProcessObject();
        AbstractProcessObject abstractProcessObject2 = this.getTargetProcessObject();
        if (this.getDesignPart() instanceof DataFlowDesign) {
            object = (DataFlowDesign)this.getDesignPart();
            arrayList.addAll(((DataFlowDesign)object).getFlowsBetween(abstractProcessObject, abstractProcessObject2));
            arrayList.addAll(((DataFlowDesign)object).getFlowsBetween(abstractProcessObject2, abstractProcessObject));
        }
        if (arrayList.size() == 1) {
            Object object2;
            object = this.getComponentFlows();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = (Flow)iterator.next();
                ((Flow)object2).remove();
            }
            if (abstractProcessObject instanceof Process && ((Process)abstractProcessObject).isComposite() && ((Process)abstractProcessObject).getDiagram() != null && (object2 = (AbstractDataFlowTV)abstractProcessObject2.getFirstViewForDPV(((Process)abstractProcessObject).getDiagram().getMainView())) != null && !((AbstractDataFlowTV)object2).isConnected()) {
                ((AbstractDataFlowTV)object2).remove(false);
            }
            if (abstractProcessObject2 instanceof Process && ((Process)abstractProcessObject2).isComposite() && ((Process)abstractProcessObject2).getDiagram() != null && (object2 = (AbstractDataFlowTV)abstractProcessObject.getFirstViewForDPV(((Process)abstractProcessObject2).getDiagram().getMainView())) != null && !((AbstractDataFlowTV)object2).isConnected()) {
                ((AbstractDataFlowTV)object2).remove(false);
            }
        } else {
            object = this.getComponentFlows();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Flow flow = (Flow)iterator.next();
                flow.remove();
            }
        }
        super.remove();
        this.setProcessObject(1, null);
        this.setProcessObject(0, null);
    }

    @Override
    public void changed(TopView topView, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView designPartView = topView.getDesignPartView();
            designPartView.removeViewFor(this);
            dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            dpvInfo2.tv = null;
            if (dpvInfo2.sourceTV == topView) {
                dpvInfo2.sourceTV = null;
            }
            if (dpvInfo2.targetTV == topView) {
                dpvInfo2.targetTV = null;
            }
            if (this.getDesignPart() == designPartView.getDesignPart()) {
                this.remove();
            }
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FlowPropertiesDialogEx flowPropertiesDialogEx = new FlowPropertiesDialogEx(this.getDesign().getAppView(), this);
            flowPropertiesDialogEx.initProperties(this);
            flowPropertiesDialogEx.show();
        }
    }

    public void addSynonymToCompositeProcDiagram() {
        if (this.getSourceProcessObject() != null && this.getTargetProcessObject() != null) {
            AbstractProcessObject abstractProcessObject = this.getSourceProcessObject();
            AbstractProcessObject abstractProcessObject2 = this.getTargetProcessObject();
            if (abstractProcessObject.getTopView() != null && abstractProcessObject2.getTopView() != null) {
                AbstractDataFlowTV abstractDataFlowTV;
                DesignPartView designPartView;
                DataFlowDesign dataFlowDesign = null;
                if (abstractProcessObject instanceof Process) {
                    dataFlowDesign = ((Process)abstractProcessObject).getDiagram();
                }
                if (abstractProcessObject instanceof Process && ((Process)abstractProcessObject).isComposite() && dataFlowDesign != null) {
                    designPartView = dataFlowDesign.getMainView();
                    if (abstractProcessObject2 != abstractProcessObject && !(abstractProcessObject2 instanceof Process) && abstractProcessObject2.getViewsCountForDPV(designPartView) == 0) {
                        abstractDataFlowTV = (AbstractDataFlowTV)abstractProcessObject2.getTopView().createViewSynonim(designPartView);
                        abstractDataFlowTV.addTVFlows();
                    }
                    if (abstractProcessObject2 != abstractProcessObject && abstractProcessObject2 instanceof Process && !this.isParentProcessPresentedInDPV((Process)abstractProcessObject2, (DPVProcess)designPartView) && abstractProcessObject2.getViewsCountForDPV(designPartView) == 0) {
                        abstractDataFlowTV = (AbstractDataFlowTV)abstractProcessObject2.getTopView().createViewSynonim(designPartView);
                        abstractDataFlowTV.addTVFlows();
                    }
                }
                dataFlowDesign = null;
                if (abstractProcessObject2 instanceof Process) {
                    dataFlowDesign = ((Process)abstractProcessObject2).getDiagram();
                }
                if (abstractProcessObject2 instanceof Process && ((Process)abstractProcessObject2).isComposite() && dataFlowDesign != null) {
                    designPartView = dataFlowDesign.getMainView();
                    if (abstractProcessObject2 != abstractProcessObject && !(abstractProcessObject instanceof Process) && abstractProcessObject.getViewsCountForDPV(designPartView) == 0) {
                        abstractDataFlowTV = (AbstractDataFlowTV)abstractProcessObject.getTopView().createViewSynonim(designPartView);
                        abstractDataFlowTV.addTVFlows();
                    }
                    if (abstractProcessObject2 != abstractProcessObject && abstractProcessObject instanceof Process && !this.isParentProcessPresentedInDPV((Process)abstractProcessObject, (DPVProcess)designPartView) && abstractProcessObject.getViewsCountForDPV(designPartView) == 0) {
                        abstractDataFlowTV = (AbstractDataFlowTV)abstractProcessObject.getTopView().createViewSynonim(designPartView);
                        abstractDataFlowTV.addTVFlows();
                    }
                }
            }
        }
    }

    private boolean isParentProcessPresentedInDPV(Process process, DPVProcess dPVProcess) {
        if (process.getViewsCountForDPV(dPVProcess) > 0) {
            return true;
        }
        Process process2 = process.getParentProcess();
        if (process2 != null) {
            return this.isParentProcessPresentedInDPV(process2, dPVProcess);
        }
        return false;
    }

    public void createOrSetParentFlow() {
        if (this.getSourceProcessObject() != null && this.getTargetProcessObject() != null) {
            AbstractProcessObject abstractProcessObject = this.getSourceProcessObject();
            AbstractProcessObject abstractProcessObject2 = this.getTargetProcessObject();
            if (abstractProcessObject instanceof Process && ((Process)abstractProcessObject).getDesignPart() == this.getDesignPart()) {
                if (abstractProcessObject2 != abstractProcessObject && (abstractProcessObject2 instanceof InfoStore || abstractProcessObject2 instanceof ExternalAgent || abstractProcessObject2 instanceof Process && ((Process)abstractProcessObject2).getDesignPart() != this.getDesignPart())) {
                    Process process = ((DataFlowDesign)this.getDesignPart()).getProcess();
                    DataFlowDesign dataFlowDesign = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
                    if (process != null && dataFlowDesign != null) {
                        Flow flow = dataFlowDesign.getFirstFlowBetween(process, abstractProcessObject2);
                        if (flow == null) {
                            DesignPartView designPartView = dataFlowDesign.getMainView();
                            TopView topView = process.getFirstViewForDPV(designPartView);
                            TopView topView2 = abstractProcessObject2.getFirstViewForDPV(designPartView);
                            if (topView != null && topView2 != null) {
                                flow = dataFlowDesign.createFlow();
                                flow.setName(this.getName() + "_" + this.getDesignPart().getName() + "_Par");
                                flow.setSourceTV((AbstractDataFlowTV)topView);
                                flow.setTargetTV((AbstractDataFlowTV)topView2);
                                ((TVFlow)flow.getTopView()).addConnection();
                                this.setParentObject(flow);
                            }
                        } else {
                            this.setParentObject(flow);
                        }
                    }
                }
            } else if (abstractProcessObject2 instanceof Process && ((Process)abstractProcessObject2).getDesignPart() == this.getDesignPart()) {
                if (abstractProcessObject2 != abstractProcessObject && (abstractProcessObject instanceof InfoStore || abstractProcessObject instanceof ExternalAgent || abstractProcessObject instanceof Process && ((Process)abstractProcessObject).getDesignPart() != this.getDesignPart())) {
                    Process process = ((DataFlowDesign)this.getDesignPart()).getProcess();
                    DataFlowDesign dataFlowDesign = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
                    if (process != null && dataFlowDesign != null) {
                        Flow flow = dataFlowDesign.getFirstFlowBetween(abstractProcessObject, process);
                        if (flow == null) {
                            DesignPartView designPartView = dataFlowDesign.getMainView();
                            TopView topView = abstractProcessObject.getFirstViewForDPV(designPartView);
                            TopView topView3 = process.getFirstViewForDPV(designPartView);
                            if (topView != null && topView3 != null) {
                                flow = dataFlowDesign.createFlow();
                                flow.setName(this.getName() + "_" + this.getDesignPart().getName() + "_Par");
                                flow.setSourceTV((AbstractDataFlowTV)topView);
                                flow.setTargetTV((AbstractDataFlowTV)topView3);
                                ((TVFlow)flow.getTopView()).addConnection();
                                this.setParentObject(flow);
                            }
                        } else {
                            this.setParentObject(flow);
                        }
                    }
                }
            } else if (abstractProcessObject instanceof Process && ((Process)abstractProcessObject).getDesignPart() != this.getDesignPart()) {
                if (abstractProcessObject2 != abstractProcessObject && abstractProcessObject2 instanceof Process && ((Process)abstractProcessObject2).getDesignPart() == this.getDesignPart()) {
                    Process process = ((DataFlowDesign)this.getDesignPart()).getProcess();
                    DataFlowDesign dataFlowDesign = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
                    if (process != null && dataFlowDesign != null) {
                        Flow flow = dataFlowDesign.getFirstFlowBetween(abstractProcessObject, process);
                        if (flow == null) {
                            DesignPartView designPartView = dataFlowDesign.getMainView();
                            TopView topView = abstractProcessObject.getFirstViewForDPV(designPartView);
                            TopView topView4 = process.getFirstViewForDPV(designPartView);
                            if (topView != null && topView4 != null) {
                                flow = dataFlowDesign.createFlow();
                                flow.setName(this.getName() + "_" + this.getDesignPart().getName() + "_Par");
                                flow.setSourceTV((AbstractDataFlowTV)topView);
                                flow.setTargetTV((AbstractDataFlowTV)topView4);
                                ((TVFlow)flow.getTopView()).addConnection();
                                this.setParentObject(flow);
                            }
                        } else {
                            this.setParentObject(flow);
                        }
                    }
                } else if (abstractProcessObject2 != abstractProcessObject && (abstractProcessObject2 instanceof InfoStore || abstractProcessObject2 instanceof ExternalAgent)) {
                    DataFlowDesign dataFlowDesign = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
                    DPVProcess dPVProcess = (DPVProcess)((DataFlowDesign)this.getDesignPart()).getMainView();
                    TopView topView = abstractProcessObject2.getFirstViewForDPV(dPVProcess);
                    if (dataFlowDesign != null) {
                        DPVProcess dPVProcess2 = (DPVProcess)dataFlowDesign.getMainView();
                        AbstractDataFlowTV abstractDataFlowTV = (AbstractDataFlowTV)abstractProcessObject2.getFirstViewForDPV(dPVProcess2);
                        if (abstractDataFlowTV == null) {
                            abstractDataFlowTV = (AbstractDataFlowTV)dPVProcess2.createViewSynonim(abstractProcessObject2);
                            if (abstractDataFlowTV.getCellView() != null) {
                                abstractDataFlowTV.getCellView().setNewBounds(new Rectangle(topView.getLocation(), new Dimension(topView.getBounds().width, topView.getBounds().height)));
                            } else {
                                abstractDataFlowTV.setBounds(new Rectangle(topView.getLocation(), new Dimension(topView.getBounds().width, topView.getBounds().height)));
                            }
                        }
                        abstractDataFlowTV.addTVFlows();
                    }
                }
            } else if (abstractProcessObject2 instanceof Process && ((Process)abstractProcessObject2).getDesignPart() != this.getDesignPart()) {
                if (abstractProcessObject2 != abstractProcessObject && abstractProcessObject instanceof Process && ((Process)abstractProcessObject).getDesignPart() == this.getDesignPart()) {
                    Process process = ((DataFlowDesign)this.getDesignPart()).getProcess();
                    DataFlowDesign dataFlowDesign = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
                    if (process != null && dataFlowDesign != null) {
                        Flow flow = dataFlowDesign.getFirstFlowBetween(abstractProcessObject, process);
                        if (flow == null) {
                            DesignPartView designPartView = dataFlowDesign.getMainView();
                            TopView topView = process.getFirstViewForDPV(designPartView);
                            TopView topView5 = abstractProcessObject2.getFirstViewForDPV(designPartView);
                            if (topView != null && topView5 != null) {
                                flow = dataFlowDesign.createFlow();
                                flow.setName(this.getName() + "_" + this.getDesignPart().getName() + "_Par");
                                flow.setSourceTV((AbstractDataFlowTV)topView);
                                flow.setTargetTV((AbstractDataFlowTV)topView5);
                                ((TVFlow)flow.getTopView()).addConnection();
                                this.setParentObject(flow);
                            }
                        } else {
                            this.setParentObject(flow);
                        }
                    }
                } else if (abstractProcessObject2 != abstractProcessObject && (abstractProcessObject instanceof InfoStore || abstractProcessObject instanceof ExternalAgent)) {
                    DataFlowDesign dataFlowDesign = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
                    DPVProcess dPVProcess = (DPVProcess)((DataFlowDesign)this.getDesignPart()).getMainView();
                    TopView topView = abstractProcessObject.getFirstViewForDPV(dPVProcess);
                    if (dataFlowDesign != null) {
                        DPVProcess dPVProcess3 = (DPVProcess)dataFlowDesign.getMainView();
                        AbstractDataFlowTV abstractDataFlowTV = (AbstractDataFlowTV)abstractProcessObject.getFirstViewForDPV(dPVProcess3);
                        if (abstractDataFlowTV == null) {
                            abstractDataFlowTV = (AbstractDataFlowTV)dPVProcess3.createViewSynonim(abstractProcessObject);
                            if (abstractDataFlowTV.getCellView() != null) {
                                abstractDataFlowTV.getCellView().setNewBounds(new Rectangle(topView.getLocation(), new Dimension(topView.getBounds().width, topView.getBounds().height)));
                            } else {
                                abstractDataFlowTV.setBounds(new Rectangle(topView.getLocation(), new Dimension(topView.getBounds().width, topView.getBounds().height)));
                            }
                        }
                        abstractDataFlowTV.addTVFlows();
                    }
                }
            }
        }
    }

    public List getPossibleParentFlows() {
        DataFlowDesign dataFlowDesign = ((DataFlowDesign)this.getDesignPart()).getParentDataFlowdesign();
        if (dataFlowDesign != null) {
            AbstractProcessObject abstractProcessObject = this.getSourceProcessObject();
            AbstractProcessObject abstractProcessObject2 = this.getTargetProcessObject();
            if (abstractProcessObject instanceof Process && abstractProcessObject.getDesignPart() == this.getDesignPart()) {
                abstractProcessObject = ((DataFlowDesign)abstractProcessObject.getDesignPart()).getProcess();
            }
            if (abstractProcessObject2 instanceof Process && abstractProcessObject2.getDesignPart() == this.getDesignPart()) {
                abstractProcessObject2 = ((DataFlowDesign)abstractProcessObject2.getDesignPart()).getProcess();
            }
            return dataFlowDesign.getFlowsBetween(abstractProcessObject, abstractProcessObject2);
        }
        return new ArrayList();
    }

    public boolean isConnecedTotCompositeProc() {
        if (this.getSourceProcessObject() instanceof Process && ((Process)this.getSourceProcessObject()).isComposite()) {
            return true;
        }
        return this.getTargetProcessObject() instanceof Process && ((Process)this.getTargetProcessObject()).isComposite();
    }

    public boolean isConnectedToInfoStore() {
        if (this.getSourceProcessObject() instanceof InfoStore) {
            return true;
        }
        return this.getTargetProcessObject() instanceof InfoStore;
    }

    public boolean isConnectedToExternaAgent() {
        if (this.getSourceProcessObject() instanceof ExternalAgent) {
            return true;
        }
        return this.getTargetProcessObject() instanceof ExternalAgent;
    }

    @Override
    public void setSourceTopView(TopView topView) {
        this.setSourceTV((AbstractDataFlowTV)topView);
    }

    @Override
    public void setTargetTopView(TopView topView) {
        this.setTargetTV((AbstractDataFlowTV)topView);
    }

    @Override
    public TopView getSourceTopView(DesignPartView designPartView) {
        return this.getSourceTV(designPartView);
    }

    @Override
    public TopView getTargetTopView(DesignPartView designPartView) {
        return this.getTargetTV(designPartView);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getSourceProcessObject();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getTargetProcessObject();
    }

    @Override
    public void restoreTopView(TopView topView, TopView topView2, TopView topView3) {
        topView.getDesignPartView().restoreTopview(topView, this);
        dpvInfo dpvInfo2 = this.getDPVInfoFor(topView.getDesignPartView());
        if (dpvInfo2.tv == topView) {
            this.addObjectListener(topView);
            dpvInfo2.targetTV = (AbstractDataFlowTV)topView3;
            dpvInfo2.targetTV.addTopViewListener(this);
            dpvInfo2.sourceTV = (AbstractDataFlowTV)topView2;
            dpvInfo2.sourceTV.addTopViewListener(this);
        }
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "flow/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public class DestinationConnection
    extends Connection {
        @Override
        public AbstractProcessObject getProcessObject() {
            return Flow.this.getProcessObject(1);
        }

        @Override
        public String getDescriptor() {
            return "Destination";
        }

        @Override
        public boolean isSource() {
            return false;
        }
    }

    public class SourceConnection
    extends Connection {
        @Override
        public AbstractProcessObject getProcessObject() {
            return Flow.this.getProcessObject(0);
        }

        @Override
        public String getDescriptor() {
            return "Source";
        }

        @Override
        public boolean isSource() {
            return true;
        }
    }

    public abstract class Connection {
        private Boolean optionality = Boolean.TRUE;
        private String nameOn = null;

        public Flow getFlow() {
            return Flow.this;
        }

        public abstract AbstractProcessObject getProcessObject();

        public abstract String getDescriptor();

        public abstract boolean isSource();

        public String toString() {
            return Flow.this.getName() + this.getDescriptor();
        }

        public boolean isOptional() {
            return this.optionality;
        }

        public void setOptional(boolean bl) {
            this.optionality = bl ? Boolean.TRUE : Boolean.FALSE;
        }

        public Boolean getOptionality() {
            return this.optionality;
        }

        public void setOptionality(Boolean bl) {
            this.optionality = bl == null ? Boolean.FALSE : bl;
        }

        public void setNameOn(String string) {
            this.nameOn = string;
        }

        public TopView getTopView() {
            return Flow.this.getTopView();
        }

        public String getNameOn() {
            return this.nameOn;
        }
    }

    public class dpvInfo {
        public AbstractDataFlowTV sourceTV;
        public AbstractDataFlowTV targetTV;
        public TopView tv;
        public DesignPartView dpv;

        dpvInfo() {
        }
    }
}

