/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.swingui.editor.process.ExternalDataPropertiesDialog;

public class ExternalData
extends AbstractProcessObject {
    private LogicalDatatype type;
    private int startingPos = 0;
    private String description = "";
    private DesignObject mappedDesignObject;
    private boolean structured = false;
    private RecordStructure recStructure;
    private RecordStructure owner;
    public static final String TYPE_NAME = "ExternalData";

    public ExternalData(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "ED";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ExternalDataPropertiesDialog externalDataPropertiesDialog = new ExternalDataPropertiesDialog(this.getDesign().getAppView(), this);
            externalDataPropertiesDialog.initProperties(this);
            externalDataPropertiesDialog.show();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (string != null) {
            this.description = string;
        }
    }

    public int getStartingPos() {
        return this.startingPos;
    }

    public void setStartingPos(int n) {
        this.startingPos = n;
    }

    public LogicalDatatype getType() {
        return this.type;
    }

    public void setType(LogicalDatatype logicalDatatype) {
        this.type = logicalDatatype;
    }

    public DesignObject getMappedDesignObject() {
        return this.mappedDesignObject;
    }

    public void setMappedDesignObject(DesignObject designObject) {
        if (this.mappedDesignObject != designObject) {
            this.mappedDesignObject = designObject;
            this.setDirty(true);
        }
    }

    public RecordStructure getRecordStructure() {
        return this.recStructure;
    }

    public void setRecordStructure(RecordStructure recordStructure) {
        this.recStructure = recordStructure;
    }

    public boolean isStructured() {
        return this.structured;
    }

    public void setStructured(boolean bl) {
        this.structured = bl;
    }

    public RecordStructure getOwner() {
        return this.owner;
    }

    public void setOwner(RecordStructure recordStructure) {
        this.owner = recordStructure;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "extdata/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

