/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.TopViewListener;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.swingui.process.TVFlow;

public abstract class AbstractProcessObject
extends DesignObject {
    Collection allViews = new ArrayList();
    private String synonym = "";
    private List relationConnections = new ArrayList();

    public AbstractProcessObject(DesignPart designPart) {
        super(designPart);
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String string) {
        this.synonym = string;
    }

    void add(Flow.Connection connection) {
        this.relationConnections.add(connection);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_ADDED);
    }

    void remove(Flow.Connection connection) {
        this.relationConnections.remove(connection);
        this.removeTVListenerFromAllViews(connection.getFlow());
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_REMOVED);
    }

    public Flow.Connection[] getAllFlows() {
        return (Flow.Connection[])this.relationConnections.toArray(Flow.CONNECTION_PROTO_ARRAY);
    }

    public List getIncomingFlows() {
        ArrayList<Flow> arrayList = new ArrayList<Flow>();
        Flow.Connection[] connectionArray = this.getAllFlows();
        for (int i = 0; i < connectionArray.length; ++i) {
            if (connectionArray[i].isSource()) continue;
            arrayList.add(connectionArray[i].getFlow());
        }
        return arrayList;
    }

    public List getOutgoingFlows() {
        ArrayList<Flow> arrayList = new ArrayList<Flow>();
        Flow.Connection[] connectionArray = this.getAllFlows();
        for (int i = 0; i < connectionArray.length; ++i) {
            if (!connectionArray[i].isSource() || connectionArray[i].getFlow().getSourceProcessObject() != this) continue;
            arrayList.add(connectionArray[i].getFlow());
        }
        return arrayList;
    }

    public List getIncomingFlowsFrom(AbstractProcessObject abstractProcessObject) {
        ArrayList<Flow> arrayList = new ArrayList<Flow>();
        Flow.Connection[] connectionArray = this.getAllFlows();
        for (int i = 0; i < connectionArray.length; ++i) {
            if (connectionArray[i].isSource() || connectionArray[i].getFlow().getSourceProcessObject() != abstractProcessObject) continue;
            arrayList.add(connectionArray[i].getFlow());
        }
        return arrayList;
    }

    public List getOutgoingFlowsTo(AbstractProcessObject abstractProcessObject) {
        ArrayList<Flow> arrayList = new ArrayList<Flow>();
        Flow.Connection[] connectionArray = this.getAllFlows();
        for (int i = 0; i < connectionArray.length; ++i) {
            if (!connectionArray[i].isSource() || connectionArray[i].getFlow().getTargetProcessObject() != abstractProcessObject) continue;
            arrayList.add(connectionArray[i].getFlow());
        }
        return arrayList;
    }

    public int getNumberOfFlows() {
        return this.relationConnections.size();
    }

    public void removeFlows() {
        for (int i = this.relationConnections.size() - 1; i >= 0; --i) {
            Flow.Connection connection = (Flow.Connection)this.relationConnections.get(i);
            Flow flow = connection.getFlow();
            flow.getSource().remove(connection);
            flow.getTargetProcessObject().remove(connection);
            TVFlow tVFlow = (TVFlow)flow.getTopView();
            if (tVFlow == null) continue;
            tVFlow.remove();
        }
    }

    @Override
    public void setTopView(TopView topView) {
        this.addTopView(topView);
    }

    @Override
    public TopView getTopView() {
        if (this.allViews.isEmpty()) {
            return null;
        }
        Iterator iterator = this.allViews.iterator();
        TopViewCollection topViewCollection = (TopViewCollection)iterator.next();
        if (topViewCollection.isEmpty()) {
            return null;
        }
        Iterator iterator2 = topViewCollection.iterator();
        return (TopView)iterator2.next();
    }

    public TopView getTopViewByID(String string) {
        TopViewCollection topViewCollection2 = null;
        for (TopViewCollection topViewCollection2 : this.allViews) {
            for (TopView topView : topViewCollection2) {
                if (!string.equalsIgnoreCase(topView.getViewID())) continue;
                return topView;
            }
        }
        return this.getTopView();
    }

    @Override
    public TopView getTopViewByID(DesignPartView designPartView, String string, int n) {
        if (string != null) {
            Collection collection = this.getAllViews(designPartView);
            for (TopView topView : collection) {
                if (!string.equalsIgnoreCase(topView.getViewID())) continue;
                return topView;
            }
            int n2 = 0;
            for (TopView topView : collection) {
                if (n == n2) {
                    topView.setViewNumber(n);
                    return topView;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public int getViewNumber(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        if (topViewCollection.isEmpty()) {
            return -100;
        }
        Iterator iterator = topViewCollection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TopView topView2 = (TopView)iterator.next();
            if (topView2 == topView) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Collection getViewSynonims(DesignPartView designPartView) {
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        ArrayList arrayList = new ArrayList();
        if (topViewCollection.size() > 1) {
            Iterator iterator = topViewCollection.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    public Collection getAllViews(DesignPartView designPartView) {
        ArrayList arrayList = new ArrayList();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        if (topViewCollection.size() > 0) {
            Iterator iterator = topViewCollection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    public List getAllViews() {
        ArrayList arrayList = new ArrayList();
        for (TopViewCollection topViewCollection : this.allViews) {
            arrayList.addAll(topViewCollection);
        }
        return arrayList;
    }

    public Collection getAllViewsForCurrentDPV() {
        DesignPartView designPartView = this.getDesign().getAppView().getCurrentDPV();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        ArrayList arrayList = new ArrayList();
        if (topViewCollection.size() > 0) {
            Iterator iterator = topViewCollection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    @Override
    public void remove() {
        this.removeFlows();
        this.removeAllViews();
        super.remove();
    }

    public void removeAllViews() {
        TopViewCollection[] topViewCollectionArray = this.allViews.toArray(new TopViewCollection[0]);
        for (int i = 0; i < topViewCollectionArray.length; ++i) {
            DesignPartView designPartView = topViewCollectionArray[i].getDPV();
            designPartView.getWorkSpace().removeProcessObject(this);
            TopView[] topViewArray = topViewCollectionArray[i].toArray(new TopView[0]);
            for (int j = 0; j < topViewArray.length; ++j) {
                designPartView.unregisterFromTreemodel(topViewArray[j]);
                this.removeTopView(topViewArray[j]);
            }
        }
    }

    public void removeTVListenerFromAllViews(TopViewListener topViewListener) {
        TopViewCollection[] topViewCollectionArray = this.allViews.toArray(new TopViewCollection[0]);
        for (int i = 0; i < topViewCollectionArray.length; ++i) {
            TopView[] topViewArray = topViewCollectionArray[i].toArray(new TopView[0]);
            for (int j = 0; j < topViewArray.length; ++j) {
                ((AbstractDataFlowTV)topViewArray[j]).removeTopViewListener(topViewListener);
            }
        }
    }

    public TopView getAnotherView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        for (TopView topView2 : topViewCollection) {
            if (topView2 == topView) continue;
            return topView2;
        }
        return null;
    }

    @Override
    public void removeViewSynonim(TopView topView) {
        this.removeTopView(topView);
    }

    @Override
    public void resetViewNumbers() {
        for (TopViewCollection topViewCollection : this.allViews) {
            for (TopView topView : topViewCollection) {
                topView.setViewNumber(this.getViewNumber(topView));
            }
        }
    }

    @Override
    public int getTopViewsCount() {
        int n = 0;
        for (TopViewCollection topViewCollection : this.allViews) {
            n += topViewCollection.size();
        }
        return n;
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView designPartView) {
        for (TopViewCollection topViewCollection : this.allViews) {
            if (topViewCollection.getDPV() != designPartView) continue;
            if (topViewCollection.size() > 0) {
                return (TopView)topViewCollection.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public TopViewCollection getViewsForDPV(DesignPartView designPartView) {
        TopViewCollection topViewCollection2;
        for (TopViewCollection topViewCollection2 : this.allViews) {
            if (topViewCollection2.getDPV() != designPartView) continue;
            return topViewCollection2;
        }
        topViewCollection2 = new TopViewCollection();
        topViewCollection2.setDPV(designPartView);
        this.allViews.add(topViewCollection2);
        return topViewCollection2;
    }

    @Override
    public int getViewsCountForDPV(DesignPartView designPartView) {
        for (TopViewCollection topViewCollection : this.allViews) {
            if (topViewCollection.getDPV() != designPartView) continue;
            return topViewCollection.size();
        }
        return 0;
    }

    public Collection getAffectedDPVs() {
        ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
        for (TopViewCollection topViewCollection : this.allViews) {
            if (arrayList.contains(topViewCollection.dpv) || topViewCollection.size() <= 0) continue;
            arrayList.add(topViewCollection.dpv);
        }
        return arrayList;
    }

    public void addTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        topViewCollection.add(topView);
        this.addObjectListener(topView);
    }

    public void removeTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        topViewCollection.remove(topView);
        if (topViewCollection.size() == 0) {
            this.allViews.remove(topViewCollection);
        }
        this.removeObjectListener(topView);
    }
}

