/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.editor.multidimensional.SlicePropertiesDialogEx;

public class Slice
extends AbstractMDObject {
    private boolean readOnlySlice = true;
    private final List levels = new ArrayList();
    private boolean fullyRealized;
    private Entity entity;
    private final List selectionCriterias = new ArrayList();
    private Cube cube;
    private final List selectedMeasureWrappers = new ArrayList();
    private final List allMeasureWrappers = new ArrayList();
    private final List selectedLevels = new ArrayList();
    private final List sliceMappings = new ArrayList();
    private final List sqlDefinitions = new ArrayList();
    public static final String TYPE_NAME = "Slice";

    public Slice(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SlicePropertiesDialogEx slicePropertiesDialogEx = new SlicePropertiesDialogEx(this.getDesign().getAppView(), this);
            slicePropertiesDialogEx.initProperties(this);
            slicePropertiesDialogEx.show();
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
        if (entity != null) {
            entity.setTypeID(this.getDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_SUMMARY).getTypeID());
        }
    }

    public boolean isFullyRealized() {
        return this.fullyRealized;
    }

    public void setFullyRealized(boolean bl) {
        this.fullyRealized = bl;
    }

    public boolean isReadOnlySlice() {
        return this.readOnlySlice;
    }

    public void setReadOnlySlice(boolean bl) {
        this.readOnlySlice = bl;
    }

    public List getLevels() {
        return this.levels;
    }

    public void addLevel(Level level) {
        this.levels.add(level);
    }

    public void removeLevel(Level level) {
        this.levels.remove(level);
    }

    public List getSelectionCriterias() {
        return this.selectionCriterias;
    }

    public void addSelectionCriteria(SelectionCriteria selectionCriteria) {
        selectionCriteria.setSlice(this);
        this.selectionCriterias.add(selectionCriteria);
    }

    public void removeSelectionCriteria(SelectionCriteria selectionCriteria) {
        this.selectionCriterias.remove(selectionCriteria);
    }

    public SelectionCriteria createSelectionCriteria() {
        SelectionCriteria selectionCriteria = this.getMultidimensionalDesign().createSelectionCriteria();
        this.addSelectionCriteria(selectionCriteria);
        return selectionCriteria;
    }

    public Cube getCube() {
        return this.cube;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
    }

    public void applyMeasureWrappers(List list) {
        MeasureWrapper[] measureWrapperArray = this.selectedMeasureWrappers.toArray(new MeasureWrapper[0]);
        this.selectedMeasureWrappers.clear();
        for (MeasureWrapper measureWrapper : list) {
            MeasureWrapper measureWrapper2 = this.getMeasureWrapperFor(measureWrapper, measureWrapperArray);
            if (measureWrapper2 != null) {
                this.selectedMeasureWrappers.add(measureWrapper2);
                continue;
            }
            this.selectedMeasureWrappers.add(measureWrapper);
        }
    }

    private MeasureWrapper getMeasureWrapperFor(MeasureWrapper measureWrapper, MeasureWrapper[] measureWrapperArray) {
        for (int i = 0; i < measureWrapperArray.length; ++i) {
            MeasureWrapper measureWrapper2 = measureWrapperArray[i];
            if (measureWrapper2.measureId == null || !measureWrapper2.measureId.equals(measureWrapper.measureId)) continue;
            if (measureWrapper2.aggrFuncId != null && measureWrapper.aggrFuncId != null && measureWrapper2.aggrFuncId.equals(measureWrapper.aggrFuncId)) {
                return measureWrapper2;
            }
            if (measureWrapper2.aggrFuncId != null || measureWrapper.aggrFuncId != null) continue;
            return measureWrapper2;
        }
        return null;
    }

    public SelectedLevel createSelectedLevel() {
        return new SelectedLevel(this);
    }

    public void applySelectedLevels(List list) {
        this.selectedLevels.clear();
        this.selectedLevels.addAll(list);
    }

    public List getSelectedMeasureWrappers() {
        return this.selectedMeasureWrappers;
    }

    public List getAllMeasureWrappers() {
        return this.allMeasureWrappers;
    }

    public void verifyMeasureWrappers() {
        Object object;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.selectedMeasureWrappers);
        this.allMeasureWrappers.clear();
        for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : this.cube.getMeasures()) {
            if (((Measure)iD_ObjectPropertyTranslator).getAggregateFunctions().size() == 0) {
                object = ((Measure)iD_ObjectPropertyTranslator).createAggregateFunction();
                ((Measure)iD_ObjectPropertyTranslator).addAggregateFunction((Measure.AggregateFunction)object);
                ((Measure)iD_ObjectPropertyTranslator).setDefaultAggregationFunction((Measure.AggregateFunction)object);
                for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator2 : ((Measure)iD_ObjectPropertyTranslator).getAggregateFunctions()) {
                    MeasureWrapper measureWrapper = new MeasureWrapper((Measure)iD_ObjectPropertyTranslator, (Measure.AggregateFunction)iD_ObjectPropertyTranslator2, this);
                    measureWrapper.levels.addAll(((Measure.AggregateFunction)object).levels);
                    this.allMeasureWrappers.add(measureWrapper);
                }
                continue;
            }
            if (((Measure)iD_ObjectPropertyTranslator).isDefinedAsOracleAWCalculated()) {
                object = (Measure.AggregateFunction)((Measure)iD_ObjectPropertyTranslator).getAggregateFunctions().get(0);
                ((Measure.AggregateFunction)object).name = "OLAP";
                Object object2 = new MeasureWrapper((Measure)iD_ObjectPropertyTranslator, (Measure.AggregateFunction)object, this);
                ((MeasureWrapper)object2).levels.addAll(((Measure.AggregateFunction)object).levels);
                this.allMeasureWrappers.add(object2);
                continue;
            }
            for (Object object2 : ((Measure)iD_ObjectPropertyTranslator).getAggregateFunctions()) {
                ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator2;
                iD_ObjectPropertyTranslator2 = new MeasureWrapper((Measure)iD_ObjectPropertyTranslator, (Measure.AggregateFunction)object2, this);
                ((MeasureWrapper)iD_ObjectPropertyTranslator2).levels.addAll(((Measure.AggregateFunction)object2).levels);
                this.allMeasureWrappers.add(iD_ObjectPropertyTranslator2);
            }
        }
        this.selectedMeasureWrappers.clear();
        for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : this.allMeasureWrappers) {
            object = this.findMeasureWrapper(arrayList, (MeasureWrapper)iD_ObjectPropertyTranslator);
            if (object == null || this.findMeasureWrapper(this.selectedMeasureWrappers, (MeasureWrapper)object) != null) continue;
            this.selectedMeasureWrappers.add(iD_ObjectPropertyTranslator);
            ((MeasureWrapper)iD_ObjectPropertyTranslator).levels.clear();
            ((MeasureWrapper)iD_ObjectPropertyTranslator).levels.addAll(((MeasureWrapper)object).levels);
        }
    }

    private MeasureWrapper findMeasureWrapper(List list, MeasureWrapper measureWrapper) {
        String string = measureWrapper.getMeasure().getObjectID();
        String string2 = measureWrapper.getAggrFunction().getObjectID();
        for (MeasureWrapper measureWrapper2 : list) {
            if (measureWrapper.getMeasure().isDefinedAsOracleAWCalculated() && measureWrapper.getMeasure() == measureWrapper2.getMeasure()) {
                return measureWrapper2;
            }
            if (measureWrapper2.getAggrFunction() == null || measureWrapper2.getMeasure() == null || !measureWrapper2.getMeasure().getObjectID().equalsIgnoreCase(string) || !measureWrapper2.getAggrFunction().getObjectID().equalsIgnoreCase(string2)) continue;
            return measureWrapper2;
        }
        return null;
    }

    public MeasureWrapper createMeasureWrapper(String string, String string2) {
        MeasureWrapper measureWrapper = new MeasureWrapper(string, string2, this);
        return measureWrapper;
    }

    public MeasureWrapper createMeasureWrapper(Measure measure, Measure.AggregateFunction aggregateFunction) {
        MeasureWrapper measureWrapper = new MeasureWrapper(measure, aggregateFunction, this);
        return measureWrapper;
    }

    public MeasureWrapper createMeasureWrapper() {
        MeasureWrapper measureWrapper = new MeasureWrapper(this);
        return measureWrapper;
    }

    public List getSelectedLevels() {
        if (this.getCube() != null) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.selectedLevels);
            this.selectedLevels.clear();
            List list = null;
            if (!this.getDesign().isLoading()) {
                list = this.getCube().getDimensions();
            }
            for (SelectedLevel selectedLevel : arrayList) {
                if (!this.isCorrect(selectedLevel, list)) continue;
                this.selectedLevels.add(selectedLevel);
            }
        }
        return this.selectedLevels;
    }

    public List getUsedDimensions() {
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        List list = null;
        if (!this.getDesign().isLoading()) {
            list = this.getCube().getDimensions();
        }
        for (SelectedLevel selectedLevel : this.selectedLevels) {
            Dimension dimension = selectedLevel.getDimension();
            if (list != null) {
                if (!list.contains(dimension)) continue;
                arrayList.add(dimension);
                continue;
            }
            arrayList.add(dimension);
        }
        return arrayList;
    }

    private boolean isCorrect(SelectedLevel selectedLevel, List list) {
        Dimension dimension = (Dimension)((MultidimensionalDesign)this.getDesignPart()).getDimensionSet().getObjectByID(selectedLevel.dimensionId);
        if (dimension == null) {
            return false;
        }
        if (list != null && list.indexOf(dimension) == -1) {
            return false;
        }
        Hierarchy hierarchy = (Hierarchy)((MultidimensionalDesign)this.getDesignPart()).getHierarchySet().getObjectByID(selectedLevel.hierarchyId);
        if (hierarchy == null) {
            if (dimension.getHierarchies().size() > 0) {
                hierarchy = (Hierarchy)dimension.getHierarchies().getElement(0);
                if (hierarchy.getLevels().size() > 0) {
                    Level level = (Level)hierarchy.getLevels().get(0);
                    selectedLevel.setHierarchy(hierarchy);
                    selectedLevel.setLevel(level);
                    return true;
                }
                return false;
            }
            return false;
        }
        Level level = (Level)((MultidimensionalDesign)this.getDesignPart()).getLevelSet().getObjectByID(selectedLevel.levelId);
        if (level == null) {
            return false;
        }
        if (!hierarchy.getLevels().contains(level)) {
            selectedLevel.setLevel((Level)hierarchy.getLevels().get(0));
        }
        return true;
    }

    public List getSliceMappings() {
        return this.sliceMappings;
    }

    public MeasureWrapper getMeasureWrapper(Measure measure, String string) {
        for (MeasureWrapper measureWrapper : this.selectedMeasureWrappers) {
            if (measureWrapper.getMeasure() != measure || !measureWrapper.getAggrFunction().objectId.equals(string)) continue;
            return measureWrapper;
        }
        return null;
    }

    public MeasureWrapper getMeasureWrapper(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        for (MeasureWrapper measureWrapper : this.selectedMeasureWrappers) {
            if (!measureWrapper.getMeasure().getObjectID().equalsIgnoreCase(string) || !measureWrapper.getAggrFunction().objectId.equals(string2)) continue;
            return measureWrapper;
        }
        return null;
    }

    public String getWhereClauseFor(MeasureWrapper measureWrapper) {
        String string = "";
        Iterator iterator = this.selectionCriterias.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            String string2;
            SelectionCriteria selectionCriteria = (SelectionCriteria)iterator.next();
            if (selectionCriteria.getMeasureWrapper() != measureWrapper || "".equals(string2 = selectionCriteria.getSelectionCriteria().trim())) continue;
            if (bl) {
                string = string2;
                bl = false;
                continue;
            }
            string = string + " AND " + string2;
        }
        return string.trim();
    }

    public List getSQLDefinitions() {
        return this.sqlDefinitions;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "slice/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public class SliceMapping {
        private final Attribute attribute;
        private DesignObject mapping;

        public SliceMapping(SliceMapping sliceMapping) {
            this.attribute = sliceMapping.getAttribute();
            this.mapping = sliceMapping.getMapping();
        }

        public SliceMapping(Attribute attribute, DesignObject designObject) {
            this.attribute = attribute;
            this.mapping = designObject;
        }

        public DesignObject getMapping() {
            return this.mapping;
        }

        public void setMapping(DesignObject designObject) {
            this.mapping = designObject;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }
    }

    public class SelectedLevel
    implements ID_ObjectPropertyTranslator {
        String dimensionId;
        String hierarchyId;
        String levelId;
        Dimension dimension;
        Hierarchy hierarchy;
        Level level;
        String selAttrIDs;
        public RollupLink rollupLink;
        List selectedAttributes = new ArrayList();
        Slice slice;

        public SelectedLevel(String string, String string2, String string3, Slice slice2) {
            this.slice = slice2;
            this.dimensionId = string;
            this.hierarchyId = string2;
            this.levelId = string3;
        }

        public SelectedLevel(Dimension dimension, Hierarchy hierarchy, Level level, Slice slice2) {
            this.slice = slice2;
            this.dimension = dimension;
            this.hierarchy = hierarchy;
            this.level = level;
            this.dimensionId = dimension.getObjectID();
            this.hierarchyId = hierarchy.getObjectID();
            this.levelId = level.getObjectID();
        }

        public SelectedLevel(Slice slice2) {
            this.slice = slice2;
        }

        public Dimension getDimension() {
            if (this.dimension == null) {
                this.dimension = (Dimension)((MultidimensionalDesign)Slice.this.getDesignPart()).getDimensionSet().getObjectByID(this.dimensionId);
            }
            return this.dimension;
        }

        public void setDimension(Dimension dimension) {
            this.dimension = dimension;
            this.dimensionId = dimension.getObjectID();
        }

        public Hierarchy getHierarchy() {
            if (this.hierarchy == null) {
                this.hierarchy = (Hierarchy)((MultidimensionalDesign)Slice.this.getDesignPart()).getHierarchySet().getObjectByID(this.hierarchyId);
            }
            return this.hierarchy;
        }

        public void setHierarchy(Hierarchy hierarchy) {
            this.hierarchy = hierarchy;
            this.hierarchyId = hierarchy != null ? hierarchy.getObjectID() : null;
        }

        public Level getLevel() {
            if (this.level == null) {
                this.level = (Level)((MultidimensionalDesign)Slice.this.getDesignPart()).getLevelSet().getObjectByID(this.levelId);
            }
            return this.level;
        }

        public void setLevel(Level level) {
            if (this.level != level) {
                this.level = level;
                this.levelId = level.getObjectID();
                this.selectedAttributes.clear();
                this.selAttrIDs = null;
                this.selectedAttributes.addAll(level.getLevelKey());
            }
        }

        public void validateSelectedAttributes() {
            Object[] objectArray = this.selectedAttributes.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                DesignObject designObject = this.level.getAttributeById(((DesignObject)objectArray[i]).getObjectID());
                if (designObject != null) continue;
                this.selectedAttributes.remove(objectArray[i]);
            }
        }

        public String toString() {
            if (this.getDimension() != null) {
                return this.getDimension().getName();
            }
            return "empty";
        }

        public String getSelAttrIDs() {
            this.getSelectedAttributes();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (int i = 0; i < this.selectedAttributes.size(); ++i) {
                DesignObject designObject = (DesignObject)this.selectedAttributes.get(i);
                if (!bl) {
                    stringBuffer.append(",").append(designObject.getObjectID());
                    continue;
                }
                stringBuffer.append(designObject.getObjectID());
                bl = false;
            }
            return stringBuffer.toString();
        }

        public void setSelAttrIDs(String string) {
            this.selAttrIDs = string;
            this.selectedAttributes.clear();
        }

        public List getSelectedAttributes() {
            if (this.selectedAttributes.size() == 0 && this.selAttrIDs != null && !"".equalsIgnoreCase(this.selAttrIDs)) {
                String[] stringArray = this.selAttrIDs.indexOf(59) > -1 ? this.selAttrIDs.split(";") : this.selAttrIDs.split(",");
                Level level = this.getLevel();
                if (level != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        DesignObject designObject = level.getAttributeById(stringArray[i]);
                        if (designObject == null) continue;
                        this.selectedAttributes.add(designObject);
                    }
                }
                this.selAttrIDs = null;
            }
            this.validateSelectedAttributes();
            return this.selectedAttributes;
        }

        public RollupLink getRollupLink() {
            return this.rollupLink;
        }

        public void setRollupLink(RollupLink rollupLink) {
            this.rollupLink = rollupLink;
        }

        @Override
        public Object translateIdToObject(String string, String string2) {
            if (this.slice != null) {
                return this.slice.translateIdToObject(string, string2);
            }
            return null;
        }

        @Override
        public String translateObjectToID(String string, Object object) {
            if (this.slice != null) {
                return this.slice.translateObjectToID(string, object);
            }
            return null;
        }
    }

    public class MeasureWrapper
    implements ID_ObjectPropertyTranslator {
        Measure measure;
        Measure.AggregateFunction aggrFunction;
        String measureId;
        String aggrFuncId;
        public List levels = new ArrayList();
        private Slice slice;

        public MeasureWrapper(Measure measure, Measure.AggregateFunction aggregateFunction, Slice slice2) {
            this.measure = measure;
            this.slice = slice2;
            if (measure != null) {
                this.measureId = measure.getObjectID();
            }
            this.aggrFunction = aggregateFunction;
            if (aggregateFunction != null) {
                this.aggrFuncId = aggregateFunction.getObjectID();
            }
        }

        MeasureWrapper(String string, String string2, Slice slice2) {
            this.slice = slice2;
            this.measureId = string;
            this.aggrFuncId = string2;
        }

        MeasureWrapper(Slice slice2) {
            this.slice = slice2;
        }

        public String getFunctionName() {
            if (this.getAggrFunction() != null) {
                return this.getAggrFunction().name;
            }
            return "";
        }

        public String getMeasureAlias() {
            if (this.getAggrFunction() != null) {
                return this.getAggrFunction().measureAlias;
            }
            return "";
        }

        public Measure.AggregateFunction getAggrFunction() {
            if (this.aggrFunction == null && this.getMeasure() != null) {
                this.aggrFunction = this.getMeasure().getAggregateFunctionById(this.aggrFuncId);
            }
            return this.aggrFunction;
        }

        public Measure getMeasure() {
            if (this.measure == null) {
                this.measure = (Measure)((MultidimensionalDesign)Slice.this.getDesignPart()).getMeasureSet().getObjectByID(this.measureId);
            }
            return this.measure;
        }

        public String toString() {
            if (this.getMeasure() != null && this.getAggrFunction() != null) {
                return this.getMeasure().getName() + " : " + this.getAggrFunction().name;
            }
            return "empty";
        }

        public List getLevels() {
            return this.levels;
        }

        public String getMeasureId() {
            return this.measureId;
        }

        public void setMeasureId(String string) {
            this.measureId = string;
        }

        public String getAggrFuncId() {
            return this.aggrFuncId;
        }

        public void setAggrFuncId(String string) {
            this.aggrFuncId = string;
        }

        @Override
        public Object translateIdToObject(String string, String string2) {
            return this.slice.translateIdToObject(string, string2);
        }

        @Override
        public String translateObjectToID(String string, Object object) {
            return this.slice.translateObjectToID(string, object);
        }
    }
}

