/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SQLAttribute;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;

public class SQLtoAWGenerator {
    private SQLAccessToAW sqlAccesToAW;
    private boolean formatted;
    private List outSQLAttributes;
    private String olap_calc = "olap_calc";
    private String indent = "   ";
    private String twoindents = this.indent + this.indent;
    private String threeindents = this.twoindents + this.indent;
    private String fourindents = this.threeindents + this.indent;
    private String fiveindents = this.fourindents + this.indent;
    private String sixindents = this.fiveindents + this.indent;
    private String sevindents = this.sixindents + this.indent;
    private StringBuffer sb = new StringBuffer();
    private StringBuffer lmsb = new StringBuffer();

    public String generateSQL(SQLAccessToAW sQLAccessToAW, boolean bl, List list) {
        this.formatted = bl;
        this.outSQLAttributes = list;
        this.sqlAccesToAW = sQLAccessToAW;
        this.sb.setLength(0);
        this.lmsb.setLength(0);
        this.makeSQL();
        return this.sb.toString();
    }

    private void makeSQL() {
        if (this.sqlAccesToAW.isUseObjectType()) {
            this.addObjectTypeDef();
            this.addTableTypeDef();
        }
        this.addViewDef();
    }

    private void addObjectTypeDef() {
        this.sb.append("CREATE TYPE ").append(this.sqlAccesToAW.getObjectADTName()).append(" AS OBJECT (");
        boolean bl = true;
        for (int i = 0; i < this.outSQLAttributes.size(); ++i) {
            SQLAttribute sQLAttribute = (SQLAttribute)this.outSQLAttributes.get(i);
            if (bl) {
                bl = false;
                this.sb.append("\n").append(this.threeindents).append(this.getAttrName(sQLAttribute)).append(" ").append(sQLAttribute.getDataType());
                continue;
            }
            this.sb.append(",\n").append(this.threeindents).append(this.getAttrName(sQLAttribute)).append(" ").append(sQLAttribute.getDataType());
        }
        if (this.sqlAccesToAW.isUseRowToCellColumn()) {
            if (bl) {
                bl = false;
                this.sb.append("\n").append(this.threeindents).append(this.olap_calc).append(" raw(32)");
            } else {
                this.sb.append(",\n").append(this.threeindents).append(this.olap_calc).append(" raw(32)");
            }
        }
        this.sb.append("\n").append(this.threeindents).append(");");
        this.sb.append("\n\n");
    }

    private void addTableTypeDef() {
        this.sb.append("CREATE TYPE ").append(this.sqlAccesToAW.getTableADTName()).append(" AS TABLE OF ").append(this.sqlAccesToAW.getObjectADTName());
        this.sb.append(";\n");
    }

    private void addViewDef() {
        this.addCreateView();
        this.addSelect();
    }

    private void addCreateView() {
        this.sb.append("\nCREATE OR REPLACE VIEW ").append(this.sqlAccesToAW.getName().replaceAll(" ", "_")).append(" AS ");
    }

    private void addSelect() {
        this.sb.append("\n" + this.indent).append("SELECT ");
        this.addSelectColumns();
        this.addFromClause();
        this.addAWName();
        this.addTableType();
        this.addOlapCommand();
        this.addLimitMap();
        this.addClosingBrackets();
        this.addModelClause();
    }

    private void addClosingBrackets() {
        this.sb.append("\n").append(this.twoindents).append("))");
    }

    private void addSelectColumns() {
        boolean bl = true;
        for (int i = 0; i < this.outSQLAttributes.size(); ++i) {
            SQLAttribute sQLAttribute = (SQLAttribute)this.outSQLAttributes.get(i);
            if (bl) {
                bl = false;
                this.sb.append("\n").append(this.fourindents).append(this.getAttrName(sQLAttribute));
                continue;
            }
            this.sb.append(",\n").append(this.fourindents).append(this.getAttrName(sQLAttribute));
        }
        if (this.sqlAccesToAW.isUseRowToCellColumn()) {
            if (bl) {
                bl = false;
                this.sb.append("\n").append(this.fourindents).append(this.olap_calc);
            } else {
                this.sb.append(",\n").append(this.fourindents).append(this.olap_calc);
            }
        }
    }

    private void addFromClause() {
        this.sb.append("\n").append(this.twoindents).append("FROM TABLE(OLAP_TABLE(");
    }

    private void addAWName() {
        this.sb.append("\n").append(this.threeindents).append("'" + this.sqlAccesToAW.getAWName().replaceAll(" ", "_") + " duration session',");
    }

    private void addTableType() {
        if (this.sqlAccesToAW.isUseObjectType()) {
            this.sb.append("\n").append(this.threeindents).append("'" + this.sqlAccesToAW.getTableADTName().replaceAll(" ", "_") + "',");
        } else {
            this.sb.append("\n").append(this.threeindents).append("'',");
        }
    }

    private void addOlapCommand() {
        this.sb.append("\n").append(this.threeindents).append("'',");
    }

    private void addLimitMap() {
        String string = this.makeLimimtMap();
        if (this.formatted) {
            this.sb.append("\n" + this.threeindents + "'").append(string).append("'");
        } else if (string.length() <= 32000) {
            int n = string.length() / 4000;
            boolean bl = true;
            for (int i = 0; i < n + 1; ++i) {
                int n2 = i * 4000;
                int n3 = n2 + 4000;
                if (n3 > string.length()) {
                    n3 = string.length();
                }
                String string2 = string.substring(n2, n3);
                if (bl) {
                    this.sb.append("\n" + this.threeindents + "'" + string2 + "'");
                    bl = false;
                    continue;
                }
                this.sb.append(",\n" + this.threeindents + "'" + string2 + "'");
            }
        }
    }

    private String makeLimimtMap() {
        this.addDimensions();
        this.addMeasures();
        if (this.sqlAccesToAW.isUseRowToCellColumn()) {
            if (this.formatted) {
                this.lmsb.append("\n").append(this.fiveindents).append("ROW2CELL ").append(this.olap_calc);
            } else {
                this.lmsb.append(" ROW2CELL ").append(this.olap_calc);
            }
        }
        return this.lmsb.toString();
    }

    private void addModelClause() {
        SQLAttribute sQLAttribute;
        int n;
        this.sb.append("\n").append(this.indent).append("model");
        this.sb.append("\n").append(this.twoindents).append("dimension by (");
        boolean bl = true;
        for (n = 0; n < this.outSQLAttributes.size(); ++n) {
            sQLAttribute = (SQLAttribute)this.outSQLAttributes.get(n);
            if (!sQLAttribute.getType().equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_ID)) continue;
            if (bl) {
                bl = false;
                this.sb.append(this.getAttrName(sQLAttribute));
                continue;
            }
            this.sb.append(",").append(this.getAttrName(sQLAttribute));
        }
        for (n = 0; n < this.outSQLAttributes.size(); ++n) {
            sQLAttribute = (SQLAttribute)this.outSQLAttributes.get(n);
            if (!sQLAttribute.getType().equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_GID)) continue;
            if (bl) {
                bl = false;
                this.sb.append(this.getAttrName(sQLAttribute));
                continue;
            }
            this.sb.append(",").append(this.getAttrName(sQLAttribute));
        }
        this.sb.append(")");
        this.sb.append("\n").append(this.twoindents).append("measures (");
        bl = true;
        for (n = 0; n < this.outSQLAttributes.size(); ++n) {
            sQLAttribute = (SQLAttribute)this.outSQLAttributes.get(n);
            if (sQLAttribute.getType().equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_GID) || sQLAttribute.getType().equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_ID)) continue;
            if (bl) {
                bl = false;
                this.sb.append(this.getAttrName(sQLAttribute));
                continue;
            }
            this.sb.append(",").append(this.getAttrName(sQLAttribute));
        }
        if (this.sqlAccesToAW.isUseRowToCellColumn()) {
            if (bl) {
                bl = false;
                this.sb.append(this.olap_calc);
            } else {
                this.sb.append(",").append(this.olap_calc);
            }
        }
        this.sb.append(")\n" + this.twoindents + "rules update sequential order();");
    }

    private String getAttrName(SQLAttribute sQLAttribute) {
        return sQLAttribute.getName().replaceAll(" ", "_");
    }

    private void addDimensions() {
        boolean bl = true;
        for (SQLAccessToAW.SQLDimension sQLDimension : this.sqlAccesToAW.getSqlDimensionDefinitions()) {
            this.addDimension(sQLDimension, bl);
            bl = false;
        }
    }

    private void addDimension(SQLAccessToAW.SQLDimension sQLDimension, boolean bl) {
        SQLAttribute sQLAttribute = this.sqlAccesToAW.getIDColumnForDimension(this.outSQLAttributes, sQLDimension.getDimension());
        SQLAttribute sQLAttribute2 = this.sqlAccesToAW.getGIDForDimension(this.outSQLAttributes, sQLDimension.getDimension());
        List list = this.getAttributesFor(this.outSQLAttributes, sQLDimension);
        if (this.formatted) {
            if (bl) {
                this.lmsb.append("DIMENSION ");
            } else {
                this.lmsb.append("\n").append(this.threeindents).append(" DIMENSION ");
            }
        } else {
            this.lmsb.append(" DIMENSION ");
        }
        if (sQLAttribute != null) {
            this.lmsb.append(sQLAttribute.getName()).append(" FROM ");
        }
        this.lmsb.append(sQLDimension.getName());
        this.addWithClause(sQLDimension, list);
        for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : sQLDimension.getSelectedSQLHierarhies()) {
            this.addHierarchy((SQLAccessToAW.SQLHierarchy)iD_ObjectPropertyTranslator, sQLDimension, sQLAttribute2);
            sQLAttribute2 = null;
        }
        for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : list) {
            if (this.formatted) {
                this.lmsb.append("\n").append(this.fiveindents).append("ATTRIBUTE ");
            } else {
                this.lmsb.append(" ATTRIBUTE ");
            }
            this.lmsb.append(((SQLAttribute)iD_ObjectPropertyTranslator).getName()).append(" FROM ").append(((SQLAttribute)iD_ObjectPropertyTranslator).getSQLAWName());
        }
    }

    private void addMeasures() {
        List list = this.getMeasures(this.outSQLAttributes);
        for (SQLAttribute sQLAttribute : list) {
            if (this.formatted) {
                this.lmsb.append("\n").append(this.threeindents).append("MEASURE ");
            } else {
                this.lmsb.append(" MEASURE ");
            }
            this.lmsb.append(sQLAttribute.getName()).append(" FROM ").append(sQLAttribute.getSQLAWName());
        }
    }

    private List getAttributesFor(List list, SQLAccessToAW.SQLDimension sQLDimension) {
        ArrayList<SQLAttribute> arrayList = new ArrayList<SQLAttribute>();
        for (SQLAttribute sQLAttribute : list) {
            if (!sQLAttribute.getType().equals(SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR) && !sQLAttribute.getType().equals(SQLAccessToAW.ATTR_TYPE_LEVEL_NAME) && !sQLAttribute.getType().equals(SQLAccessToAW.ATTR_TYPE_TIME_SPAN) && !sQLAttribute.getType().equals(SQLAccessToAW.ATTR_TYPE_END_DATE) && !sQLAttribute.getType().equals(SQLAccessToAW.ATTR_TYPE_SHORT_DESC) && !sQLAttribute.getType().equals(SQLAccessToAW.ATTR_TYPE_LONG_DESC) || sQLAttribute.getDimension() != sQLDimension.getDimension()) continue;
            arrayList.add(sQLAttribute);
        }
        return arrayList;
    }

    private List getMeasures(List list) {
        ArrayList<SQLAttribute> arrayList = new ArrayList<SQLAttribute>();
        for (SQLAttribute sQLAttribute : list) {
            if (!sQLAttribute.getType().equals(SQLAccessToAW.ATTR_TYPE_MEASURE)) continue;
            arrayList.add(sQLAttribute);
        }
        return arrayList;
    }

    private void addWithClause(SQLAccessToAW.SQLDimension sQLDimension, List list) {
        if (sQLDimension.getSelectedSQLHierarhies().size() > 0 || list.size() > 0) {
            if (this.formatted) {
                this.lmsb.append("\n").append(this.fourindents).append("WITH");
            } else {
                this.lmsb.append(" WITH");
            }
        }
    }

    private void addHierarchy(SQLAccessToAW.SQLHierarchy sQLHierarchy, SQLAccessToAW.SQLDimension sQLDimension, SQLAttribute sQLAttribute) {
        String string = sQLDimension.getName();
        String string2 = sQLHierarchy.getHierarchy().getName().replaceAll(" ", "_").toUpperCase();
        if (this.formatted) {
            this.lmsb.append("\n").append(this.fourindents).append("HIERARCHY ").append(string + "_parentrel ");
            this.lmsb.append("\n").append(this.fiveindents).append("( ").append(string + "_hierlist ");
            this.lmsb.append("''").append(string2).append("'' ) ");
            this.lmsb.append("\n").append(this.fiveindents).append("INHIERARCHY ").append(string + "_inhier ");
            if (sQLAttribute != null) {
                this.lmsb.append("\n").append(this.fiveindents).append("GID ").append(sQLAttribute.getName()).append(" FROM " + string + "_gid");
            }
        } else {
            this.lmsb.append(" HIERARCHY ").append(string + "_parentrel ");
            this.lmsb.append("( ").append(string + "_hierlist ");
            this.lmsb.append("''").append(string2).append("'' ) ");
            this.lmsb.append("INHIERARCHY ").append(string + "_inhier ");
            if (sQLAttribute != null) {
                this.lmsb.append("GID ").append(sQLAttribute.getName()).append(" FROM " + string + "_gid");
            }
        }
        if (sQLHierarchy.isRollupForm()) {
            this.addFamilyRel(sQLHierarchy, string, sQLDimension);
        }
    }

    private void addFamilyRel(SQLAccessToAW.SQLHierarchy sQLHierarchy, String string, SQLAccessToAW.SQLDimension sQLDimension) {
        List list = sQLHierarchy.getValidSelLevels();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list.size() > 0) {
            if (this.formatted) {
                Object object;
                int n;
                this.lmsb.append("\n").append(this.fiveindents).append("FAMILYREL ");
                boolean bl = true;
                for (n = 0; n < list.size(); ++n) {
                    object = (Level)list.get(n);
                    String string2 = ((DesignObject)object).getName().replaceAll(" ", "_").toUpperCase();
                    SQLAttribute sQLAttribute = this.sqlAccesToAW.getSQLLevelAttr(this.outSQLAttributes, sQLDimension.getDimension(), sQLHierarchy.getHierarchy(), (Level)object);
                    if (sQLAttribute == null) continue;
                    if (bl) {
                        this.lmsb.append("\n").append(this.sevindents).append(sQLAttribute.getName());
                        bl = false;
                    } else {
                        this.lmsb.append(",\n").append(this.sevindents).append(sQLAttribute.getName());
                    }
                    arrayList.add(string2);
                }
                bl = true;
                this.lmsb.append("\n").append(this.sixindents).append("FROM ");
                for (n = 0; n < arrayList.size(); ++n) {
                    object = (String)arrayList.get(n);
                    if (bl) {
                        this.lmsb.append("\n").append(this.sevindents).append(string + "_familyrel");
                        this.lmsb.append("(" + string + "_levellist ''" + (String)object + "'') ");
                        bl = false;
                        continue;
                    }
                    this.lmsb.append(",\n").append(this.sevindents).append(string + "_familyrel");
                    this.lmsb.append("(" + string + "_levellist ''" + (String)object + "'') ");
                }
                if (sQLHierarchy.getLabelAttribute() != null) {
                    this.lmsb.append("\n").append(this.sixindents).append("LABEL ").append(sQLHierarchy.getLabelAttribute().getSQLAWName());
                }
            } else {
                Object object;
                int n;
                this.lmsb.append(" FAMILYREL ");
                boolean bl = true;
                for (n = 0; n < list.size(); ++n) {
                    object = (Level)list.get(n);
                    String string3 = ((DesignObject)object).getName().replaceAll(" ", "_").toUpperCase();
                    SQLAttribute sQLAttribute = this.sqlAccesToAW.getSQLLevelAttr(this.outSQLAttributes, sQLDimension.getDimension(), sQLHierarchy.getHierarchy(), (Level)object);
                    if (sQLAttribute == null) continue;
                    if (bl) {
                        this.lmsb.append(sQLAttribute.getName());
                        bl = false;
                    } else {
                        this.lmsb.append(",").append(sQLAttribute.getName());
                    }
                    arrayList.add(string3);
                }
                bl = true;
                this.lmsb.append(" FROM ");
                for (n = 0; n < arrayList.size(); ++n) {
                    object = (String)arrayList.get(n);
                    if (bl) {
                        this.lmsb.append(string + "_familyrel");
                        this.lmsb.append("(" + string + "_levellist ''" + (String)object + "'') ");
                        bl = false;
                        continue;
                    }
                    this.lmsb.append(",").append(string + "_familyrel");
                    this.lmsb.append("(" + string + "_levellist ''" + (String)object + "'') ");
                }
                if (sQLHierarchy.getLabelAttribute() != null) {
                    this.lmsb.append(" LABEL ").append(sQLHierarchy.getLabelAttribute().getSQLAWName());
                }
            }
        }
    }
}

