/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;

public class SQLAttribute
implements ID_ObjectPropertyTranslator {
    private String type;
    private String name = "";
    public String hierarchyID;
    private Dimension dimension;
    private SlowChangingAttribute slowChangingAttribute;
    private Level level;
    public Hierarchy hierarchy;
    private Measure measure;
    private Slice.MeasureWrapper measureWrapper;
    private boolean nameEditable = false;
    private String dataType = "";
    private Slice slice;
    private Cube cube;
    private int outPosition = 0;
    private SQLAccessToAW sqlAW;
    private ID_ObjectPropertyTranslator idProvider;
    private String mw_MeasureID;
    private String mw_FunctID;
    private String sca_AttributeID;
    private String sca_AttributeName;

    public SQLAttribute(SQLAccessToAW sQLAccessToAW) {
        this.sqlAW = sQLAccessToAW;
        this.slice = sQLAccessToAW.getSlice();
        this.cube = sQLAccessToAW.getCube();
    }

    public SQLAttribute(String string, String string2, Dimension dimension) {
        this.type = string;
        this.name = string2;
        this.dimension = dimension;
        this.nameEditable = true;
    }

    public SQLAttribute(String string, Measure measure, Cube cube) {
        this.type = SQLAccessToAW.ATTR_TYPE_MEASURE;
        this.name = string;
        this.measure = measure;
        this.cube = cube;
        this.nameEditable = true;
    }

    public SQLAttribute(String string, Slice.MeasureWrapper measureWrapper, Slice slice) {
        this.type = SQLAccessToAW.ATTR_TYPE_MEASURE;
        this.name = string;
        this.measureWrapper = measureWrapper;
        this.slice = slice;
        this.nameEditable = true;
    }

    public SQLAttribute(String string, Dimension dimension, Level level, SlowChangingAttribute slowChangingAttribute) {
        this.type = SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR;
        this.name = string;
        this.dimension = dimension;
        this.level = level;
        this.slowChangingAttribute = slowChangingAttribute;
        this.nameEditable = true;
    }

    public SQLAttribute(String string, Dimension dimension, Hierarchy hierarchy, Level level) {
        this.type = SQLAccessToAW.ATTR_TYPE_LEVEL;
        this.name = string;
        this.dimension = dimension;
        this.hierarchy = hierarchy;
        this.level = level;
        this.nameEditable = true;
    }

    public SQLAttribute(String string, Dimension dimension, String string2, Level level) {
        this.type = SQLAccessToAW.ATTR_TYPE_LEVEL;
        this.name = string;
        this.dimension = dimension;
        this.hierarchyID = string2;
        this.level = level;
        this.nameEditable = true;
    }

    public String getType() {
        return this.type;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String getName() {
        return this.name;
    }

    public String getLevelName() {
        if (this.level != null) {
            return this.level.getName();
        }
        return "";
    }

    public String getDimensionName() {
        if (this.dimension != null) {
            return this.dimension.getName();
        }
        return "";
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getSQLAWName() {
        String string = "";
        String string2 = "";
        if (!this.type.equals(SQLAccessToAW.ATTR_TYPE_MEASURE)) {
            string2 = this.dimension.getName().replaceAll(" ", "_");
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_SHORT_DESC)) {
            return string2 + "_" + "short_description";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_LONG_DESC)) {
            return string2 + "_" + "long_description";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_END_DATE)) {
            return string2 + "_" + "end_date";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_TIME_SPAN)) {
            return string2 + "_" + "time_span";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_LEVEL_NAME)) {
            return string2 + "_" + "levelrel";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_GID)) {
            return string2 + "_" + "gid";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_ID)) {
            return string2;
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR)) {
            String string3 = this.slowChangingAttribute.getName().replaceAll(" ", "_");
            return string2 + "_" + string3;
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_MEASURE)) {
            String string4 = "";
            String string5 = "";
            if (this.measure != null) {
                string4 = this.cube.getName().replaceAll(" ", "_");
                string5 = this.measure.getName().replaceAll(" ", "_");
            } else if (this.measureWrapper != null) {
                string4 = this.slice.getName().replaceAll(" ", "_");
                string5 = this.measureWrapper.getAggrFunction().measureAlias.replaceAll(" ", "_");
            }
            return string4 + "_" + string5;
        }
        return string;
    }

    private String getAttributeDataType() {
        String string = "varchar2(30)";
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR)) {
            string = this.getSlowChangingAttribute().getAttribute() instanceof AttributeView ? ((AttributeView)this.getSlowChangingAttribute().getAttribute()).getDataType() : ((Attribute)this.getSlowChangingAttribute().getAttribute()).getDataType().toString();
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_MEASURE)) {
            string = "number";
        }
        return string;
    }

    public String toString() {
        String string = "";
        String string2 = this.dimension.getName().replaceAll(" ", "_");
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_SHORT_DESC)) {
            return "Short Description";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_LONG_DESC)) {
            return "Long Description";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_LEVEL_NAME)) {
            return string2 + "_" + "levelrel";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_GID)) {
            return string2 + "_" + "gid";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DIMENSION_ID)) {
            return string2 + " column";
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR)) {
            String string3 = this.slowChangingAttribute.getName();
            return string3;
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_MEASURE)) {
            String string4 = "";
            if (this.measure != null) {
                string4 = this.measure.getName().replaceAll(" ", "_");
            } else if (this.measureWrapper != null) {
                string4 = this.measureWrapper.getAggrFunction().measureAlias.replaceAll(" ", "_");
            }
            return string4;
        }
        return string;
    }

    public SlowChangingAttribute getSlowChangingAttribute() {
        return this.slowChangingAttribute;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SQLAttribute)) {
            return false;
        }
        SQLAttribute sQLAttribute = (SQLAttribute)object;
        if (!this.type.equals(sQLAttribute.getType())) {
            return false;
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_MEASURE)) {
            return !(this.measure != null ? this.measure != sQLAttribute.getMeasure() : this.measureWrapper != sQLAttribute.getMeasureWrapper());
        }
        if (this.dimension != sQLAttribute.getDimension()) {
            return false;
        }
        if (this.type.equals(SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR)) {
            if (this.level != sQLAttribute.level) {
                return false;
            }
            if (this.slowChangingAttribute.getAttribute() != sQLAttribute.getSlowChangingAttribute().getAttribute()) {
                return false;
            }
        } else if (this.type.equals(SQLAccessToAW.ATTR_TYPE_LEVEL)) {
            if (this.getHierarchy() != sQLAttribute.getHierarchy()) {
                return false;
            }
            if (this.level != sQLAttribute.level) {
                return false;
            }
        } else if (this.type.equals(SQLAccessToAW.ATTR_TYPE_LEVEL_NAME) && this.level != sQLAttribute.level) {
            return false;
        }
        return true;
    }

    public Level getLevel() {
        return this.level;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public Slice.MeasureWrapper getMeasureWrapper() {
        return this.measureWrapper;
    }

    public boolean isNameEditable() {
        return this.nameEditable;
    }

    public void setNameEditable(boolean bl) {
        this.nameEditable = bl;
    }

    public boolean isDataTypePreset() {
        return !"".equals(this.dataType);
    }

    public String getDataType() {
        if (!this.isDataTypePreset()) {
            return this.getAttributeDataType();
        }
        return this.dataType;
    }

    public void setDataType(String string) {
        this.dataType = string.trim();
    }

    public Hierarchy getHierarchy() {
        if (this.hierarchy == null && this.hierarchyID != null) {
            this.hierarchy = (Hierarchy)this.getDimension().getMultidimensionalDesign().getHierarchySet().getObjectByID(this.hierarchyID);
        }
        return this.hierarchy;
    }

    public Cube getCube() {
        return this.cube;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public int getOutPosition() {
        return this.outPosition;
    }

    public void setOutPosition(int n) {
        this.outPosition = n;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public void setSlowChangingAttribute(SlowChangingAttribute slowChangingAttribute) {
        this.slowChangingAttribute = slowChangingAttribute;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setHierarchy(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    public void setSlice(Slice slice) {
        this.slice = slice;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
    }

    public ID_ObjectPropertyTranslator getIdProvider() {
        if (this.idProvider == null) {
            if (this.sqlAW != null) {
                this.idProvider = this.sqlAW;
            } else if (this.dimension != null) {
                this.idProvider = this.dimension;
            } else if (this.level != null) {
                this.idProvider = this.level;
            } else if (this.hierarchy != null) {
                this.idProvider = this.hierarchy;
            } else if (this.slowChangingAttribute != null) {
                this.idProvider = this.slowChangingAttribute;
            } else if (this.cube != null) {
                this.idProvider = this.cube;
            } else if (this.measure != null) {
                this.idProvider = this.measure;
            } else if (this.slice != null) {
                this.idProvider = this.slice;
            } else if (this.measureWrapper != null) {
                this.idProvider = this.measureWrapper;
            }
        }
        return this.idProvider;
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        return this.getIdProvider().translateIdToObject(string, string2);
    }

    @Override
    public String translateObjectToID(String string, Object object) {
        return this.getIdProvider().translateObjectToID(string, object);
    }

    public String getMw_MeasureID() {
        if (this.getMeasureWrapper() != null) {
            return this.getMeasureWrapper().getMeasure().getObjectID();
        }
        return this.mw_MeasureID;
    }

    public void setMw_MeasureID(String string) {
        Slice.MeasureWrapper measureWrapper;
        this.mw_MeasureID = string;
        if (this.slice != null && this.mw_MeasureID != null && this.mw_FunctID != null && (measureWrapper = this.slice.getMeasureWrapper(string, string)) != null) {
            this.measureWrapper = measureWrapper;
        }
    }

    public String getMw_FunctID() {
        if (this.getMeasureWrapper() != null) {
            return this.getMeasureWrapper().getAggrFunction().getObjectID();
        }
        return this.mw_FunctID;
    }

    public void setMw_FunctID(String string) {
        this.mw_FunctID = string;
    }

    public String getSca_AttributeID() {
        if (this.getSlowChangingAttribute() != null) {
            return this.getSlowChangingAttribute().getAttribute().getObjectID();
        }
        return this.sca_AttributeID;
    }

    public void setSca_AttributeID(String string) {
        SlowChangingAttribute slowChangingAttribute;
        this.sca_AttributeID = string;
        if (this.level != null && this.sca_AttributeID != null && this.sca_AttributeName != null && (slowChangingAttribute = this.level.getSlowChangingAttribute(this.sca_AttributeID, this.sca_AttributeName)) != null) {
            this.setSlowChangingAttribute(slowChangingAttribute);
        }
    }

    public String getSca_AttributeName() {
        if (this.getSlowChangingAttribute() != null) {
            this.getSlowChangingAttribute().getName();
        }
        return this.sca_AttributeName;
    }

    public void setSca_AttributeName(String string) {
        this.sca_AttributeName = string;
    }

    public void setType(String string) {
        this.type = string;
    }
}

