/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.SQLAttribute;
import oracle.dbtools.crest.model.design.multidimensional.SQLtoAWGenerator;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.editor.multidimensional.SQLAccessToAWPropertiesDialogEx;

public class SQLAccessToAW
extends AbstractMDObject {
    private Cube cube;
    private Slice slice;
    private boolean generateGIDs;
    private boolean useModelClause = true;
    private boolean useObjectType = false;
    private String objectADTName = "";
    private String tableADTName = "";
    private List sqlDimensionDefinitions = new ArrayList();
    private List allSQLDimensions = new ArrayList();
    private List selMeasures = new ArrayList();
    private List selMeasureWrappers = new ArrayList();
    private List allMeasures = new ArrayList();
    private List allMeasureWrappers = new ArrayList();
    private List selectedSQLMeasures = new ArrayList();
    private List selectedSQLMeasureWrappers = new ArrayList();
    private List outSQLAttributes = new ArrayList();
    private SQLtoAWGenerator sqlToAWGenerator;
    private boolean useRowToCellColumn = true;
    private String aWName = "";
    public static String ATTR_TYPE_LONG_DESC = Messages.getString("SQLAccessToAW.LongDescription");
    public static String ATTR_TYPE_SHORT_DESC = Messages.getString("SQLAccessToAW.ShortDescription");
    public static String ATTR_TYPE_END_DATE = Messages.getString("SQLAccessToAW.EndDate");
    public static String ATTR_TYPE_TIME_SPAN = Messages.getString("SQLAccessToAW.TimeSpan");
    public static String ATTR_TYPE_LEVEL_NAME = Messages.getString("SQLAccessToAW.LevelName");
    public static String ATTR_TYPE_LEVEL = Messages.getString("SQLAccessToAW.Level");
    public static String ATTR_TYPE_MEASURE = Messages.getString("SQLAccessToAW.Measure");
    public static String ATTR_TYPE_DIMENSION_GID = Messages.getString("SQLAccessToAW.DimensionGid");
    public static String ATTR_TYPE_DIMENSION_ID = Messages.getString("SQLAccessToAW.DimensionID");
    public static String ATTR_TYPE_DESCRIPTIVE_ATTR = Messages.getString("SQLAccessToAW.Attribute");
    public static final String TYPE_NAME = "SQLAccessToAW";
    private Map dimMap = new TreeMap();
    private List sqlmeasCopy = new ArrayList();

    public SQLAccessToAW(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public Cube getCube() {
        return this.cube;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
        if (cube != null && !cube.getSQLDefinitions().contains(this)) {
            cube.getSQLDefinitions().add(this);
        }
    }

    private void verifyDimensions() {
        List list = null;
        list = this.slice != null ? this.slice.getUsedDimensions() : (this.cube != null ? this.cube.getDimensions() : new ArrayList());
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.sqlDimensionDefinitions);
        this.sqlDimensionDefinitions.clear();
        for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : arrayList) {
            if (!list.contains(iD_ObjectPropertyTranslator.getDimension())) continue;
            this.sqlDimensionDefinitions.add(iD_ObjectPropertyTranslator);
            iD_ObjectPropertyTranslator.verifyAttributes();
        }
        arrayList.clear();
        arrayList.addAll(this.allSQLDimensions);
        this.allSQLDimensions.clear();
        for (ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator : list) {
            SQLDimension sQLDimension = this.getSQLDimensionFor(arrayList, (Dimension)iD_ObjectPropertyTranslator);
            if (sQLDimension == null) {
                sQLDimension = this.getSQLDimensionFor(this.sqlDimensionDefinitions, (Dimension)iD_ObjectPropertyTranslator);
            }
            if (sQLDimension == null) {
                sQLDimension = new SQLDimension((Dimension)iD_ObjectPropertyTranslator, this);
                sQLDimension.verifyAttributes();
            }
            this.allSQLDimensions.add(sQLDimension);
        }
    }

    private SQLDimension getSQLDimensionFor(List list, Dimension dimension) {
        for (SQLDimension sQLDimension : list) {
            if (sQLDimension.getDimension() != dimension) continue;
            return sQLDimension;
        }
        return null;
    }

    private void verifyMeasures() {
        if (this.cube != null) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.selMeasures);
            List list = this.cube.getMeasures();
            this.selMeasures.clear();
            for (Measure measure : arrayList) {
                if (!list.contains(measure)) continue;
                this.selMeasures.add(measure);
            }
            this.allMeasures.clear();
            this.allMeasures.addAll(list);
        }
    }

    private void verifyMeasureWrappers() {
        if (this.slice != null) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.selMeasureWrappers);
            List list = this.slice.getSelectedMeasureWrappers();
            this.selMeasureWrappers.clear();
            for (Slice.MeasureWrapper measureWrapper : arrayList) {
                Slice.MeasureWrapper measureWrapper2 = this.getMeasureWrapper(list, measureWrapper);
                if (measureWrapper2 == null) continue;
                this.selMeasureWrappers.add(measureWrapper2);
            }
            this.allMeasureWrappers.clear();
            this.allMeasureWrappers.addAll(list);
        }
    }

    private Slice.MeasureWrapper getMeasureWrapper(List list, Slice.MeasureWrapper measureWrapper) {
        for (Slice.MeasureWrapper measureWrapper2 : list) {
            if (measureWrapper2.getMeasure() != measureWrapper.getMeasure() || !measureWrapper2.getAggrFunction().getObjectID().equals(measureWrapper.getAggrFunction().getObjectID())) continue;
            return measureWrapper2;
        }
        return null;
    }

    public void verifyDefinitions() {
        this.verifyRefsToHierarchies();
        this.verifyDimensions();
        if (this.slice != null) {
            this.verifyMeasureWrappers();
            this.verifySQLMeasureWrappers();
        } else if (this.cube != null) {
            this.verifyMeasures();
            this.verifySQLMeasures();
        }
        this.verifyOutAttributes();
        this.orderOutSQLAttributes();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SQLAccessToAWPropertiesDialogEx sQLAccessToAWPropertiesDialogEx = new SQLAccessToAWPropertiesDialogEx(this.getDesign().getAppView(), this);
            sQLAccessToAWPropertiesDialogEx.initProperties(this);
            sQLAccessToAWPropertiesDialogEx.setModal(true);
            sQLAccessToAWPropertiesDialogEx.show();
        }
    }

    public boolean isGenerateGIDs() {
        return this.generateGIDs;
    }

    public void setGenerateGIDs(boolean bl) {
        this.generateGIDs = bl;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public void setSlice(Slice slice) {
        this.slice = slice;
        if (slice != null && !slice.getSQLDefinitions().contains(this)) {
            slice.getSQLDefinitions().add(this);
        }
    }

    public boolean isUseModelClause() {
        return this.useModelClause;
    }

    public void setUseModelClause(boolean bl) {
        this.useModelClause = bl;
    }

    public List getMeasures() {
        return this.selMeasures;
    }

    public List getMeasureWrappers() {
        return this.selMeasureWrappers;
    }

    public List getSqlDimensionDefinitions() {
        return this.sqlDimensionDefinitions;
    }

    private SQLHierarchy getSQLHierarchyFor(List list, Hierarchy hierarchy) {
        for (SQLHierarchy sQLHierarchy : list) {
            if (sQLHierarchy.hierarchy != hierarchy) continue;
            return sQLHierarchy;
        }
        return null;
    }

    private SQLAttribute getSQLAttributeFor(List list, Level level, SlowChangingAttribute slowChangingAttribute) {
        for (SQLAttribute sQLAttribute : list) {
            if (sQLAttribute.getSlowChangingAttribute() != slowChangingAttribute || level != sQLAttribute.getLevel()) continue;
            return sQLAttribute;
        }
        return null;
    }

    private SQLAttribute getSQLAttributeFor(List list, Hierarchy hierarchy, Level level) {
        for (SQLAttribute sQLAttribute : list) {
            if (sQLAttribute.getLevel() != level || sQLAttribute.hierarchy != hierarchy) continue;
            return sQLAttribute;
        }
        return null;
    }

    private SQLAttribute getSQLAttributeFor(List list, Measure measure) {
        for (SQLAttribute sQLAttribute : list) {
            if (sQLAttribute.getMeasure() != measure) continue;
            return sQLAttribute;
        }
        return null;
    }

    private SQLAttribute getSQLAttributeFor(List list, Slice.MeasureWrapper measureWrapper) {
        for (SQLAttribute sQLAttribute : list) {
            Slice.MeasureWrapper measureWrapper2 = sQLAttribute.getMeasureWrapper();
            if (measureWrapper2.getMeasure() != measureWrapper.getMeasure() || !measureWrapper2.getAggrFunction().getObjectID().equals(measureWrapper.getAggrFunction().getObjectID())) continue;
            return sQLAttribute;
        }
        return null;
    }

    public boolean isUseObjectType() {
        return this.useObjectType;
    }

    public void setUseObjectType(boolean bl) {
        this.useObjectType = bl;
    }

    public String getTableADTName() {
        return this.tableADTName;
    }

    public void setTableADTName(String string) {
        this.tableADTName = string;
    }

    public String getObjectADTName() {
        return this.objectADTName;
    }

    public void setObjectADTName(String string) {
        this.objectADTName = string;
    }

    private void verifySQLMeasures() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.selectedSQLMeasures);
        this.selectedSQLMeasures.clear();
        for (Measure measure : this.selMeasures) {
            SQLAttribute sQLAttribute = this.getSQLAttributeFor(arrayList, measure);
            if (sQLAttribute == null) {
                sQLAttribute = new SQLAttribute(measure.getName().replaceAll(" ", "_"), measure, this.cube);
            }
            this.selectedSQLMeasures.add(sQLAttribute);
        }
    }

    public List getSelectedSQLMeasures() {
        this.verifyMeasures();
        this.verifySQLMeasures();
        return this.selectedSQLMeasures;
    }

    private void verifySQLMeasureWrappers() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.selectedSQLMeasureWrappers);
        this.selectedSQLMeasureWrappers.clear();
        for (Slice.MeasureWrapper measureWrapper : this.selMeasureWrappers) {
            SQLAttribute sQLAttribute = this.getSQLAttributeFor(arrayList, measureWrapper);
            if (sQLAttribute == null) {
                sQLAttribute = new SQLAttribute(measureWrapper.getAggrFunction().measureAlias.replaceAll(" ", "_"), measureWrapper, this.slice);
            }
            this.selectedSQLMeasureWrappers.add(sQLAttribute);
        }
    }

    public List getSelectedSQLMeasureWrappers() {
        this.verifyMeasureWrappers();
        this.verifySQLMeasureWrappers();
        return this.selectedSQLMeasureWrappers;
    }

    private void verifyOutAttributes() {
        Object object;
        this.dimMap.clear();
        this.sqlmeasCopy.clear();
        if (this.slice != null) {
            this.sqlmeasCopy.addAll(this.selectedSQLMeasureWrappers);
        } else {
            this.sqlmeasCopy.addAll(this.selectedSQLMeasures);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.outSQLAttributes);
        this.outSQLAttributes.clear();
        for (Object object2 : this.sqlDimensionDefinitions) {
            object = new DimDesc((SQLDimension)object2);
            this.dimMap.put(((SQLDimension)object2).getDimension().getObjectID(), object);
        }
        for (Object object2 : arrayList) {
            object = this.getSQLAttribite((SQLAttribute)object2);
            if (object == null) continue;
            this.outSQLAttributes.add(object);
        }
        this.outSQLAttributes.addAll(this.sqlmeasCopy);
        for (Object object2 : this.dimMap.keySet()) {
            object = (DimDesc)this.dimMap.get(object2);
            this.outSQLAttributes.addAll(((DimDesc)object).selAttrCopy);
        }
    }

    private void orderOutSQLAttributes() {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = -1;
        for (Object object : this.outSQLAttributes) {
            Integer n2;
            Object v;
            int n3 = ((SQLAttribute)object).getOutPosition();
            if (n < n3) {
                n = n3;
            }
            if ((v = treeMap.get(n2 = new Integer(n3))) == null) {
                treeMap.put(n2, object);
                continue;
            }
            arrayList.add(object);
        }
        this.outSQLAttributes.clear();
        for (Object object : treeMap.keySet()) {
            Object v = treeMap.get(object);
            this.outSQLAttributes.add(v);
        }
        ++n;
        for (Object object : arrayList) {
            ((SQLAttribute)object).setOutPosition(n);
            this.outSQLAttributes.add(object);
            ++n;
        }
    }

    private SQLAttribute getSQLAttribite(SQLAttribute sQLAttribute) {
        String string = sQLAttribute.getType();
        SQLAttribute sQLAttribute2 = null;
        if (ATTR_TYPE_MEASURE.equals(string)) {
            sQLAttribute2 = this.slice != null ? (this.getSQLAttributeFor(this.selectedSQLMeasureWrappers, sQLAttribute.getMeasureWrapper()) != null ? sQLAttribute : null) : (this.getSQLAttributeFor(this.selectedSQLMeasures, sQLAttribute.getMeasure()) != null ? sQLAttribute : null);
            if (sQLAttribute2 != null) {
                this.sqlmeasCopy.remove(sQLAttribute2);
            }
            return sQLAttribute2;
        }
        DimDesc dimDesc = (DimDesc)this.dimMap.get(sQLAttribute.getDimension().getObjectID());
        if (dimDesc != null) {
            SQLDimension sQLDimension = dimDesc.sqldim;
            if (ATTR_TYPE_DIMENSION_ID.equals(string)) {
                if (sQLDimension.isSelectedDimensionID()) {
                    sQLAttribute2 = sQLAttribute;
                }
            } else if (ATTR_TYPE_DIMENSION_GID.equals(string)) {
                if (this.isGenerateGIDs()) {
                    sQLAttribute2 = sQLAttribute;
                }
            } else if (ATTR_TYPE_LEVEL.equals(string)) {
                sQLAttribute2 = this.getSQLAttributeFor(dimDesc.selAttrCopy, sQLAttribute.hierarchy, sQLAttribute.getLevel());
            } else if (ATTR_TYPE_LEVEL_NAME.equals(string)) {
                if (sQLDimension.isSelectedLevelNameAttr()) {
                    sQLAttribute2 = sQLAttribute;
                }
            } else if (ATTR_TYPE_SHORT_DESC.equals(string)) {
                if (sQLDimension.isSelectedShortDescAttr()) {
                    sQLAttribute2 = sQLAttribute;
                }
            } else if (ATTR_TYPE_LONG_DESC.equals(string)) {
                if (sQLDimension.isSelectedLongDescAttr()) {
                    sQLAttribute2 = sQLAttribute;
                }
            } else if (ATTR_TYPE_END_DATE.equals(string)) {
                if (sQLDimension.isSelectedEndDate()) {
                    sQLAttribute2 = sQLAttribute;
                }
            } else if (ATTR_TYPE_TIME_SPAN.equals(string)) {
                if (sQLDimension.isSelectedTimeSpan()) {
                    sQLAttribute2 = sQLAttribute;
                }
            } else if (ATTR_TYPE_DESCRIPTIVE_ATTR.equals(string)) {
                sQLAttribute2 = this.getSQLAttributeFor(dimDesc.selAttrCopy, sQLAttribute.getLevel(), sQLAttribute.getSlowChangingAttribute());
            }
            if (sQLAttribute2 != null) {
                dimDesc.selAttrCopy.remove(sQLAttribute2);
            }
        }
        return sQLAttribute2;
    }

    private void verifyRefsToHierarchies() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.outSQLAttributes);
        for (SQLAttribute sQLAttribute : arrayList) {
            if (sQLAttribute.hierarchy != null || sQLAttribute.hierarchyID == null) continue;
            Hierarchy hierarchy = (Hierarchy)this.getMultidimensionalDesign().getHierarchySet().getObjectByID(sQLAttribute.hierarchyID);
            if (hierarchy != null) {
                sQLAttribute.hierarchy = hierarchy;
                continue;
            }
            this.outSQLAttributes.remove(sQLAttribute);
        }
    }

    public SQLAccessToAW makeCopy() {
        Object object2;
        SQLAccessToAW sQLAccessToAW = new SQLAccessToAW(this.getDesignPart());
        sQLAccessToAW.setGenerateGIDs(this.isGenerateGIDs());
        sQLAccessToAW.setName(this.getName());
        sQLAccessToAW.setAWName(this.getAWName());
        sQLAccessToAW.setComment(this.getComment());
        sQLAccessToAW.setNotes(this.getNotes());
        sQLAccessToAW.setDescription(this.getDescription());
        sQLAccessToAW.setSlice(this.getSlice());
        sQLAccessToAW.setCube(this.getCube());
        sQLAccessToAW.setUseModelClause(this.isUseModelClause());
        sQLAccessToAW.setUseObjectType(this.isUseObjectType());
        sQLAccessToAW.setObjectADTName(this.getObjectADTName());
        sQLAccessToAW.setTableADTName(this.getTableADTName());
        sQLAccessToAW.getMeasures().addAll(this.getMeasures());
        sQLAccessToAW.getMeasureWrappers().addAll(this.getMeasureWrappers());
        sQLAccessToAW.getSelectedSQLMeasures().addAll(this.selectedSQLMeasures);
        sQLAccessToAW.getSelectedSQLMeasureWrappers().addAll(this.getSelectedSQLMeasureWrappers());
        for (Object object2 : this.getSqlDimensionDefinitions()) {
            SQLAccessToAW sQLAccessToAW2 = sQLAccessToAW;
            sQLAccessToAW2.getClass();
            SQLDimension sQLDimension = sQLAccessToAW2.new SQLDimension(((SQLDimension)object2).getDimension(), sQLAccessToAW);
            ((SQLDimension)object2).makeCopyTo(sQLDimension);
            sQLAccessToAW.getSqlDimensionDefinitions().add(sQLDimension);
        }
        object2 = sQLAccessToAW.getSqlDimensionDefinitions();
        for (SQLDimension sQLDimension : this.allSQLDimensions) {
            SQLDimension sQLDimension2 = this.getSQLDimensionFor((List)object2, sQLDimension.getDimension());
            if (sQLDimension2 == null) {
                SQLAccessToAW sQLAccessToAW3 = sQLAccessToAW;
                sQLAccessToAW3.getClass();
                sQLDimension2 = sQLAccessToAW3.new SQLDimension(sQLDimension.getDimension(), sQLAccessToAW);
                sQLDimension.makeCopyTo(sQLDimension2);
            }
            sQLAccessToAW.getAllSQLDimensions().add(sQLDimension2);
        }
        sQLAccessToAW.getOutSQLAttributes().addAll(this.getOutSQLAttributes());
        return sQLAccessToAW;
    }

    public void makeCopyTo(SQLAccessToAW sQLAccessToAW) {
        Object object2;
        sQLAccessToAW.setGenerateGIDs(this.isGenerateGIDs());
        sQLAccessToAW.setName(this.getName());
        sQLAccessToAW.setAWName(this.getAWName());
        sQLAccessToAW.setComment(this.getComment());
        sQLAccessToAW.setNotes(this.getNotes());
        sQLAccessToAW.setDescription(this.getDescription());
        sQLAccessToAW.setSlice(this.getSlice());
        sQLAccessToAW.setCube(this.getCube());
        sQLAccessToAW.setUseModelClause(this.isUseModelClause());
        sQLAccessToAW.setUseObjectType(this.isUseObjectType());
        sQLAccessToAW.setObjectADTName(this.getObjectADTName());
        sQLAccessToAW.setTableADTName(this.getTableADTName());
        sQLAccessToAW.getMeasures().clear();
        sQLAccessToAW.getMeasures().addAll(this.getMeasures());
        sQLAccessToAW.getMeasureWrappers().clear();
        sQLAccessToAW.getMeasureWrappers().addAll(this.getMeasureWrappers());
        sQLAccessToAW.getSelectedSQLMeasures().clear();
        sQLAccessToAW.getSelectedSQLMeasures().addAll(this.selectedSQLMeasures);
        sQLAccessToAW.getSelectedSQLMeasureWrappers().clear();
        sQLAccessToAW.getSelectedSQLMeasureWrappers().addAll(this.getSelectedSQLMeasureWrappers());
        sQLAccessToAW.getSqlDimensionDefinitions().clear();
        for (Object object2 : this.getSqlDimensionDefinitions()) {
            SQLAccessToAW sQLAccessToAW2 = sQLAccessToAW;
            sQLAccessToAW2.getClass();
            SQLDimension sQLDimension = sQLAccessToAW2.new SQLDimension(((SQLDimension)object2).getDimension(), sQLAccessToAW);
            ((SQLDimension)object2).makeCopyTo(sQLDimension);
            sQLAccessToAW.getSqlDimensionDefinitions().add(sQLDimension);
        }
        object2 = sQLAccessToAW.getSqlDimensionDefinitions();
        sQLAccessToAW.getAllSQLDimensions().clear();
        for (SQLDimension sQLDimension : this.allSQLDimensions) {
            SQLDimension sQLDimension2 = this.getSQLDimensionFor((List)object2, sQLDimension.getDimension());
            if (sQLDimension2 == null) {
                SQLAccessToAW sQLAccessToAW3 = sQLAccessToAW;
                sQLAccessToAW3.getClass();
                sQLDimension2 = sQLAccessToAW3.new SQLDimension(sQLDimension.getDimension(), sQLAccessToAW);
                sQLDimension.makeCopyTo(sQLDimension2);
            }
            sQLAccessToAW.getAllSQLDimensions().add(sQLDimension2);
        }
        sQLAccessToAW.getOutSQLAttributes().clear();
        sQLAccessToAW.getOutSQLAttributes().addAll(this.getOutSQLAttributes());
    }

    public List getOutSQLAttributes() {
        return this.outSQLAttributes;
    }

    public List getAllSQLDimensions() {
        return this.allSQLDimensions;
    }

    public List getAllMeasures() {
        return this.allMeasures;
    }

    public List getAllMeasureWrappers() {
        return this.allMeasureWrappers;
    }

    public String getSQLText(boolean bl) {
        return this.getSQLText(bl, this.getOutSQLAttributes());
    }

    public String getSQLText(boolean bl, List list) {
        return this.getSqlToAWGenerator().generateSQL(this, bl, list);
    }

    private SQLtoAWGenerator getSqlToAWGenerator() {
        if (this.sqlToAWGenerator == null) {
            this.sqlToAWGenerator = new SQLtoAWGenerator();
        }
        return this.sqlToAWGenerator;
    }

    public boolean isUseRowToCellColumn() {
        return this.useRowToCellColumn;
    }

    public void setUseRowToCellColumn(boolean bl) {
        this.useRowToCellColumn = bl;
    }

    public String getAWName() {
        return this.aWName;
    }

    public void setAWName(String string) {
        this.aWName = string;
    }

    public SQLAttribute getIDColumnForDimension(List list, Dimension dimension) {
        for (SQLAttribute sQLAttribute : list) {
            if (!sQLAttribute.getType().equals(ATTR_TYPE_DIMENSION_ID) || sQLAttribute.getDimension() != dimension) continue;
            return sQLAttribute;
        }
        return null;
    }

    public SQLAttribute getSQLShortDescAttr(List list, Dimension dimension) {
        for (SQLAttribute sQLAttribute : list) {
            if (!sQLAttribute.getType().equals(ATTR_TYPE_SHORT_DESC) || sQLAttribute.getDimension() != dimension) continue;
            return sQLAttribute;
        }
        return null;
    }

    public SQLAttribute getSQLLongDescAttr(List list, Dimension dimension) {
        for (SQLAttribute sQLAttribute : list) {
            if (!sQLAttribute.getType().equals(ATTR_TYPE_LONG_DESC) || sQLAttribute.getDimension() != dimension) continue;
            return sQLAttribute;
        }
        return null;
    }

    public SQLAttribute getSQLEndDateAttr(List list, Dimension dimension) {
        for (SQLAttribute sQLAttribute : list) {
            if (!sQLAttribute.getType().equals(ATTR_TYPE_END_DATE) || sQLAttribute.getDimension() != dimension) continue;
            return sQLAttribute;
        }
        return null;
    }

    public SQLAttribute getSQLTimeSpanAttr(List list, Dimension dimension) {
        for (SQLAttribute sQLAttribute : list) {
            if (!sQLAttribute.getType().equals(ATTR_TYPE_TIME_SPAN) || sQLAttribute.getDimension() != dimension) continue;
            return sQLAttribute;
        }
        return null;
    }

    public SQLAttribute getSQLLevelNameAttr(List list, Dimension dimension) {
        for (SQLAttribute sQLAttribute : list) {
            if (!sQLAttribute.getType().equals(ATTR_TYPE_LEVEL_NAME) || sQLAttribute.getDimension() != dimension) continue;
            return sQLAttribute;
        }
        return null;
    }

    public SQLAttribute getGIDForDimension(List list, Dimension dimension) {
        for (SQLAttribute sQLAttribute : list) {
            if (!sQLAttribute.getType().equals(ATTR_TYPE_DIMENSION_GID) || sQLAttribute.getDimension() != dimension) continue;
            return sQLAttribute;
        }
        return null;
    }

    public SQLAttribute getSQLLevelAttr(List list, Dimension dimension, Hierarchy hierarchy, Level level) {
        for (SQLAttribute sQLAttribute : list) {
            if (!sQLAttribute.getType().equals(ATTR_TYPE_LEVEL) || sQLAttribute.getDimension() != dimension || sQLAttribute.getLevel() != level || sQLAttribute.getHierarchy() != hierarchy) continue;
            return sQLAttribute;
        }
        return null;
    }

    public void attributeIsDeleted(Attribute attribute) {
    }

    public void entityIsDeleted(Entity entity) {
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "sqltoaw/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public List getOtherOutAttributes() {
        ArrayList<SQLAttribute> arrayList = new ArrayList<SQLAttribute>();
        for (SQLAttribute sQLAttribute : this.getOutSQLAttributes()) {
            if (!ATTR_TYPE_MEASURE.equals(sQLAttribute.getType())) continue;
            arrayList.add(sQLAttribute);
        }
        return arrayList;
    }

    public List getMeasureWrapperMaps() {
        if (this.selMeasureWrappers.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        for (Slice.MeasureWrapper measureWrapper : this.selMeasureWrappers) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("measure_id", measureWrapper.getMeasure().getObjectID());
            treeMap.put("aggrFunctionID", measureWrapper.getAggrFuncId());
            arrayList.add(treeMap);
        }
        return arrayList;
    }

    public void applyMeasureWrapperMaps(List list) {
        this.selMeasureWrappers.clear();
        if (this.slice != null) {
            for (Object e : list) {
                Map map;
                String string;
                if (!(e instanceof Map) || (string = (String)(map = (Map)e).get("measure_id")) == null) continue;
                Slice.MeasureWrapper measureWrapper = null;
                String string2 = (String)map.get("aggrFunctionID");
                measureWrapper = this.slice.getMeasureWrapper(string, string2);
                if (measureWrapper == null) continue;
                this.selMeasureWrappers.add(measureWrapper);
            }
        }
    }

    public SQLAttribute createSQLAttribute() {
        return new SQLAttribute(this);
    }

    public SQLDimension createSQLDimension() {
        return new SQLDimension(this);
    }

    private class DimDesc {
        SQLDimension sqldim;
        List selAttrCopy;

        DimDesc(SQLDimension sQLDimension) {
            this.sqldim = sQLDimension;
            this.selAttrCopy = new ArrayList();
            this.selAttrCopy.addAll(sQLDimension.getAllSelectedAttributes());
        }
    }

    public class SQLDimension
    implements ID_ObjectPropertyTranslator {
        private Dimension dimension;
        private SQLAttribute longDescAttr;
        private SQLAttribute shortDescAttr;
        private SQLAttribute levelNameAttr;
        private SQLAttribute dimensionGIDAttr;
        private SQLAttribute dimensionIDAttr;
        private SQLAttribute endDateAttr;
        private SQLAttribute timeSpanAttr;
        private boolean selectedLongDescAttr;
        private boolean selectedShortDescAttr;
        private boolean selectedLevelNameAttr;
        private boolean selectedDimensionID = true;
        private boolean selectedEndDate;
        private boolean selectedTimeSpan;
        private List selectedDescriptiveAttributes = new ArrayList();
        private List selectedNoneDescriptiveAttributes = new ArrayList();
        private List allDescriptiveAttributes = new ArrayList();
        private List selectedSQLHierarhies = new ArrayList();
        private List allSQLHierarchies = new ArrayList();
        private List allSelectedAttributes = new ArrayList();
        private SQLAccessToAW sqlawObject;
        private String dimensionID;

        public SQLDimension(Dimension dimension, SQLAccessToAW sQLAccessToAW2) {
            this.dimension = dimension;
            this.sqlawObject = sQLAccessToAW2;
        }

        public SQLDimension(SQLAccessToAW sQLAccessToAW2) {
            this.sqlawObject = sQLAccessToAW2;
        }

        public String getName() {
            return this.dimension.getName().replaceAll(" ", "_");
        }

        public SQLHierarchy createSQLHierarchy() {
            return new SQLHierarchy(this.sqlawObject);
        }

        public void makeCopyTo(SQLDimension sQLDimension) {
            sQLDimension.dimension = this.dimension;
            sQLDimension.setSelectedDimensionID(this.isSelectedDimensionID());
            sQLDimension.setSelectedShortDescAttr(this.isSelectedShortDescAttr());
            sQLDimension.setSelectedLongDescAttr(this.isSelectedLongDescAttr());
            sQLDimension.setSelectedLevelNameAttr(this.isSelectedLevelNameAttr());
            sQLDimension.setSelectedEndDate(this.isSelectedEndDate());
            sQLDimension.setSelectedTimeSpan(this.isSelectedTimeSpan());
            sQLDimension.selectedDescriptiveAttributes.clear();
            sQLDimension.selectedDescriptiveAttributes.addAll(this.selectedDescriptiveAttributes);
            sQLDimension.allDescriptiveAttributes.clear();
            sQLDimension.allDescriptiveAttributes.addAll(this.allDescriptiveAttributes);
            sQLDimension.selectedSQLHierarhies.clear();
            sQLDimension.selectedNoneDescriptiveAttributes.clear();
            sQLDimension.selectedNoneDescriptiveAttributes.addAll(this.selectedNoneDescriptiveAttributes);
            for (SQLHierarchy sQLHierarchy : this.selectedSQLHierarhies) {
                SQLAccessToAW sQLAccessToAW = this.getSqlawObject();
                sQLAccessToAW.getClass();
                SQLHierarchy sQLHierarchy2 = sQLAccessToAW.new SQLHierarchy(sQLHierarchy.getHierarchy());
                sQLHierarchy.makeCopyTo(sQLHierarchy2);
                sQLDimension.selectedSQLHierarhies.add(sQLHierarchy2);
            }
            sQLDimension.verifyHierarchies();
            sQLDimension.verifyNoneDescAttributes();
        }

        public Dimension getDimension() {
            return this.dimension;
        }

        public SQLAttribute getLevelNameAttr() {
            if (this.levelNameAttr == null) {
                this.levelNameAttr = new SQLAttribute(ATTR_TYPE_LEVEL_NAME, this.dimension.getName().replaceAll(" ", "_") + "Level_Name", this.dimension);
            }
            return this.levelNameAttr;
        }

        public SQLAttribute getLongDescAttr() {
            if (this.longDescAttr == null) {
                this.longDescAttr = new SQLAttribute(ATTR_TYPE_LONG_DESC, this.dimension.getName().replaceAll(" ", "_") + "Long_DSC", this.dimension);
            }
            return this.longDescAttr;
        }

        public SQLAttribute getShortDescAttr() {
            if (this.shortDescAttr == null) {
                this.shortDescAttr = new SQLAttribute(ATTR_TYPE_SHORT_DESC, this.dimension.getName().replaceAll(" ", "_") + "Short_DSC", this.dimension);
            }
            return this.shortDescAttr;
        }

        public SQLAttribute getEndDateAttr() {
            if (this.endDateAttr == null) {
                this.endDateAttr = new SQLAttribute(ATTR_TYPE_END_DATE, this.dimension.getName().replaceAll(" ", "_") + "End_Date", this.dimension);
            }
            return this.endDateAttr;
        }

        public SQLAttribute getTimeSpanAttr() {
            if (this.timeSpanAttr == null) {
                this.timeSpanAttr = new SQLAttribute(ATTR_TYPE_TIME_SPAN, this.dimension.getName().replaceAll(" ", "_") + "Time_Span", this.dimension);
            }
            return this.timeSpanAttr;
        }

        public boolean isSelectedLevelNameAttr() {
            return this.selectedLevelNameAttr;
        }

        public void setSelectedLevelNameAttr(boolean bl) {
            this.selectedLevelNameAttr = bl;
        }

        public boolean isSelectedLongDescAttr() {
            return this.selectedLongDescAttr;
        }

        public void setSelectedLongDescAttr(boolean bl) {
            this.selectedLongDescAttr = bl;
        }

        public boolean isSelectedShortDescAttr() {
            return this.selectedShortDescAttr;
        }

        public void setSelectedShortDescAttr(boolean bl) {
            this.selectedShortDescAttr = bl;
        }

        public List getSelectedDescriptiveAttributes() {
            return this.selectedDescriptiveAttributes;
        }

        public List getSelectedSQLHierarhies() {
            return this.selectedSQLHierarhies;
        }

        public SQLAttribute getDimensionGIDAttr() {
            if (this.dimensionGIDAttr == null) {
                this.dimensionGIDAttr = new SQLAttribute(ATTR_TYPE_DIMENSION_GID, this.dimension.getName().replaceAll(" ", "_") + "_GID", this.dimension);
            }
            return this.dimensionGIDAttr;
        }

        private void verifyHierarchies() {
            Hierarchy hierarchy;
            Object object2;
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.selectedSQLHierarhies);
            this.selectedSQLHierarhies.clear();
            for (Object object2 : arrayList) {
                hierarchy = (Hierarchy)this.dimension.getHierarchies().getObjectByID(((SQLHierarchy)object2).getHierarchy().getObjectID());
                if (hierarchy == null) continue;
                this.selectedSQLHierarhies.add(object2);
            }
            object2 = new ArrayList();
            object2.addAll(this.allSQLHierarchies);
            this.allSQLHierarchies.clear();
            Iterator iterator = this.dimension.getHierarchies().iterator();
            while (iterator.hasNext()) {
                hierarchy = (Hierarchy)iterator.next();
                SQLHierarchy sQLHierarchy = SQLAccessToAW.this.getSQLHierarchyFor((List)object2, hierarchy);
                if (sQLHierarchy == null) {
                    sQLHierarchy = SQLAccessToAW.this.getSQLHierarchyFor(this.selectedSQLHierarhies, hierarchy);
                }
                if (sQLHierarchy == null) {
                    sQLHierarchy = new SQLHierarchy(hierarchy);
                }
                this.allSQLHierarchies.add(sQLHierarchy);
            }
        }

        private void verifyNoneDescAttributes() {
            Object object;
            ArrayList arrayList = new ArrayList();
            List list = this.getSqlawObject().getOutSQLAttributes();
            arrayList.addAll(this.selectedNoneDescriptiveAttributes);
            this.selectedNoneDescriptiveAttributes.clear();
            if (this.isSelectedDimensionID()) {
                object = SQLAccessToAW.this.getIDColumnForDimension(list, this.getDimension());
                if (object == null) {
                    object = SQLAccessToAW.this.getIDColumnForDimension(arrayList, this.getDimension());
                }
                if (object != null) {
                    this.selectedNoneDescriptiveAttributes.add(object);
                } else {
                    this.selectedNoneDescriptiveAttributes.add(this.getDimensionIDAttr());
                }
            }
            if (SQLAccessToAW.this.isGenerateGIDs() && this.selectedSQLHierarhies.size() > 0) {
                object = SQLAccessToAW.this.getGIDForDimension(arrayList, this.getDimension());
                if (object != null) {
                    this.selectedNoneDescriptiveAttributes.add(object);
                } else {
                    this.selectedNoneDescriptiveAttributes.add(this.getDimensionGIDAttr());
                }
            }
            if (this.isSelectedLevelNameAttr()) {
                object = SQLAccessToAW.this.getSQLLevelNameAttr(arrayList, this.getDimension());
                if (object != null) {
                    this.selectedNoneDescriptiveAttributes.add(object);
                } else {
                    this.selectedNoneDescriptiveAttributes.add(this.getLevelNameAttr());
                }
            }
            if (this.isSelectedShortDescAttr()) {
                object = SQLAccessToAW.this.getSQLShortDescAttr(arrayList, this.getDimension());
                if (object != null) {
                    this.selectedNoneDescriptiveAttributes.add(object);
                } else {
                    this.selectedNoneDescriptiveAttributes.add(this.getShortDescAttr());
                }
            }
            if (this.isSelectedLongDescAttr()) {
                object = SQLAccessToAW.this.getSQLLongDescAttr(arrayList, this.getDimension());
                if (object != null) {
                    this.selectedNoneDescriptiveAttributes.add(object);
                } else {
                    this.selectedNoneDescriptiveAttributes.add(this.getLongDescAttr());
                }
            }
            if (this.getDimension().isTimeDimension()) {
                if (this.isSelectedEndDate()) {
                    object = SQLAccessToAW.this.getSQLEndDateAttr(arrayList, this.getDimension());
                    if (object != null) {
                        this.selectedNoneDescriptiveAttributes.add(object);
                    } else {
                        this.selectedNoneDescriptiveAttributes.add(this.getEndDateAttr());
                    }
                }
                if (this.isSelectedTimeSpan()) {
                    object = SQLAccessToAW.this.getSQLTimeSpanAttr(arrayList, this.getDimension());
                    if (object != null) {
                        this.selectedNoneDescriptiveAttributes.add(object);
                    } else {
                        this.selectedNoneDescriptiveAttributes.add(this.getTimeSpanAttr());
                    }
                }
            }
            for (SQLHierarchy sQLHierarchy : this.selectedSQLHierarhies) {
                if (!sQLHierarchy.isRollupForm()) continue;
                List list2 = sQLHierarchy.getValidSelLevels();
                for (Level level : list2) {
                    SQLAttribute sQLAttribute = SQLAccessToAW.this.getSQLAttributeFor(arrayList, sQLHierarchy.getHierarchy(), level);
                    if (sQLAttribute == null) {
                        sQLAttribute = new SQLAttribute(level.getName().replaceAll(" ", "_"), this.dimension, sQLHierarchy.getHierarchy(), level);
                    }
                    this.selectedNoneDescriptiveAttributes.add(sQLAttribute);
                }
            }
        }

        private void verifyDescAttributes() {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.selectedDescriptiveAttributes);
            this.selectedDescriptiveAttributes.clear();
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(this.allDescriptiveAttributes);
            this.allDescriptiveAttributes.clear();
            for (Level level : this.dimension.getAllLevels()) {
                for (SlowChangingAttribute slowChangingAttribute : level.getSlowChangingAttributes()) {
                    SQLAttribute sQLAttribute = SQLAccessToAW.this.getSQLAttributeFor(arrayList, level, slowChangingAttribute);
                    if (sQLAttribute != null) {
                        this.selectedDescriptiveAttributes.add(sQLAttribute);
                        this.allDescriptiveAttributes.add(sQLAttribute);
                        continue;
                    }
                    sQLAttribute = SQLAccessToAW.this.getSQLAttributeFor(arrayList2, level, slowChangingAttribute);
                    if (sQLAttribute == null) {
                        sQLAttribute = new SQLAttribute(slowChangingAttribute.getName().replaceAll(" ", "_"), this.dimension, level, slowChangingAttribute);
                    }
                    this.allDescriptiveAttributes.add(sQLAttribute);
                }
            }
        }

        public void verifyAttributes() {
            this.verifyHierarchies();
            this.verifyNoneDescAttributes();
            this.verifyDescAttributes();
        }

        public List getAllSelectedAttributes() {
            this.allSelectedAttributes.clear();
            this.allSelectedAttributes.addAll(this.selectedNoneDescriptiveAttributes);
            this.allSelectedAttributes.addAll(this.selectedDescriptiveAttributes);
            return this.allSelectedAttributes;
        }

        public SQLAttribute getDimensionIDAttr() {
            if (this.dimensionIDAttr == null) {
                this.dimensionIDAttr = new SQLAttribute(ATTR_TYPE_DIMENSION_ID, this.dimension.getName().replaceAll(" ", "_") + "_id", this.dimension);
            }
            return this.dimensionIDAttr;
        }

        public boolean isSelectedDimensionID() {
            return this.selectedDimensionID;
        }

        public void setSelectedDimensionID(boolean bl) {
            this.selectedDimensionID = bl;
        }

        public List getAllDescriptiveAttributes() {
            return this.allDescriptiveAttributes;
        }

        public String toString() {
            return this.dimension.getName();
        }

        public List getAllSQLHierarchies() {
            return this.allSQLHierarchies;
        }

        public SQLAccessToAW getSqlawObject() {
            return this.sqlawObject;
        }

        public boolean isSelectedEndDate() {
            return this.selectedEndDate;
        }

        public void setSelectedEndDate(boolean bl) {
            this.selectedEndDate = bl;
        }

        public boolean isSelectedTimeSpan() {
            return this.selectedTimeSpan;
        }

        public void setSelectedTimeSpan(boolean bl) {
            this.selectedTimeSpan = bl;
        }

        public String getDimensionID() {
            return this.dimensionID;
        }

        public void setDimensionID(String string) {
            this.dimensionID = string;
        }

        public SQLAttribute createSQLAttribute() {
            SQLAttribute sQLAttribute = new SQLAttribute(this.sqlawObject);
            sQLAttribute.setDimension(this.getDimension());
            return sQLAttribute;
        }

        @Override
        public Object translateIdToObject(String string, String string2) {
            return this.sqlawObject.translateIdToObject(string, string2);
        }

        @Override
        public String translateObjectToID(String string, Object object) {
            return this.sqlawObject.translateObjectToID(string, object);
        }

        public void applySQLAttributes(List list) {
            List list2 = this.getAllSelectedAttributes();
            for (SQLAttribute sQLAttribute : list) {
                String string = sQLAttribute.getType();
                if (ATTR_TYPE_SHORT_DESC.equals(string)) {
                    this.setSelectedShortDescAttr(true);
                    this.shortDescAttr = sQLAttribute;
                } else if (ATTR_TYPE_LONG_DESC.equals(string)) {
                    this.setSelectedLongDescAttr(true);
                    this.longDescAttr = sQLAttribute;
                } else if (ATTR_TYPE_END_DATE.equals(string)) {
                    this.setSelectedEndDate(true);
                    this.endDateAttr = sQLAttribute;
                } else if (ATTR_TYPE_TIME_SPAN.equals(string)) {
                    this.setSelectedTimeSpan(true);
                    this.timeSpanAttr = sQLAttribute;
                } else if (ATTR_TYPE_LEVEL_NAME.equals(string)) {
                    this.setSelectedLevelNameAttr(true);
                    this.levelNameAttr = sQLAttribute;
                } else if (ATTR_TYPE_DIMENSION_ID.equals(string)) {
                    this.setSelectedDimensionID(true);
                    this.dimensionIDAttr = sQLAttribute;
                } else if (ATTR_TYPE_DIMENSION_GID.equals(string)) {
                    this.dimensionGIDAttr = sQLAttribute;
                }
                list2.add(sQLAttribute);
            }
        }

        public void setDimension(Dimension dimension) {
            this.dimension = dimension;
        }
    }

    public class SQLHierarchy
    implements ID_ObjectPropertyTranslator {
        private List selectedLevels = new ArrayList();
        private Hierarchy hierarchy;
        private SQLAttribute labelAttribute;
        private boolean rollupForm;
        private String hierarchyID = "";
        private SQLAccessToAW sqlawObject;

        public SQLHierarchy(Hierarchy hierarchy) {
            this.hierarchy = hierarchy;
        }

        public SQLHierarchy(SQLAccessToAW sQLAccessToAW2) {
            this.sqlawObject = sQLAccessToAW2;
        }

        public SQLHierarchy(String string) {
            this.hierarchyID = string;
        }

        public Hierarchy getHierarchy() {
            if (this.hierarchy == null) {
                this.hierarchy = (Hierarchy)SQLAccessToAW.this.getMultidimensionalDesign().getHierarchySet().getObjectByID(this.hierarchyID);
            }
            return this.hierarchy;
        }

        public String getHierarchyID() {
            return this.hierarchyID;
        }

        public boolean isLevelSelected(Level level) {
            return this.selectedLevels.contains(level);
        }

        public void setLevelSelection(Level level, boolean bl) {
            if (bl && !this.selectedLevels.contains(level)) {
                this.selectedLevels.add(level);
            } else if (!bl) {
                this.selectedLevels.remove(level);
            }
        }

        public SQLAttribute getLabelAttribute() {
            return this.labelAttribute;
        }

        public void setLabelAttribute(SQLAttribute sQLAttribute) {
            this.labelAttribute = sQLAttribute;
        }

        public SQLAttribute createLabelAttribute() {
            if (this.sqlawObject == null) {
                this.sqlawObject = SQLAccessToAW.this;
            }
            this.labelAttribute = new SQLAttribute(this.sqlawObject);
            return this.labelAttribute;
        }

        public void removeLabelAttribute() {
            this.labelAttribute = null;
        }

        public String toString() {
            return this.getHierarchy().getName();
        }

        public SQLHierarchy makeCopy() {
            SQLHierarchy sQLHierarchy = new SQLHierarchy(this.getHierarchy());
            sQLHierarchy.labelAttribute = this.labelAttribute;
            sQLHierarchy.setRollupForm(this.isRollupForm());
            sQLHierarchy.selectedLevels.addAll(this.getValidSelLevels());
            return sQLHierarchy;
        }

        public SQLHierarchy makeCopyTo(SQLHierarchy sQLHierarchy) {
            sQLHierarchy.labelAttribute = this.labelAttribute;
            sQLHierarchy.setRollupForm(this.isRollupForm());
            sQLHierarchy.selectedLevels.addAll(this.getValidSelLevels());
            return sQLHierarchy;
        }

        public boolean isRollupForm() {
            return this.rollupForm;
        }

        public void setRollupForm(boolean bl) {
            this.rollupForm = bl;
        }

        public List getValidSelLevels() {
            List list = this.getHierarchy().getLevels();
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.selectedLevels);
            this.selectedLevels.clear();
            for (Level level : arrayList) {
                if (!list.contains(level)) continue;
                this.selectedLevels.add(level);
            }
            return this.selectedLevels;
        }

        public List getSelectedLevels() {
            return this.selectedLevels;
        }

        public void setHierarchyID(String string) {
            this.hierarchyID = string;
        }

        @Override
        public Object translateIdToObject(String string, String string2) {
            return this.sqlawObject.translateIdToObject(string, string2);
        }

        @Override
        public String translateObjectToID(String string, Object object) {
            return this.sqlawObject.translateObjectToID(string, object);
        }
    }
}

