/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.swingui.editor.multidimensional.RollupLinkPropertiesDialogEx;

public class RollupLink
extends AbstractMDObject {
    private AbstractMDObject childLevel;
    private AbstractMDObject parentLevel;
    private List childToParentAttributes = new ArrayList();
    private ContainerObject factEntity;
    private boolean rolePlaying;
    private String defaultAggregationOperator = "SUM";
    private boolean sparseDimension = false;
    private Link link;
    public static final String TYPE_NAME = "RollupLink";

    public RollupLink(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RollupLinkPropertiesDialogEx rollupLinkPropertiesDialogEx = new RollupLinkPropertiesDialogEx(this.getDesign().getAppView(), this);
            rollupLinkPropertiesDialogEx.initProperties(this);
            rollupLinkPropertiesDialogEx.show();
        }
    }

    public AbstractMDObject getChildLevel() {
        return this.childLevel;
    }

    public void setChildLevel(AbstractMDObject abstractMDObject) {
        this.childLevel = abstractMDObject;
    }

    public AbstractMDObject getParentLevel() {
        return this.parentLevel;
    }

    public void setParentLevel(AbstractMDObject abstractMDObject) {
        this.parentLevel = abstractMDObject;
    }

    public List getChildToParentAttributes() {
        return this.childToParentAttributes;
    }

    public void addChildToParentAttribute(ContainedObject containedObject) {
        if (!this.childToParentAttributes.contains(containedObject)) {
            this.childToParentAttributes.add(containedObject);
        }
    }

    public void removeChildToParentAttribute(ContainedObject containedObject) {
        this.childToParentAttributes.remove(containedObject);
    }

    public ContainerObject getFactEntity() {
        if (this.childLevel == null || !(this.childLevel instanceof Cube)) {
            return null;
        }
        if (this.factEntity != null) {
            return this.factEntity;
        }
        if (this.childToParentAttributes.size() > 0) {
            ContainedObject containedObject = (ContainedObject)this.childToParentAttributes.get(0);
            this.factEntity = containedObject.getContainer();
            return this.factEntity;
        }
        Cube cube = (Cube)this.childLevel;
        if (cube.getFactEntities().size() == 1) {
            this.factEntity = (ContainerObject)cube.getFactEntities().get(0);
            return this.factEntity;
        }
        return null;
    }

    public void setFactEntity(ContainerObject containerObject) {
        this.factEntity = containerObject;
    }

    public boolean isRolePlaying() {
        return this.rolePlaying;
    }

    public void setRolePlaying(boolean bl) {
        this.rolePlaying = bl;
    }

    public String getDefaultAggregationOperator() {
        return this.defaultAggregationOperator;
    }

    public void setDefaultAggregationOperator(String string) {
        this.defaultAggregationOperator = string;
    }

    public boolean isSparseDimension() {
        return this.sparseDimension;
    }

    public void setSparseDimension(boolean bl) {
        this.sparseDimension = bl;
    }

    public Link getLink() {
        if (this.link == null) {
            Iterator iterator = ((MultidimensionalDesign)this.getDesignPart()).getLinkSet().iterator();
            while (iterator.hasNext()) {
                Link link = (Link)iterator.next();
                if (link.getRollupLink() != this) continue;
                this.link = link;
            }
        }
        return this.link;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "rolluplink/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setLink(Link link) {
        this.link = link;
    }

    public Link getOrCreateLink() {
        if (this.link == null) {
            this.link = this.getMultidimensionalDesign().getLinkSet().createLink(null, this);
        }
        return this.link;
    }

    @Override
    public void remove() {
        super.remove();
    }
}

