/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.multidimensional.RaggedHLinkPropertiesDialogEx;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;

public class RaggedHLink
extends AbstractMDObject
implements ConnectionInterface {
    public static final Object[] CONNECTION_PROTO_ARRAY = new Connection[0];
    public static final int SOURCE = 0;
    public static final int DESTINATION = 1;
    private final AbstractMDObject[] MD_OBJECTS = new AbstractMDObject[2];
    private final Connection[] CONNECTIONS = new Connection[]{new SourceConnection(), new DestinationConnection()};
    private Collection dpvCol = new ArrayList();
    private AbstractMDObject source;
    private AbstractMDObject destination;
    private List childToParentAttributes = new ArrayList();
    private Entity factEntity;
    public static final String TYPE_NAME = "RaggedHLink";

    public RaggedHLink(DesignPart designPart, Level level, Level level2) {
        super(designPart);
        this.destination = level;
        this.source = level2;
        if (level != null) {
            level.getRaggedHLinks().add(this);
        }
        if (level2 != null) {
            level2.getInputRaggedHLinks().add(this);
        }
    }

    public RaggedHLink(DesignPart designPart) {
        super(designPart);
    }

    public void setMDObject(int n, AbstractMDObject abstractMDObject) {
        if (this.MD_OBJECTS[n] == abstractMDObject) {
            return;
        }
        if (this.MD_OBJECTS[n] != null) {
            if (this.MD_OBJECTS[0] != this.MD_OBJECTS[1]) {
                // empty if block
            }
            this.MD_OBJECTS[n].remove(this.CONNECTIONS[n]);
        }
        if (abstractMDObject != null) {
            abstractMDObject.add(this.CONNECTIONS[n]);
        }
        this.MD_OBJECTS[n] = abstractMDObject;
        if (abstractMDObject != null) {
            // empty if block
        }
        this.fireChange(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED);
    }

    public AbstractMDObject getMDObject(int n) {
        return this.MD_OBJECTS[n];
    }

    public AbstractMDObject getTargetMDObject() {
        return this.getMDObject(1);
    }

    public void setTargetMDObject(AbstractMDObject abstractMDObject) {
        AbstractMDObject abstractMDObject2 = this.getTargetMDObject();
        this.setMDObject(1, abstractMDObject);
        this.setDestination(abstractMDObject);
        if (abstractMDObject2 != abstractMDObject && abstractMDObject2 != null) {
            this.clearTargetTV();
        }
    }

    public AbstractMDObject getSourceMDObject() {
        return this.getMDObject(0);
    }

    public void setSourceMDObject(AbstractMDObject abstractMDObject) {
        AbstractMDObject abstractMDObject2 = this.getSourceMDObject();
        this.setMDObject(0, abstractMDObject);
        this.setSource(abstractMDObject);
        if (abstractMDObject2 != abstractMDObject && abstractMDObject2 != null) {
            this.clearSourceTV();
        }
    }

    @Override
    public void removeAllViews() {
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.dpv == null || dpvInfo2.tv == null) continue;
            dpvInfo2.dpv.unregisterFromTreemodel(dpvInfo2.tv);
            dpvInfo2.dpv.getWorkSpace().removeConnection(this);
            dpvInfo2.tv = null;
        }
    }

    public void clearSourceTV() {
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            dpvInfo2.sourceTV = null;
        }
    }

    public void clearTargetTV() {
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            dpvInfo2.targetTV = null;
        }
    }

    public dpvInfo getDPVInfoFor(DesignPartView designPartView) {
        dpvInfo dpvInfo22;
        for (dpvInfo dpvInfo22 : this.dpvCol) {
            if (dpvInfo22.dpv != designPartView) continue;
            return dpvInfo22;
        }
        dpvInfo22 = new dpvInfo();
        dpvInfo22.dpv = designPartView;
        this.dpvCol.add(dpvInfo22);
        return dpvInfo22;
    }

    @Override
    public TopView getViewFor(DesignPartView designPartView) {
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        return dpvInfo2.tv;
    }

    public AbstractMDTV getSourceTV(DesignPartView designPartView) {
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.sourceTV == null && this.getSourceMDObject() != null) {
            dpvInfo2.sourceTV = (AbstractMDTV)this.getSourceMDObject().getFirstViewForDPV(designPartView);
            if (dpvInfo2.sourceTV != null) {
                dpvInfo2.sourceTV.addTopViewListener(this);
                this.addTVRaggedHLink(dpvInfo2);
            }
        }
        return dpvInfo2.sourceTV;
    }

    public AbstractMDTV getTargetTV(DesignPartView designPartView) {
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.targetTV == null && this.getTargetMDObject() != null) {
            dpvInfo2.targetTV = (AbstractMDTV)this.getTargetMDObject().getFirstViewForDPV(designPartView);
            if (dpvInfo2.targetTV != null) {
                dpvInfo2.targetTV.addTopViewListener(this);
                this.addTVRaggedHLink(dpvInfo2);
            }
        }
        return dpvInfo2.targetTV;
    }

    public void addTVRaggedHLink(dpvInfo dpvInfo2) {
        if (dpvInfo2.tv == null && dpvInfo2.sourceTV != null && dpvInfo2.targetTV != null && dpvInfo2.dpv != null) {
            TVRaggedHLink tVRaggedHLink = new TVRaggedHLink(this.getDesign().getAppView(), dpvInfo2.dpv);
            tVRaggedHLink.setModel(this);
            tVRaggedHLink.setSize(new Dimension(100, 100));
            this.addObjectListener(tVRaggedHLink);
            dpvInfo2.dpv.registerForTreemodel(tVRaggedHLink);
            if (!ApplicationView.loading) {
                tVRaggedHLink.addConnection();
            }
        } else if (dpvInfo2.tv != null && dpvInfo2.sourceTV != null && dpvInfo2.targetTV != null && dpvInfo2.dpv != null && ((TVRaggedHLink)dpvInfo2.tv).getEdge() == null && !ApplicationView.loading) {
            ((TVRaggedHLink)dpvInfo2.tv).addConnection();
        }
    }

    public void setSourceTV(AbstractMDTV abstractMDTV) {
        if (abstractMDTV != null) {
            if (this.getSourceMDObject() == null) {
                this.setSourceMDObject((AbstractMDObject)abstractMDTV.getModel());
                ((Level)abstractMDTV.getModel()).getRaggedHLinks().add(this);
            }
            DesignPartView designPartView = abstractMDTV.getDesignPartView();
            dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            if (dpvInfo2.sourceTV != null) {
                if (dpvInfo2.tv != null) {
                    ((TVRaggedHLink)dpvInfo2.tv).removeConnection();
                }
                dpvInfo2.sourceTV.removeTopViewListener(this);
            }
            dpvInfo2.sourceTV = abstractMDTV;
            dpvInfo2.sourceTV.addTopViewListener(this);
            this.addTVRaggedHLink(dpvInfo2);
        }
    }

    public void setTargetTV(AbstractMDTV abstractMDTV) {
        if (abstractMDTV != null) {
            if (this.getTargetMDObject() == null) {
                this.setTargetMDObject((AbstractMDObject)abstractMDTV.getModel());
                ((Level)abstractMDTV.getModel()).getInputRaggedHLinks().add(this);
            }
            DesignPartView designPartView = abstractMDTV.getDesignPartView();
            dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            if (dpvInfo2.targetTV != null) {
                if (dpvInfo2.tv != null) {
                    ((TVRaggedHLink)dpvInfo2.tv).removeConnection();
                }
                dpvInfo2.targetTV.removeTopViewListener(this);
            }
            dpvInfo2.targetTV = abstractMDTV;
            dpvInfo2.targetTV.addTopViewListener(this);
            this.addTVRaggedHLink(dpvInfo2);
        }
    }

    public boolean isValid() {
        return this.getMDObject(0) != null && this.getMDObject(1) != null;
    }

    public Connection getConnection(int n) {
        return this.CONNECTIONS[n];
    }

    public Connection getSourceConnection() {
        return this.getConnection(0);
    }

    public Connection getTargetConnection() {
        return this.getConnection(1);
    }

    @Override
    public void setTopView(TopView topView) {
        this.addTopView(topView);
    }

    @Override
    public TopView getTopView() {
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.tv == null) continue;
            return dpvInfo2.tv;
        }
        return null;
    }

    @Override
    public void addTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.tv != null) {
            throw new RuntimeException(Messages.getString("RaggedHLink.AssociationAlreadyExists"));
        }
        dpvInfo2.tv = topView;
    }

    @Override
    public void removeTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.tv == null) {
            return;
        }
        this.dpvCol.remove(dpvInfo2);
        this.removeObjectListener(topView);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RaggedHLinkPropertiesDialogEx raggedHLinkPropertiesDialogEx = new RaggedHLinkPropertiesDialogEx(this.getDesign().getAppView(), this);
            raggedHLinkPropertiesDialogEx.initProperties(this);
            raggedHLinkPropertiesDialogEx.show();
        }
    }

    public Level getChildLevel() {
        return (Level)this.source;
    }

    public Level getParentLevel() {
        return (Level)this.destination;
    }

    public AbstractMDObject getSource() {
        return this.source;
    }

    public void setSource(AbstractMDObject abstractMDObject) {
        this.source = abstractMDObject;
    }

    public AbstractMDObject getDestination() {
        return this.destination;
    }

    public void setDestination(AbstractMDObject abstractMDObject) {
        this.destination = abstractMDObject;
    }

    public List getChildToParentAttributes() {
        return this.childToParentAttributes;
    }

    public void addChildToParentAttribute(Attribute attribute) {
        if (!this.childToParentAttributes.contains(attribute)) {
            this.childToParentAttributes.add(attribute);
        }
    }

    public void removeChildToParentAttribute(Attribute attribute) {
        this.childToParentAttributes.remove(attribute);
    }

    public Entity getFactEntity() {
        if (this.source == null) {
            return null;
        }
        if (this.factEntity != null) {
            return this.factEntity;
        }
        if (this.childToParentAttributes.size() > 0) {
            Attribute attribute = (Attribute)this.childToParentAttributes.get(0);
            this.factEntity = (Entity)attribute.getContainerWithKeyObject();
            return this.factEntity;
        }
        return null;
    }

    public void setFactEntity(Entity entity) {
        this.factEntity = entity;
    }

    public TopView getSourceTV() {
        if (this.source != null) {
            return this.source.getTopView();
        }
        return null;
    }

    public TopView getTargetTV() {
        if (this.destination != null) {
            return this.destination.getTopView();
        }
        return null;
    }

    public void setChildLevel(Level level) {
        if (level != null) {
            level.getRaggedHLinks().remove(this);
        }
        this.source = level;
        if (level != null) {
            level.getRaggedHLinks().add(this);
        }
    }

    public void setParentLevel(Level level) {
        if (level != null) {
            level.getInputRaggedHLinks().remove(this);
        }
        this.destination = level;
        if (level != null) {
            level.getInputRaggedHLinks().add(this);
        }
    }

    @Override
    public void remove() {
        if (this.source != null) {
            ((Level)this.source).getRaggedHLinks().remove(this);
        }
        if (this.destination != null) {
            ((Level)this.destination).getInputRaggedHLinks().add(this);
        }
        super.remove();
        this.setMDObject(1, null);
        this.setMDObject(0, null);
    }

    @Override
    public void changed(TopView topView, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView designPartView = topView.getDesignPartView();
            designPartView.removeViewFor(this);
            dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            dpvInfo2.tv = null;
            if (dpvInfo2.sourceTV == topView) {
                dpvInfo2.sourceTV = null;
            }
            if (dpvInfo2.targetTV == topView) {
                dpvInfo2.targetTV = null;
            }
            if (this.getDesignPart() == designPartView.getDesignPart()) {
                this.remove();
            }
        }
    }

    public void attributeIsDeleted(Attribute attribute) {
        this.getChildToParentAttributes().remove(attribute);
    }

    @Override
    public void setSourceTopView(TopView topView) {
        this.setSourceTV((AbstractMDTV)topView);
    }

    @Override
    public void setTargetTopView(TopView topView) {
        this.setTargetTV((AbstractMDTV)topView);
    }

    @Override
    public TopView getSourceTopView(DesignPartView designPartView) {
        return this.getSourceTV(designPartView);
    }

    @Override
    public TopView getTargetTopView(DesignPartView designPartView) {
        return this.getTargetTV(designPartView);
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView designPartView) {
        return this.getViewFor(designPartView);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getSourceMDObject();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getTargetMDObject();
    }

    @Override
    public List getAllViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.tv == null) continue;
            arrayList.add(dpvInfo2.tv);
        }
        return arrayList;
    }

    @Override
    public void restoreTopView(TopView topView, TopView topView2, TopView topView3) {
        topView.getDesignPartView().restoreTopview(topView, this);
        dpvInfo dpvInfo2 = this.getDPVInfoFor(topView.getDesignPartView());
        if (dpvInfo2.tv == topView) {
            this.addObjectListener(topView);
            dpvInfo2.targetTV = (AbstractMDTV)topView3;
            dpvInfo2.targetTV.addTopViewListener(this);
            dpvInfo2.sourceTV = (AbstractMDTV)topView2;
            dpvInfo2.sourceTV.addTopViewListener(this);
        }
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "rhlink/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public class DestinationConnection
    extends Connection {
        @Override
        public AbstractMDObject getMDObject() {
            return RaggedHLink.this.getMDObject(1);
        }

        @Override
        public String getDescriptor() {
            return "Destination";
        }

        @Override
        public boolean isSource() {
            return false;
        }
    }

    public class SourceConnection
    extends Connection {
        @Override
        public AbstractMDObject getMDObject() {
            return RaggedHLink.this.getMDObject(0);
        }

        @Override
        public String getDescriptor() {
            return "Source";
        }

        @Override
        public boolean isSource() {
            return true;
        }
    }

    public abstract class Connection {
        private Boolean optionality = Boolean.TRUE;
        private String nameOn = null;

        public RaggedHLink getRaggedHLink() {
            return RaggedHLink.this;
        }

        public abstract AbstractMDObject getMDObject();

        public abstract String getDescriptor();

        public abstract boolean isSource();

        public String toString() {
            return RaggedHLink.this.getName() + this.getDescriptor();
        }

        public boolean isOptional() {
            return this.optionality;
        }

        public void setOptional(boolean bl) {
            this.optionality = bl ? Boolean.TRUE : Boolean.FALSE;
        }

        public Boolean getOptionality() {
            return this.optionality;
        }

        public void setOptionality(Boolean bl) {
            this.optionality = bl == null ? Boolean.FALSE : bl;
        }

        public void setNameOn(String string) {
            this.nameOn = string;
        }

        public TopView getTopView() {
            return RaggedHLink.this.getTopView();
        }

        public String getNameOn() {
            return this.nameOn;
        }
    }

    public class dpvInfo {
        public AbstractMDTV sourceTV;
        public AbstractMDTV targetTV;
        public TopView tv;
        public DesignPartView dpv;

        dpvInfo() {
        }
    }
}

