/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolderSet;
import oracle.dbtools.crest.model.design.multidimensional.MeasureSet;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SliceSet;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.placeholder.MeasurePlaceHolder;
import oracle.dbtools.crest.swingui.editor.multidimensional.MeasureFolderPropertiesDialogEx;

public class MeasureFolder
extends AbstractMDObject
implements SetListener {
    public static final String MEASURE_ID = "measure_id";
    private static String OWNER_ID = "owner_id";
    private static String IS_MEASURE_WRAPPER = "isMW";
    public static final String AGGR_FUNCTION_ID = "aggrFunctionID";
    private static String TRUE = "true";
    private MeasureFolder parentFolder = null;
    private List measures = new ArrayList();
    private List availableMeasures = new ArrayList();
    private List subfolders = new ArrayList();
    private DesignObjectCollection folders = new DesignObjectCollection();
    private DesignObjectCollection usedMeasures;
    private String parentFolderID;
    public static final String TYPE_NAME = "MeasureFolder";

    public MeasureFolder(DesignPart designPart) {
        super(designPart);
        this.folders.setName(Messages.getString("MeasureFolder.Subfolders"));
        this.folders.setParent(this);
        this.folders.setDesign(designPart.getDesign());
        this.usedMeasures = new DesignObjectCollection();
        this.usedMeasures.setName(Messages.getString("MeasureFolder.Measures"));
        this.usedMeasures.setParent(this);
        this.usedMeasures.setDesign(designPart.getDesign());
        this.usedMeasures.setElementDescriptor(Measure.class);
        ((MultidimensionalDesign)designPart).getMeasureFolderSet().addSetListener(this);
        ((MultidimensionalDesign)designPart).getMeasureSet().addSetListener(this);
        ((MultidimensionalDesign)designPart).getSliceSet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public List getMeasures() {
        return this.measures;
    }

    public void setMeasures(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addMeasure((MFElement)iterator.next());
        }
    }

    public MeasureFolder getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(MeasureFolder measureFolder) {
        if (this.parentFolder != measureFolder) {
            this.parentFolder = measureFolder;
            this.fireChange(ObjectChangeEvent.PARENTFOLDER_CHANGED);
        }
    }

    public List getSubfolders() {
        return this.subfolders;
    }

    public void setSubfolders(List list) {
        this.subfolders = list;
    }

    public void addSubfolders(MeasureFolder measureFolder) {
        if (!this.folders.contains(measureFolder)) {
            measureFolder.setParentFolder(this);
            measureFolder.setParent(this.folders);
            this.folders.add(measureFolder);
        }
    }

    public void addMeasure(MFElement mFElement) {
        if (!this.measures.contains(mFElement)) {
            this.measures.add(mFElement);
            MeasurePlaceHolder measurePlaceHolder = new MeasurePlaceHolder(this.getDesignPart());
            measurePlaceHolder.setObject(mFElement);
            measurePlaceHolder.setParent(this.usedMeasures);
            this.usedMeasures.add(measurePlaceHolder);
        }
    }

    public void removeFromMeasures(MFElement mFElement) {
        int n = this.measures.indexOf(mFElement);
        if (n > -1) {
            this.usedMeasures.remove(this.usedMeasures.getElement(n));
            this.measures.remove(mFElement);
        }
    }

    public void removeMeasures() {
        this.measures.clear();
        this.usedMeasures.removeAll();
    }

    public List getOnlyMeasures() {
        if (this.measures.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<MFElement> arrayList = new ArrayList<MFElement>();
        for (MFElement mFElement : this.measures) {
            if (mFElement.isMeasureWrapper) continue;
            arrayList.add(mFElement);
        }
        return arrayList;
    }

    public List getOnlyMeasureWrapper() {
        if (this.measures.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MFElement> arrayList = new ArrayList<MFElement>();
        for (MFElement mFElement : this.measures) {
            if (!mFElement.isMeasureWrapper) continue;
            arrayList.add(mFElement);
        }
        return arrayList;
    }

    public List getMeasureWrapperMaps() {
        if (this.measures.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        for (MFElement mFElement : this.measures) {
            if (mFElement.parent == null) continue;
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put(OWNER_ID, mFElement.parent.getObjectID());
            if (mFElement.isMeasureWrapper) {
                treeMap.put(IS_MEASURE_WRAPPER, TRUE);
                Slice.MeasureWrapper measureWrapper = (Slice.MeasureWrapper)mFElement.measure;
                treeMap.put(MEASURE_ID, measureWrapper.getMeasure().getObjectID());
                treeMap.put(AGGR_FUNCTION_ID, measureWrapper.getAggrFuncId());
            } else {
                treeMap.put(MEASURE_ID, ((DesignObject)mFElement.measure).getObjectID());
            }
            arrayList.add(treeMap);
        }
        return arrayList;
    }

    public void applyMeasureWrapperMaps(List list) {
        this.measures.clear();
        this.usedMeasures.removeAll();
        for (Object e : list) {
            Object object;
            String string;
            if (!(e instanceof Map)) continue;
            Map map = (Map)e;
            String string2 = (String)map.get(OWNER_ID);
            DesignObject designObject = null;
            if (string2 != null) {
                designObject = this.getDesign().getDesignObject(string2);
            }
            if (designObject == null) continue;
            String string3 = (String)map.get(IS_MEASURE_WRAPPER);
            boolean bl = false;
            if (string3 != null && TRUE.equals(string3)) {
                bl = true;
            }
            if ((string = (String)map.get(MEASURE_ID)) == null) continue;
            ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator = null;
            if (bl) {
                object = (String)map.get(AGGR_FUNCTION_ID);
                if (designObject instanceof Slice) {
                    iD_ObjectPropertyTranslator = ((Slice)designObject).getMeasureWrapper(string, (String)object);
                }
            } else {
                iD_ObjectPropertyTranslator = this.getDesign().getMultidimensionalDesign().getMeasureSet().getObjectByID(string);
            }
            if (iD_ObjectPropertyTranslator == null) continue;
            object = new MFElement(designObject, iD_ObjectPropertyTranslator);
            this.addMeasure((MFElement)object);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            MeasureFolderPropertiesDialogEx measureFolderPropertiesDialogEx = new MeasureFolderPropertiesDialogEx(this.getDesign().getAppView(), this);
            measureFolderPropertiesDialogEx.initProperties(this);
            measureFolderPropertiesDialogEx.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.usedMeasures;
            }
            case 1: {
                return this.folders;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.usedMeasures) {
            return 0;
        }
        if (modelObject == this.folders) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.usedMeasures) {
            return 0;
        }
        if (object == this.folders) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (designObjectSet instanceof MeasureFolderSet && setEvent.isAdded()) {
            MeasureFolder measureFolder = (MeasureFolder)setEvent.getAffected();
            if (measureFolder.parentFolder == this) {
                measureFolder.setParent(this.folders);
                this.folders.add(measureFolder);
            }
        } else if (setEvent == SetEvent.OBJECT_REMOVED) {
            AbstractMDObject abstractMDObject;
            if (designObjectSet instanceof MeasureFolderSet) {
                abstractMDObject = (MeasureFolder)setEvent.getAffected();
                this.folders.remove(abstractMDObject);
            }
            if (designObjectSet instanceof MeasureSet) {
                abstractMDObject = (Measure)setEvent.getAffected();
                this.removeMeasureFromMeasureFolder((Measure)abstractMDObject);
            }
            if (designObjectSet instanceof SliceSet) {
                abstractMDObject = (Slice)setEvent.getAffected();
                this.removeMFEParentFromMeasureFolder(abstractMDObject);
            }
        }
    }

    private void removeMeasureFromMeasureFolder(Measure measure) {
        List list = this.getMFElementByMeasure(measure);
        this.removeFromMeasures(list);
    }

    private void removeMFEParentFromMeasureFolder(Object object) {
        List list = this.getMFElementByParent(object);
        this.removeFromMeasures(list);
    }

    private void removeFromMeasures(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.removeFromMeasures((MFElement)iterator.next());
        }
    }

    private List getMFElementByParent(Object object) {
        ArrayList<MFElement> arrayList = new ArrayList<MFElement>();
        for (MFElement mFElement : this.measures) {
            if (mFElement.getParent() != object) continue;
            arrayList.add(mFElement);
        }
        return arrayList;
    }

    private List getMFElementByMeasure(Measure measure) {
        ArrayList<MFElement> arrayList = new ArrayList<MFElement>();
        for (MFElement mFElement : this.measures) {
            if (mFElement.getMeasureObject() != measure) continue;
            arrayList.add(mFElement);
        }
        return arrayList;
    }

    public List getAvailableMeasures() {
        return this.availableMeasures;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "measurefolder/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getParentFolderID() {
        if (this.parentFolder != null) {
            return this.parentFolder.getObjectID();
        }
        return this.parentFolderID;
    }

    public void setParentFolderID(String string) {
        this.parentFolderID = string;
        if (string != null && this.parentFolder == null) {
            MeasureFolder measureFolder = (MeasureFolder)this.getMultidimensionalDesign().getMeasureFolderSet().getObjectByID(string);
            if (measureFolder == null) {
                this.getMultidimensionalDesign().addTask(new AddParentFolderTask(this));
            } else {
                measureFolder.addSubfolders(this);
            }
        }
    }

    public class AddParentFolderTask
    implements Task {
        private static final String TASK_NAME = "add parent folder task";
        MeasureFolder mf;

        AddParentFolderTask(MeasureFolder measureFolder2) {
            this.mf = measureFolder2;
        }

        @Override
        public boolean execute() {
            MeasureFolder measureFolder = (MeasureFolder)MeasureFolder.this.getMultidimensionalDesign().getMeasureFolderSet().getObjectByID(this.mf.parentFolderID);
            if (measureFolder != null) {
                measureFolder.addSubfolders(this.mf);
            }
            return measureFolder != null;
        }

        public String toString() {
            return TASK_NAME;
        }
    }

    public class MFElement {
        private DesignObject parent = null;
        private Object measure = null;
        private boolean isMeasureWrapper;

        public MFElement(DesignObject designObject, Object object) {
            this.measure = object;
            this.parent = designObject;
            this.isMeasureWrapper = object instanceof Slice.MeasureWrapper;
        }

        public String toString() {
            if (this.measure instanceof Measure) {
                return this.parent.getName() + "." + ((Measure)this.measure).getName();
            }
            if (this.measure instanceof Slice.MeasureWrapper) {
                return this.parent.getName() + "." + ((Slice.MeasureWrapper)this.measure).getMeasureAlias();
            }
            return super.toString();
        }

        public String getAgregateFunctionName() {
            if (this.measure instanceof Measure) {
                return ((Measure)this.measure).getDefaultAggregationFunction().toString();
            }
            if (this.measure instanceof Slice.MeasureWrapper) {
                return ((Slice.MeasureWrapper)this.measure).getAggrFunction().toString();
            }
            return super.toString();
        }

        public Object getMeasure() {
            return this.measure;
        }

        public void setMeasure(Object object) {
            this.measure = object;
        }

        public DesignObject getParent() {
            return this.parent;
        }

        public void setParent(DesignObject designObject) {
            this.parent = designObject;
        }

        public boolean isMeasureWrapper() {
            return this.isMeasureWrapper;
        }

        public String getMeasureObjectID() {
            if (this.measure instanceof Measure) {
                return ((Measure)this.measure).getObjectID();
            }
            return ((Slice.MeasureWrapper)this.measure).getMeasure().getObjectID();
        }

        public Measure getMeasureObject() {
            if (this.isMeasureWrapper()) {
                return ((Slice.MeasureWrapper)this.measure).getMeasure();
            }
            return (Measure)this.measure;
        }
    }
}

