/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.EngineerFromOracle;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.MessageDialogs;

public class FromOracleModelSelector {
    private File logicalFile = null;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private static final int FIELD_WIDTH = 220;
    private static final int FIELD_HEIGHT = 20;
    private Dimension prefDimension = new Dimension(220, 20);
    private JComboBox cbRelDes;
    private JComboBox cbStorage;
    private Design design;
    private RelationalDesign physicalDesign;
    private StorageDesign storageDesign;
    private MultidimensionalDesign multidimensionalDesign;
    private String schema = "";
    private JButton okButton;
    private JSpinner jspinner;
    private boolean useFactTables;
    private JCheckBox chbFactTablesOnly;
    private JComboBox cbSearch;
    private Object[] searchList = new Object[]{EngineerFromOracle.USE_FK, EngineerFromOracle.USE_COLUMN_NAMES};

    public boolean showDialog(ApplicationView applicationView) {
        this.result = false;
        this.design = applicationView.getCurrentDesign();
        this.dialog = new JDialog((Frame)applicationView.getFrame(), Messages.getString("FromOracleModelSelector.SelectOracleModel"));
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setModal(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("FromOracleModelSelector.OracleModel")));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("FromOracleModelSelector.CubeDiscoveryOptions")));
        JPanel jPanel4 = new JPanel(new GridLayout(0, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder(""));
        this.okButton = new JButton(Messages.getString("FromOracleModelSelector.OK"));
        this.okButton.setEnabled(false);
        JLabel jLabel = new JLabel(Messages.getString("FromOracleModelSelector.RelationalModel"));
        ArrayList arrayList = new ArrayList();
        this.design.getRelationalDesigns().addAllElementsTo(arrayList);
        jLabel.setPreferredSize(this.prefDimension);
        this.cbRelDes = new JComboBox<Object>(arrayList.toArray());
        this.cbRelDes.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbRelDes.setPreferredSize(this.prefDimension);
        this.cbStorage = new JComboBox();
        this.cbStorage.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbStorage.setPreferredSize(this.prefDimension);
        this.cbRelDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = FromOracleModelSelector.this.cbRelDes.getSelectedItem();
                if (object != null && object instanceof RelationalDesign) {
                    RelationalDesign relationalDesign = (RelationalDesign)object;
                    ArrayList<StorageDesign> arrayList = new ArrayList<StorageDesign>();
                    StorageDesign[] storageDesignArray = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
                    for (int i = 0; i < storageDesignArray.length; ++i) {
                        StorageDesign storageDesign = storageDesignArray[i];
                        if (!(storageDesign instanceof StorageDesignOracle)) continue;
                        arrayList.add(storageDesign);
                    }
                    FromOracleModelSelector.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                    if (arrayList.size() > 0) {
                        FromOracleModelSelector.this.okButton.setEnabled(true);
                    } else {
                        FromOracleModelSelector.this.okButton.setEnabled(false);
                    }
                } else if (object == null) {
                    FromOracleModelSelector.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                }
            }
        });
        if (arrayList.size() > 0) {
            this.cbRelDes.setSelectedItem(arrayList.get(0));
        }
        JPanel jPanel5 = this.newRow(jLabel, this.cbRelDes);
        jPanel2.add(jPanel5);
        JLabel jLabel2 = new JLabel(Messages.getString("FromOracleModelSelector.PhysicalOracleModel"));
        jLabel2.setPreferredSize(this.prefDimension);
        jPanel5 = this.newRow(jLabel2, this.cbStorage);
        jPanel2.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setPreferredSize(this.prefDimension);
        jPanel2.add(jPanel6);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(3, 3, 100, 1);
        this.jspinner = new JSpinner(spinnerNumberModel);
        JLabel jLabel3 = new JLabel(Messages.getString("FromOracleModelSelector.MinimumDimensions"));
        jLabel3.setPreferredSize(this.prefDimension);
        this.jspinner.setPreferredSize(this.prefDimension);
        jPanel5 = this.newRow(jLabel3, this.jspinner);
        jPanel3.add(jPanel5);
        JLabel jLabel4 = new JLabel(Messages.getString("FromOracleModelSelector.MatchMethod"));
        jLabel4.setPreferredSize(this.prefDimension);
        this.cbSearch = new JComboBox<Object>(this.searchList);
        this.cbSearch.setPreferredSize(this.prefDimension);
        jPanel5 = this.newRow(jLabel4, this.cbSearch);
        jPanel3.add(jPanel5);
        JLabel jLabel5 = new JLabel(Messages.getString("FromOracleModelSelector.UseFactEntitiesOnly"));
        jLabel5.setPreferredSize(this.prefDimension);
        this.chbFactTablesOnly = new JCheckBox();
        this.chbFactTablesOnly.setPreferredSize(this.prefDimension);
        jPanel5 = this.newRow(jLabel5, this.chbFactTablesOnly);
        jPanel3.add(jPanel5);
        JPanel jPanel7 = new JPanel();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FromOracleModelSelector.this.result = true;
                FromOracleModelSelector.this.physicalDesign = (RelationalDesign)FromOracleModelSelector.this.cbRelDes.getSelectedItem();
                FromOracleModelSelector.this.storageDesign = (StorageDesign)FromOracleModelSelector.this.cbStorage.getSelectedItem();
                if (FromOracleModelSelector.this.result) {
                    FromOracleModelSelector.this.dialog.dispose();
                }
            }
        });
        jPanel7.add(this.okButton);
        JButton jButton = new JButton(Messages.getString("FromOracleModelSelector.Cancel"));
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FromOracleModelSelector.this.result = false;
                FromOracleModelSelector.this.dialog.dispose();
            }
        });
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        jPanel7.add(jButton);
        this.okButton.setPreferredSize(jButton.getPreferredSize());
        jPanel.add((Component)jPanel4, "Center");
        jPanel.add((Component)jPanel7, "South");
        this.dialog.getContentPane().add(jPanel);
        this.dialog.pack();
        this.centerOnScreen(this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setVisible(true);
        return this.result;
    }

    private void centerOnScreen(JDialog jDialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jDialog.getSize();
        Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        jDialog.setLocation(point);
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    private JPanel newRow(JLabel jLabel, Component component) {
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(component);
        return jPanel;
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public String getSchema() {
        return this.schema;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.multidimensionalDesign;
    }

    public int getMinDimensions() {
        Object object = this.jspinner.getValue();
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 3;
    }

    public boolean isUseFactTablesOnly() {
        return this.useFactTables;
    }

    public String getSearchMethod() {
        return (String)this.cbSearch.getSelectedItem();
    }
}

