/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;

public class FactEntitiesJoin
extends DesignObject {
    private Entity leftEntity;
    private Entity rightEntity;
    private Relation usedRelation;
    private MultidimensionalDesign multidimensionalDesign;
    private Cube cube;
    public static String CARD_ONE_TO_ONE = "1:1";
    public static String CARD_ONE_TO_MANY = "1:*";
    public static String CARD_MANY_TO_ONE = "*:1";
    public static String CARD_MANY_TO_MANY = "*:*";
    public static String[] POSSIBLE_CARDINALITY = new String[]{CARD_ONE_TO_ONE, CARD_ONE_TO_MANY, CARD_MANY_TO_ONE};
    private String cardinality = CARD_ONE_TO_ONE;
    private Entity dominantEntity;
    private List leftAttributes = new ArrayList();
    private List rightAttributes = new ArrayList();
    public static final String TYPE_NAME = "FactEntitiesJoin";

    public FactEntitiesJoin(DesignPart designPart) {
        super(designPart);
        this.multidimensionalDesign = (MultidimensionalDesign)designPart;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "FEJoin";
    }

    public Entity getLeftEntity() {
        return this.leftEntity;
    }

    public void setLeftEntity(Entity entity) {
        this.leftEntity = entity;
    }

    public Entity getRightEntity() {
        return this.rightEntity;
    }

    public void setRightEntity(Entity entity) {
        this.rightEntity = entity;
    }

    public Relation getUsedRelation() {
        return this.usedRelation;
    }

    public void setUsedRelation(Relation relation) {
        this.usedRelation = relation;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.multidimensionalDesign;
    }

    public Cube getCube() {
        return this.cube;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
    }

    public String getCardinality() {
        if (this.usedRelation != null && this.getLeftEntity() != null && this.getRightEntity() != null) {
            return FactEntitiesJoin.getCardinalityOf(this.getUsedRelation(), this.getLeftEntity(), this.getRightEntity());
        }
        return this.cardinality;
    }

    public void setCardinality(String string) {
        this.cardinality = string;
    }

    public static String getCardinalityOf(Relation relation, Entity entity, Entity entity2) {
        int n = relation.getEndPointFor(entity);
        int n2 = relation.getEndPointFor(entity2);
        String string = relation.getCardinality(n).toString() + ":" + relation.getCardinality(n2).toString();
        return string;
    }

    public Entity getDominantEntity() {
        return this.dominantEntity;
    }

    public void setDominantEntity(Entity entity) {
        this.dominantEntity = entity;
    }

    public List getLeftAttributes() {
        return this.leftAttributes;
    }

    public List getRightAttributes() {
        return this.rightAttributes;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "fejoins/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

