/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.text.MessageFormat;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;

public class EngineerToOracle {
    private MultidimensionalDesign mdmDesign;
    private RelationalDesign phDes;
    private StorageDesignOracle sdOracle;
    private boolean valid = true;
    private StringBuffer validationSB;

    public EngineerToOracle(MultidimensionalDesign multidimensionalDesign, RelationalDesign relationalDesign, StorageDesignOracle storageDesignOracle) {
        this.mdmDesign = multidimensionalDesign;
        this.phDes = relationalDesign;
        this.sdOracle = storageDesignOracle;
    }

    public void engineer() {
        this.validationSB = new StringBuffer(Messages.getString("EngineerToOracle.ErrorsDuringValidationPhase"));
        this.validate();
        if (this.valid) {
            Iterator iterator = this.mdmDesign.getDimensionSet().iterator();
            while (iterator.hasNext()) {
                Dimension dimension = (Dimension)iterator.next();
                this.processDimension(dimension);
            }
            ApplicationView.log(MessageFormat.format(Messages.getString("EngineerToOracle.EngineerToOracleModel"), this.phDes.getName()));
        } else {
            LogReport logReport = new LogReport(this.mdmDesign.getAppView());
            logReport.setName(Messages.getString("EngineerToOracle.ValidationLog"));
            logReport.setLog(this.validationSB.toString());
            logReport.showDialog(new java.awt.Dimension(750, 550));
        }
    }

    private void validate() {
        Iterator iterator = this.mdmDesign.getLevelSet().iterator();
        while (iterator.hasNext()) {
            Level level = (Level)iterator.next();
            this.validateLevel(level);
        }
    }

    private void processDimension(Dimension dimension) {
        DimensionOracle dimensionOracle = (DimensionOracle)this.sdOracle.getDimensionSet().getObjectGeneratedBy(dimension);
        if (dimensionOracle == null) {
            dimensionOracle = (DimensionOracle)this.sdOracle.getDimensionSet().getObjectByID(dimension.getGeneratorID());
        }
        if (dimensionOracle == null) {
            dimensionOracle = this.sdOracle.getDimensionSet().createDimension();
        } else {
            this.clearDimension(dimensionOracle);
        }
        dimensionOracle.setName(dimension.getName());
        dimensionOracle.setGeneratorID(dimension.getObjectID());
        Iterator iterator = dimension.getHierarchies().iterator();
        while (iterator.hasNext()) {
            Hierarchy hierarchy = (Hierarchy)iterator.next();
            HierarchyOracle hierarchyOracle = this.createHierarchy(dimensionOracle, this.sdOracle);
            hierarchyOracle.setName(hierarchy.getName());
            this.processHierarchy(hierarchyOracle, hierarchy, dimensionOracle);
        }
    }

    private void clearDimension(DimensionOracle dimensionOracle) {
        Object[] objectArray = dimensionOracle.getAttributeSet();
        for (int i = 0; i < objectArray.length - 1; ++i) {
            ((StorageObject)objectArray[i]).remove();
        }
        dimensionOracle.clearChildren();
    }

    private void processHierarchy(HierarchyOracle hierarchyOracle, Hierarchy hierarchy, DimensionOracle dimensionOracle) {
        for (Level level : hierarchy.getLevels()) {
            LevelOracle levelOracle = this.findOrCreateLevel(level, dimensionOracle, this.sdOracle);
            levelOracle.setName(level.getName());
            hierarchyOracle.setLevels(levelOracle.getObjectID());
            this.processLevel(level, levelOracle);
        }
        this.processJoins(hierarchyOracle, hierarchy);
    }

    private void processLevel(Level level, LevelOracle levelOracle) {
        ColumnProxy columnProxy;
        DimensionAttributeOracle dimensionAttributeOracle = this.findOrCreateAttribute(levelOracle, this.sdOracle);
        ContainerObject containerObject = level.getLevelEntity();
        Entity entity = null;
        if (containerObject != null && containerObject instanceof Entity) {
            entity = (Entity)containerObject;
        }
        TableProxy tableProxy = null;
        for (Attribute attribute : level.getLevelKey()) {
            columnProxy = this.getColumnProxy(attribute);
            if (columnProxy == null) continue;
            levelOracle.setColumns(columnProxy.getObjectID());
            if (tableProxy != null) continue;
            tableProxy = columnProxy.getTableProxyR();
        }
        for (Attribute attribute : level.getDescriptiveAttributes()) {
            columnProxy = this.getColumnProxy(attribute);
            if (columnProxy == null) continue;
            dimensionAttributeOracle.setColumns(columnProxy.getObjectID());
            if (tableProxy != null) continue;
            tableProxy = columnProxy.getTableProxyR();
        }
        if (tableProxy == null && entity != null) {
            tableProxy = this.getTableProxy(entity);
        }
        if (tableProxy != null) {
            levelOracle.setLevelTable(tableProxy);
        }
    }

    private DimensionAttributeOracle findOrCreateAttribute(LevelOracle levelOracle, StorageDesignOracle storageDesignOracle) {
        DimensionAttributeOracle dimensionAttributeOracle;
        Iterator iterator = storageDesignOracle.getDimensionAttributeSet().iterator();
        while (iterator.hasNext()) {
            dimensionAttributeOracle = (DimensionAttributeOracle)iterator.next();
            if (dimensionAttributeOracle.getLevel() != levelOracle) continue;
            return dimensionAttributeOracle;
        }
        dimensionAttributeOracle = storageDesignOracle.getDimensionAttributeSet().createDimensionAttribute();
        dimensionAttributeOracle.setLevel(levelOracle);
        dimensionAttributeOracle.setName(levelOracle.getName());
        return dimensionAttributeOracle;
    }

    private void validateLevel(Level level) {
        ColumnProxy columnProxy;
        Iterator iterator;
        ContainerObject containerObject = level.getLevelEntity();
        Entity entity = null;
        if (containerObject != null && containerObject instanceof Entity) {
            entity = (Entity)containerObject;
        }
        if (entity != null && (iterator = this.getTableProxy(entity)) == null) {
            this.valid = false;
            this.validationSB.append(MessageFormat.format(Messages.getString("EngineerToOracle.NoCorrespondingTableForEntity"), entity.getName()));
        }
        for (Attribute attribute : level.getLevelKey()) {
            columnProxy = this.getColumnProxy(attribute);
            if (columnProxy != null) continue;
            this.valid = false;
            this.validationSB.append(MessageFormat.format(Messages.getString("EngineerToOracle.NoCorrespondingColumnForAttribute"), attribute.getLongName()));
        }
        for (Attribute attribute : level.getDescriptiveAttributes()) {
            columnProxy = this.getColumnProxy(attribute);
            if (columnProxy != null) continue;
            this.valid = false;
            this.validationSB.append(MessageFormat.format(Messages.getString("EngineerToOracle.NoCorrespondingColumnForAttribute"), attribute.getLongName()));
        }
        int n = level.getOutgoingLinks().size();
        for (int i = 0; i < n; ++i) {
            Link link = (Link)level.getOutgoingLinks().get(i);
            RollupLink rollupLink = link.getRollupLink();
            if (rollupLink == null) continue;
            for (Attribute attribute : rollupLink.getChildToParentAttributes()) {
                ColumnProxy columnProxy2 = this.getColumnProxy(attribute);
                if (columnProxy2 != null) continue;
                this.valid = false;
                this.validationSB.append(MessageFormat.format(Messages.getString("EngineerToOracle.NoCorrespondingColumnForAttribute"), attribute.getLongName()));
            }
        }
    }

    private void processJoins(HierarchyOracle hierarchyOracle, Hierarchy hierarchy) {
        for (int i = 0; i < hierarchy.getLevels().size() - 1; ++i) {
            Object object;
            RollupLink rollupLink;
            Level level;
            Level level2 = (Level)hierarchy.getLevels().get(i);
            Link link = level2.getFirstLinkToTarget(level = (Level)hierarchy.getLevels().get(i + 1));
            if (link == null || level2.getLevelEntity() == null || level.getLevelEntity() == null || (rollupLink = link.getRollupLink()).getChildToParentAttributes().size() <= 0 || level2.getLevelEntity() == level.getLevelEntity()) continue;
            StringBuffer stringBuffer = new StringBuffer();
            if (rollupLink.getChildToParentAttributes().size() > 1) {
                stringBuffer.append("JOIN KEY (");
            } else {
                stringBuffer.append("JOIN KEY ");
            }
            Iterator iterator = rollupLink.getChildToParentAttributes().iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                object = (Attribute)iterator.next();
                ColumnProxy columnProxy = this.getColumnProxy((Attribute)object);
                if (columnProxy == null) continue;
                if (!bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(columnProxy.getLongName());
            }
            object = level.getName().indexOf(" ") > 0 ? "\"" + level.getName() + "\"" : level.getName();
            if (rollupLink.getChildToParentAttributes().size() > 1) {
                stringBuffer.append(") REFERENCES ").append((String)object);
            } else {
                stringBuffer.append(" REFERENCES ").append((String)object);
            }
            hierarchyOracle.setJoins(stringBuffer.toString());
        }
    }

    private DimensionAttributeOracle createAttribute(LevelOracle levelOracle, StorageDesignOracle storageDesignOracle) {
        DimensionAttributeOracle dimensionAttributeOracle = storageDesignOracle.getDimensionAttributeSet().createDimensionAttribute();
        dimensionAttributeOracle.setLevel(levelOracle);
        dimensionAttributeOracle.setName(levelOracle.getName());
        return dimensionAttributeOracle;
    }

    private LevelOracle findOrCreateLevel(Level level, DimensionOracle dimensionOracle, StorageDesignOracle storageDesignOracle) {
        LevelOracle levelOracle = dimensionOracle.getLevelByName(level.getName());
        if (levelOracle == null) {
            levelOracle = storageDesignOracle.getLevelSet().createLevel();
            levelOracle.setDimension(dimensionOracle);
        }
        return levelOracle;
    }

    private HierarchyOracle createHierarchy(DimensionOracle dimensionOracle, StorageDesignOracle storageDesignOracle) {
        HierarchyOracle hierarchyOracle = storageDesignOracle.getHierarchySet().createHierarchy();
        hierarchyOracle.setDimension(dimensionOracle);
        return hierarchyOracle;
    }

    private ColumnProxy getColumnProxy(Attribute attribute) {
        Column column = attribute.getEngColumn(this.phDes);
        if (column != null) {
            ColumnProxy columnProxy = (ColumnProxy)this.sdOracle.getColumnProxySet().getProxy(column.getObjectID());
            return columnProxy;
        }
        return null;
    }

    private TableProxy getTableProxy(Entity entity) {
        Table table = entity.getEngTable(this.phDes);
        if (table != null) {
            TableProxy tableProxy = (TableProxy)this.sdOracle.getTableProxySet().getProxy(table.getObjectID());
            return tableProxy;
        }
        return null;
    }
}

