/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;

public class EngineerFromOracle {
    static String REFERENCES = "REFERENCES";
    public static String USE_FK = Messages.getString("EngineerFromOracle.UseFK");
    public static String USE_COLUMN_NAMES = Messages.getString("EngineerFromOracle.UseColumnNames");
    private final MultidimensionalDesign mdmDesign;
    private RelationalDesign phDes;
    private final StorageDesignOracle sdOracle;
    private DimensionAttributeOracle attribute;
    private boolean valid = true;
    private StringBuffer validationSB;
    private int minDimensions;
    private boolean factsOnly = false;
    private boolean matchOnFK = true;

    public EngineerFromOracle(MultidimensionalDesign multidimensionalDesign, RelationalDesign relationalDesign, StorageDesignOracle storageDesignOracle, int n, boolean bl, String string) {
        this.mdmDesign = multidimensionalDesign;
        this.phDes = relationalDesign;
        this.sdOracle = storageDesignOracle;
        this.factsOnly = bl;
        this.matchOnFK = USE_FK.equalsIgnoreCase(string);
        if (n > 2) {
            this.minDimensions = n;
        }
    }

    public void engineer() {
        this.validationSB = new StringBuffer(Messages.getString("EngineerFromOracle.ErrorsDuringValidationPhase"));
        this.validate();
        if (this.valid) {
            Iterator iterator = this.sdOracle.getDimensionSet().iterator();
            while (iterator.hasNext()) {
                DimensionOracle dimensionOracle = (DimensionOracle)iterator.next();
                this.processDimension(dimensionOracle);
            }
            this.makeCubes();
            ApplicationView.log(MessageFormat.format(Messages.getString("EngineerFromOracle.EngineerFromOracleModel"), this.phDes.getName()));
        } else {
            LogReport logReport = new LogReport(this.mdmDesign.getAppView());
            logReport.setName(Messages.getString("EngineerFromOracle.ValidationLog"));
            logReport.setLog(this.validationSB.toString());
            logReport.showDialog(new java.awt.Dimension(750, 550));
        }
    }

    private void processDimension(DimensionOracle dimensionOracle) {
        Object[] objectArray = dimensionOracle.getLevelSet();
        Dimension dimension = null;
        if (dimensionOracle.getGeneratorID() != null) {
            dimension = (Dimension)this.mdmDesign.getDimensionSet().getObjectByID(dimensionOracle.getGeneratorID());
        }
        if (dimension == null) {
            dimension = (Dimension)this.mdmDesign.getDimensionSet().getObjectGeneratedBy(dimensionOracle.getObjectID());
        }
        if (dimension == null) {
            dimension = (Dimension)this.mdmDesign.getDimensionSet().getByName(dimensionOracle.getName());
        }
        if (dimension != null) {
            this.clearDimension(dimension);
        }
        if (dimension == null) {
            dimension = this.mdmDesign.createDimension();
        }
        dimension.setGeneratorID(dimensionOracle.getObjectID());
        dimension.setName(dimensionOracle.getName());
        for (int i = 0; i < objectArray.length; ++i) {
            LevelOracle levelOracle = (LevelOracle)objectArray[i];
            this.processLevel(levelOracle, dimensionOracle);
        }
        Object[] objectArray2 = dimensionOracle.getHierarchySet();
        for (int i = 0; i < objectArray2.length; ++i) {
            HierarchyOracle hierarchyOracle = (HierarchyOracle)objectArray2[i];
            this.processHierarchy(hierarchyOracle, dimension);
        }
    }

    private void clearDimension(Dimension dimension) {
        int n;
        ArrayList arrayList = new ArrayList();
        Object[] objectArray = dimension.getHierarchies().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            Hierarchy hierarchy = (Hierarchy)objectArray[n];
            arrayList.addAll(hierarchy.getLevels());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ((Level)arrayList.get(n)).remove();
        }
    }

    private void processLevel(LevelOracle levelOracle, DimensionOracle dimensionOracle) {
        Table table;
        Level level = (Level)this.mdmDesign.getLevelSet().getObjectGeneratedBy(levelOracle.getObjectID());
        if (level == null) {
            level = this.mdmDesign.createLevel();
            level.setGeneratorID(levelOracle.getObjectID());
            level.setName(levelOracle.getName());
            if (!level.getName().equalsIgnoreCase(levelOracle.getName())) {
                levelOracle.setNewName(level.getName());
            } else {
                levelOracle.setNewName(levelOracle.getName());
            }
            level.setOraDimension(dimensionOracle.getName());
        } else {
            level.getLevelKey().clear();
            level.getSlowChangingAttributes().clear();
        }
        TableProxy tableProxy = levelOracle.getLevelTable();
        if (tableProxy != null && (table = (Table)tableProxy.getObject()) != null) {
            Attribute attribute;
            Column column;
            ColumnProxy columnProxy;
            int n;
            Entity entity = null;
            ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
            for (n = 0; n < columnProxyArray.length; ++n) {
                columnProxy = columnProxyArray[n];
                if (!levelOracle.getColumnSet().contains(columnProxy.getObjectID()) || (column = (Column)columnProxy.getObject()) == null || (attribute = column.getEngAttribute()) == null) continue;
                level.getLevelKey().add(attribute);
                if (entity != null) continue;
                entity = (Entity)attribute.getContainerWithKeyObject();
            }
            this.attribute = this.getAttributeForLevel(levelOracle, this.sdOracle);
            if (this.attribute != null) {
                for (n = 0; n < columnProxyArray.length; ++n) {
                    columnProxy = columnProxyArray[n];
                    if (!this.attribute.getColumnSet().contains(columnProxy.getObjectID()) || (column = (Column)columnProxy.getObject()) == null || (attribute = column.getEngAttribute()) == null) continue;
                    level.addDescriptiveAttribute(new SlowChangingAttribute(level, attribute));
                    if (entity != null) continue;
                    entity = (Entity)attribute.getContainerWithKeyObject();
                }
            }
            if (entity == null) {
                entity = table.getEngEntity();
            }
            if (entity != null) {
                level.setLevelEntity(entity);
            }
        }
    }

    private void validateLevel(LevelOracle levelOracle) {
        Table table;
        TableProxy tableProxy = levelOracle.getLevelTable();
        if (tableProxy != null && (table = (Table)tableProxy.getObject()) != null) {
            Entity entity = table.getEngEntity();
            if (entity == null) {
                this.valid = false;
                this.validationSB.append(MessageFormat.format(Messages.getString("EngineerFromOracle.NoCorrespondingEentityForTable"), table.getName()));
            } else {
                Attribute attribute;
                Column column;
                ColumnProxy columnProxy;
                int n;
                ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
                for (n = 0; n < columnProxyArray.length; ++n) {
                    columnProxy = columnProxyArray[n];
                    if (!levelOracle.getColumnSet().contains(columnProxy.getObjectID()) || (column = (Column)columnProxy.getObject()) == null || (attribute = column.getEngAttribute()) != null) continue;
                    this.valid = false;
                    this.validationSB.append(MessageFormat.format(Messages.getString("EngineerFromOracle.NoCorrespondingAttributeForCcolumn"), column.getLongName()));
                }
                this.attribute = this.getAttributeForLevel(levelOracle, this.sdOracle);
                if (this.attribute != null) {
                    for (n = 0; n < columnProxyArray.length; ++n) {
                        columnProxy = columnProxyArray[n];
                        if (!this.attribute.getColumnSet().contains(columnProxy.getObjectID()) || (column = (Column)columnProxy.getObject()) == null || (attribute = column.getEngAttribute()) != null) continue;
                        this.valid = false;
                        this.validationSB.append(MessageFormat.format(Messages.getString("EngineerFromOracle.NoCorrespondingAttributeForCcolumn"), column.getLongName()));
                    }
                }
            }
        }
    }

    private DimensionAttributeOracle getAttributeForLevel(LevelOracle levelOracle, StorageDesignOracle storageDesignOracle) {
        Iterator iterator = storageDesignOracle.getDimensionAttributeSet().iterator();
        while (iterator.hasNext()) {
            DimensionAttributeOracle dimensionAttributeOracle = (DimensionAttributeOracle)iterator.next();
            if (dimensionAttributeOracle.getLevel() != levelOracle) continue;
            return dimensionAttributeOracle;
        }
        return null;
    }

    private void processHierarchy(HierarchyOracle hierarchyOracle, Dimension dimension) {
        List list = this.getLevels(hierarchyOracle);
        AbstractMDObject abstractMDObject = dimension;
        for (int i = 0; i < list.size(); ++i) {
            Link link;
            AbstractMDObject abstractMDObject2 = (AbstractMDObject)list.get(i);
            if (abstractMDObject != null && (link = abstractMDObject.getFirstLinkToTarget(abstractMDObject2)) == null) {
                AbstractMDTV abstractMDTV = (AbstractMDTV)abstractMDObject.getTopView();
                AbstractMDTV abstractMDTV2 = (AbstractMDTV)abstractMDObject2.getTopView();
                if (abstractMDTV != null && abstractMDTV2 != null) {
                    link = this.mdmDesign.createLink();
                    link.setSourceTV(abstractMDTV);
                    link.setTargetTV(abstractMDTV2);
                    ((TVLink)link.getTopView()).addConnection();
                }
            }
            abstractMDObject = abstractMDObject2;
        }
        Hierarchy hierarchy = this.mdmDesign.getHierarchyDefinedByLevels(list);
        if (hierarchy != null) {
            hierarchy.setName(hierarchyOracle.getName());
            this.processJoins(hierarchyOracle, hierarchy);
        }
    }

    private void processJoins(HierarchyOracle hierarchyOracle, Hierarchy hierarchy) {
        for (String string : hierarchyOracle.getJoinSet()) {
            String string2 = string.toUpperCase();
            int n = string2.indexOf("KEY");
            int n2 = string2.indexOf(REFERENCES);
            if (n <= -1 || n2 <= n + 3) continue;
            String string3 = string.substring(n + 3, n2);
            String string4 = Token.getValBetweenBrackets(string3);
            String[] stringArray = "".equalsIgnoreCase(string4) ? new String[]{string3} : string4.split(Messages.getString("EngineerFromOracle.10"));
            this.setChildToParentAttributes(stringArray, hierarchy);
        }
    }

    private void validateJoins(HierarchyOracle hierarchyOracle) {
        for (String string : hierarchyOracle.getJoinSet()) {
            String string2 = string.toUpperCase();
            int n = string2.indexOf("KEY");
            int n2 = string2.indexOf(REFERENCES);
            if (n <= -1 || n2 <= n + 3) continue;
            String string3 = string.substring(n + 3, n2);
            String string4 = Token.getValBetweenBrackets(string3);
            String[] stringArray = "".equalsIgnoreCase(string4) ? new String[]{string3} : string4.split(",");
            this.checkChildToParentAttributes(stringArray);
        }
    }

    private void validate() {
        Iterator iterator = this.sdOracle.getDimensionSet().iterator();
        while (iterator.hasNext()) {
            DimensionOracle dimensionOracle = (DimensionOracle)iterator.next();
            this.validateDimension(dimensionOracle);
        }
    }

    private void validateDimension(DimensionOracle dimensionOracle) {
        int n;
        Object[] objectArray = dimensionOracle.getLevelSet();
        for (n = 0; n < objectArray.length; ++n) {
            this.validateLevel((LevelOracle)objectArray[n]);
        }
        objectArray = dimensionOracle.getHierarchySet();
        for (n = 0; n < objectArray.length; ++n) {
            this.validateJoins((HierarchyOracle)objectArray[n]);
        }
    }

    private void setChildToParentAttributes(String[] stringArray, Hierarchy hierarchy) {
        List list = hierarchy.getLevels();
        ColumnProxyOracle columnProxyOracle = ((ColumnProxySetOracle)this.sdOracle.getColumnProxySet()).getByLongName(stringArray[0].trim());
        if (columnProxyOracle != null) {
            Entity entity;
            TableProxyOracle tableProxyOracle = columnProxyOracle.getTableProxy();
            Attribute attribute = columnProxyOracle.getColumn().getEngAttribute();
            if (tableProxyOracle != null && attribute != null && (entity = ((Table)tableProxyOracle.getObject()).getEngEntity()) != null) {
                block0: for (int i = 0; i < list.size() - 1; ++i) {
                    Level level;
                    Level level2 = level = (Level)list.get(i);
                    if (level.getLevelEntity() != entity) continue;
                    for (int j = i; j < list.size(); ++j) {
                        Link link;
                        Level level3 = (Level)list.get(j);
                        if (entity != level3.getLevelEntity() && (link = level2.getFirstLinkToTarget(level3)) != null) {
                            for (int k = 0; k < stringArray.length; ++k) {
                                columnProxyOracle = ((ColumnProxySetOracle)this.sdOracle.getColumnProxySet()).getByLongName(stringArray[k].trim());
                                tableProxyOracle = columnProxyOracle.getTableProxy();
                                attribute = columnProxyOracle.getColumn().getEngAttribute();
                                if (tableProxyOracle == null || attribute == null) continue;
                                link.getRollupLink().getChildToParentAttributes().add(attribute);
                            }
                            break block0;
                        }
                        level2 = level3;
                    }
                    break;
                }
            }
        }
    }

    private void checkChildToParentAttributes(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Attribute attribute;
            ColumnProxyOracle columnProxyOracle = ((ColumnProxySetOracle)this.sdOracle.getColumnProxySet()).getByLongName(stringArray[i].trim());
            if (columnProxyOracle == null || (attribute = columnProxyOracle.getColumn().getEngAttribute()) != null) continue;
            this.valid = false;
            this.validationSB.append(MessageFormat.format(Messages.getString("EngineerFromOracle.NoCorrespondingAttributeForCcolumn"), columnProxyOracle.getColumn().getName()));
        }
    }

    private List getLevels(HierarchyOracle hierarchyOracle) {
        ArrayList<Level> arrayList = new ArrayList<Level>();
        String[] stringArray = hierarchyOracle.getLevels().split(",");
        Object[] objectArray = hierarchyOracle.getDimension().getLevelSet();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            for (int j = 0; j < objectArray.length; ++j) {
                Level level;
                LevelOracle levelOracle = (LevelOracle)objectArray[j];
                if (!string.equalsIgnoreCase(levelOracle.getObjectID()) || (level = this.getLevel(levelOracle, hierarchyOracle.getDimension())) == null) continue;
                arrayList.add(level);
            }
        }
        return arrayList;
    }

    private Level getLevel(LevelOracle levelOracle, DimensionOracle dimensionOracle) {
        Iterator iterator = this.mdmDesign.getLevelSet().iterator();
        String string = levelOracle.getName();
        if (!levelOracle.getName().equalsIgnoreCase(levelOracle.getNewName())) {
            string = levelOracle.getNewName();
        }
        while (iterator.hasNext()) {
            Level level = (Level)iterator.next();
            if (!level.getOraDimension().equalsIgnoreCase(dimensionOracle.getName()) || !level.getName().equalsIgnoreCase(string)) continue;
            return level;
        }
        return null;
    }

    private void makeCubes() {
        if (this.mdmDesign.getDimensionSet().size() >= this.minDimensions) {
            Iterator iterator = this.mdmDesign.getDesign().getLogicalDesign().getEntitySet().iterator();
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                if ((!this.factsOnly || !entity.getTypeID().equalsIgnoreCase(entity.getDesign().getDLSettings().getClassificationTypeByName(ContainerObject.TYPE_FACT).getTypeID())) && this.factsOnly) continue;
                Iterator iterator2 = this.mdmDesign.getDimensionSet().iterator();
                ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
                while (iterator2.hasNext()) {
                    Dimension dimension = (Dimension)iterator2.next();
                    if (!this.entityMatch(entity, dimension)) continue;
                    arrayList.add(dimension);
                }
                if (arrayList.size() < this.minDimensions) continue;
                this.makeCube(entity, arrayList);
            }
        }
    }

    private void makeCube(Entity entity, List list) {
        Cube cube = this.mdmDesign.getCubeOnEntity(entity);
        if (cube == null) {
            cube = this.mdmDesign.createCube();
            cube.setName(entity.getName());
            cube.setFactEntity(entity);
        }
        this.createMeasures(cube);
        for (Dimension dimension : list) {
            this.createLink(cube, dimension);
        }
    }

    private void createMeasures(Cube cube) {
        ContainerObject containerObject = cube.getFactEntity();
        if (containerObject != null) {
            for (Attribute attribute : containerObject.getElementsCollection()) {
                Measure measure;
                if (attribute.isFKAttribute() || !this.isNumericDataType(attribute.getDataType().getName()) || (measure = cube.getMeasureForAttribute(attribute)) != null) continue;
                measure = this.mdmDesign.createMeasure();
                measure.setName(attribute.getName());
                measure.setMeasureFact(attribute);
                Measure.AggregateFunction aggregateFunction = measure.createAggregateFunction();
                measure.getAggregateFunctions().add(aggregateFunction);
                measure.setDefaultAggregationFunction(aggregateFunction);
                cube.addMeasure(measure);
            }
        }
    }

    private void createLink(Cube cube, Dimension dimension) {
        block4: {
            Entity entity;
            ContainerObject containerObject;
            RollupLink rollupLink;
            block5: {
                Link link = cube.getFirstLinkToTarget(dimension);
                if (link == null) {
                    link = this.mdmDesign.createLink();
                    link.setSourceTV((AbstractMDTV)cube.getTopView());
                    link.setTargetTV((AbstractMDTV)dimension.getTopView());
                    ((TVLink)link.getTopView()).addConnection();
                }
                rollupLink = link.getRollupLink();
                containerObject = cube.getFactEntity();
                entity = dimension.getBaseEntity();
                if (!(containerObject instanceof Entity) || entity == null || entity.getPK() == null) break block4;
                if (!this.matchOnFK) break block5;
                Relation relation = ((Entity)containerObject).getRelationTo(entity);
                if (relation == null) break block4;
                Iterator iterator = containerObject.getElementsCollection().iterator();
                KeyObject keyObject = entity.getPK();
                while (iterator.hasNext()) {
                    ContainedObject containedObject = (ContainedObject)iterator.next();
                    if (containedObject.getDelegateElement() == null || !keyObject.contains(containedObject.getDelegateElement())) continue;
                    rollupLink.addChildToParentAttribute(containedObject);
                }
                break block4;
            }
            for (Attribute attribute : entity.getPK().getElementsCollection()) {
                Attribute attribute2 = (Attribute)containerObject.getElementByName(attribute.getName());
                if (attribute2 == null || !attribute2.getDataType().toString().equalsIgnoreCase(attribute.getDataType().toString())) continue;
                rollupLink.addChildToParentAttribute(attribute2);
                Object[] objectArray = cube.getMeasures().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Measure measure = (Measure)objectArray[i];
                    if (measure.isFormula() || measure.getMeasureFact() != attribute2) continue;
                    cube.getMeasures().remove(measure);
                }
            }
        }
    }

    private boolean entityMatch(Entity entity, Dimension dimension) {
        Entity entity2 = dimension.getBaseEntity();
        if (entity2 != null && entity2.getPK() != null) {
            if (this.matchOnFK) {
                Relation relation = entity.getRelationTo(entity2);
                if (relation != null) {
                    Iterator iterator = entity.getElementsCollection().iterator();
                    KeyObject keyObject = entity2.getPK();
                    int n = 0;
                    while (iterator.hasNext()) {
                        Attribute attribute = (Attribute)iterator.next();
                        if (attribute.getDelegateElement() == null || !keyObject.contains(attribute.getDelegateElement())) continue;
                        ++n;
                    }
                    if (n == keyObject.getElementsCollection().size()) {
                        return true;
                    }
                }
            } else {
                for (Attribute attribute : entity2.getPK().getElementsCollection()) {
                    Attribute attribute2 = (Attribute)entity.getElementByName(attribute.getName());
                    if (attribute2 == null) {
                        return false;
                    }
                    if (attribute2.getDataType().toString().equalsIgnoreCase(attribute.getDataType().toString())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isNumericDataType(String string) {
        String string2 = string.toUpperCase();
        return string2.indexOf("INT") > -1 || string2.indexOf("DEC") > -1 || string2.indexOf("NUM") > -1 || string2.indexOf("FLOAT") > -1 || string2.indexOf("REAL") > -1 || string2.indexOf("DOUBLE") > -1;
    }
}

