/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.swingui.editor.multidimensional.DimensionPropertiesDialogEx;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class Dimension
extends AbstractMDObject
implements EditableFonts {
    private boolean timeDimension;
    private boolean useNaturalKeys = true;
    private List levels = new ArrayList();
    private List attributes = new ArrayList();
    private DesignObjectCollection hierarchies = new DesignObjectCollection();
    private List oracleAWAttributes = new ArrayList();
    private List permanentCalcMembers = new ArrayList();
    private List editableFonts;
    public static final String TYPE_NAME = "Dimension";

    public Dimension(DesignPart designPart) {
        super(designPart);
        this.hierarchies.setName(Messages.getString("Dimension.Hierarchies"));
        this.hierarchies.setParent(this);
        this.hierarchies.setElementDescriptor(Hierarchy.class);
        this.initEditableFonts();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DimensionPropertiesDialogEx dimensionPropertiesDialogEx = new DimensionPropertiesDialogEx(this.getDesign().getAppView(), this);
            dimensionPropertiesDialogEx.initProperties(this);
            dimensionPropertiesDialogEx.show();
        }
    }

    public boolean isTimeDimension() {
        return this.timeDimension;
    }

    public void setTimeDimension(boolean bl) {
        this.timeDimension = bl;
    }

    public DesignObjectCollection getHierarchies() {
        return this.hierarchies;
    }

    public void addHierarchy(Hierarchy hierarchy) {
        hierarchy.setParent(this.hierarchies);
        this.hierarchies.add(hierarchy);
        hierarchy.setDimension(this);
    }

    public void removeHierarchy(Hierarchy hierarchy) {
        this.hierarchies.remove(hierarchy);
    }

    public List getAllLevels() {
        this.levels.clear();
        ArrayList arrayList = new ArrayList();
        this.getHierarchies().addAllElementsTo(arrayList);
        for (Hierarchy hierarchy : arrayList) {
            for (Level level : hierarchy.getLevels()) {
                if (this.levels.contains(level)) continue;
                this.levels.add(level);
            }
        }
        return this.levels;
    }

    public List getAllAttributes() {
        this.attributes.clear();
        for (Level level : this.getAllLevels()) {
            for (DesignObject designObject : level.getAllAttributes()) {
                if (this.attributes.contains(designObject)) continue;
                this.attributes.add(designObject);
            }
        }
        return this.attributes;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.hierarchies;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.hierarchies) {
            return 0;
        }
        return -1;
    }

    public Entity getBaseEntity() {
        Iterator iterator = this.hierarchies.iterator();
        while (iterator.hasNext()) {
            Level level;
            Hierarchy hierarchy = (Hierarchy)iterator.next();
            if (hierarchy.getLevels().size() <= 0 || (level = (Level)hierarchy.getLevels().get(0)).getLevelEntity() == null || !(level.getLevelEntity() instanceof Entity)) continue;
            return (Entity)level.getLevelEntity();
        }
        return null;
    }

    public Level getBaseLevel() {
        Iterator iterator = this.hierarchies.iterator();
        while (iterator.hasNext()) {
            Hierarchy hierarchy = (Hierarchy)iterator.next();
            if (hierarchy.getLevels().size() <= 0) continue;
            Level level = (Level)hierarchy.getLevels().get(0);
            return level;
        }
        return null;
    }

    public Hierarchy getHierarchyDefinedByLevels(List list) {
        Iterator iterator = this.getHierarchies().iterator();
        while (iterator.hasNext()) {
            Hierarchy hierarchy = (Hierarchy)iterator.next();
            if (!hierarchy.isEqualToLevelList(list)) continue;
            return hierarchy;
        }
        return null;
    }

    public static void validateAWAttributes(Level.OraAWAttributes oraAWAttributes, boolean bl) {
        Level level = oraAWAttributes.level;
        if (level != null) {
            DesignObject designObject;
            if (oraAWAttributes.shortDesc != null && (designObject = level.getAttributeById(oraAWAttributes.shortDesc.getObjectID())) == null) {
                oraAWAttributes.shortDesc = null;
            }
            if (oraAWAttributes.longDesc != null && (designObject = level.getAttributeById(oraAWAttributes.longDesc.getObjectID())) == null) {
                oraAWAttributes.longDesc = null;
            }
            if (bl) {
                if (oraAWAttributes.timeEnd != null && (designObject = level.getAttributeById(oraAWAttributes.timeEnd.getObjectID())) == null) {
                    oraAWAttributes.timeEnd = null;
                }
                if (oraAWAttributes.timeSpan != null && (designObject = level.getAttributeById(oraAWAttributes.timeSpan.getObjectID())) == null) {
                    oraAWAttributes.timeSpan = null;
                }
            }
        } else {
            oraAWAttributes.shortDesc = null;
            oraAWAttributes.longDesc = null;
            oraAWAttributes.timeEnd = null;
            oraAWAttributes.timeSpan = null;
        }
    }

    public List getOracleAWAttributes() {
        for (Level level : this.getAllLevels()) {
            Level.OraAWAttributes oraAWAttributes = level.getOraAWAttributes();
            if (oraAWAttributes != null) {
                Dimension.validateAWAttributes(oraAWAttributes, this.isTimeDimension());
            }
            this.oracleAWAttributes.add(oraAWAttributes);
        }
        return this.oracleAWAttributes;
    }

    public boolean isUseNaturalKeys() {
        return this.useNaturalKeys;
    }

    public void setUseNaturalKeys(boolean bl) {
        this.useNaturalKeys = bl;
    }

    public List getPermanentCalcMembers() {
        return this.permanentCalcMembers;
    }

    public String getWhereClauseFor(Level level) {
        return level.getSelectionCriteria().trim();
    }

    public PermanentCalcMember createPermanentCalcMember() {
        return new PermanentCalcMember("");
    }

    public PermanentCalcMember getPermanentCalcMemberByID(String string) {
        for (PermanentCalcMember permanentCalcMember : this.permanentCalcMembers) {
            if (!permanentCalcMember.getId().equals(string)) continue;
            return permanentCalcMember;
        }
        return null;
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
            this.setUseDefaultColor(bl);
        } else if (DefaultFontAndColor.isModified(TYPE_NAME)) {
            DefaultFontAndColor defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME);
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
            this.setUseDefaultColor(bl);
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "dimension/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public class PermanentCalcMember {
        String name;
        String expression = "";
        String id;

        public PermanentCalcMember(String string, String string2) {
            this(string);
            this.expression = string2;
        }

        public PermanentCalcMember(String string) {
            this.name = string;
            this.id = new GUID().toString();
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String string) {
            this.expression = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }
    }
}

