/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;

public abstract class AbstractMDObject
extends DesignObject {
    private String description = "";
    protected List relationConnections = new ArrayList();
    protected List raggedLinkConnections = new ArrayList();
    private Collection allViews = new ArrayList();
    private MultidimensionalDesign multidimensionalDesign;
    private String oracleShortName = "";
    private String oracleLongName = "";
    private String oraclePluralName = "";
    private String nameInOracleAW = "";

    public AbstractMDObject(DesignPart designPart) {
        super(designPart);
        this.multidimensionalDesign = (MultidimensionalDesign)designPart;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    void add(Link.Connection connection) {
        this.relationConnections.add(connection);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_ADDED);
    }

    void add(RaggedHLink.Connection connection) {
        this.raggedLinkConnections.add(connection);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_ADDED);
    }

    void remove(Link.Connection connection) {
        this.relationConnections.remove(connection);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_REMOVED);
    }

    void remove(RaggedHLink.Connection connection) {
        this.raggedLinkConnections.remove(connection);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_REMOVED);
    }

    void moveToIndex(Link.Connection connection, int n) {
        this.relationConnections.remove(connection);
        this.relationConnections.add(n, connection);
    }

    void moveToIndex(RaggedHLink.Connection connection, int n) {
        this.raggedLinkConnections.remove(connection);
        this.raggedLinkConnections.add(n, connection);
    }

    public Link.Connection[] getAllLinks() {
        return (Link.Connection[])this.relationConnections.toArray(Link.CONNECTION_PROTO_ARRAY);
    }

    public RaggedHLink.Connection[] getAllRaggedHLinks() {
        return (RaggedHLink.Connection[])this.raggedLinkConnections.toArray(RaggedHLink.CONNECTION_PROTO_ARRAY);
    }

    public void removeLinks() {
        for (int i = this.relationConnections.size() - 1; i >= 0; --i) {
            Link.Connection connection = (Link.Connection)this.relationConnections.get(i);
            Link link = connection.getLink();
            link.getSource().remove(connection);
            link.getTargetMDObject().remove(connection);
            TVLink tVLink = (TVLink)link.getTopView();
            tVLink.remove();
        }
    }

    public void removeRaggedHLinks() {
        for (int i = this.raggedLinkConnections.size() - 1; i >= 0; --i) {
            RaggedHLink.Connection connection = (RaggedHLink.Connection)this.raggedLinkConnections.get(i);
            RaggedHLink raggedHLink = connection.getRaggedHLink();
            raggedHLink.getSource().remove(connection);
            raggedHLink.getTargetMDObject().remove(connection);
            TVRaggedHLink tVRaggedHLink = (TVRaggedHLink)raggedHLink.getTopView();
            tVRaggedHLink.remove();
        }
    }

    @Override
    public void remove() {
        this.removeLinks();
        this.removeRaggedHLinks();
        this.removeAllViews();
        super.remove();
    }

    public void removeAllViews() {
        TopViewCollection[] topViewCollectionArray = this.allViews.toArray(new TopViewCollection[0]);
        for (int i = 0; i < topViewCollectionArray.length; ++i) {
            DesignPartView designPartView = topViewCollectionArray[i].getDPV();
            designPartView.getWorkSpace().removeMDObject(this);
            TopView[] topViewArray = topViewCollectionArray[i].toArray(new TopView[0]);
            for (int j = 0; j < topViewArray.length; ++j) {
                designPartView.unregisterFromTreemodel(topViewArray[j]);
                this.removeTopView(topViewArray[j]);
            }
        }
    }

    @Override
    public TopViewCollection getViewsForDPV(DesignPartView designPartView) {
        TopViewCollection topViewCollection2;
        for (TopViewCollection topViewCollection2 : this.allViews) {
            if (topViewCollection2.getDPV() != designPartView) continue;
            return topViewCollection2;
        }
        topViewCollection2 = new TopViewCollection();
        topViewCollection2.setDPV(designPartView);
        this.allViews.add(topViewCollection2);
        return topViewCollection2;
    }

    @Override
    public void setTopView(TopView topView) {
        this.addTopView(topView);
    }

    @Override
    public TopView getTopView() {
        if (this.allViews.isEmpty()) {
            return null;
        }
        for (TopViewCollection topViewCollection : this.allViews) {
            Object object;
            if (topViewCollection.dpv == null || !topViewCollection.dpv.isMainDiagram()) continue;
            if (topViewCollection.isEmpty() && (object = topViewCollection.dpv.getViewFor(this)) != null) {
                topViewCollection.add(object);
                return object;
            }
            object = topViewCollection.iterator();
            if (topViewCollection.size() <= 0) continue;
            return (TopView)object.next();
        }
        return null;
    }

    public TopView getTopViewByID(String string) {
        TopViewCollection topViewCollection2 = null;
        for (TopViewCollection topViewCollection2 : this.allViews) {
            for (TopView topView : topViewCollection2) {
                if (!string.equalsIgnoreCase(topView.getViewID())) continue;
                return topView;
            }
        }
        return this.getTopView();
    }

    @Override
    public TopView getTopViewByID(DesignPartView designPartView, String string, int n) {
        if (string != null) {
            Collection collection = this.getAllViews(designPartView);
            for (TopView topView : collection) {
                if (!string.equalsIgnoreCase(topView.getViewID())) continue;
                return topView;
            }
            int n2 = 0;
            for (TopView topView : collection) {
                if (n == n2) {
                    topView.setViewNumber(n);
                    return topView;
                }
                ++n2;
            }
        }
        return null;
    }

    public Collection getAllViews(DesignPartView designPartView) {
        ArrayList arrayList = new ArrayList();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        if (topViewCollection.size() > 0) {
            Iterator iterator = topViewCollection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    @Override
    public int getViewNumber(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        if (topViewCollection.isEmpty()) {
            return -100;
        }
        Iterator iterator = topViewCollection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TopView topView2 = (TopView)iterator.next();
            if (topView2 == topView) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public void removeViewSynonim(TopView topView) {
        this.removeTopView(topView);
    }

    @Override
    public void resetViewNumbers() {
        for (TopViewCollection topViewCollection : this.allViews) {
            for (TopView topView : topViewCollection) {
                topView.setViewNumber(this.getViewNumber(topView));
            }
        }
    }

    @Override
    public int getTopViewsCount() {
        int n = 0;
        for (TopViewCollection topViewCollection : this.allViews) {
            n += topViewCollection.size();
        }
        return n;
    }

    @Override
    public int getViewsCountForDPV(DesignPartView designPartView) {
        for (TopViewCollection topViewCollection : this.allViews) {
            if (topViewCollection.getDPV() != designPartView) continue;
            return topViewCollection.size();
        }
        return 0;
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView designPartView) {
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        return topViewCollection.size() > 0;
    }

    public void addTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        topViewCollection.add(topView);
        this.addObjectListener(topView);
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView designPartView) {
        for (TopViewCollection topViewCollection : this.allViews) {
            if (topViewCollection.getDPV() != designPartView) continue;
            if (topViewCollection.size() > 0) {
                return (TopView)topViewCollection.get(0);
            }
            return null;
        }
        return null;
    }

    public void removeTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        topViewCollection.remove(topView);
        if (topViewCollection.size() == 0) {
            this.allViews.remove(topViewCollection);
        }
        this.removeObjectListener(topView);
    }

    public List getIncomingLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        Link.Connection[] connectionArray = this.getAllLinks();
        for (int i = 0; i < connectionArray.length; ++i) {
            if (connectionArray[i].isSource()) continue;
            arrayList.add(connectionArray[i].getLink());
        }
        return arrayList;
    }

    public List getOutgoingLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        Link.Connection[] connectionArray = this.getAllLinks();
        for (int i = 0; i < connectionArray.length; ++i) {
            if (!connectionArray[i].isSource() || connectionArray[i].getLink().getSourceMDObject() != this) continue;
            arrayList.add(connectionArray[i].getLink());
        }
        return arrayList;
    }

    public Link getFirstLinkToTarget(AbstractMDObject abstractMDObject) {
        for (Link link : this.getOutgoingLinks()) {
            if (link.getTargetMDObject() != abstractMDObject) continue;
            return link;
        }
        return null;
    }

    public List getAllLinksToTarget(AbstractMDObject abstractMDObject) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.getOutgoingLinks()) {
            if (link.getTargetMDObject() != abstractMDObject) continue;
            arrayList.add(link);
        }
        return arrayList;
    }

    public List getAllRollupLinksToTarget(AbstractMDObject abstractMDObject) {
        ArrayList<RollupLink> arrayList = new ArrayList<RollupLink>();
        for (Link link : this.getOutgoingLinks()) {
            if (link.getTargetMDObject() != abstractMDObject || link.getRollupLink() == null) continue;
            arrayList.add(link.getRollupLink());
        }
        return arrayList;
    }

    public String getOracleLongName() {
        return this.oracleLongName;
    }

    public void setOracleLongName(String string) {
        this.oracleLongName = string;
    }

    public String getOraclePluralName() {
        return this.oraclePluralName;
    }

    public void setOraclePluralName(String string) {
        this.oraclePluralName = string;
    }

    public String getOracleShortName() {
        return this.oracleShortName;
    }

    public void setOracleShortName(String string) {
        this.oracleShortName = string;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.multidimensionalDesign;
    }

    public String getNameInOracleAW() {
        if ("".equals(this.nameInOracleAW)) {
            return this.getName().replaceAll(" ", "_").toUpperCase();
        }
        return this.nameInOracleAW.toUpperCase();
    }

    public void setNameInOracleAW(String string) {
        this.nameInOracleAW = string;
    }
}

