/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;

public class RelationSet
extends DesignObjectSet {
    private static final Object[] PROTO_RELATION = new Relation[0];

    public RelationSet(DesignPart designPart) {
        super(designPart);
        this.requireSort = true;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_RELATION;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default relation name");
    }

    public Relation createRelation(String string) {
        Relation relation = new Relation(this.getDesignPart());
        relation.setObjectID(string);
        relation.setDesign(this.getDesign());
        this.getDesign().addDesignObject(relation);
        this.add(relation);
        return relation;
    }

    public List getRelationsTo(Entity entity) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Relation relation = (Relation)iterator.next();
            if (relation.getSourceEntity() != entity && relation.getTargetEntity() != entity) continue;
            arrayList.add(relation);
        }
        return arrayList;
    }

    public Collection getRelationsToSource(Entity entity) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Relation relation = (Relation)iterator.next();
            if (relation.getSourceEntity() != entity) continue;
            arrayList.add(relation);
        }
        return arrayList;
    }

    public Collection getRelationsToTarget(Entity entity) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Relation relation = (Relation)iterator.next();
            if (relation.getTargetEntity() != entity) continue;
            arrayList.add(relation);
        }
        return arrayList;
    }

    public Collection getRelationsToSandT(Entity entity, Entity entity2) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Relation relation = (Relation)iterator.next();
            if (relation.getSourceEntity() != entity || relation.getTargetEntity() != entity2) continue;
            arrayList.add(relation);
        }
        return arrayList;
    }

    public Collection getRelationsToSandTAll(Entity entity, Entity entity2) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Relation relation = (Relation)iterator.next();
            if ((relation.getSourceEntity() != entity || relation.getTargetEntity() != entity2) && (relation.getTargetEntity() != entity || relation.getSourceEntity() != entity2)) continue;
            arrayList.add(relation);
        }
        return arrayList;
    }

    public Relation getRelationBetween(Entity entity, Entity entity2) {
        Relation relation = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            relation = (Relation)iterator.next();
            if ((relation.getSourceEntity() != entity || relation.getTargetEntity() != entity2) && (relation.getSourceEntity() != entity2 || relation.getTargetEntity() != entity)) continue;
            return relation;
        }
        return null;
    }

    public Relation getByNameSourceAndTarget(String string, String string2, String string3) {
        for (Relation relation : this.elements) {
            if (!relation.getName().equalsIgnoreCase(string) || !relation.getSourceEntity().getName().equalsIgnoreCase(string2) || !relation.getTargetEntity().getName().equalsIgnoreCase(string3)) continue;
            return relation;
        }
        return null;
    }

    @Override
    public void removeAll() {
        Object[] objectArray = this.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            DesignObject designObject = (DesignObject)objectArray[i];
            designObject.remove();
        }
        super.removeAll();
    }
}

