/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.FKAttributeManager;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.logical.RelationPropertiesDialogEx;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;

public class Relation
extends DesignObject
implements ConnectionInterface {
    public static final int SOURCE = 0;
    public static final int TARGET = 1;
    public static final int MANY = 0;
    private final Entity[] ENTITIES = new Entity[2];
    private static final Cardinality MANY_CARD = new Cardinality(0, "*");
    private static Cardinality ONE_CARD = new Cardinality(1);
    public static final Cardinality[] CARDINALITY_CHOICES = new Cardinality[]{MANY_CARD, ONE_CARD};
    private final Cardinality[] CARDINALITIES = new Cardinality[]{MANY_CARD, MANY_CARD};
    private final Connection[] CONNECTIONS = new Connection[]{new SourceConnection(), new TargetConnection()};
    private FKAttributeManager fkAttributeManager = null;
    Collection dpvCol = new ArrayList();
    private boolean belongsToTargetPK = false;
    private boolean belongsToSourcePK = false;
    private boolean fireCardinalityChange = true;
    private Entity DOMINANT_ROLE;
    private Entity NONE = new Entity(this.getDesignPart());
    private boolean identifying = false;
    private Arc arc = null;
    private boolean transferable = true;
    private String deleteRule = "RESTRICT";
    public static final String TYPE_NAME = "Relation";
    TVEntity sourceTVT = null;
    TVEntity targetTVT = null;
    public static final Object[] CONNECTION_PROTO_ARRAY = new Connection[0];

    public Relation(DesignPart designPart) {
        super(designPart);
        this.getFKAttributeManager();
        String string = designPart.getAppView().getSettings().getDefaultFKDeleteRule();
        if (string.equals("RESTRICT") || string.equals("NO ACTION") || string.equals("SET NULL")) {
            this.deleteRule = string;
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 0;
    }

    @Override
    public ModelObject getChild(int n) {
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Object getParent() {
        return this.getDesign().getLogicalDesign();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setEntity(int n, Entity entity) {
        if (this.ENTITIES[n] == entity) {
            return;
        }
        if (this.ENTITIES[n] != null) {
            if (this.ENTITIES[0] != this.ENTITIES[1]) {
                this.ENTITIES[n].removeRelationFromRelationCollections(this);
            }
            this.ENTITIES[n].remove(this.CONNECTIONS[n]);
        }
        if (entity != null) {
            entity.add(this.CONNECTIONS[n]);
        }
        this.ENTITIES[n] = entity;
        if (entity != null) {
            entity.addRelationToRelationCollections(this);
        }
        this.fireChange(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED);
    }

    public void setEntityInh(int n, Entity entity) {
        Entity entity2 = this.ENTITIES[n];
        if (this.ENTITIES[n] == entity) {
            return;
        }
        if (this.ENTITIES[n] != null) {
            if (this.ENTITIES[0] != this.ENTITIES[1]) {
                this.ENTITIES[n].removeRelationFromRelationCollections(this);
            }
            this.ENTITIES[n].remove(this.CONNECTIONS[n]);
        }
        if (entity != null) {
            entity.add(this.CONNECTIONS[n]);
        }
        this.ENTITIES[n] = entity;
        if (entity != null) {
            entity.addRelationToRelationCollections(this);
        }
        this.fireChange(ObjectChangeEvent.RELATION_ENDPOINT_CHANGED);
        if (0 == n && this.ENTITIES[1] != null) {
            this.ENTITIES[1].setHierarchicalParent(entity);
        }
        if (1 == n && entity2 != null) {
            entity2.setHierarchicalParentToNull();
            if (entity != null) {
                entity.joinInheritanceRelation(this, this.ENTITIES[0]);
            }
        }
    }

    public Entity getEntity(int n) {
        return this.ENTITIES[n];
    }

    public void setCardinality(int n, Cardinality cardinality) {
        this.CARDINALITIES[n] = cardinality;
        if (this.fireCardinalityChange) {
            this.fireChange(ObjectChangeEvent.RELATION_CARDINALITY_CHANGED);
        }
    }

    public void setCardinality(int n, int n2) {
        if (n2 < 0 || n2 >= CARDINALITY_CHOICES.length) {
            throw new IllegalArgumentException(Messages.getString("Relation.CodeMustPointCardinality"));
        }
        this.setCardinality(n, CARDINALITY_CHOICES[n2]);
    }

    public Cardinality getCardinality(int n) {
        return this.CARDINALITIES[n];
    }

    public Entity getTargetEntity() {
        return this.getEntity(1);
    }

    public void setTargetEntity(Entity entity) {
        if (this.getTargetEntity() != entity) {
            Entity entity2 = this.getTargetEntity();
            this.setEntity(1, entity);
            if (entity2 != null && entity2 != entity) {
                this.clearTargetTV();
            }
            this.addToAllDPVs();
        }
    }

    public Entity getSourceEntity() {
        return this.getEntity(0);
    }

    public void setSourceEntity(Entity entity) {
        if (this.getSourceEntity() != entity) {
            Entity entity2 = this.getSourceEntity();
            this.setEntity(0, entity);
            if (entity2 != null && entity2 != entity) {
                this.clearSourceTV();
            }
            this.addToAllDPVs();
        }
    }

    public void setTargetCardinality(Object object) {
        if (object instanceof Cardinality) {
            this.setCardinality(1, (Cardinality)object);
        } else if (object instanceof String) {
            this.setCardinality(1, (String)object);
        }
    }

    public Object getTargetCardinality() {
        return this.getCardinality(1);
    }

    public void setSourceCardinality(Object object) {
        if (object instanceof Cardinality) {
            this.setCardinality(0, (Cardinality)object);
        } else if (object instanceof String) {
            this.setCardinality(0, (String)object);
        }
    }

    public Object getSourceCardinality() {
        return this.getCardinality(0);
    }

    public boolean isValid() {
        return this.getEntity(0) != null && this.getEntity(1) != null;
    }

    public static Cardinality[] getCardinalityChoices() {
        return CARDINALITY_CHOICES;
    }

    public Connection getSourceConnection() {
        return this.getConnection(0);
    }

    public Connection getTargetConnection() {
        return this.getConnection(1);
    }

    public int getOtherEndPoint(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 0;
        }
        throw new IllegalArgumentException(Messages.getString("Relation.EndPointMmustBeRelation.SOURCE"));
    }

    public Connection getConnection(int n) {
        return this.CONNECTIONS[n];
    }

    public boolean isOptional(int n) {
        return this.getConnection(n).isOptional();
    }

    public Boolean getOptional(int n) {
        return this.getConnection(n).getOptionality();
    }

    public void setOptional(int n, Boolean bl) {
        Connection connection = this.getConnection(n);
        if (connection != null && connection.isOptional() != bl.booleanValue()) {
            connection.setOptionality(bl);
            this.fireChange(ObjectChangeEvent.RELATION_OPTIONALITY_CHANGED);
        }
    }

    public void setOptionalTarget(boolean bl) {
        this.setOptional(1, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setOptionalSource(boolean bl) {
        this.setOptional(0, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isOptionalTarget() {
        return this.getOptional(1);
    }

    public boolean isOptionalSource() {
        return this.getOptional(0);
    }

    public void setNameOnTarget(String string) {
        this.getConnection(1).setNameOn(string);
    }

    public String getNameOnTarget() {
        return this.getConnection(1).getNameOn();
    }

    public void setNameOnSource(String string) {
        this.getConnection(0).setNameOn(string);
    }

    public String getNameOnSource() {
        return this.getConnection(0).getNameOn();
    }

    public String getLabelText(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isOptional(n) && this.getCardinality(n) != MANY_CARD) {
            stringBuffer.append("0 .. ");
        } else if (!this.isOptional(n) && this.getCardinality(n) == MANY_CARD) {
            stringBuffer.append("1 .. ");
        }
        stringBuffer.append(this.getCardinality(n));
        String string = this.getNameOn(n);
        if (string != null) {
            stringBuffer.append(' ').append(string);
        }
        return stringBuffer.toString();
    }

    public String getNameOn(int n) {
        return this.getConnection(n).getNameOn();
    }

    public void setNameOn(int n, String string) {
        this.getConnection(n).setNameOn(string);
    }

    public void invertSense() {
        Cardinality cardinality = this.CARDINALITIES[0];
        this.CARDINALITIES[0] = this.CARDINALITIES[1];
        this.CARDINALITIES[1] = cardinality;
        Entity entity = this.getEntity(0);
        this.setEntity(0, this.getEntity(1));
        this.setEntity(1, entity);
    }

    public void setCardinality(int n, String string) {
        for (int i = 0; i < CARDINALITY_CHOICES.length; ++i) {
            if (!string.equals(CARDINALITY_CHOICES[i].toString())) continue;
            this.setCardinality(n, CARDINALITY_CHOICES[i]);
        }
    }

    public boolean isManyToMany() {
        return !this.getConnection(0).isOneCardinality() && !this.getConnection(1).isOneCardinality();
    }

    public boolean isOneToOne() {
        return this.getConnection(0).isOneCardinality() && this.getConnection(1).isOneCardinality();
    }

    public boolean isInheritanceRelation() {
        return false;
    }

    public FKAttributeManager getFKAttributeManager() {
        if (this.fkAttributeManager == null) {
            this.fkAttributeManager = new FKAttributeManager(this);
        }
        return this.fkAttributeManager;
    }

    public Attribute[] getFKAttributes(int n) {
        return this.getFKAttributeManager().getFKAttributes(n);
    }

    public Attribute[] getFKAttributes(Entity entity) {
        if (entity != null) {
            return this.getFKAttributes(this.getEndPointFor(entity));
        }
        return (Attribute[])DesignObject.PROTOTYPE;
    }

    public int getEndPointFor(Entity entity) {
        if (entity != null) {
            if (entity.equals(this.getSourceEntity())) {
                return 0;
            }
            if (entity.equals(this.getTargetEntity())) {
                return 1;
            }
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("Relation.EntityNotSourceOrTarget"), entity));
        }
        throw new IllegalArgumentException(Messages.getString("Relation.EndpointForNullCanNotBeDetermined"));
    }

    public boolean isPrimaryForeignKey(int n) {
        return this.getFKAttributeManager().isPrimaryForeignKey(n);
    }

    public int[] getPKProviderEndPoint() {
        if (this.isManyToMany()) {
            return new int[]{0, 1};
        }
        if (this.getSourceConnection().isOneCardinality() && this.getTargetConnection().isOneCardinality()) {
            if (this.getEntity(0) == this.getEntity(1)) {
                return new int[]{0};
            }
            if (this.getDominantRole() != this.NONE) {
                if (this.getDominantRole() == this.getSourceEntity()) {
                    return new int[]{0};
                }
                return new int[]{1};
            }
            if (this.getSourceConnection().isOptional() && !this.getTargetConnection().isOptional()) {
                return new int[]{0};
            }
            if (!this.getSourceConnection().isOptional() && this.getTargetConnection().isOptional()) {
                return new int[]{1};
            }
            return new int[]{0, 1};
        }
        if (this.getSourceConnection().isOneCardinality()) {
            return new int[]{0};
        }
        if (this.getTargetConnection().isOneCardinality()) {
            return new int[]{1};
        }
        return new int[0];
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("relation id prefix");
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public void remove() {
        if (this.getTargetEntity() != null) {
            this.getTargetEntity().removeRelationFromRelationCollections(this);
        }
        if (this.getSourceEntity() != null) {
            this.getSourceEntity().removeRelationFromRelationCollections(this);
        }
        if (this.fkAttributeManager != null) {
            this.fkAttributeManager.removeFromListeners();
        }
        super.remove();
        this.setEntity(1, null);
        this.setEntity(0, null);
        this.delete();
    }

    public void delete() {
    }

    @Override
    public void changed(TopView topView, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.TOPVIEW_REMOVED)) {
            DesignPartView designPartView = topView.getDesignPartView();
            designPartView.removeViewFor(this);
            dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            dpvInfo2.tv = null;
            if (dpvInfo2.sourceTV == topView) {
                dpvInfo2.sourceTV = null;
            }
            if (dpvInfo2.targetTV == topView) {
                dpvInfo2.targetTV = null;
            }
        }
    }

    @Override
    public void setTopView(TopView topView) {
        this.addTopView(topView);
    }

    @Override
    public TopView getTopView() {
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.tv == null) continue;
            return dpvInfo2.tv;
        }
        return null;
    }

    public void addTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.tv != null && dpvInfo2.tv != topView) {
            throw new RuntimeException(Messages.getString("Relation.AssociationAlreadyexists"));
        }
        dpvInfo2.tv = topView;
    }

    @Override
    public void removeTopView(TopView topView) {
        if (topView != null) {
            DesignPartView designPartView = topView.getDesignPartView();
            dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            ((TVRelation)topView).removeConnection();
            if (dpvInfo2.dpv != null) {
                dpvInfo2.dpv.unregisterFromTreemodel(topView);
            }
            if (dpvInfo2.tv == null) {
                return;
            }
            this.dpvCol.remove(dpvInfo2);
            this.removeObjectListener(topView);
        }
    }

    public void removeViewFor(DesignPartView designPartView) {
        if (designPartView != null) {
            dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
            if (dpvInfo2.tv != null) {
                ((TVRelation)dpvInfo2.tv).removeConnection();
                if (dpvInfo2.dpv != null) {
                    dpvInfo2.dpv.unregisterFromTreemodel(dpvInfo2.tv);
                }
                this.dpvCol.remove(dpvInfo2);
            }
        }
    }

    public dpvInfo getDPVInfoFor(DesignPartView designPartView) {
        dpvInfo dpvInfo22;
        for (dpvInfo dpvInfo22 : this.dpvCol) {
            if (dpvInfo22.dpv != designPartView) continue;
            return dpvInfo22;
        }
        dpvInfo22 = new dpvInfo();
        dpvInfo22.dpv = designPartView;
        this.dpvCol.add(dpvInfo22);
        return dpvInfo22;
    }

    public List getAllTVRelations() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.tv == null) continue;
            arrayList.add(dpvInfo2.tv);
        }
        return arrayList;
    }

    @Override
    public TopView getViewFor(DesignPartView designPartView) {
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        return dpvInfo2.tv;
    }

    public void updateConnections() {
        TVRelation tVRelation = (TVRelation)this.getTopView();
        tVRelation.removeConnection();
        tVRelation.addConnection();
    }

    public void setSourceTV(TVEntity tVEntity) {
        if (tVEntity == null) {
            return;
        }
        DesignPartView designPartView = tVEntity.getDesignPartView();
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.sourceTV != tVEntity) {
            if (dpvInfo2.sourceTV != null) {
                if (dpvInfo2.tv != null) {
                    ((TVRelation)dpvInfo2.tv).removeConnection();
                    if (dpvInfo2.dpv != null) {
                        dpvInfo2.dpv.unregisterFromTreemodel(dpvInfo2.tv);
                    }
                }
                dpvInfo2.sourceTV.removeTopViewListener(this);
            }
            dpvInfo2.sourceTV = tVEntity;
            dpvInfo2.sourceTV.addTopViewListener(this);
            this.addTVRelation(dpvInfo2);
        }
    }

    public void setTargetTV(TVEntity tVEntity) {
        if (tVEntity == null) {
            return;
        }
        DesignPartView designPartView = tVEntity.getDesignPartView();
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.targetTV != tVEntity) {
            if (dpvInfo2.targetTV != null) {
                if (dpvInfo2.tv != null) {
                    ((TVRelation)dpvInfo2.tv).removeConnection();
                    if (dpvInfo2.dpv != null) {
                        dpvInfo2.dpv.unregisterFromTreemodel(dpvInfo2.tv);
                    }
                }
                dpvInfo2.targetTV.removeTopViewListener(this);
            }
            dpvInfo2.targetTV = tVEntity;
            dpvInfo2.targetTV.addTopViewListener(this);
            this.addTVRelation(dpvInfo2);
        }
    }

    public void addTVRelation(dpvInfo dpvInfo2) {
        if (dpvInfo2.tv == null && dpvInfo2.sourceTV != null && dpvInfo2.targetTV != null && dpvInfo2.dpv != null) {
            TVRelation tVRelation = new TVRelation(this.getDesign().getAppView(), dpvInfo2.dpv);
            tVRelation.setModel(this);
            tVRelation.setSize(new Dimension(100, 100));
            this.addObjectListener(tVRelation);
            dpvInfo2.dpv.registerForTreemodel(tVRelation);
            if (dpvInfo2.dpv.isVisible() && !ApplicationView.loading) {
                tVRelation.addConnection();
            }
        } else if (dpvInfo2.tv != null && dpvInfo2.sourceTV != null && dpvInfo2.targetTV != null && dpvInfo2.dpv != null && ((TVRelation)dpvInfo2.tv).getEdge() == null && !ApplicationView.loading) {
            ((TVRelation)dpvInfo2.tv).addConnection();
        }
        if (dpvInfo2.tv != null && dpvInfo2.sourceTV != null && dpvInfo2.targetTV != null && dpvInfo2.dpv != null) {
            dpvInfo2.dpv.registerTopView(dpvInfo2.tv);
        }
    }

    public void addTVRelation(TopView topView, TVEntity tVEntity, TVEntity tVEntity2, DesignPartView designPartView) {
        if (topView == null && tVEntity != null && tVEntity2 != null && designPartView != null) {
            TVRelation tVRelation = new TVRelation(this.getDesign().getAppView(), designPartView);
            tVRelation.setModel(this);
            tVRelation.setSize(new Dimension(100, 100));
            this.addObjectListener(tVRelation);
            designPartView.registerForTreemodel(tVRelation);
            if (designPartView.isVisible() && !ApplicationView.loading) {
                tVRelation.addConnection();
            }
        }
    }

    public void addToAllDPVs() {
        DesignPartView designPartView;
        if (this.getTargetEntity() == null || this.getSourceEntity() == null) {
            return;
        }
        Collection collection = this.getTargetEntity().getAffectedDPVs();
        Collection collection2 = this.getSourceEntity().getAffectedDPVs();
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            designPartView = (DesignPartView)iterator.next();
            this.getTargetTV(designPartView);
        }
        while (iterator2.hasNext()) {
            designPartView = (DesignPartView)iterator2.next();
            this.getSourceTV(designPartView);
        }
    }

    public void clearSourceTV() {
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            dpvInfo2.sourceTV = null;
            if (dpvInfo2.tv == null) continue;
            ((TVRelation)dpvInfo2.tv).removeConnection();
            if (dpvInfo2.dpv != null) {
                dpvInfo2.dpv.unregisterFromTreemodel(dpvInfo2.tv);
            }
            dpvInfo2.tv = null;
        }
    }

    public void clearTargetTV() {
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            dpvInfo2.targetTV = null;
            if (dpvInfo2.tv == null) continue;
            ((TVRelation)dpvInfo2.tv).removeConnection();
            if (dpvInfo2.dpv != null) {
                dpvInfo2.dpv.unregisterFromTreemodel(dpvInfo2.tv);
            }
            dpvInfo2.tv = null;
        }
    }

    public TVEntity getSourceTVEntity() {
        DesignPartView designPartView = ApplicationView.loading ? this.getDesign().getLogicalDesign().getMainView() : this.getDesign().getAppView().getCurrentDPV();
        return this.getSourceTV(designPartView);
    }

    public TVEntity getTargetTVEntity() {
        DesignPartView designPartView = ApplicationView.loading ? this.getDesign().getLogicalDesign().getMainView() : this.getDesign().getAppView().getCurrentDPV();
        return this.getTargetTV(designPartView);
    }

    public TVEntity getSourceTV(DesignPartView designPartView) {
        Collection collection;
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.sourceTV == null && this.getSourceEntity() != null && !(collection = this.getSourceEntity().getAllViews(designPartView)).isEmpty()) {
            Iterator iterator = collection.iterator();
            dpvInfo2.sourceTV = (TVEntity)iterator.next();
            dpvInfo2.sourceTV.addTopViewListener(this);
            this.addTVRelation(dpvInfo2);
        }
        return dpvInfo2.sourceTV;
    }

    public TVEntity getTargetTV(DesignPartView designPartView) {
        Collection collection;
        dpvInfo dpvInfo2 = this.getDPVInfoFor(designPartView);
        if (dpvInfo2.targetTV == null && this.getTargetEntity() != null && !(collection = this.getTargetEntity().getAllViews(designPartView)).isEmpty()) {
            Iterator iterator = collection.iterator();
            dpvInfo2.targetTV = (TVEntity)iterator.next();
            dpvInfo2.targetTV.addTopViewListener(this);
            this.addTVRelation(dpvInfo2);
        }
        return dpvInfo2.targetTV;
    }

    public void callRemoveListeners() {
        ObjectChangeEvent objectChangeEvent = ObjectChangeEvent.OBJECT_REMOVED;
        objectChangeEvent.setAffected(this);
        this.fireChange(objectChangeEvent);
    }

    public void repairSelfReference() {
    }

    public boolean belongsToTargetPK() {
        return this.belongsToTargetPK;
    }

    public void setBelongsToTargetPK(boolean bl) {
        this.belongsToTargetPK = bl;
    }

    public boolean belongsToSourcePK() {
        return this.belongsToSourcePK;
    }

    public void setBelongsToSourcePK(boolean bl) {
        this.belongsToSourcePK = bl;
    }

    @Override
    public boolean isReadOnly() {
        if (this.getTargetEntity() != null && this.getTargetEntity().isReadOnly() || this.getSourceEntity() != null && this.getSourceEntity().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    @Override
    public boolean hasAliveGenerator() {
        TableSet tableSet;
        DesignObject designObject;
        FKIndexAssociationSet fKIndexAssociationSet = this.getDesign().getRelationalDesign().getFKIndexAssociationSet();
        return ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID()) || (designObject = fKIndexAssociationSet.getObjectByID(this.getGeneratorID())) != null || (tableSet = this.getDesign().getRelationalDesign().getTableSet()).getObjectByID(this.getGeneratorID()) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RelationPropertiesDialogEx relationPropertiesDialogEx = new RelationPropertiesDialogEx(this.getDesign().getAppView(), this);
            this.setShowForFirstTime(false);
            relationPropertiesDialogEx.initProperties(this);
            relationPropertiesDialogEx.show();
        }
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView designPartView) {
        return this.getViewFor(designPartView) != null;
    }

    @Override
    public boolean getShouldEngineer() {
        boolean bl = super.getShouldEngineer();
        return bl;
    }

    public void setFireCardinalityChange(boolean bl) {
        this.fireCardinalityChange = bl;
    }

    public Entity getDominantRole() {
        if (this.DOMINANT_ROLE == null) {
            return this.getNONEEntity();
        }
        return this.DOMINANT_ROLE;
    }

    public void setDominantRole(Entity entity) {
        if (entity == null) {
            this.DOMINANT_ROLE = this.getNONEEntity();
        }
        this.DOMINANT_ROLE = entity;
    }

    public Entity getNONEEntity() {
        this.NONE.setName(AbstractEditorConstants.NONE);
        return this.NONE;
    }

    public void setNONEEntity(Entity entity) {
        this.NONE = entity;
    }

    public Entity[] initDominatRole() {
        return new Entity[]{this.getNONEEntity(), this.getEntity(0), this.getEntity(1)};
    }

    public boolean isIdentifying() {
        return this.identifying;
    }

    public void setIdentifying(boolean bl) {
        this.identifying = bl;
        this.fireFK_AttributesChanged();
    }

    @Override
    public String getLongName() {
        return this.getName() + "(" + this.getObjectID() + ")";
    }

    @Override
    public String toString() {
        String string = this.getName() + " (";
        String string2 = this.isOptionalSource() ? "0" : "1";
        String string3 = this.getTargetCardinality().toString();
        string2 = string2 + ".." + string3;
        String string4 = this.isOptionalTarget() ? "0" : "1";
        string3 = this.getSourceCardinality().toString();
        string4 = string4 + ".." + string3;
        if (this.getSourceEntity() != null) {
            string = string + this.getSourceEntity().getName() + " - " + string2 + ":";
        }
        if (this.getTargetEntity() != null) {
            string = string + string4 + " - " + this.getTargetEntity().getName();
        }
        return string + ")";
    }

    @Override
    public boolean setName(String string) {
        boolean bl = super.setName(string);
        return bl;
    }

    public XtdMapping getDeletedMapping(String string) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, string);
        if (list.size() > 0) {
            XtdMapping xtdMapping = (XtdMapping)list.get(0);
            return xtdMapping;
        }
        return null;
    }

    public XtdMapping getDeletedMapping(String string, String string2) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, string);
        for (XtdMapping xtdMapping : list) {
            if (!string2.equals(xtdMapping.getDeletedID())) continue;
            return xtdMapping;
        }
        return null;
    }

    @Override
    public void setSourceTopView(TopView topView) {
        this.setSourceTV((TVEntity)topView);
    }

    @Override
    public void setTargetTopView(TopView topView) {
        this.setTargetTV((TVEntity)topView);
    }

    @Override
    public TopView getSourceTopView(DesignPartView designPartView) {
        return this.getSourceTV(designPartView);
    }

    @Override
    public TopView getTargetTopView(DesignPartView designPartView) {
        return this.getTargetTV(designPartView);
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView designPartView) {
        return this.getViewFor(designPartView);
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getSourceEntity();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getTargetEntity();
    }

    public Entity getOtherEntity(Entity entity) {
        if (entity == this.getSourceEntity()) {
            return this.getTargetEntity();
        }
        return this.getSourceEntity();
    }

    public FKIndexAssociation getEngFK(RelationalDesign relationalDesign, Table table) {
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                FKIndexAssociation fKIndexAssociation;
                XtdMapping xtdMapping = (XtdMapping)list.get(i);
                DesignObject designObject = xtdMapping.getObjectMappedTo(this);
                if (designObject == null || !(designObject instanceof FKIndexAssociation) || (fKIndexAssociation = (FKIndexAssociation)designObject).getContainerWithKeyObject() != table) continue;
                return fKIndexAssociation;
            }
        }
        return null;
    }

    public boolean isPKConsumer(Entity entity) {
        if (entity == this.getSourceEntity() || entity == this.getTargetEntity()) {
            int[] nArray = this.getPKProviderEndPoint();
            for (int i = 0; i < nArray.length; ++i) {
                if (this.getEntity(nArray[i]) == entity && this.getSourceEntity() != this.getTargetEntity()) continue;
                return true;
            }
        }
        return false;
    }

    void fireFK_AttributesChanged() {
        this.fireChange(ObjectChangeEvent.FK_ATTRIBUTES_CHANGED);
    }

    @Override
    public List getAllViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (dpvInfo dpvInfo2 : this.dpvCol) {
            if (dpvInfo2.tv == null) continue;
            arrayList.add(dpvInfo2.tv);
        }
        return arrayList;
    }

    @Override
    public void restoreTopView(TopView topView, TopView topView2, TopView topView3) {
        topView.getDesignPartView().restoreTopview(topView, this);
        dpvInfo dpvInfo2 = this.getDPVInfoFor(topView.getDesignPartView());
        if (dpvInfo2.tv == topView) {
            this.addObjectListener(topView);
            dpvInfo2.targetTV = (TVEntity)topView3;
            dpvInfo2.targetTV.addTopViewListener(this);
            dpvInfo2.sourceTV = (TVEntity)topView2;
            dpvInfo2.sourceTV.addTopViewListener(this);
        }
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    public Arc getArc() {
        return this.arc;
    }

    public void setArc(Arc arc) {
        this.arc = arc;
    }

    public boolean inArc() {
        return this.arc != null;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public void setTransferable(boolean bl) {
        this.transferable = bl;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "relation/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getSourceCardinalityString() {
        return this.getSourceCardinality().toString();
    }

    public void setSourceCardinalityString(String string) {
        if ("*".equals(string)) {
            this.setSourceCardinality(MANY_CARD);
        } else {
            this.setSourceCardinality(ONE_CARD);
        }
    }

    public String getTargetCardinalityString() {
        return this.getTargetCardinality().toString();
    }

    public void setTargetCardinalityString(String string) {
        if ("*".equals(string)) {
            this.setTargetCardinality(MANY_CARD);
        } else {
            this.setTargetCardinality(ONE_CARD);
        }
    }

    public boolean isSelfRefrence() {
        return this.getSourceEntity() == this.getTargetEntity();
    }

    public String getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(String string) {
        this.deleteRule = string;
    }

    public class dpvInfo {
        public TVEntity sourceTV;
        public TVEntity targetTV;
        public TopView tv;
        public DesignPartView dpv;

        dpvInfo() {
        }
    }

    public class TargetConnection
    extends Connection {
        @Override
        public Entity getEntity() {
            return Relation.this.getEntity(1);
        }

        @Override
        public Entity getOtherEntity() {
            return Relation.this.getEntity(0);
        }

        @Override
        public Cardinality getCardinality() {
            return Relation.this.getCardinality(1);
        }

        @Override
        public String getDescriptor() {
            return "Target";
        }

        @Override
        public Connection getOtherConnection() {
            return Relation.this.getSourceConnection();
        }

        @Override
        public boolean isSource() {
            return false;
        }
    }

    public class SourceConnection
    extends Connection {
        @Override
        public Entity getEntity() {
            return Relation.this.getEntity(0);
        }

        @Override
        public Entity getOtherEntity() {
            return Relation.this.getEntity(1);
        }

        @Override
        public Cardinality getCardinality() {
            return Relation.this.getCardinality(0);
        }

        @Override
        public String getDescriptor() {
            return "Source";
        }

        @Override
        public Connection getOtherConnection() {
            return Relation.this.getTargetConnection();
        }

        @Override
        public boolean isSource() {
            return true;
        }
    }

    public abstract class Connection {
        private Boolean optionality = Boolean.TRUE;
        private String nameOn = null;

        public Relation getRelation() {
            return Relation.this;
        }

        public abstract Entity getEntity();

        public abstract Entity getOtherEntity();

        public abstract Cardinality getCardinality();

        public abstract String getDescriptor();

        public abstract Connection getOtherConnection();

        public abstract boolean isSource();

        public String toString() {
            return Relation.this.getName() + this.getDescriptor();
        }

        public boolean isOneCardinality() {
            return this.getCardinality().getValue() == 1;
        }

        public boolean isOptional() {
            return this.optionality;
        }

        public void setOptional(boolean bl) {
            this.optionality = bl ? Boolean.TRUE : Boolean.FALSE;
        }

        public Boolean getOptionality() {
            return this.optionality;
        }

        public void setOptionality(Boolean bl) {
            this.optionality = bl == null ? Boolean.FALSE : bl;
        }

        public boolean isSingleEntityRelation() {
            return this.getEntity() == this.getOtherEntity();
        }

        public void setNameOn(String string) {
            this.nameOn = string;
        }

        public TopView getTopView() {
            return Relation.this.getTopView();
        }

        public String getNameOn() {
            return this.nameOn;
        }
    }

    public static class Cardinality {
        private int cardinality;
        private String representation;

        private Cardinality(int n) {
            this.cardinality = n;
            this.representation = String.valueOf(n);
        }

        private Cardinality(int n, String string) {
            this.cardinality = n;
            this.representation = string;
        }

        public String toString() {
            return this.representation;
        }

        public int getValue() {
            return this.cardinality;
        }
    }
}

