/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.FKAttributeManager;
import oracle.dbtools.crest.model.design.logical.InheritanceFKAttributeManager;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.logical.InheritanceRelationPropertiesDialogEx;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVInheritanceRelation;

public class InheritanceRelation
extends Relation {
    private FKAttributeManager fkAttributeManager = null;
    public static final String TYPE_NAME = "Hierarchy relation";

    public InheritanceRelation(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isInheritanceRelation() {
        return true;
    }

    @Override
    public void setEntity(int n, Entity entity) {
        super.setEntityInh(n, entity);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.getSourceEntity() != null) {
            this.getSourceEntity().setHierarchicalParent(null);
        }
        this.setTargetEntity(null);
        this.setSourceEntity(null);
    }

    @Override
    public FKAttributeManager getFKAttributeManager() {
        if (this.fkAttributeManager == null) {
            this.fkAttributeManager = new InheritanceFKAttributeManager(this);
        }
        return this.fkAttributeManager;
    }

    @Override
    public Object getSourceCardinality() {
        return "";
    }

    @Override
    public Object getTargetCardinality() {
        return "";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            InheritanceRelationPropertiesDialogEx inheritanceRelationPropertiesDialogEx = new InheritanceRelationPropertiesDialogEx(this.getDesign().getAppView(), this);
            inheritanceRelationPropertiesDialogEx.initProperties(this);
            inheritanceRelationPropertiesDialogEx.show();
        }
    }

    @Override
    public void addTVRelation(Relation.dpvInfo dpvInfo2) {
        if (dpvInfo2.tv == null && dpvInfo2.sourceTV != null && dpvInfo2.targetTV != null && dpvInfo2.dpv != null) {
            TVInheritanceRelation tVInheritanceRelation = new TVInheritanceRelation(this.getDesign().getAppView(), dpvInfo2.dpv);
            tVInheritanceRelation.setModel(this);
            tVInheritanceRelation.setSize(new Dimension(100, 100));
            this.addObjectListener(tVInheritanceRelation);
            dpvInfo2.dpv.registerForTreemodel(tVInheritanceRelation);
            if (dpvInfo2.dpv.isVisible() && !ApplicationView.loading) {
                tVInheritanceRelation.addConnection();
            }
        } else if (dpvInfo2.tv != null && dpvInfo2.sourceTV != null && dpvInfo2.targetTV != null && dpvInfo2.dpv != null && ((TVInheritanceRelation)dpvInfo2.tv).getEdge() == null && !ApplicationView.loading) {
            ((TVInheritanceRelation)dpvInfo2.tv).addConnection();
        }
    }

    @Override
    public void addTVRelation(TopView topView, TVEntity tVEntity, TVEntity tVEntity2, DesignPartView designPartView) {
        if (topView == null && tVEntity != null && tVEntity2 != null && designPartView != null) {
            TVInheritanceRelation tVInheritanceRelation = new TVInheritanceRelation(this.getDesign().getAppView(), designPartView);
            tVInheritanceRelation.setModel(this);
            tVInheritanceRelation.setSize(new Dimension(100, 100));
            this.addObjectListener(tVInheritanceRelation);
            designPartView.registerForTreemodel(tVInheritanceRelation);
            if (designPartView.isVisible() && !ApplicationView.loading) {
                tVInheritanceRelation.addConnection();
            }
        }
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("inheritance id prefix");
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "inheritance/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void setSourceEntity(Entity entity) {
        super.setSourceEntity(entity);
    }

    @Override
    public void setTargetEntity(Entity entity) {
        super.setTargetEntity(entity);
    }
}

