/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.SubsetCO;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.engineering.HierarchicalStrategy;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeSet;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.CandidateKeySet;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.InheritanceRelationSet;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.editor.logical.EntityPropertiesDialogEx;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class Entity
extends ContainerWithKeyObject
implements HierarchicalStrategy,
SetListener,
EditableFonts {
    private static final KeyObject[] KEY_PROTOTYPE = new CandidateKey[0];
    private List relationConnections = new ArrayList();
    private Entity hierarchicalParent = null;
    private List hierarchicalChildren = new ArrayList();
    private String fwdEngineeringStrategyName = "Single Table";
    private Relation inheritanceRelation;
    private KeyObjectSet allkeys;
    private DesignObjectCollection pkSet;
    private DesignObjectCollection unSet;
    private DesignObjectCollection inhSetParent;
    private DesignObjectCollection inhSetChild;
    private DesignObjectCollection relations;
    private Map referIDMap;
    private String synonym = "";
    private String owner = "";
    private String source = "";
    private String minVolumes = "0";
    private String expectedVolumes = "0";
    private String maxVolumes = "9999999";
    private int growthPercent = 0;
    private String growthType = GROWTH_TYPES[2];
    private String normalForm = NORMAL_FORMS[3];
    private String adequatelyNormalized = YES_NO_STATES[1];
    private String scope = "";
    public static final String[] GROWTH_TYPES = new String[]{"Day", "Month", "Year"};
    private static Set growthSet = null;
    public static final String[] NORMAL_FORMS = new String[]{"None", "First", "Second", "Third", "Fourth"};
    private static Set normalFormSet = null;
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private List arcs;
    private static final int ARC_SIZE_INDEX = 20;
    private List editableFonts;
    private String preferredAbbreviation = "";
    private List relationsList;
    private String synonymToDisplay = "";
    private String shortName = "";
    private String hierarchicalParentID = "";
    private Map foldedAttributesMap = new TreeMap();
    public static final String TYPE_NAME = "Entity";
    public static final Entity NULL_ENTITY = new NullEntity(null);

    public Entity(DesignPart designPart) {
        super(designPart);
        this.arcs = new ArrayList();
        this.initEditableFonts();
    }

    @Override
    public KeyObject[] getKeyArrayPrototype() {
        return KEY_PROTOTYPE;
    }

    @Override
    public Class getContainedClass() {
        return Attribute.class;
    }

    public AttributeSet getAttributeSet() {
        return this.getDesign().getLogicalDesign().getAttributeSet();
    }

    public List getAttributes() {
        return Arrays.asList(this.getElements());
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getAttributeSet();
    }

    public Attribute createAttribute() {
        return this.createAttribute(null);
    }

    public void initIndexFilters() {
        this.allkeys = this.getKeySet();
        this.pkSet = new DesignObjectCollection();
        this.unSet = new DesignObjectCollection();
        this.inhSetParent = new DesignObjectCollection();
        this.inhSetChild = new DesignObjectCollection();
        this.relations = new DesignObjectCollection();
        this.pkSet.setParent(this);
        this.pkSet.setDesign(this.getDesign());
        this.pkSet.setName(Messages.getString("Entity.PrimaryKeys"));
        this.unSet.setParent(this);
        this.unSet.setDesign(this.getDesign());
        this.unSet.setName(Messages.getString("Entity.AlternateKeys"));
        this.relations.setParent(this);
        this.relations.setDesign(this.getDesign());
        this.relations.setName(Messages.getString("Entity.Relations"));
        this.inhSetParent.setParent(this);
        this.inhSetParent.setDesign(this.getDesign());
        this.inhSetParent.setName(Messages.getString("Entity.InheritanceFromSupertype"));
        this.inhSetChild.setParent(this);
        this.inhSetChild.setDesign(this.getDesign());
        this.inhSetChild.setName(Messages.getString("Entity.InheritancesToSubtypes"));
        this.allkeys.addSetListener(this);
        this.unSet.setElementDescriptor(CandidateKey.class);
        this.pkSet.setElementDescriptor(CandidateKey.class);
        this.relations.setElementDescriptor(Relation.class);
        this.inhSetParent.setElementDescriptor(InheritanceRelation.class);
        this.inhSetChild.setElementDescriptor(InheritanceRelation.class);
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (designObject instanceof StructuredType) {
            super.changed(designObject, objectChangeEvent);
            return;
        }
        if (designObject instanceof CandidateKey) {
            if (objectChangeEvent == ObjectChangeEvent.KEY_CHANGED_TO_PK) {
                if (!this.pkSet.containsPlaceHolderFor(designObject)) {
                    this.pkSet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), designObject));
                }
                this.unSet.removePlaceHolderFor(designObject);
            } else if (objectChangeEvent == ObjectChangeEvent.KEY_CHANGED_NO_PK) {
                this.pkSet.removePlaceHolderFor(designObject);
            }
            if (objectChangeEvent == ObjectChangeEvent.PK_REMOVED) {
                if (!this.unSet.containsPlaceHolderFor(designObject)) {
                    this.unSet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), designObject));
                }
                this.pkSet.removePlaceHolderFor(designObject);
            }
            if (objectChangeEvent == ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE) {
                if (!this.unSet.containsPlaceHolderFor(designObject)) {
                    this.unSet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), designObject));
                }
                this.pkSet.removePlaceHolderFor(designObject);
            }
        } else if (designObject instanceof Arc && objectChangeEvent == ObjectChangeEvent.OBJECT_REMOVED) {
            this.removeArc((Arc)designObject);
        }
    }

    @Override
    public void changed(DesignObjectSet designObjectSet, SetEvent setEvent) {
        if (designObjectSet instanceof StructuredTypeSet) {
            super.changed(designObjectSet, setEvent);
            return;
        }
        if (setEvent == SetEvent.OBJECT_ADDED) {
            CandidateKey candidateKey = (CandidateKey)setEvent.getAffected();
            candidateKey.addObjectListener(this);
            if (candidateKey.isPK()) {
                this.pkSet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), candidateKey));
            } else {
                this.unSet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), candidateKey));
            }
        } else if (setEvent == SetEvent.OBJECT_REMOVED) {
            CandidateKey candidateKey = (CandidateKey)setEvent.getAffected();
            if (candidateKey.isPK()) {
                this.pkSet.removePlaceHolderFor(candidateKey);
                this.setPK(null);
            } else {
                this.unSet.removePlaceHolderFor(candidateKey);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 4;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n < super.getNumberOfChildren() - 1) {
            return super.getChild(n);
        }
        if (n == this.getNumberOfChildren() - 5) {
            return this.pkSet;
        }
        if (n == this.getNumberOfChildren() - 4) {
            return this.unSet;
        }
        if (n == this.getNumberOfChildren() - 3) {
            return this.relations;
        }
        if (n == this.getNumberOfChildren() - 2) {
            return this.inhSetParent;
        }
        return this.inhSetChild;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.pkSet) {
            return this.getNumberOfChildren() - 5;
        }
        if (modelObject == this.unSet) {
            return this.getNumberOfChildren() - 4;
        }
        if (modelObject == this.relations) {
            return this.getNumberOfChildren() - 3;
        }
        if (modelObject == this.inhSetParent) {
            return this.getNumberOfChildren() - 2;
        }
        if (modelObject == this.inhSetChild) {
            return this.getNumberOfChildren() - 1;
        }
        return super.getIndexForChild(modelObject);
    }

    public void addRelationToRelationCollections(Relation relation) {
        if (relation instanceof InheritanceRelation) {
            if (relation.getTargetEntity() == this) {
                this.inhSetParent.add(new DesignObjectPlaceHolder(this.getDesignPart(), relation));
            } else if (relation.getSourceEntity() == this) {
                this.inhSetChild.add(new DesignObjectPlaceHolder(this.getDesignPart(), relation));
            }
            return;
        }
        if (!this.relations.containsPlaceHolderFor(relation)) {
            this.relations.add(new DesignObjectPlaceHolder(this.getDesignPart(), relation));
        }
    }

    public void updateRelationStatus(Relation relation) {
        this.relations.removePlaceHolderFor(relation);
        this.addRelationToRelationCollections(relation);
    }

    public void removeRelationFromRelationCollections(Relation relation) {
        if (relation instanceof InheritanceRelation) {
            if (relation.getTargetEntity() == this) {
                this.inhSetParent.removePlaceHolderFor(relation);
            } else if (relation.getSourceEntity() == this) {
                this.inhSetChild.removePlaceHolderFor(relation);
            }
            this.fireChange(ObjectChangeEvent.ENTITY_IN_RELATION_REMOVED);
            return;
        }
        this.relations.removePlaceHolderFor(relation);
        this.fireChange(ObjectChangeEvent.ENTITY_IN_RELATION_REMOVED);
    }

    public void remove(boolean bl) {
        if (bl) {
            this.removeAllRelations();
        }
        this.clearViews();
        this.deleteAllArcs();
        super.remove();
    }

    @Override
    public void remove() {
        ArrayList arrayList = null;
        if (!this.getDesign().isClosing() && this.relations.size() > 0) {
            arrayList = new ArrayList();
            this.relations.addAllElementsTo(arrayList);
        }
        this.clearViews();
        this.deleteAllArcs();
        super.remove();
        if (arrayList != null) {
            for (Relation relation : arrayList) {
                relation.remove();
            }
        }
        this.relations.removeAll();
    }

    public Attribute createAttribute(String string) {
        Attribute attribute = new Attribute(this.getDesignPart());
        attribute.setDesign(this.getDesign());
        attribute.setContainer(this);
        this.getAttributeSet().add(attribute);
        this.add(attribute);
        if (string != null) {
            attribute.setName(string);
        }
        return attribute;
    }

    public Attribute recreateAttribute(String string) {
        Attribute attribute = new Attribute(this.getDesignPart());
        attribute.setObjectID(string);
        attribute.setDesign(this.getDesign());
        attribute.setContainer(this);
        this.getAttributeSet().add(attribute);
        this.add(attribute);
        return attribute;
    }

    @Override
    public ContainedObject createContainedObject(String string) {
        if (!this.isReadOnly()) {
            return this.recreateAttribute(string);
        }
        return null;
    }

    @Override
    public KeyObject createKeyObject(String string) {
        return this.createCandidateKey(string);
    }

    public CandidateKey createCandidateKey(String string) {
        CandidateKey candidateKey = new CandidateKey(this.getDesignPart());
        candidateKey.setObjectID(string);
        candidateKey.setDesign(this.getDesign());
        candidateKey.setContainerObject(this);
        candidateKey.setUnique(true);
        this.add(candidateKey);
        return candidateKey;
    }

    public CandidateKey createCandidateKeyNoAddToKeys(String string) {
        CandidateKey candidateKey = new CandidateKey(this.getDesignPart());
        candidateKey.setObjectID(string);
        candidateKey.setDesign(this.getDesign());
        candidateKey.setContainerObject(this);
        candidateKey.setUnique(true);
        return candidateKey;
    }

    public CandidateKey createCandidateKey() {
        return this.createCandidateKey(null);
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("entity id prefix");
    }

    void add(Relation.Connection connection) {
        this.relationConnections.add(connection);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_ADDED);
    }

    void remove(Relation.Connection connection) {
        this.relationConnections.remove(connection);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_REMOVED);
    }

    public Relation.Connection[] getRelationConnections() {
        return (Relation.Connection[])this.relationConnections.toArray(Relation.CONNECTION_PROTO_ARRAY);
    }

    public int getNumberOfRelationConnections() {
        return this.relationConnections.size();
    }

    public int getNumberOfNormalRelationConnections() {
        int n = this.getNumberOfRelationConnections();
        int n2 = this.getHierarchicalChildrenCount();
        int n3 = this.hasHierarchicalParent() ? 1 : 0;
        return n - n2 - n3;
    }

    @Override
    public int countRelationsWith(ContainerWithKeyObject containerWithKeyObject) {
        if (containerWithKeyObject != null && containerWithKeyObject instanceof Entity) {
            Entity entity = (Entity)containerWithKeyObject;
            int n = 0;
            Relation.Connection[] connectionArray = this.getRelationConnections();
            for (int i = 0; i < connectionArray.length; ++i) {
                if (!entity.equals(connectionArray[i].getOtherEntity())) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    public List getRelations() {
        this.relationsList = new ArrayList();
        Relation.Connection[] connectionArray = this.getRelationConnections();
        for (int i = 0; i < connectionArray.length; ++i) {
            Relation.Connection connection = connectionArray[i];
            Relation relation = connection.getRelation();
            if (this.relationsList.contains(relation)) continue;
            this.relationsList.add(relation);
        }
        return this.relationsList;
    }

    public Relation getRelationTo(Entity entity) {
        if (entity != null) {
            Relation.Connection[] connectionArray = this.getRelationConnections();
            for (int i = 0; i < connectionArray.length; ++i) {
                if (!entity.equals(connectionArray[i].getOtherEntity())) continue;
                return connectionArray[i].getRelation();
            }
        }
        return null;
    }

    public List getAllRelationsTo(Entity entity) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        if (entity != null) {
            Relation.Connection[] connectionArray = this.getRelationConnections();
            for (int i = 0; i < connectionArray.length; ++i) {
                if (!entity.equals(connectionArray[i].getOtherEntity())) continue;
                arrayList.add(connectionArray[i].getRelation());
            }
        }
        return arrayList;
    }

    @Override
    public int countRelations() {
        return this.getNumberOfRelationConnections();
    }

    public int getIndexOf(Relation.Connection connection) {
        return this.relationConnections.indexOf(connection);
    }

    @Override
    protected KeyObjectSet createKeySet() {
        return new CandidateKeySet(this.getDesignPart());
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setHierarchicalParent(Entity entity) {
        Object object;
        ObjectListener objectListener;
        if (entity instanceof NullEntity || entity == null) {
            entity = null;
            this.hierarchicalParentID = "";
        }
        if (this.hierarchicalParent != entity) {
            objectListener = this.hierarchicalParent;
            object = entity;
            if (entity != null) {
                this.hierarchicalParentID = entity.getObjectID();
            }
            if (!(object == this || object != null && this.isHierarchicalAncestorOf((Entity)object))) {
                if (objectListener != null) {
                    ((Entity)objectListener).removeHierarchicalChild(this);
                }
                this.hierarchicalParent = object;
                this.updateInheritanceRelation((Entity)objectListener, (Entity)object);
                if (object != null) {
                    ((Entity)object).addHierarchicalChild(this);
                }
                this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
            }
        }
        if ((objectListener = this.getFirstViewForDPV(this.getDesign().getAppView().getCurrentDPV())) == null) {
            objectListener = this.getTopView();
        }
        if ((object = ((TopView)objectListener).getCellView()) != null) {
            ((AbstractCellView)object).setNewBounds(((AbstractCellView)object).getBounds().getBounds());
        }
    }

    public void setHierarchicalParent(Entity entity, InheritanceRelation inheritanceRelation) {
        if (entity instanceof NullEntity) {
            entity = null;
        }
        if (this.hierarchicalParent != entity) {
            AbstractCellView abstractCellView;
            TopView topView;
            Entity entity2 = this.hierarchicalParent;
            Entity entity3 = entity;
            if (!(entity3 == this || entity3 != null && this.hasHierarchicalRelationWith(entity3))) {
                if (entity2 != null) {
                    entity2.removeHierarchicalChild(this);
                }
                this.hierarchicalParent = entity3;
                this.inheritanceRelation = inheritanceRelation;
                this.updateInheritanceRelation(entity2, entity3);
                if (entity3 != null) {
                    entity3.addHierarchicalChild(this);
                }
                this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
            }
            if ((topView = this.getFirstViewForDPV(this.getDesign().getAppView().getCurrentDPV())) == null) {
                topView = this.getTopView();
            }
            if ((abstractCellView = topView.getCellView()) != null) {
                abstractCellView.setNewBounds(abstractCellView.getBounds().getBounds());
            }
        }
    }

    protected void updateInheritanceRelation(Entity entity, Entity entity2) {
        if (entity2 == null) {
            if (this.inheritanceRelation != null) {
                this.inheritanceRelation.remove();
                this.inheritanceRelation = null;
            }
        } else if (entity != entity2) {
            if (this.inheritanceRelation == null) {
                this.inheritanceRelation = ((InheritanceRelationSet)this.getDesign().getLogicalDesign().getInheritanceRelationSet()).createRelation(null, entity2, this);
            } else {
                this.inheritanceRelation.setSourceEntity(entity2);
                this.inheritanceRelation.setSourceTV(this.inheritanceRelation.getSourceTVEntity());
            }
        }
    }

    public void setHierarchicalParentToNull() {
        this.inheritanceRelation = null;
        if (this.hierarchicalParent != null) {
            this.hierarchicalParent.removeHierarchicalChild(this);
            this.hierarchicalParent = null;
        }
    }

    public void joinInheritanceRelation(Relation relation, Entity entity) {
        if (relation instanceof InheritanceRelation) {
            this.inheritanceRelation = relation;
            this.hierarchicalParent = entity;
            this.hierarchicalParent.addHierarchicalChild(this);
        }
    }

    public Entity getHierarchicalParent() {
        return this.hierarchicalParent;
    }

    public void addHierarchicalChild(Entity entity) {
        this.hierarchicalChildren.add(entity);
    }

    public void removeHierarchicalChild(Entity entity) {
        this.hierarchicalChildren.remove(entity);
        if (this.inhSetChild.containsPlaceHolderFor(entity)) {
            this.inhSetChild.removePlaceHolderFor(entity);
        }
    }

    public boolean hasHierarchicalChildren() {
        return this.hierarchicalChildren.size() > 0;
    }

    public int getHierarchicalChildrenCount() {
        return this.hierarchicalChildren.size();
    }

    public Entity getHierarchicalChild(int n) {
        return (Entity)this.hierarchicalChildren.get(n);
    }

    public List getHierarchicalAttributes() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getElementsCollection());
        if (this.isHierarchicalEntityType()) {
            List list = this.getHierarchicalLeaves();
            for (Entity entity : list) {
                arrayList.addAll(entity.getElementsCollection());
            }
        }
        return arrayList;
    }

    public List getHierarchicalLeaves() {
        ArrayList arrayList = new ArrayList();
        if (this.isHierarchicalEntityType()) {
            this.addHiearachicalLeavesFor(this, arrayList);
        }
        return arrayList;
    }

    private void addHiearachicalLeavesFor(Entity entity, List list) {
        int n = entity.getHierarchicalChildrenCount();
        if (n == 0) {
            list.add(entity);
        } else {
            for (int i = 0; i < n; ++i) {
                Entity entity2 = entity.getHierarchicalChild(i);
                this.addHiearachicalLeavesFor(entity2, list);
            }
        }
    }

    public boolean isInheriting() {
        return this.hasHierarchicalParent();
    }

    public boolean hasHierarchicalParent() {
        return this.getHierarchicalParent() != null;
    }

    public boolean isHierarchicalRoot() {
        return !this.hasHierarchicalParent() && this.hasHierarchicalChildren();
    }

    public boolean isHierarchicalEntityType() {
        return this.isInheriting() || this.hasHierarchicalChildren();
    }

    public boolean isHierarchicalAncestorOf(Entity entity) {
        if (entity != null && entity.isHierarchicalEntityType()) {
            int n = this.getHierarchicalChildrenCount();
            for (int i = 0; i < n; ++i) {
                if (this.getHierarchicalChild(i) != entity && !this.getHierarchicalChild(i).isHierarchicalAncestorOf(entity)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean hasHierarchicalRelationWith(Entity entity) {
        if (entity != null && entity.isHierarchicalEntityType()) {
            Entity entity2 = this.getHierarchicalRoot();
            return entity2 == entity || entity2.isHierarchicalAncestorOf(entity);
        }
        return false;
    }

    @Override
    public Map getReferIDMap() {
        if (this.referIDMap == null) {
            this.referIDMap = new HashMap();
        }
        return this.referIDMap;
    }

    public Entity getHierarchicalRoot() {
        if (this.getHierarchicalParent() != null) {
            return this.getHierarchicalParent().getHierarchicalRoot();
        }
        return this;
    }

    public boolean hasHierarchicalPK() {
        return this.hasPK() || this.hasHierarchicalParent() && this.getHierarchicalParent().hasHierarchicalPK();
    }

    public boolean hasHierarchicalFK() {
        return this.hasUnique() || this.hasHierarchicalParent() && this.getHierarchicalParent().hasHierarchicalFK();
    }

    public KeyObject getHierarchicalPK() {
        if (this.hasPK()) {
            return this.getPK();
        }
        if (this.hasHierarchicalPK()) {
            return this.getHierarchicalParent().getHierarchicalPK();
        }
        return null;
    }

    public KeyObject getHierarchicalFK() {
        if (this.getFirstFK() != null) {
            return this.getFirstFK();
        }
        if (this.hasHierarchicalParent()) {
            return this.getHierarchicalParent().getHierarchicalFK();
        }
        return null;
    }

    public List getAllElementsList() {
        if (this.isInheriting()) {
            List list = this.getHierarchicalParent().getAllElementsList();
            list.addAll(Arrays.asList(this.getElements()));
            return list;
        }
        ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
        arrayList.addAll(Arrays.asList(this.getElements()));
        return arrayList;
    }

    public String getFwdEngineeringStrategyName() {
        if (this.isInheriting()) {
            return this.getHierarchicalParent().getFwdEngineeringStrategyName();
        }
        return this.fwdEngineeringStrategyName;
    }

    public void setFwdEngineeringStrategyName(String string) {
        if (this.isInheriting()) {
            this.getHierarchicalParent().setFwdEngineeringStrategyName(string);
            return;
        }
        if (!this.fwdEngineeringStrategyName.equals(string)) {
            this.fwdEngineeringStrategyName = string;
            this.setDirty(true);
        }
    }

    public void applyEngineeringStrategyToHierarchy(String string) {
        Entity entity = this.getHierarchicalRoot();
        if (entity != null) {
            entity.setFwdEngineeringStrategyName(string);
            entity.applyEngineeringStrategyToChilds(string);
        } else {
            this.setFwdEngineeringStrategyName(string);
            this.applyEngineeringStrategyToChilds(string);
        }
    }

    private void applyEngineeringStrategyToChilds(String string) {
        int n = this.getHierarchicalChildrenCount();
        for (int i = 0; i < n; ++i) {
            Entity entity = this.getHierarchicalChild(i);
            if (entity == null) continue;
            entity.setFwdEngineeringStrategyName(string);
            entity.applyEngineeringStrategyToChilds(string);
        }
    }

    public Attribute getFKAttributeByDelegateGenerator(String string) {
        for (Attribute attribute : this.getElementsCollection()) {
            if (!attribute.isFKAttribute() || !string.equals(attribute.getDelegate().getGeneratorID())) continue;
            return attribute;
        }
        return null;
    }

    public Attribute getAttributeReferingDelegate(String string) {
        for (Attribute attribute : this.getElementsCollection()) {
            String string2 = attribute.getReferedAttribute();
            if (string2 == null || !string2.equals(string)) continue;
            return attribute;
        }
        return null;
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String string) {
        if (!this.synonym.equals(string)) {
            this.synonym = string;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    private boolean checkGrowth(String string) {
        if (growthSet == null) {
            growthSet = new HashSet();
            growthSet.addAll(Arrays.asList(GROWTH_TYPES));
        }
        return growthSet.contains(string);
    }

    private boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(string);
    }

    private boolean checkNormalForm(String string) {
        if (normalFormSet == null) {
            normalFormSet = new HashSet();
            normalFormSet.addAll(Arrays.asList(NORMAL_FORMS));
        }
        return normalFormSet.contains(string);
    }

    public String getAdequatelyNormalized() {
        return this.adequatelyNormalized;
    }

    public void setAdequatelyNormalized(String string) {
        if (this.checkYesNo(string)) {
            this.adequatelyNormalized = string;
        }
    }

    public String getExpectedVolumes() {
        return this.expectedVolumes;
    }

    public void setExpectedVolumes(String string) {
        try {
            if (string != null) {
                this.expectedVolumes = string;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getGrowthPercent() {
        return Integer.toString(this.growthPercent);
    }

    public int getGrowthPercentInt() {
        return this.growthPercent;
    }

    public void setGrowthPercent(String string) {
        try {
            this.growthPercent = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getGrowthType() {
        return this.growthType;
    }

    public void setGrowthType(String string) {
        if (this.checkGrowth(string)) {
            this.growthType = string;
        }
    }

    public String getMaxVolumes() {
        return this.maxVolumes;
    }

    public void setMaxVolumes(String string) {
        try {
            if (string != null) {
                this.maxVolumes = string;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getMinVolumes() {
        return this.minVolumes;
    }

    public void setMinVolumes(String string) {
        try {
            if (string != null) {
                this.minVolumes = string;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getNormalForm() {
        return this.normalForm;
    }

    public void setNormalForm(String string) {
        if (this.checkNormalForm(string)) {
            this.normalForm = string;
        }
    }

    @Override
    public boolean hasAliveGenerator() {
        DesignObject designObject;
        TableSet tableSet = this.getDesign().getRelationalDesign().getTableSet();
        return ModelIDObject.USER_GENERATED.equalsIgnoreCase(this.getGeneratorID()) || (designObject = tableSet.getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            EntityPropertiesDialogEx entityPropertiesDialogEx = new EntityPropertiesDialogEx(this.getDesign().getAppView(), this);
            entityPropertiesDialogEx.initProperties(this);
            entityPropertiesDialogEx.show();
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        if (string != null && string.equals(this.scope)) {
            return;
        }
        this.scope = string;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public boolean canPaste() {
        for (Object e : this.getAppView().getCopiedObjects()) {
            if (e == null || !(e instanceof Attribute)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void copy(DesignObject designObject) {
        DesignObject designObject2;
        DesignObject designObject3;
        Entity entity = (Entity)designObject;
        super.copy(entity);
        entity.setOwner(this.getOwner());
        entity.setSynonym(this.getSynonym());
        entity.setFwdEngineeringStrategyName(this.getFwdEngineeringStrategyName());
        entity.setHierarchicalParent(this.getHierarchicalParent());
        entity.setSource(this.getSource());
        entity.setTypeID(this.getTypeID());
        entity.setScope(this.getScope());
        entity.setBasedOnStructuredType(this.getBasedOnStructuredType());
        entity.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
        entity.setMinVolumes(this.getMinVolumes());
        entity.setExpectedVolumes(this.getExpectedVolumes());
        entity.setMaxVolumes(this.getMaxVolumes());
        entity.setGrowthPercent(this.getGrowthPercent());
        entity.setGrowthType(this.getGrowthType());
        entity.setNormalForm(this.getNormalForm());
        entity.setAdequatelyNormalized(this.getAdequatelyNormalized());
        entity.setShortName(this.getShortName());
        if (!this.isBST()) {
            ContainedObject[] containedObjectArray = this.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                designObject3 = (Attribute)containedObjectArray[i];
                designObject2 = entity.createAttribute();
                ((Attribute)designObject3).copy(designObject2);
            }
        }
        for (int i = 0; i < this.getKeySet().size(); ++i) {
            designObject2 = (KeyObject)this.getKeySet().getElement(i);
            if (((KeyObject)designObject2).isFK()) continue;
            designObject3 = null;
            if (((KeyObject)designObject2).isOidKey()) {
                designObject3 = entity.getOidKey();
            }
            if (designObject3 == null) {
                designObject3 = entity.createKeyObject();
            }
            ((KeyObject)designObject2).copy(designObject3);
            ((SubsetCO)designObject3).setContainerObject(entity);
            ContainedObject[] containedObjectArray = ((ContainerObject)designObject2).getElements();
            for (int j = 0; j < containedObjectArray.length; ++j) {
                Attribute attribute = (Attribute)entity.getElementByName(containedObjectArray[j].getName());
                ((SubsetCO)designObject3).add(attribute);
            }
            if (!(designObject2 instanceof CandidateKey)) continue;
            ((CandidateKey)designObject3).setKeyState(((CandidateKey)designObject2).getKeyState());
        }
        entity.setPKName(this.getPKName());
    }

    public void copyEntityWithoutInhRel(DesignObject designObject) {
        DesignObject designObject2;
        DesignObject designObject3;
        Entity entity = (Entity)designObject;
        super.copy(entity);
        entity.setOwner(this.getOwner());
        entity.setSynonym(this.getSynonym());
        entity.setFwdEngineeringStrategyName(this.getFwdEngineeringStrategyName());
        entity.setSource(this.getSource());
        entity.setTypeID(this.getTypeID());
        entity.setScope(this.getScope());
        entity.setBasedOnStructuredType(this.getBasedOnStructuredType());
        entity.setMinVolumes(this.getMinVolumes());
        entity.setExpectedVolumes(this.getExpectedVolumes());
        entity.setMaxVolumes(this.getMaxVolumes());
        entity.setGrowthPercent(this.getGrowthPercent());
        entity.setGrowthType(this.getGrowthType());
        entity.setNormalForm(this.getNormalForm());
        entity.setAdequatelyNormalized(this.getAdequatelyNormalized());
        if (!this.isBST()) {
            ContainedObject[] containedObjectArray = this.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                designObject3 = (Attribute)containedObjectArray[i];
                designObject2 = entity.createAttribute();
                ((Attribute)designObject3).copy(designObject2);
            }
        }
        for (int i = 0; i < this.getKeySet().size(); ++i) {
            designObject2 = (KeyObject)this.getKeySet().getElement(i);
            if (((KeyObject)designObject2).isFK()) continue;
            designObject3 = null;
            if (((KeyObject)designObject2).isOidKey()) {
                designObject3 = entity.getOidKey();
            }
            if (designObject3 == null) {
                designObject3 = entity.createKeyObject();
            }
            ((KeyObject)designObject2).copy(designObject3);
            ((SubsetCO)designObject3).setContainerObject(entity);
            ContainedObject[] containedObjectArray = ((ContainerObject)designObject2).getElements();
            for (int j = 0; j < containedObjectArray.length; ++j) {
                Attribute attribute = (Attribute)entity.getElementByName(containedObjectArray[j].getName());
                ((SubsetCO)designObject3).add(attribute);
            }
            if (!(designObject2 instanceof CandidateKey)) continue;
            ((CandidateKey)designObject3).setKeyState(((CandidateKey)designObject2).getKeyState());
        }
        entity.setPKName(this.getPKName());
    }

    public void importEntity(Entity entity) {
        DesignObject designObject;
        DesignObject designObject2;
        int n;
        super.copy(entity);
        entity.setOwner(this.getOwner());
        entity.setSynonym(this.getSynonym());
        entity.setFwdEngineeringStrategyName(this.getFwdEngineeringStrategyName());
        entity.setHierarchicalParent(this.getHierarchicalParent());
        entity.setSource(this.getSource());
        entity.setTypeID(this.getTypeID());
        entity.setScope(this.getScope());
        entity.setBasedOnStructuredType(this.getBasedOnStructuredType());
        entity.setMinVolumes(this.getMinVolumes());
        entity.setExpectedVolumes(this.getExpectedVolumes());
        entity.setMaxVolumes(this.getMaxVolumes());
        entity.setGrowthPercent(this.getGrowthPercent());
        entity.setGrowthType(this.getGrowthType());
        entity.setNormalForm(this.getNormalForm());
        entity.setAdequatelyNormalized(this.getAdequatelyNormalized());
        if (!this.isBST()) {
            for (n = 0; n < this.getElements().length; ++n) {
                designObject2 = (Attribute)this.getElements()[n];
                designObject = entity.createAttribute();
                ((Attribute)designObject2).importAttribute(designObject);
            }
        }
        for (n = 0; n < this.getKeySet().size(); ++n) {
            designObject = (KeyObject)this.getKeySet().getElement(n);
            if (((KeyObject)designObject).isFK()) continue;
            designObject2 = entity.createKeyObject();
            ((KeyObject)designObject).copy(designObject2);
            ((SubsetCO)designObject2).setContainerObject(entity);
            ContainedObject[] containedObjectArray = ((ContainerObject)designObject).getElements();
            block2: for (int i = 0; i < containedObjectArray.length; ++i) {
                ContainedObject[] containedObjectArray2 = entity.getElements();
                for (int j = 0; j < containedObjectArray2.length; ++j) {
                    if (containedObjectArray2[j].getImportedId() == null || !containedObjectArray2[j].getImportedId().equalsIgnoreCase(containedObjectArray[i].getObjectID())) continue;
                    ((SubsetCO)designObject2).add(containedObjectArray2[j]);
                    continue block2;
                }
            }
            if (designObject instanceof CandidateKey) {
                ((CandidateKey)designObject2).setKeyState(((CandidateKey)designObject).getKeyState());
            }
            designObject2.setImportedId(designObject.getObjectID());
            designObject2.setImportedDesign(designObject.getDesign());
        }
        entity.setPKName(this.getPKName());
    }

    @Override
    public void paste() {
        for (Object e : this.getAppView().getCopiedObjects()) {
            if (e == null || !(e instanceof Attribute)) continue;
            Attribute attribute = this.createAttribute();
            Attribute attribute2 = (Attribute)e;
            attribute2.copy(attribute);
        }
    }

    public Attribute getAttributeForDelegate(Attribute attribute, Relation relation) {
        for (Attribute attribute2 : this.getElementsCollection()) {
            if (attribute2.getDelegateElement() != attribute || !relation.getObjectID().equals(attribute2.getGeneratorID())) continue;
            return attribute2;
        }
        return null;
    }

    public Attribute getAttributeForDelegate(Attribute attribute) {
        for (Attribute attribute2 : this.getElementsCollection()) {
            if (attribute2.getDelegateElement() != attribute) continue;
            return attribute2;
        }
        return null;
    }

    public Table getEngTable(RelationalDesign relationalDesign) {
        RepositoryObject repositoryObject;
        Table table;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
        if (list.size() > 0 && (table = (Table)((XtdMapping)(repositoryObject = (XtdMapping)list.get(0))).getObjectMappedTo(this)) != null) {
            return table;
        }
        repositoryObject = (Table)relationalDesign.getTableSet().getObjectByID(this.getGeneratorID());
        if (repositoryObject != null && ((DesignObject)repositoryObject).getDesignPart() == relationalDesign) {
            return repositoryObject;
        }
        repositoryObject = (Table)relationalDesign.getTableSet().getObjectGeneratedBy(this.getObjectID());
        return repositoryObject;
    }

    public List getEngTables(RelationalDesign relationalDesign) {
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
        for (XtdMapping xtdMapping : list) {
            DesignObject designObject = xtdMapping.getObjectMappedTo(this);
            if (designObject == null || !(designObject instanceof Table)) continue;
            arrayList.add(xtdMapping);
        }
        return arrayList;
    }

    public List getAllMappedtables() {
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
            for (XtdMapping xtdMapping : list) {
                DesignObject designObject = xtdMapping.getObjectMappedTo(this);
                if (designObject == null || !(designObject instanceof Table)) continue;
                arrayList.add(designObject);
            }
        }
        return arrayList;
    }

    public XtdMapping getMappingFor(Table table) {
        RelationalDesign relationalDesign = (RelationalDesign)table.getDesignPart();
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
        for (int i = 0; i < list.size(); ++i) {
            XtdMapping xtdMapping = (XtdMapping)list.get(i);
            DesignObject designObject = xtdMapping.getObjectMappedTo(this);
            if (designObject == null || designObject != table) continue;
            return xtdMapping;
        }
        return null;
    }

    @Override
    protected void clearStructure() {
        this.removeAllRelations();
        this.removeAllKeys();
        this.removeAll();
    }

    private void removeAllRelations() {
        for (Relation relation : this.getDesign().getLogicalDesign().getRelationSet().getRelationsTo(this)) {
            relation.remove();
        }
        for (Relation relation : this.getDesign().getLogicalDesign().getInheritanceRelationSet().getRelationsTo(this)) {
            relation.remove();
        }
    }

    @Override
    protected void updateStructure() {
        if (this.isBST()) {
            TypeElement typeElement;
            int n;
            StructuredType structuredType = this.getBasedOnStructuredType();
            List list = structuredType.getAllElements();
            ContainedObject[] containedObjectArray = this.getElements();
            for (n = 0; n < containedObjectArray.length; ++n) {
                if (containedObjectArray[n].isOid() || (typeElement = this.findTypeElement(list, containedObjectArray[n].getStructAttributeID())) != null) continue;
                containedObjectArray[n].remove();
            }
            this.addOidAttribute();
            this.updateElements(list);
            for (n = 0; n < list.size(); ++n) {
                typeElement = (TypeElement)list.get(n);
                ContainedObject containedObject = this.getElementByStructAttributeID(typeElement.getObjectID());
                if (containedObject == null) continue;
                this.moveToIndex(containedObject, n + 1);
            }
        }
    }

    public void createNestedAttributes(TypeElement typeElement, Attribute attribute) throws StackOverflowError {
        if (typeElement.getType() instanceof StructuredType && !typeElement.isReference()) {
            StructuredType structuredType = (StructuredType)typeElement.getType();
            TypeElement[] typeElementArray = structuredType.getElements();
            for (int i = 0; i < typeElementArray.length; ++i) {
                TypeElement typeElement2 = typeElementArray[i];
                Attribute attribute2 = (Attribute)this.getElementByStructAttributeID(typeElement2.getObjectID());
                if (attribute2 == null) {
                    attribute2 = this.createNestedAttribute(typeElement.getName(), attribute);
                    attribute2.setStructAttributeID(typeElement2.getObjectID());
                }
                this.copyTEtoColumn(typeElement2, attribute2);
                this.createNestedAttributes(typeElement2, attribute2);
            }
        }
    }

    public Attribute createNestedAttribute(String string, Attribute attribute) {
        Attribute attribute2 = new Attribute(this.getDesignPart());
        attribute2.setDesign(this.getDesign());
        attribute2.setContainer(this);
        attribute2.setParentObject(attribute);
        this.getAttributeSet().add(attribute2);
        this.add(attribute2);
        if (string != null) {
            attribute2.setName(string);
        }
        return attribute2;
    }

    private void copyTEtoColumn(TypeElement typeElement, Attribute attribute) {
        attribute.setName(typeElement.getName());
        if (typeElement.getType() instanceof LogicalDatatype) {
            attribute.setUse((short)1);
            attribute.setLogicalDatatype((LogicalDatatype)typeElement.getType());
            attribute.setReference(false);
            attribute.setDataTypeParameter("size", typeElement.getSize());
            attribute.setDataTypeParameter("precision", Integer.toString(typeElement.getPrecision()));
            attribute.setDataTypeParameter("scale", Integer.toString(typeElement.getScale()));
        } else if (typeElement.getType() instanceof DistinctType) {
            attribute.setUse((short)2);
            attribute.setDistinctType((DistinctType)typeElement.getType());
            attribute.setReference(false);
        } else if (typeElement.getType() instanceof StructuredType) {
            attribute.setUse((short)3);
            attribute.setStructuredType((StructuredType)typeElement.getType());
            attribute.setReference(typeElement.isReference());
        }
    }

    private TypeElement findTypeElement(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            TypeElement typeElement = (TypeElement)list.get(i);
            if (!typeElement.getObjectID().equalsIgnoreCase(string)) continue;
            return typeElement;
        }
        return null;
    }

    private void addOidAttribute() {
        if (this.getElementsCollection().size() == 0) {
            Attribute attribute = new Attribute(this.getDesignPart());
            attribute.setName(Messages.getString("Entity.Oid"));
            attribute.setOid(true);
            attribute.setUse((short)1);
            attribute.setUse((short)3);
            attribute.setStructuredType(this.getBasedOnStructuredType());
            attribute.setReference(true);
            attribute.setDesign(this.getDesign());
            attribute.setContainer(this);
            attribute.setNullsAllowed(false);
            this.add(attribute);
            this.getDesign().getLogicalDesign().getAttributeSet().add(attribute);
            CandidateKey candidateKey = this.createCandidateKey();
            candidateKey.setPK(true);
            candidateKey.add(attribute);
            candidateKey.setName("Oid_PK_" + this.getName());
            candidateKey.setOidKey(true);
        }
    }

    private void updateElements(List list) {
        for (int i = 0; i < list.size(); ++i) {
            TypeElement typeElement = (TypeElement)list.get(i);
            Attribute attribute = (Attribute)this.getElementByStructAttributeID(typeElement.getObjectID());
            if (attribute == null) {
                attribute = new Attribute(this.getDesignPart());
                attribute.setName(typeElement.getName());
                attribute.setStructAttributeID(typeElement.getObjectID());
                attribute.setDesign(this.getDesign());
                attribute.setContainer(this);
                this.add(attribute);
                this.getAttributeSet().add(attribute);
            }
            this.copyTEtoAttribute(typeElement, attribute);
        }
    }

    private void copyTEtoAttribute(TypeElement typeElement, Attribute attribute) {
        attribute.setName(typeElement.getName());
        if (typeElement.getType() instanceof LogicalDatatype) {
            attribute.setUse((short)1);
            attribute.setLogicalDatatype((LogicalDatatype)typeElement.getType());
            attribute.setReference(false);
            String string = typeElement.getUnits();
            if (string != null && !"".equals(string) && !typeElement.getSize().equals("")) {
                attribute.setDataTypeParameter("size", typeElement.getSize() + " " + string);
            } else {
                attribute.setDataTypeParameter("size", typeElement.getSize());
            }
            attribute.setDataTypeParameter("precision", Integer.toString(typeElement.getPrecision()));
            attribute.setDataTypeParameter("scale", Integer.toString(typeElement.getScale()));
        } else if (typeElement.getType() instanceof DistinctType) {
            attribute.setUse((short)2);
            attribute.setDistinctType((DistinctType)typeElement.getType());
            attribute.setReference(false);
        } else if (typeElement.getType() instanceof StructuredType) {
            attribute.setUse((short)3);
            attribute.setStructuredType((StructuredType)typeElement.getType());
            attribute.setReference(typeElement.isReference());
        } else if (typeElement.getType() instanceof Domain) {
            Domain domain = (Domain)typeElement.getType();
            attribute.setUse((short)0);
            attribute.setDomain(domain);
            attribute.setReference(false);
            attribute.setDataTypeParameter("size", domain.getSize());
            attribute.setDataTypeParameter("precision", domain.getPrecision());
            attribute.setDataTypeParameter("scale", domain.getScale());
        }
        attribute.setNullsAllowed(!typeElement.isMandatory());
    }

    public Attribute getExactRefToStructurtedType(StructuredType structuredType, Entity entity) {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Attribute attribute = (Attribute)entity.getOidElement();
        String string = attribute.getObjectID();
        if (attribute != null) {
            Object object;
            for (Attribute attribute2 : this.getElementsCollection()) {
                if (!attribute2.isExactRefToStructuredType(structuredType)) continue;
                if (attribute2.getScopeId() != null && (object = (ContainerWithKeyObject)this.getDesign().getDesignObject(attribute2.getScopeId())) != null && ((ContainerObject)object).isBST() && ((ContainerObject)object).getBasedOnStructuredType() == structuredType) {
                    String string2 = attribute2.getReferedAttribute();
                    if (object == entity && string.equalsIgnoreCase(string2)) {
                        return attribute2;
                    }
                }
                arrayList.add(attribute2);
            }
            for (Attribute attribute2 : arrayList) {
                object = attribute2.getReferedAttribute();
                if (attribute2.getScopeId() != null || !string.equalsIgnoreCase((String)object)) continue;
                return attribute2;
            }
            for (Attribute attribute2 : arrayList) {
                if (attribute2.getScopeId() != null || arrayList.size() != 1) continue;
                attribute2.setReferedAttribute(string);
                return attribute2;
            }
            for (Attribute attribute2 : arrayList) {
                if (arrayList.size() != 1) continue;
                attribute2.setReferedAttribute(string);
                return attribute2;
            }
        }
        return null;
    }

    public Attribute getRefToStructurtedType(StructuredType structuredType, Entity entity) {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Attribute attribute = (Attribute)entity.getOidElement();
        if (attribute != null) {
            Object object;
            String string = attribute.getObjectID();
            for (Attribute attribute2 : this.getElementsCollection()) {
                if (!attribute2.isRefToStructuredType(structuredType)) continue;
                if (attribute2.getScopeId() != null && (object = (ContainerWithKeyObject)this.getDesign().getDesignObject(attribute2.getScopeId())) != null && ((ContainerObject)object).isBST() && ((ContainerObject)object).getBasedOnStructuredType() == structuredType) {
                    String string2 = attribute2.getReferedAttribute();
                    if (object == entity && string.equalsIgnoreCase(string2)) {
                        return attribute2;
                    }
                }
                arrayList.add(attribute2);
            }
            for (Attribute attribute2 : arrayList) {
                object = attribute2.getReferedAttribute();
                if (attribute2.getScopeId() != null || !string.equalsIgnoreCase((String)object)) continue;
                return attribute2;
            }
            for (Attribute attribute2 : arrayList) {
                if (attribute2.getScopeId() != null) continue;
                return attribute2;
            }
        }
        return null;
    }

    public Attribute createRefToStructuredType(StructuredType structuredType, Relation relation) {
        Entity entity = null;
        if (relation.getSourceEntity() == this) {
            entity = relation.getTargetEntity();
        } else if (relation.getTargetEntity() == this) {
            entity = relation.getSourceEntity();
        }
        Attribute attribute = new Attribute(this.getDesignPart());
        attribute.setDesign(this.getDesign());
        attribute.setContainer(this);
        attribute.setUse((short)3);
        attribute.setStructuredType(structuredType);
        attribute.setReference(true);
        attribute.setGeneratorID(relation.getObjectID());
        if (entity != null) {
            attribute.setScopeId(entity.getObjectID());
            Attribute attribute2 = (Attribute)entity.getOidElement();
            if (attribute2 != null && entity.isBST() && structuredType.isParentOf(structuredType)) {
                attribute.setReferedAttribute(attribute2.getObjectID());
            }
        }
        this.add(attribute);
        return attribute;
    }

    public Attribute findBestMatchForFKattr(Attribute attribute, List list) {
        if (!attribute.isReference() && !(attribute.getDataType() instanceof StructuredType)) {
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            String string = attribute.getObjectID();
            String string2 = attribute.getDataType().toString();
            String string3 = attribute.getName();
            for (Attribute attribute2 : this.getElementsCollection()) {
                if (attribute2.isOid() || list.contains(attribute2)) continue;
                if (string.equalsIgnoreCase(attribute2.getReferedAttribute())) {
                    return attribute2;
                }
                if (attribute2.isReference() || attribute2.getDataType() instanceof StructuredType || attribute2.isFKAttribute() || !attribute2.getDataType().toString().equalsIgnoreCase(string2)) continue;
                arrayList.add(attribute2);
            }
            for (Attribute attribute2 : arrayList) {
                if (!string3.equalsIgnoreCase(attribute2.getName())) continue;
                return attribute2;
            }
            for (Attribute attribute2 : arrayList) {
                if (attribute2.getName().indexOf(string3) <= -1) continue;
                return attribute2;
            }
            for (Attribute attribute2 : arrayList) {
                if (attribute2.getName().toUpperCase().indexOf(string3.toUpperCase()) <= -1) continue;
                return attribute2;
            }
            if (arrayList.size() > 0) {
                return (Attribute)arrayList.get(0);
            }
        }
        return null;
    }

    public Relation getInheritanceRelation() {
        return this.inheritanceRelation;
    }

    public XtdMapping getDeletedMapping(String string) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, string);
        if (list.size() > 0) {
            XtdMapping xtdMapping = (XtdMapping)list.get(0);
            return xtdMapping;
        }
        return null;
    }

    @Override
    public void setShouldEngineer(boolean bl) {
        super.setShouldEngineer(bl);
    }

    @Override
    public boolean getShouldEngineer() {
        return super.getShouldEngineer();
    }

    public void addArc(Arc arc) {
        if (!this.arcExists(arc)) {
            this.arcs.add(arc);
            arc.setEntity(this);
            arc.addObjectListener(this);
            this.updateArcSizeIndexes();
        }
    }

    public boolean arcExists(Arc arc) {
        if (this.arcs.contains(arc)) {
            return true;
        }
        for (Arc arc2 : this.arcs) {
            if (arc2.getRelations().size() != arc.getRelations().size() || !arc2.getRelations().containsAll(arc.getRelations())) continue;
            return true;
        }
        return false;
    }

    public boolean arcExists(List list) {
        for (Arc arc : this.arcs) {
            if (!arc.getRelations().containsAll(list)) continue;
            return true;
        }
        return false;
    }

    public void removeArc(Arc arc) {
        this.arcs.remove(arc);
        arc.removeObjectListener(this);
        this.updateArcSizeIndexes();
    }

    public void deleteAllArcs() {
        Object[] objectArray = this.arcs.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            Arc arc = (Arc)objectArray[i];
            arc.remove();
        }
    }

    public List getArcs() {
        return this.arcs;
    }

    public void clearArcs() {
        this.arcs.clear();
    }

    private void updateArcSizeIndexes() {
        Object[] objectArray = this.arcs.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Arc arc = (Arc)objectArray[i];
            arc.setSizeIndex((i + 1) * 20);
        }
    }

    public boolean inArc(Relation relation) {
        for (Arc arc : this.arcs) {
            if (!arc.containsRelation(relation)) continue;
            return true;
        }
        return false;
    }

    public void showArcs(boolean bl) {
        for (Arc arc : this.arcs) {
            arc.setVisible(bl);
            if (bl) {
                this.getDesignPart().getMainView().getWorkSpace().addArc(arc, new Rectangle());
                continue;
            }
            this.getDesignPart().getMainView().getWorkSpace().removeArc(arc);
        }
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && this.getDesignPart().getAppView() != null && (defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.resetAllTopViewsCustomFormat();
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
            this.setUseDefaultColor(true);
        } else if (DefaultFontAndColor.isModified(TYPE_NAME)) {
            DefaultFontAndColor defaultFontAndColor = this.getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME);
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
            this.setUseDefaultColor(bl);
        }
    }

    public boolean hasFKPathTo(Entity entity) {
        ArrayList arrayList = new ArrayList();
        return this.hasFKPathTo(entity, arrayList);
    }

    private boolean hasFKPathTo(Entity entity, List list) {
        if (this == entity) {
            return true;
        }
        list.add(this);
        KeyObject keyObject = this.getPK();
        if (keyObject == null) {
            return false;
        }
        for (Attribute attribute : keyObject.getElementsCollection()) {
            boolean bl;
            Entity entity2;
            Attribute attribute2;
            if (!attribute.isFKAttribute() || (attribute2 = attribute.getDelegate()) == null || list.contains(entity2 = (Entity)attribute2.getContainerWithKeyObject()) || !(bl = entity2.hasFKPathTo(entity, list))) continue;
            return true;
        }
        return false;
    }

    public boolean hasRelPathTo(Entity entity) {
        ArrayList arrayList = new ArrayList();
        return this.hasRelPathTo(entity, arrayList);
    }

    private boolean hasRelPathTo(Entity entity, List list) {
        if (this == entity) {
            return true;
        }
        list.add(this);
        for (Relation.Connection connection : this.relationConnections) {
            boolean bl;
            int[] nArray;
            Relation relation;
            Entity entity2 = connection.getOtherEntity();
            if (entity2 == this || !(relation = connection.getRelation()).isIdentifying() || (nArray = relation.getPKProviderEndPoint()).length != 1 || relation.getEntity(nArray[0]) != entity2 || list.contains(entity2) || !(bl = entity2.hasFKPathTo(entity, list))) continue;
            return true;
        }
        return false;
    }

    public boolean hasFK_Rel_PathTo(Entity entity) {
        return this.hasFKPathTo(entity) || this.hasRelPathTo(entity);
    }

    public Attribute getFKAttributeForOriginating(Attribute attribute) {
        for (Attribute attribute2 : this.getElementsCollection()) {
            if (!attribute2.isFKAttribute() || attribute2.getOriginatingAttribute() != attribute) continue;
            return attribute2;
        }
        return null;
    }

    public Attribute getFKAttributeForOriginating(Attribute attribute, Relation relation) {
        String string = relation.getObjectID();
        for (Attribute attribute2 : this.getElementsCollection()) {
            if (!attribute2.isFKAttribute() || !attribute2.getGeneratorID().equalsIgnoreCase(string) || attribute2.getOriginatingAttribute() != attribute) continue;
            return attribute2;
        }
        return null;
    }

    public String getPreferredAbbreviation() {
        return this.preferredAbbreviation;
    }

    public void setPreferredAbbreviation(String string) {
        this.preferredAbbreviation = string;
    }

    public List getPKProviderRelations() {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        Relation.Connection[] connectionArray = this.getRelationConnections();
        for (int i = 0; i < connectionArray.length; ++i) {
            Relation relation = connectionArray[i].getRelation();
            if (relation instanceof InheritanceRelation || !relation.isPKConsumer(this)) continue;
            arrayList.add(connectionArray[i].getRelation());
        }
        return arrayList;
    }

    public String getSynonymToDisplay() {
        return this.synonymToDisplay;
    }

    public void setSynonymToDisplay(String string) {
        this.synonymToDisplay = string;
    }

    public void clearViews() {
        Iterator iterator = ((LogicalDesign)this.getDesignPart()).getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            EntityView entityView = (EntityView)iterator.next();
            entityView.clear(this);
        }
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "entity/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public List getUniqueIdentifiers() {
        ArrayList arrayList = new ArrayList();
        this.getKeySet().addAllElementsTo(arrayList);
        return arrayList;
    }

    public void applyKeyOrderFromList(List list) {
        this.getKeySet().applyOrderFromList(list);
    }

    public String getHierarchicalParentID() {
        if (this.getHierarchicalParent() != null) {
            this.hierarchicalParentID = this.getHierarchicalParent().getObjectID();
        }
        return this.hierarchicalParentID;
    }

    public void setHierarchicalParentID(String string) {
        this.hierarchicalParentID = string;
    }

    public Map getFoldedAttributesMap() {
        return this.foldedAttributesMap;
    }

    public List getKeysUsingRelationsip(Relation relation) {
        ArrayList<CandidateKey> arrayList = null;
        Iterator iterator = this.getKeySet().iterator();
        while (iterator.hasNext()) {
            CandidateKey candidateKey = (CandidateKey)iterator.next();
            if (!candidateKey.getNewElementsCollection().contains(relation)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<CandidateKey>();
            }
            arrayList.add(candidateKey);
        }
        if (arrayList != null) {
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public static class NullEntity
    extends Entity {
        public NullEntity(DesignPart designPart) {
            super(designPart);
        }

        @Override
        public String toString() {
            return " ";
        }

        @Override
        public String getName() {
            return " ";
        }
    }
}

