/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.util.List;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.editor.logical.EntityViewPropertiesDialogEx;

public class AttributeView
extends AbstractViewElement {
    public AttributeView(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return "AttributeView";
    }

    @Override
    public String getIDPrefix() {
        return "AV";
    }

    public Entity getEntity() {
        return (Entity)this.getTable();
    }

    public void setEntity(Entity entity) {
        this.setTable(entity);
    }

    public void setEntityAlias(String string) {
        this.setTableAlias(string);
    }

    public String getEntityAlias() {
        return this.getTableAlias();
    }

    public void setReferencedAttribute(ContainedObjectWithDomain containedObjectWithDomain) {
        this.setReferencedColumn(containedObjectWithDomain);
    }

    public Attribute getReferencedAttribute() {
        return (Attribute)this.getReferencedColumn();
    }

    @Override
    public void copy(DesignObject designObject) {
        AttributeView attributeView = (AttributeView)designObject;
        attributeView.setDesign(this.getDesign());
        super.copy(attributeView);
        attributeView.setDesign(this.getDesign());
        attributeView.setEntityAlias(this.getEntityAlias());
        attributeView.setAlias(this.getAlias());
        attributeView.setExpression(this.getExpression());
        attributeView.setDataType(this.getDataType());
        attributeView.setReferencedAttribute(this.getReferencedAttribute());
        attributeView.setEntity(this.getEntity());
        attributeView.setScopeId(this.getScopeId());
        attributeView.setReference(this.isReference());
        attributeView.setStructuredType(this.getStructuredType());
    }

    public ColumnView getEngColumnView(RelationalDesign relationalDesign) {
        XtdMapping xtdMapping;
        ColumnView columnView;
        ColumnView columnView2 = null;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, relationalDesign.getObjectID());
        if (list.size() > 0 && (columnView = (ColumnView)(xtdMapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null) {
            return columnView;
        }
        if (this.getGenerator() instanceof ColumnView) {
            columnView2 = (ColumnView)this.getGenerator();
        }
        if (columnView2 != null && columnView2.getDesignPart() == relationalDesign) {
            return columnView2;
        }
        columnView2 = (ColumnView)relationalDesign.getColumnViewSet().getObjectGeneratedBy(this.getObjectID());
        return columnView2;
    }

    @Override
    public void showPropertyDialog() {
        if (this.getContainer() != null && !this.getContainer().isDialogVisible()) {
            EntityViewPropertiesDialogEx entityViewPropertiesDialogEx = new EntityViewPropertiesDialogEx(this.getDesign().getAppView(), this.getContainer());
            entityViewPropertiesDialogEx.initProperties(this.getContainer());
            entityViewPropertiesDialogEx.show();
        }
    }
}

