/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.editor.logical.ArcPropertiesDialogEx;

public class Arc
extends ContainerObject
implements ObjectListener {
    private Entity entity;
    private List relations = new ArrayList();
    private int sizeIndex;
    public static final String TYPE_NAME = "Arc";

    public Arc(DesignPart designPart) {
        super(designPart);
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
        if (entity != null && !entity.arcExists(this)) {
            entity.addArc(this);
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void addRelation(Relation relation) {
        if (!this.relations.contains(relation)) {
            this.relations.add(relation);
            relation.addObjectListener(this);
            relation.setArc(this);
        }
    }

    public void removeRelation(Relation relation) {
        this.relations.remove(relation);
        relation.removeObjectListener(this);
        relation.setArc(null);
    }

    public void clearRelations() {
        this.relations.clear();
    }

    public List getRelations() {
        return this.relations;
    }

    public boolean containsRelation(Relation relation) {
        return this.relations.contains(relation);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public int getSizeIndex() {
        return this.sizeIndex;
    }

    public void setSizeIndex(int n) {
        this.sizeIndex = n;
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (designObject instanceof Relation && objectChangeEvent == ObjectChangeEvent.OBJECT_REMOVED) {
            this.removeRelation((Relation)designObject);
            if (this.relations.size() <= 1) {
                this.remove();
            }
        }
    }

    @Override
    public void remove() {
        Object[] objectArray = this.relations.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            Relation relation = (Relation)objectArray[i];
            this.removeRelation(relation);
        }
        super.remove();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ArcPropertiesDialogEx arcPropertiesDialogEx = new ArcPropertiesDialogEx(this.getDesign().getAppView(), this);
            arcPropertiesDialogEx.initProperties(this);
            arcPropertiesDialogEx.show();
        }
    }

    @Override
    public boolean shouldBeEngineered() {
        return false;
    }

    @Override
    protected void clearStructure() {
    }

    @Override
    public ContainedObject createContainedObject(String string) {
        return null;
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return null;
    }

    @Override
    protected void updateStructure() {
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "arc/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

