/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import oracle.dbtools.crest.model.design.AbstractApplyNamingStandards;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class ApplyAttributesNamingStandards
extends AbstractApplyNamingStandards<Entity> {
    private boolean applyToPrimaryIdentifier;
    private boolean applyToRelationAttribute;
    private Settings settings;
    private NamingStandardRule nsr;

    public ApplyAttributesNamingStandards(Settings settings, boolean bl, boolean bl2) {
        this.applyToPrimaryIdentifier = bl2;
        this.applyToRelationAttribute = bl;
        this.settings = settings;
        this.nsr = settings.getNamingStandardRule();
    }

    @Override
    public void apply(Entity entity) {
        this.applyToPrimaryIdentifier(entity);
        if (!this.settings.isKeepFKNamesSynchronized()) {
            this.applyToRelationAttributes(entity);
        }
    }

    public void applyToPrimaryIdentifier(Entity entity) {
        if (this.applyToPrimaryIdentifier && entity.getPK() != null) {
            entity.getPK().setName(ApplyAttributesNamingStandards.createPrimaryIdentifierName(entity.getName(), this.nsr));
        }
    }

    public void applyToRelationAttributes(Entity entity) {
        if (this.applyToRelationAttribute && !entity.isBST()) {
            for (Relation relation : entity.getRelations()) {
                Entity entity2 = relation.getSourceEntity();
                if (entity2 == entity) {
                    entity2 = relation.getTargetEntity();
                }
                if (entity2.isBST()) continue;
                Attribute[] attributeArray = relation.getFKAttributes(entity);
                for (int i = 0; i < attributeArray.length; ++i) {
                    attributeArray[i].setName(ApplyAttributesNamingStandards.createRelationAttributeName(entity2, attributeArray[i].getDelegate(), this.nsr));
                }
            }
        }
    }

    public static String createPrimaryIdentifierName(String string, NamingStandardRule namingStandardRule) {
        String string2 = namingStandardRule.getUIConstr();
        if (string2.length() > 0) {
            string = string.replaceAll("\\$", "\\\\\\$");
            return string2.replaceAll("\\{entity\\}", string);
        }
        return string2;
    }

    public static String createRelationAttributeName(Entity entity, Attribute attribute, NamingStandardRule namingStandardRule) {
        String string = namingStandardRule.getRelationAttribute();
        if (string.length() > 0) {
            String string2 = entity.getName().replaceAll("\\$", "\\\\\\$");
            String string3 = entity.getShortName().replaceAll("\\$", "\\\\\\$");
            String string4 = entity.getPreferredAbbreviation();
            String string5 = attribute.getName().replaceAll("\\$", "\\\\\\$");
            String string6 = attribute.getPreferredAbbreviation();
            string = string.replaceAll("\\{ref entity\\}", string2);
            string = string.replaceAll("\\{ref entity short name\\}", string3);
            string = string.replaceAll("\\{ref entity pref abbr\\}", string4 != null && string4.length() > 0 ? string4 : string2);
            string = string.replaceAll("\\{ref attribute\\}", string5);
            string = string.replaceAll("\\{ref attribute pref abbr\\}", string6 != null && string6.length() > 0 ? string6 : string5);
            string = ApplyAttributesNamingStandards.process_SUBSTR_Clause(string);
        }
        return string;
    }
}

