/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.Iterator;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.impact.ImpA_FKAssociation;
import oracle.dbtools.crest.model.design.impact.ImpA_KeyObject;
import oracle.dbtools.crest.model.design.impact.ImpA_Table;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_PK_UK
extends LongNameObjectSelection {
    private Index index;

    public ImpA_PK_UK(Index index, ModelIdObjectSelection modelIdObjectSelection, boolean bl) {
        super(index);
        this.index = index;
        this.setParent(modelIdObjectSelection);
        if (bl) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addChildTables();
        this.addMappings(this);
        this.loaded = true;
    }

    private void addMappings(ImpA_PK_UK impA_PK_UK) {
        if (this.index.getObjectID() != null && this.index.getEngCandidateKey() != null) {
            ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_PK_UK.Mappings"));
            modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
            impA_PK_UK.addChild(modelIdObjectSelection);
            CandidateKey candidateKey = this.index.getEngCandidateKey();
            if (!modelIdObjectSelection.hasAsParent(candidateKey)) {
                modelIdObjectSelection.addChild(new ImpA_KeyObject(candidateKey, modelIdObjectSelection, false));
            } else {
                modelIdObjectSelection.addChild(new LongNameObjectSelection(candidateKey));
            }
        }
    }

    @Override
    public String toString() {
        if (this.index.isPK()) {
            return "(PK) " + this.index.getLongName();
        }
        return this.index.getLongName();
    }

    private void addChildTables() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_PK_UK.FKsAndChildTables"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        this.addChild(modelIdObjectSelection);
        Iterator iterator = ((RelationalDesign)this.index.getDesignPart()).getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            Table table;
            LongNameObjectSelection longNameObjectSelection;
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            if (fKIndexAssociation.getRemoteIndex() != this.index) continue;
            if (!modelIdObjectSelection.hasAsParent(fKIndexAssociation)) {
                longNameObjectSelection = new ImpA_FKAssociation(fKIndexAssociation, modelIdObjectSelection, false);
                modelIdObjectSelection.addChild(longNameObjectSelection);
                table = (Table)fKIndexAssociation.getContainerWithKeyObject();
                if (!longNameObjectSelection.hasAsParent(table)) {
                    longNameObjectSelection.addChild(new ImpA_Table(table, longNameObjectSelection, false));
                    continue;
                }
                longNameObjectSelection.addChild(new ModelIdObjectSelection(table));
                continue;
            }
            longNameObjectSelection = new LongNameObjectSelection(fKIndexAssociation);
            modelIdObjectSelection.addChild(longNameObjectSelection);
            table = (Table)fKIndexAssociation.getContainerWithKeyObject();
            if (!longNameObjectSelection.hasAsParent(table)) {
                longNameObjectSelection.addChild(new ImpA_Table(table, longNameObjectSelection, false));
                continue;
            }
            longNameObjectSelection.addChild(new ModelIdObjectSelection(table));
        }
    }
}

